/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.type.ThemeCSSCET;
import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenDefinitionRegistry;
import com.liferay.frontend.token.definition.internal.FrontendTokenDefinitionImpl;
import com.liferay.frontend.token.definition.internal.validator.FrontendTokenDefinitionJSONValidator;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.json.validator.JSONValidatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FrontendTokenDefinitionRegistry.class})
public class FrontendTokenDefinitionRegistryImpl
implements FrontendTokenDefinitionRegistry {
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(FrontendTokenDefinitionRegistryImpl.class);
    private static final Pattern _themePattern = Pattern.compile("<theme id=\"([^\"]*)\"[^>]* name=\"([^\"]*)\"[^>]*>");
    private BundleTracker<List<FrontendTokenDefinitionImpl>> _bundleTracker;
    private final BundleTrackerCustomizer<List<FrontendTokenDefinitionImpl>> _bundleTrackerCustomizer = new BundleTrackerCustomizer<List<FrontendTokenDefinitionImpl>>(){

        public List<FrontendTokenDefinitionImpl> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            List<FrontendTokenDefinitionImpl> frontendTokenDefinitionImpls = FrontendTokenDefinitionRegistryImpl.this.getFrontendTokenDefinitionImpls(bundle);
            for (FrontendTokenDefinitionImpl frontendTokenDefinitionImpl : frontendTokenDefinitionImpls) {
                if (frontendTokenDefinitionImpl.getThemeId() == null) continue;
                FrontendTokenDefinitionRegistryImpl.this._frontendTokenDefinitions.put(frontendTokenDefinitionImpl.getThemeId(), frontendTokenDefinitionImpl);
            }
            return frontendTokenDefinitionImpls;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<FrontendTokenDefinitionImpl> frontendTokenDefinitionImpls) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<FrontendTokenDefinitionImpl> frontendTokenDefinitionImpls) {
            for (FrontendTokenDefinitionImpl frontendTokenDefinitionImpl : frontendTokenDefinitionImpls) {
                FrontendTokenDefinitionRegistryImpl.this._frontendTokenDefinitions.remove(frontendTokenDefinitionImpl.getThemeId());
            }
        }
    };
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    private final FrontendTokenDefinitionJSONValidator _frontendTokenDefinitionJSONValidator = new FrontendTokenDefinitionJSONValidator();
    private final Map<String, FrontendTokenDefinition> _frontendTokenDefinitions = new ConcurrentHashMap<String, FrontendTokenDefinition>();
    private final DCLSingleton<Map<String, FrontendTokenDefinition>> _frontendTokenDefinitionsDCLSingleton = new DCLSingleton();
    private final Map<Long, Map<String, FrontendTokenDefinition>> _frontendTokenDefinitionsMap = new ConcurrentHashMap<Long, Map<String, FrontendTokenDefinition>>();
    @Reference
    private Portal _portal;
    private ServiceTracker<ThemeCSSCET, ThemeCSSCET> _serviceTracker;

    public FrontendTokenDefinition getFrontendTokenDefinition(Layout layout) {
        String cetExternalReferenceCode = null;
        if (FeatureFlagManagerUtil.isEnabled((long)layout.getCompanyId(), (String)"LPD-30204")) {
            cetExternalReferenceCode = this._getCETExternalReferenceCode(layout.getClassNameId(), layout.getPlid());
            if (cetExternalReferenceCode != null) {
                return this._getThemeCSSCETFrontendTokenDefinition(layout.getCompanyId(), cetExternalReferenceCode);
            }
            if (layout.getMasterLayoutPlid() > 0L && (cetExternalReferenceCode = this._getCETExternalReferenceCode(this._portal.getClassNameId(Layout.class), layout.getMasterLayoutPlid())) != null) {
                return this._getThemeCSSCETFrontendTokenDefinition(layout.getCompanyId(), cetExternalReferenceCode);
            }
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        cetExternalReferenceCode = this._getCETExternalReferenceCode(this._portal.getClassNameId(LayoutSet.class), layoutSet.getLayoutSetId());
        if (cetExternalReferenceCode != null) {
            return this._getThemeCSSCETFrontendTokenDefinition(layoutSet.getCompanyId(), cetExternalReferenceCode);
        }
        Theme theme = null;
        try {
            theme = layout.getTheme();
            return this._getBundleFrontendTokenDefinition(theme.getThemeId());
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get the theme for layout with layout ID " + layout.getLayoutId()), (Throwable)portalException);
            return null;
        }
    }

    public FrontendTokenDefinition getFrontendTokenDefinition(LayoutSet layoutSet) {
        return this._getFrontendTokenDefinition(layoutSet.getCompanyId(), this._getCETExternalReferenceCode(this._portal.getClassNameId(LayoutSet.class), layoutSet.getLayoutSetId()), layoutSet.getThemeId());
    }

    public FrontendTokenDefinition getFrontendTokenDefinition(long companyId, String themeId) {
        FrontendTokenDefinition frontendTokenDefinition = this._frontendTokenDefinitions.get(themeId);
        if (frontendTokenDefinition != null) {
            return frontendTokenDefinition;
        }
        Map<String, FrontendTokenDefinition> frontendTokenDefinitions = this._frontendTokenDefinitionsMap.get(companyId);
        if (frontendTokenDefinitions == null) {
            return null;
        }
        return frontendTokenDefinitions.get(themeId);
    }

    public List<FrontendTokenDefinition> getFrontendTokenDefinitions(long companyId) {
        ArrayList<FrontendTokenDefinition> frontendTokenDefinitions = new ArrayList<FrontendTokenDefinition>(this._frontendTokenDefinitions.values());
        Map<String, FrontendTokenDefinition> frontendTokenDefinitionsMap = this._frontendTokenDefinitionsMap.get(companyId);
        if (frontendTokenDefinitionsMap != null) {
            frontendTokenDefinitions.addAll(frontendTokenDefinitionsMap.values());
        }
        return frontendTokenDefinitions;
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, this._bundleTrackerCustomizer);
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, ThemeCSSCET.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ThemeCSSCET, ThemeCSSCET>(){

            public ThemeCSSCET addingService(ServiceReference<ThemeCSSCET> serviceReference) {
                ThemeCSSCET themeCSSCET = (ThemeCSSCET)bundleContext.getService(serviceReference);
                if (Validator.isNull((String)themeCSSCET.getFrontendTokenDefinitionJSON())) {
                    return themeCSSCET;
                }
                FrontendTokenDefinitionRegistryImpl.this._addingService(themeCSSCET);
                return themeCSSCET;
            }

            public void modifiedService(ServiceReference<ThemeCSSCET> serviceReference, ThemeCSSCET themeCSSCET) {
            }

            public void removedService(ServiceReference<ThemeCSSCET> serviceReference, ThemeCSSCET themeCSSCET) {
                bundleContext.ungetService(serviceReference);
                FrontendTokenDefinitionRegistryImpl.this._removedService(themeCSSCET);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
        this._serviceTracker.close();
    }

    protected List<FrontendTokenDefinitionImpl> getFrontendTokenDefinitionImpls(Bundle bundle) {
        String json = this._getFrontendTokenDefinitionJSON(bundle);
        if (json == null) {
            return Collections.emptyList();
        }
        try {
            ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)bundle.getSymbolicName());
            if (resourceBundleLoader == null) {
                resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
            }
            ArrayList<FrontendTokenDefinitionImpl> frontendTokenDefinitionImpls = new ArrayList<FrontendTokenDefinitionImpl>();
            for (Map<String, String> themeMap : this.getThemeMaps(bundle)) {
                frontendTokenDefinitionImpls.add(new FrontendTokenDefinitionImpl(this.jsonFactory.createJSONObject(json), this.jsonFactory, resourceBundleLoader, themeMap.get("id"), themeMap.get("name"), "bundle"));
            }
            return frontendTokenDefinitionImpls;
        }
        catch (JSONException | RuntimeException exception) {
            _log.error((Object)("Unable to parse frontend token definitions for bundle " + bundle.getSymbolicName()), exception);
            return Collections.emptyList();
        }
    }

    protected String getServletContextName(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String webContextPath = (String)headers.get("Web-ContextPath");
        if (webContextPath == null) {
            return null;
        }
        if (webContextPath.startsWith("/")) {
            webContextPath = webContextPath.substring(1);
        }
        return webContextPath;
    }

    protected List<Map<String, String>> getThemeMaps(Bundle bundle) {
        URL url = bundle.getEntry("WEB-INF/liferay-look-and-feel.xml");
        if (url == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<Map<String, String>> themeMaps = new ArrayList<Map<String, String>>();
            String servletContextName = this.getServletContextName(bundle);
            String xml = URLUtil.toString((URL)url);
            xml = xml.replaceAll("\n", " ");
            Matcher matcher = _themePattern.matcher(xml);
            while (matcher.find()) {
                Object themeId = matcher.group(1);
                if (servletContextName != null) {
                    themeId = (String)themeId + "_WAR_" + servletContextName;
                }
                themeMaps.add(HashMapBuilder.put((Object)"id", (Object)this.portal.getJsSafePortletId((String)themeId)).put((Object)"name", (Object)matcher.group(2)).build());
            }
            return themeMaps;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read WEB-INF/liferay-look-and-feel.xml", ioException);
        }
    }

    private void _addingService(ThemeCSSCET themeCSSCET) {
        try {
            this._frontendTokenDefinitionJSONValidator.validate(themeCSSCET.getFrontendTokenDefinitionJSON());
            Map frontendTokenDefinitions = this._frontendTokenDefinitionsMap.computeIfAbsent(themeCSSCET.getCompanyId(), entry -> new ConcurrentHashMap());
            frontendTokenDefinitions.put(themeCSSCET.getExternalReferenceCode(), new FrontendTokenDefinitionImpl(this.jsonFactory.createJSONObject(themeCSSCET.getFrontendTokenDefinitionJSON()), this.jsonFactory, ResourceBundleLoaderUtil.getPortalResourceBundleLoader(), themeCSSCET.getExternalReferenceCode(), themeCSSCET.getName(), "themeCSSCET"));
        }
        catch (JSONValidatorException | JSONException exception) {
            _log.error((Object)"Unable to parse theme CSS client extension frontend token definition", exception);
        }
    }

    private FrontendTokenDefinition _getBundleFrontendTokenDefinition(String themeId) {
        Map frontendTokenDefinitions = (Map)this._frontendTokenDefinitionsDCLSingleton.getSingleton(() -> {
            this._bundleTracker.open();
            return this._frontendTokenDefinitions;
        });
        return (FrontendTokenDefinition)frontendTokenDefinitions.get(themeId);
    }

    private String _getCETExternalReferenceCode(long classNameId, long classPK) {
        ClientExtensionEntryRel clientExtensionEntryRel = this._clientExtensionEntryRelLocalService.fetchClientExtensionEntryRel(classNameId, classPK, "themeCSS");
        if (clientExtensionEntryRel == null) {
            return null;
        }
        return clientExtensionEntryRel.getCETExternalReferenceCode();
    }

    private FrontendTokenDefinition _getFrontendTokenDefinition(long companyId, String externalReferenceCode, String themeId) {
        FrontendTokenDefinition frontendTokenDefinition;
        if (externalReferenceCode != null && (frontendTokenDefinition = this._getThemeCSSCETFrontendTokenDefinition(companyId, externalReferenceCode)) != null) {
            return frontendTokenDefinition;
        }
        return this._getBundleFrontendTokenDefinition(themeId);
    }

    private String _getFrontendTokenDefinitionJSON(Bundle bundle) {
        URL url = bundle.getEntry("WEB-INF/frontend-token-definition.json");
        if (url == null) {
            return null;
        }
        try {
            return URLUtil.toString((URL)url);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read WEB-INF/frontend-token-definition.json", ioException);
        }
    }

    private Map<String, FrontendTokenDefinition> _getFrontendTokenDefinitions(long companyId) {
        return this._frontendTokenDefinitionsMap.getOrDefault(companyId, new ConcurrentHashMap());
    }

    private FrontendTokenDefinition _getThemeCSSCETFrontendTokenDefinition(long companyId, String externalReferenceCode) {
        Map<String, FrontendTokenDefinition> frontendTokenDefinitions = this._getFrontendTokenDefinitions(companyId);
        return frontendTokenDefinitions.get(externalReferenceCode);
    }

    private void _removedService(ThemeCSSCET themeCSSCET) {
        Map<String, FrontendTokenDefinition> frontendTokenDefinitions = this._getFrontendTokenDefinitions(themeCSSCET.getCompanyId());
        frontendTokenDefinitions.remove(themeCSSCET.getExternalReferenceCode());
    }
}

