/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal.jaxrs.application;

import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.internal.FrontendTokenDefinitionImpl;
import com.liferay.frontend.token.definition.internal.validator.FrontendTokenDefinitionJSONValidator;
import com.liferay.portal.json.validator.JSONValidatorException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.jaxrs.application.base=/frontend-token-definition", "osgi.jaxrs.name=com.liferay.frontend.token.definition.internal.jaxrs.application.FrontendTokenDefinitionApplication", "auth.verifier.auth.verifier.PortalSessionAuthVerifier.urls.includes=/*", "auth.verifier.guest.allowed=false", "liferay.oauth2=false"}, service={Application.class})
public class FrontendTokenDefinitionApplication
extends Application {
    private static final Log _log = LogFactoryUtil.getLog(FrontendTokenDefinitionApplication.class);
    private final FrontendTokenDefinitionJSONValidator _frontendTokenDefinitionJSONValidator = new FrontendTokenDefinitionJSONValidator();
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public Set<Object> getSingletons() {
        return Collections.singleton(this);
    }

    @Consumes(value={"multipart/form-data"})
    @Path(value="/validate-file")
    @POST
    @Produces(value={"application/json"})
    public Response validateFile(@Context HttpServletRequest httpServletRequest) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-10773")) {
            return Response.serverError().build();
        }
        Locale locale = this._portal.getLocale(httpServletRequest);
        try {
            UploadServletRequest uploadServletRequest = this._portal.getUploadServletRequest(httpServletRequest);
            return this._getResponse(uploadServletRequest.getFile("file"), locale);
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
            return this._getResponse(this._language.get(locale, "your-upload-failed-to-complete"), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (JSONValidatorException | JSONException exception) {
            _log.error(exception);
            return this._getResponse(this._language.get(locale, "the-format-is-invalid.-please-upload-a-valid-frontend-token-definition-json-file"), Response.Status.BAD_REQUEST);
        }
    }

    private FrontendTokenDefinition _getFrontendTokenDefinition(File file) throws IOException, JSONException, JSONValidatorException {
        String json = "";
        if (file.exists()) {
            json = new String(Files.readAllBytes(file.toPath()));
        }
        this._frontendTokenDefinitionJSONValidator.validate(json);
        return new FrontendTokenDefinitionImpl(this._jsonFactory.createJSONObject(json), this._jsonFactory, null, "");
    }

    private Response _getResponse(File file, Locale locale) throws IOException, JSONException, JSONValidatorException {
        if (file == null || !StringUtil.endsWith((String)file.getName(), (String)".json")) {
            return this._getResponse(this._language.get(locale, "please-upload-a-json-file"), Response.Status.BAD_REQUEST);
        }
        FrontendTokenDefinition frontendTokenDefinition = this._getFrontendTokenDefinition(file);
        Collection frontendTokenCategories = frontendTokenDefinition.getFrontendTokenCategories();
        Collection frontendTokens = frontendTokenDefinition.getFrontendTokens();
        Collection frontendTokenSets = frontendTokenDefinition.getFrontendTokenSets();
        return this._getResponse(this._language.format(locale, "the-frontend-token-definition-json-file-was-uploaded-and-contributed-x-token-categories-x-token-sets-and-x-tokens", new Object[]{frontendTokenCategories.size(), frontendTokenSets.size(), frontendTokens.size()}), Response.Status.OK);
    }

    private Response _getResponse(String message, Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)HashMapBuilder.put((Object)"message", (Object)message).build()).type("application/json").build();
    }
}

