/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.type.ThemeCSSCET;
import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenDefinitionRegistry;
import com.liferay.frontend.token.definition.internal.FrontendTokenDefinitionImpl;
import com.liferay.frontend.token.definition.internal.validator.FrontendTokenDefinitionJSONValidator;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.json.validator.JSONValidatorException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FrontendTokenDefinitionRegistry.class})
public class FrontendTokenDefinitionRegistryImpl
implements FrontendTokenDefinitionRegistry {
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(FrontendTokenDefinitionRegistryImpl.class);
    private static final Pattern _themeIdPattern = Pattern.compile(".*<theme id=\"([^\"]*)\"[^>]*>.*");
    private BundleTracker<FrontendTokenDefinitionImpl> _bundleTracker;
    private final BundleTrackerCustomizer<FrontendTokenDefinitionImpl> _bundleTrackerCustomizer = new BundleTrackerCustomizer<FrontendTokenDefinitionImpl>(){

        public FrontendTokenDefinitionImpl addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            FrontendTokenDefinitionImpl frontendTokenDefinitionImpl = FrontendTokenDefinitionRegistryImpl.this.getFrontendTokenDefinitionImpl(bundle);
            if (frontendTokenDefinitionImpl != null && frontendTokenDefinitionImpl.getThemeId() != null) {
                FrontendTokenDefinitionRegistryImpl.this._frontendTokenDefinitionImpls.put(frontendTokenDefinitionImpl.getThemeId(), frontendTokenDefinitionImpl);
                return frontendTokenDefinitionImpl;
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, FrontendTokenDefinitionImpl frontendTokenDefinitionImpl) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, FrontendTokenDefinitionImpl frontendTokenDefinitionImpl) {
            FrontendTokenDefinitionRegistryImpl.this._frontendTokenDefinitionImpls.remove(frontendTokenDefinitionImpl.getThemeId());
        }
    };
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    private final Map<String, FrontendTokenDefinitionImpl> _frontendTokenDefinitionImpls = new ConcurrentHashMap<String, FrontendTokenDefinitionImpl>();
    private final DCLSingleton<Map<String, FrontendTokenDefinitionImpl>> _frontendTokenDefinitionImplsDCLSingleton = new DCLSingleton();
    private final FrontendTokenDefinitionJSONValidator _frontendTokenDefinitionJSONValidator = new FrontendTokenDefinitionJSONValidator();
    private final Map<Long, Map<String, FrontendTokenDefinition>> _frontendTokenDefinitionsMap = new ConcurrentHashMap<Long, Map<String, FrontendTokenDefinition>>();
    @Reference
    private Portal _portal;
    private ServiceTracker<ThemeCSSCET, ThemeCSSCET> _serviceTracker;

    public FrontendTokenDefinition getFrontendTokenDefinition(LayoutSet layoutSet) {
        return this._getFrontendTokenDefinition(layoutSet.getCompanyId(), this._getCETExternalReferenceCode(layoutSet.getLayoutSetId()), layoutSet.getThemeId());
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, this._bundleTrackerCustomizer);
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, ThemeCSSCET.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ThemeCSSCET, ThemeCSSCET>(){

            public ThemeCSSCET addingService(ServiceReference<ThemeCSSCET> serviceReference) {
                ThemeCSSCET themeCSSCET = (ThemeCSSCET)bundleContext.getService(serviceReference);
                if (Validator.isNull((String)themeCSSCET.getFrontendTokenDefinitionJSON())) {
                    return themeCSSCET;
                }
                FrontendTokenDefinitionRegistryImpl.this._addingService(themeCSSCET);
                return themeCSSCET;
            }

            public void modifiedService(ServiceReference<ThemeCSSCET> serviceReference, ThemeCSSCET themeCSSCET) {
            }

            public void removedService(ServiceReference<ThemeCSSCET> serviceReference, ThemeCSSCET themeCSSCET) {
                bundleContext.ungetService(serviceReference);
                FrontendTokenDefinitionRegistryImpl.this._removedService(themeCSSCET);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
        this._serviceTracker.close();
    }

    protected FrontendTokenDefinitionImpl getFrontendTokenDefinitionImpl(Bundle bundle) {
        String json = this._getFrontendTokenDefinitionJSON(bundle);
        if (json == null) {
            return null;
        }
        String themeId = this.getThemeId(bundle);
        try {
            ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)bundle.getSymbolicName());
            if (resourceBundleLoader == null) {
                resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
            }
            return new FrontendTokenDefinitionImpl(this.jsonFactory.createJSONObject(json), this.jsonFactory, resourceBundleLoader, themeId);
        }
        catch (JSONException | RuntimeException exception) {
            _log.error((Object)("Unable to parse frontend token definitions for theme " + themeId), exception);
            return null;
        }
    }

    protected String getServletContextName(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String webContextPath = (String)headers.get("Web-ContextPath");
        if (webContextPath == null) {
            return null;
        }
        if (webContextPath.startsWith("/")) {
            webContextPath = webContextPath.substring(1);
        }
        return webContextPath;
    }

    protected String getThemeId(Bundle bundle) {
        URL url = bundle.getEntry("WEB-INF/liferay-look-and-feel.xml");
        if (url == null) {
            return null;
        }
        try {
            String xml = URLUtil.toString((URL)url);
            xml = xml.replaceAll("\n", " ");
            Matcher matcher = _themeIdPattern.matcher(xml);
            if (!matcher.matches()) {
                return null;
            }
            String themeId = matcher.group(1);
            String servletContextName = this.getServletContextName(bundle);
            if (servletContextName != null) {
                themeId = themeId + "_WAR_" + servletContextName;
            }
            return this.portal.getJsSafePortletId(themeId);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read WEB-INF/liferay-look-and-feel.xml", ioException);
        }
    }

    private void _addingService(ThemeCSSCET themeCSSCET) {
        try {
            this._frontendTokenDefinitionJSONValidator.validate(themeCSSCET.getFrontendTokenDefinitionJSON());
            Map frontendTokenDefinitions = this._frontendTokenDefinitionsMap.computeIfAbsent(themeCSSCET.getCompanyId(), entry -> new ConcurrentHashMap());
            frontendTokenDefinitions.put(themeCSSCET.getExternalReferenceCode(), new FrontendTokenDefinitionImpl(this.jsonFactory.createJSONObject(themeCSSCET.getFrontendTokenDefinitionJSON()), this.jsonFactory, ResourceBundleLoaderUtil.getPortalResourceBundleLoader(), themeCSSCET.getExternalReferenceCode()));
        }
        catch (JSONValidatorException | JSONException exception) {
            _log.error((Object)"Unable to parse theme CSS client extension frontend token definition", exception);
        }
    }

    private String _getCETExternalReferenceCode(long layoutSetId) {
        ClientExtensionEntryRel clientExtensionEntryRel = this._clientExtensionEntryRelLocalService.fetchClientExtensionEntryRel(this._portal.getClassNameId(LayoutSet.class), layoutSetId, "themeCSS");
        if (clientExtensionEntryRel == null) {
            return null;
        }
        return clientExtensionEntryRel.getCETExternalReferenceCode();
    }

    private FrontendTokenDefinition _getFrontendTokenDefinition(long companyId, String externalReferenceCode, String themeId) {
        Map<String, FrontendTokenDefinition> frontendTokenDefinitions;
        FrontendTokenDefinition frontendTokenDefinition;
        if (externalReferenceCode != null && FeatureFlagManagerUtil.isEnabled((String)"LPD-10773") && (frontendTokenDefinition = (frontendTokenDefinitions = this._getFrontendTokenDefinitions(companyId)).get(externalReferenceCode)) != null) {
            return frontendTokenDefinition;
        }
        Map frontendTokenDefinitionImpls = (Map)this._frontendTokenDefinitionImplsDCLSingleton.getSingleton(() -> {
            this._bundleTracker.open();
            return this._frontendTokenDefinitionImpls;
        });
        return (FrontendTokenDefinition)frontendTokenDefinitionImpls.get(themeId);
    }

    private String _getFrontendTokenDefinitionJSON(Bundle bundle) {
        URL url = bundle.getEntry("WEB-INF/frontend-token-definition.json");
        if (url == null) {
            return null;
        }
        try {
            return URLUtil.toString((URL)url);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read WEB-INF/frontend-token-definition.json", ioException);
        }
    }

    private Map<String, FrontendTokenDefinition> _getFrontendTokenDefinitions(long companyId) {
        return this._frontendTokenDefinitionsMap.getOrDefault(companyId, new ConcurrentHashMap());
    }

    private void _removedService(ThemeCSSCET themeCSSCET) {
        Map<String, FrontendTokenDefinition> frontendTokenDefinitions = this._getFrontendTokenDefinitions(themeCSSCET.getCompanyId());
        frontendTokenDefinitions.remove(themeCSSCET.getExternalReferenceCode());
    }
}

