/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenDefinitionRegistry;
import com.liferay.frontend.token.definition.internal.FrontendTokenDefinitionImpl;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={FrontendTokenDefinitionRegistry.class})
public class FrontendTokenDefinitionRegistryImpl
implements FrontendTokenDefinitionRegistry {
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(FrontendTokenDefinitionRegistryImpl.class);
    private static final Pattern _themeIdPattern = Pattern.compile(".*<theme id=\"([^\"]*)\"[^>]*>.*");
    private BundleTracker<FrontendTokenDefinitionImpl> _bundleTracker;
    private final BundleTrackerCustomizer<FrontendTokenDefinitionImpl> _bundleTrackerCustomizer = new BundleTrackerCustomizer<FrontendTokenDefinitionImpl>(){

        public FrontendTokenDefinitionImpl addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            FrontendTokenDefinitionImpl frontendTokenDefinitionImpl = FrontendTokenDefinitionRegistryImpl.this.getFrontendTokenDefinitionImpl(bundle);
            if (frontendTokenDefinitionImpl != null && frontendTokenDefinitionImpl.getThemeId() != null) {
                FrontendTokenDefinitionRegistryImpl.this._themeIdFrontendTokenDefinitionImpls.put(frontendTokenDefinitionImpl.getThemeId(), frontendTokenDefinitionImpl);
                return frontendTokenDefinitionImpl;
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, FrontendTokenDefinitionImpl frontendTokenDefinitionImpl) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, FrontendTokenDefinitionImpl frontendTokenDefinitionImpl) {
            FrontendTokenDefinitionRegistryImpl.this._themeIdFrontendTokenDefinitionImpls.remove(frontendTokenDefinitionImpl.getThemeId());
        }
    };
    private final Map<String, FrontendTokenDefinitionImpl> _themeIdFrontendTokenDefinitionImpls = new ConcurrentHashMap<String, FrontendTokenDefinitionImpl>();
    private final DCLSingleton<Map<String, FrontendTokenDefinitionImpl>> _themeIdFrontendTokenDefinitionImplsDCLSingleton = new DCLSingleton();

    public FrontendTokenDefinition getFrontendTokenDefinition(String themeId) {
        Map themeIdFrontendTokenDefinitionImpls = (Map)this._themeIdFrontendTokenDefinitionImplsDCLSingleton.getSingleton(() -> {
            this._bundleTracker.open();
            return this._themeIdFrontendTokenDefinitionImpls;
        });
        return (FrontendTokenDefinition)themeIdFrontendTokenDefinitionImpls.get(themeId);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, this._bundleTrackerCustomizer);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    protected FrontendTokenDefinitionImpl getFrontendTokenDefinitionImpl(Bundle bundle) {
        String json = this._getFrontendTokenDefinitionJSON(bundle);
        if (json == null) {
            return null;
        }
        String themeId = this.getThemeId(bundle);
        try {
            ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)bundle.getSymbolicName());
            if (resourceBundleLoader == null) {
                resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
            }
            return new FrontendTokenDefinitionImpl(this.jsonFactory.createJSONObject(json), this.jsonFactory, resourceBundleLoader, themeId);
        }
        catch (JSONException | RuntimeException exception) {
            _log.error((Object)("Unable to parse frontend token definitions for theme " + themeId), exception);
            return null;
        }
    }

    protected String getServletContextName(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String webContextPath = (String)headers.get("Web-ContextPath");
        if (webContextPath == null) {
            return null;
        }
        if (webContextPath.startsWith("/")) {
            webContextPath = webContextPath.substring(1);
        }
        return webContextPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getThemeId(Bundle bundle) {
        URL url = bundle.getEntry("WEB-INF/liferay-look-and-feel.xml");
        if (url == null) {
            return null;
        }
        try (InputStream inputStream = url.openStream();){
            String xml = StringUtil.read((InputStream)inputStream);
            xml = xml.replaceAll("\n", " ");
            Matcher matcher = _themeIdPattern.matcher(xml);
            if (!matcher.matches()) {
                String string = null;
                return string;
            }
            String themeId = matcher.group(1);
            String servletContextName = this.getServletContextName(bundle);
            if (servletContextName != null) {
                themeId = themeId + "_WAR_" + servletContextName;
            }
            String string = this.portal.getJsSafePortletId(themeId);
            return string;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read WEB-INF/liferay-look-and-feel.xml", ioException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _getFrontendTokenDefinitionJSON(Bundle bundle) {
        URL url = bundle.getEntry("WEB-INF/frontend-token-definition.json");
        if (url == null) {
            return null;
        }
        try (InputStream inputStream = url.openStream();){
            String string = StringUtil.read((InputStream)inputStream);
            return string;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read WEB-INF/frontend-token-definition.json", ioException);
        }
    }
}

