/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal.json;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JSONLocalizer {
    private static final Log _log = LogFactoryUtil.getLog(JSONLocalizer.class);
    private static final Set<String> _localizableKeys = new HashSet<String>(Arrays.asList("label"));
    private final String _json;
    private final JSONFactory _jsonFactory;
    private final Map<Locale, String> _jsons = new ConcurrentHashMap<Locale, String>();
    private final ResourceBundleLoader _resourceBundleLoader;
    private final String _themeId;

    public JSONLocalizer(String json, JSONFactory jsonFactory, ResourceBundleLoader resourceBundleLoader, String themeId) {
        this._json = json;
        this._jsonFactory = jsonFactory;
        this._resourceBundleLoader = resourceBundleLoader;
        this._themeId = themeId;
    }

    public String getJSON(Locale locale) {
        if (this._resourceBundleLoader == null || locale == null) {
            return this._json;
        }
        String json = this._jsons.get(locale);
        if (json == null) {
            try {
                JSONObject jsonObject = this._jsonFactory.createJSONObject(this._json);
                this._localize(jsonObject, locale);
                json = this._jsonFactory.looseSerializeDeep((Object)jsonObject);
            }
            catch (JSONException jsonException) {
                _log.error((Object)("Unable to parse JSON for theme " + this._themeId), (Throwable)jsonException);
                json = this._json;
            }
            this._jsons.put(locale, json);
        }
        return json;
    }

    private void _localize(JSONObject jsonObject, Locale locale) {
        if (locale == null) {
            return;
        }
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        if (resourceBundle == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : jsonObject.keySet()) {
            if (_localizableKeys.contains(string)) {
                String value = jsonObject.getString(string);
                if (!Validator.isNotNull((String)value)) continue;
                try {
                    map.put(string, ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)value));
                }
                catch (MissingResourceException missingResourceException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to find key ", string, " in theme ", this._themeId}), (Throwable)missingResourceException);
                }
                continue;
            }
            Object object = jsonObject.get(string);
            if (object instanceof JSONObject) {
                this._localize((JSONObject)object, locale);
                continue;
            }
            if (!(object instanceof JSONArray)) continue;
            JSONArray jsonArray = (JSONArray)object;
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object currentObject = jsonArray.get(i);
                if (!(currentObject instanceof JSONObject)) continue;
                this._localize((JSONObject)currentObject, locale);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            jsonObject.put((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

