/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenDefinitionRegistry;
import com.liferay.frontend.token.definition.internal.FrontendTokenDefinitionImpl;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={FrontendTokenDefinitionRegistry.class})
public class FrontendTokenDefinitionRegistryImpl
implements FrontendTokenDefinitionRegistry {
    protected Map<Bundle, FrontendTokenDefinitionImpl> bundleFrontendTokenDefinitionImpls = new ConcurrentHashMap<Bundle, FrontendTokenDefinitionImpl>();
    protected BundleTracker<Bundle> bundleTracker;
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected Portal portal;
    protected Map<String, FrontendTokenDefinitionImpl> themeIdFrontendTokenDefinitionImpls = new ConcurrentHashMap<String, FrontendTokenDefinitionImpl>();
    private static final Log _log = LogFactoryUtil.getLog(FrontendTokenDefinitionRegistryImpl.class);
    private static final Pattern _themeIdPattern = Pattern.compile(".*<theme id=\"([^\"]*)\"[^>]*>.*");
    private final BundleTrackerCustomizer<Bundle> _bundleTrackerCustomizer = new BundleTrackerCustomizer<Bundle>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            FrontendTokenDefinitionImpl frontendTokenDefinitionImpl = FrontendTokenDefinitionRegistryImpl.this.getFrontendTokenDefinitionImpl(bundle);
            if (frontendTokenDefinitionImpl == null) {
                return null;
            }
            FrontendTokenDefinitionRegistryImpl frontendTokenDefinitionRegistryImpl = FrontendTokenDefinitionRegistryImpl.this;
            synchronized (frontendTokenDefinitionRegistryImpl) {
                FrontendTokenDefinitionRegistryImpl.this.bundleFrontendTokenDefinitionImpls.put(bundle, frontendTokenDefinitionImpl);
                if (frontendTokenDefinitionImpl.getThemeId() != null) {
                    FrontendTokenDefinitionRegistryImpl.this.themeIdFrontendTokenDefinitionImpls.put(frontendTokenDefinitionImpl.getThemeId(), frontendTokenDefinitionImpl);
                }
            }
            return bundle;
        }

        public void modifiedBundle(Bundle bundle1, BundleEvent bundleEvent, Bundle bundle2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedBundle(Bundle bundle1, BundleEvent bundleEvent, Bundle bundle2) {
            FrontendTokenDefinitionRegistryImpl frontendTokenDefinitionRegistryImpl = FrontendTokenDefinitionRegistryImpl.this;
            synchronized (frontendTokenDefinitionRegistryImpl) {
                FrontendTokenDefinitionImpl frontendTokenDefinitionImpl = FrontendTokenDefinitionRegistryImpl.this.bundleFrontendTokenDefinitionImpls.remove(bundle1);
                if (frontendTokenDefinitionImpl != null && frontendTokenDefinitionImpl.getThemeId() != null) {
                    FrontendTokenDefinitionRegistryImpl.this.themeIdFrontendTokenDefinitionImpls.remove(frontendTokenDefinitionImpl.getThemeId());
                }
            }
        }
    };

    public FrontendTokenDefinition getFrontendTokenDefinition(String themeId) {
        return this.themeIdFrontendTokenDefinitionImpls.get(themeId);
    }

    public Collection<FrontendTokenDefinition> getFrontendTokenDefinitions() {
        return new ArrayList<FrontendTokenDefinition>(this.bundleFrontendTokenDefinitionImpls.values());
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleTracker = new BundleTracker(bundleContext, 32, this._bundleTrackerCustomizer);
        this.bundleTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        this.bundleTracker.close();
        FrontendTokenDefinitionRegistryImpl frontendTokenDefinitionRegistryImpl = this;
        synchronized (frontendTokenDefinitionRegistryImpl) {
            this.bundleFrontendTokenDefinitionImpls.clear();
            this.themeIdFrontendTokenDefinitionImpls.clear();
        }
    }

    protected FrontendTokenDefinitionImpl getFrontendTokenDefinitionImpl(Bundle bundle) {
        String json = this._getFrontendTokenDefinitionJSON(bundle);
        if (json == null) {
            return null;
        }
        String themeId = this.getThemeId(bundle);
        try {
            ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)bundle.getSymbolicName());
            if (resourceBundleLoader == null) {
                resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
            }
            return new FrontendTokenDefinitionImpl(this.jsonFactory.createJSONObject(json), this.jsonFactory, resourceBundleLoader, themeId);
        }
        catch (JSONException | RuntimeException exception) {
            _log.error((Object)("Unable to parse frontend token definitions for theme " + themeId), exception);
            return null;
        }
    }

    protected String getServletContextName(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String webContextPath = (String)headers.get("Web-ContextPath");
        if (webContextPath == null) {
            return null;
        }
        if (webContextPath.startsWith("/")) {
            webContextPath = webContextPath.substring(1);
        }
        return webContextPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getThemeId(Bundle bundle) {
        URL url = bundle.getEntry("WEB-INF/liferay-look-and-feel.xml");
        if (url == null) {
            return null;
        }
        try (InputStream inputStream = url.openStream();){
            String xml = StringUtil.read((InputStream)inputStream);
            xml = xml.replaceAll("\n", " ");
            Matcher matcher = _themeIdPattern.matcher(xml);
            if (!matcher.matches()) {
                String string = null;
                return string;
            }
            String themeId = matcher.group(1);
            String servletContextName = this.getServletContextName(bundle);
            if (servletContextName != null) {
                themeId = themeId + "_WAR_" + servletContextName;
            }
            String string = this.portal.getJsSafePortletId(themeId);
            return string;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read WEB-INF/liferay-look-and-feel.xml", ioException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _getFrontendTokenDefinitionJSON(Bundle bundle) {
        URL url = bundle.getEntry("WEB-INF/frontend-token-definition.json");
        if (url == null) {
            return null;
        }
        try (InputStream inputStream = url.openStream();){
            String string = StringUtil.read((InputStream)inputStream);
            return string;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to read WEB-INF/frontend-token-definition.json", ioException);
        }
    }
}

