/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.frontend.token.definition.FrontendTokenSet;
import com.liferay.frontend.token.definition.internal.FrontendTokenDefinitionImpl;
import com.liferay.frontend.token.definition.internal.FrontendTokenMappingImpl;
import com.liferay.frontend.token.definition.internal.FrontendTokenSetImpl;
import com.liferay.frontend.token.definition.internal.json.JSONLocalizer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FrontendTokenImpl
implements FrontendToken {
    private final Object _defaultValue;
    private final Collection<FrontendTokenMapping> _frontendTokenMappings = new ArrayList<FrontendTokenMapping>();
    private final Map<String, List<FrontendTokenMapping>> _frontendTokenMappingsMap = new HashMap<String, List<FrontendTokenMapping>>();
    private final FrontendTokenSetImpl _frontendTokenSetImpl;
    private final JSONLocalizer _jsonLocalizer;
    private final String _name;
    private final FrontendToken.Type _type;

    public FrontendTokenImpl(FrontendTokenSetImpl frontendTokenSetImpl, JSONObject jsonObject) {
        this._frontendTokenSetImpl = frontendTokenSetImpl;
        FrontendTokenDefinitionImpl frontendTokenDefinitionImpl = frontendTokenSetImpl.getFrontendTokenDefinition();
        this._jsonLocalizer = frontendTokenDefinitionImpl.createJSONLocalizer(jsonObject);
        this._name = jsonObject.getString("name");
        this._type = FrontendToken.Type.parse((String)jsonObject.getString("type"));
        if (this._type == FrontendToken.Type.BOOLEAN) {
            this._defaultValue = jsonObject.getBoolean("defaultValue");
        } else if (this._type == FrontendToken.Type.INT) {
            this._defaultValue = jsonObject.getInt("defaultValue");
        } else if (this._type == FrontendToken.Type.DOUBLE) {
            this._defaultValue = jsonObject.getDouble("defaultValue");
        } else if (this._type == FrontendToken.Type.STRING) {
            this._defaultValue = jsonObject.getString("defaultValue");
        } else {
            throw new RuntimeException("Unsupported frontend token type " + this._type);
        }
        JSONArray mappingsJSONArray = jsonObject.getJSONArray("mappings");
        if (mappingsJSONArray == null) {
            return;
        }
        for (int i = 0; i < mappingsJSONArray.length(); ++i) {
            FrontendTokenMappingImpl frontendTokenMapping = new FrontendTokenMappingImpl(this, mappingsJSONArray.getJSONObject(i));
            this._frontendTokenMappings.add(frontendTokenMapping);
            List frontendTokenMappings = this._frontendTokenMappingsMap.computeIfAbsent(frontendTokenMapping.getType(), type -> new ArrayList());
            frontendTokenMappings.add(frontendTokenMapping);
        }
    }

    public <T> T getDefaultValue() {
        return (T)this._defaultValue;
    }

    public Collection<FrontendTokenMapping> getFrontendTokenMappings() {
        return this._frontendTokenMappings;
    }

    public Collection<FrontendTokenMapping> getFrontendTokenMappings(String type) {
        return this._frontendTokenMappingsMap.get(type);
    }

    public FrontendTokenSet getFrontendTokenSet() {
        return this._frontendTokenSetImpl;
    }

    public JSONObject getJSONObject(Locale locale) {
        return this._jsonLocalizer.getJSONObject(locale);
    }

    public String getName() {
        return this._name;
    }

    public FrontendToken.Type getType() {
        return this._type;
    }

    protected FrontendTokenDefinitionImpl getFrontendTokenDefinition() {
        return this._frontendTokenSetImpl.getFrontendTokenDefinition();
    }
}

