/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.frontend.token.definition.FrontendTokenSet;
import com.liferay.frontend.token.definition.internal.FrontendTokenDefinitionImpl;
import com.liferay.frontend.token.definition.internal.FrontendTokenMappingImpl;
import com.liferay.frontend.token.definition.internal.FrontendTokenSetImpl;
import com.liferay.frontend.token.definition.internal.json.JSONLocalizer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FrontendTokenImpl
implements FrontendToken {
    private final Object _defaultValue;
    private Collection<FrontendTokenMapping> _frontendTokenMappings = new ArrayList<FrontendTokenMapping>();
    private final FrontendTokenSetImpl _frontendTokenSetImpl;
    private final JSONLocalizer _jsonLocalizer;
    private final FrontendToken.Type _type;

    public FrontendTokenImpl(FrontendTokenSetImpl frontendTokenSetImpl, JSONObject jsonObject) {
        this._frontendTokenSetImpl = frontendTokenSetImpl;
        FrontendTokenDefinitionImpl frontendTokenDefinitionImpl = frontendTokenSetImpl.getFrontendTokenDefinition();
        this._jsonLocalizer = frontendTokenDefinitionImpl.createJSONLocalizer(jsonObject);
        this._type = FrontendToken.Type.parse((String)jsonObject.getString("type"));
        if (this._type == FrontendToken.Type.BOOLEAN) {
            this._defaultValue = jsonObject.getBoolean("defaultValue");
        } else if (this._type == FrontendToken.Type.INT) {
            this._defaultValue = jsonObject.getInt("defaultValue");
        } else if (this._type == FrontendToken.Type.DOUBLE) {
            this._defaultValue = jsonObject.getDouble("defaultValue");
        } else if (this._type == FrontendToken.Type.STRING) {
            this._defaultValue = jsonObject.getString("defaultValue");
        } else {
            throw new RuntimeException("Unsupported frontend token type " + this._type.toString());
        }
        JSONArray mappingsJSONArray = jsonObject.getJSONArray("mappings");
        if (mappingsJSONArray == null) {
            return;
        }
        for (int i = 0; i < mappingsJSONArray.length(); ++i) {
            this._frontendTokenMappings.add(new FrontendTokenMappingImpl(this, mappingsJSONArray.getJSONObject(i)));
        }
    }

    public <T> T getDefaultValue() {
        return (T)this._defaultValue;
    }

    public Collection<FrontendTokenMapping> getFrontendTokenMappings() {
        return this._frontendTokenMappings;
    }

    public Collection<FrontendTokenMapping> getFrontendTokenMappings(String type) {
        Stream<FrontendTokenMapping> stream = this._frontendTokenMappings.stream();
        return stream.filter(frontendTokenMapping -> type.equals(frontendTokenMapping.getType())).collect(Collectors.toList());
    }

    public FrontendTokenSet getFrontendTokenSet() {
        return this._frontendTokenSetImpl;
    }

    public String getJSON(Locale locale) {
        return this._jsonLocalizer.getJSON(locale);
    }

    public FrontendToken.Type getType() {
        return this._type;
    }

    protected FrontendTokenDefinitionImpl getFrontendTokenDefinition() {
        return this._frontendTokenSetImpl.getFrontendTokenDefinition();
    }
}

