/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.token.definition.internal;

import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenCategory;
import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.frontend.token.definition.FrontendTokenSet;
import com.liferay.frontend.token.definition.internal.FrontendTokenCategoryImpl;
import com.liferay.frontend.token.definition.internal.json.JSONLocalizer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class FrontendTokenDefinitionImpl
implements FrontendTokenDefinition {
    private static final Log _log = LogFactoryUtil.getLog(FrontendTokenDefinitionImpl.class);
    private static final Set<String> _localizableKeys = new HashSet<String>(Arrays.asList("label"));
    private final Collection<FrontendTokenCategory> _frontendTokenCategories = new ArrayList<FrontendTokenCategory>();
    private final Collection<FrontendTokenMapping> _frontendTokenMappings = new ArrayList<FrontendTokenMapping>();
    private final Collection<FrontendToken> _frontendTokens = new ArrayList<FrontendToken>();
    private final Collection<FrontendTokenSet> _frontendTokenSets = new ArrayList<FrontendTokenSet>();
    private final String _json;
    private final JSONFactory _jsonFactory;
    private final JSONLocalizer _jsonLocalizer;
    private final ResourceBundleLoader _resourceBundleLoader;
    private final String _themeId;

    public FrontendTokenDefinitionImpl(JSONObject jsonObject, JSONFactory jsonFactory, ResourceBundleLoader resourceBundleLoader, String themeId) {
        this._jsonFactory = jsonFactory;
        this._resourceBundleLoader = resourceBundleLoader;
        this._themeId = themeId;
        this._json = this._jsonFactory.looseSerializeDeep((Object)jsonObject);
        this._jsonLocalizer = this.createJSONLocalizer(jsonObject);
        JSONArray frontendTokenCategoriesJSONArray = jsonObject.getJSONArray("frontendTokenCategories");
        if (frontendTokenCategoriesJSONArray == null) {
            return;
        }
        this.frontendTokenizer(frontendTokenCategoriesJSONArray);
    }

    public FrontendTokenDefinitionImpl(String json, JSONFactory jsonFactory, ResourceBundleLoader resourceBundleLoader, String themeId) {
        this._json = json;
        this._jsonFactory = jsonFactory;
        this._resourceBundleLoader = resourceBundleLoader;
        this._themeId = themeId;
        JSONObject jsonObject = null;
        try {
            jsonObject = jsonFactory.createJSONObject(json);
        }
        catch (JSONException jsonException) {
            _log.error((Object)("Unable to parse JSON for theme " + this._themeId), (Throwable)jsonException);
        }
        this._jsonLocalizer = this.createJSONLocalizer(jsonObject);
        JSONArray frontendTokenCategoriesJSONArray = jsonObject.getJSONArray("frontendTokenCategories");
        if (frontendTokenCategoriesJSONArray == null) {
            return;
        }
        this.frontendTokenizer(frontendTokenCategoriesJSONArray);
    }

    public Collection<FrontendTokenCategory> getFrontendTokenCategories() {
        return this._frontendTokenCategories;
    }

    public Collection<FrontendTokenMapping> getFrontendTokenMappings() {
        return this._frontendTokenMappings;
    }

    public Collection<FrontendToken> getFrontendTokens() {
        return this._frontendTokens;
    }

    public Collection<FrontendTokenSet> getFrontendTokenSets() {
        return this._frontendTokenSets;
    }

    public String getJSON(Locale locale) {
        return this._jsonLocalizer.getJSON(locale);
    }

    public String getThemeId() {
        return this._themeId;
    }

    protected JSONLocalizer createJSONLocalizer(JSONObject jsonObject) {
        return new JSONLocalizer(this._jsonFactory.looseSerializeDeep((Object)jsonObject), this._jsonFactory, this._resourceBundleLoader, this._themeId);
    }

    protected void frontendTokenizer(JSONArray frontendTokenCategoriesJSONArray) {
        for (int i = 0; i < frontendTokenCategoriesJSONArray.length(); ++i) {
            FrontendTokenCategoryImpl frontendTokenCategory = new FrontendTokenCategoryImpl(this, frontendTokenCategoriesJSONArray.getJSONObject(i));
            this._frontendTokenCategories.add(frontendTokenCategory);
            this._frontendTokenMappings.addAll(frontendTokenCategory.getFrontendTokenMappings());
            this._frontendTokens.addAll(frontendTokenCategory.getFrontendTokens());
            this._frontendTokenSets.addAll(frontendTokenCategory.getFrontendTokenSets());
        }
    }

    protected String translateJSON(Locale locale) {
        if (this._resourceBundleLoader == null) {
            return this._json;
        }
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._json);
            this.translateJSONObject(jsonObject, this._resourceBundleLoader.loadResourceBundle(locale));
            return this._jsonFactory.looseSerializeDeep((Object)jsonObject);
        }
        catch (JSONException jsonException) {
            _log.error((Object)("Unable to parse frontend-token-definition.json for theme " + this._themeId), (Throwable)jsonException);
            return this._json;
        }
    }

    protected void translateJSONObject(JSONObject jsonObject, ResourceBundle resourceBundle) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : jsonObject.keySet()) {
            if (_localizableKeys.contains(string)) {
                String value = jsonObject.getString(string);
                if (!Validator.isNotNull((String)value)) continue;
                try {
                    map.put(string, ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)value));
                }
                catch (MissingResourceException missingResourceException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to find key " + string), (Throwable)missingResourceException);
                }
                continue;
            }
            Object object = jsonObject.get(string);
            if (object instanceof JSONObject) {
                this.translateJSONObject((JSONObject)object, resourceBundle);
                continue;
            }
            if (!(object instanceof JSONArray)) continue;
            JSONArray jsonArray = (JSONArray)object;
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object childObject = jsonArray.get(i);
                if (!(childObject instanceof JSONObject)) continue;
                this.translateJSONObject((JSONObject)childObject, resourceBundle);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            jsonObject.put((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

