/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.contributor.extender.internal;

import com.liferay.frontend.theme.contributor.extender.BundleWebResources;
import com.liferay.frontend.theme.contributor.extender.internal.BundleWebResourcesImpl;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.PortalWebResources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import org.apache.felix.utils.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ThemeContributorExtension
implements Extension {
    private final Bundle _bundle;
    private final BundleWebResourcesImpl _bundleWebResources;
    private ServiceTracker<ServletContext, Collection<ServiceRegistration<?>>> _serviceTracker;
    private final int _weight;

    public ThemeContributorExtension(Bundle bundle, BundleWebResourcesImpl bundleWebResources, int weight) {
        this._bundle = bundle;
        this._bundleWebResources = bundleWebResources;
        this._weight = weight;
    }

    public void destroy() throws Exception {
        this._serviceTracker.close();
    }

    public void start() throws Exception {
        final BundleContext bundleContext = this._bundle.getBundleContext();
        String filter = StringBundler.concat((String[])new String[]{"(&(objectClass=", ServletContext.class.getName(), ")(osgi.web.symbolicname=", this._bundle.getSymbolicName(), "))"});
        final Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", this._weight);
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServletContext, Collection<ServiceRegistration<?>>>(){

            public Collection<ServiceRegistration<?>> addingService(ServiceReference<ServletContext> serviceReference) {
                ArrayList serviceRegistrations = new ArrayList();
                ServletContext servletContext = (ServletContext)bundleContext.getService(serviceReference);
                serviceRegistrations.add(bundleContext.registerService(PortalWebResources.class.getName(), (Object)new ThemeContributorPortalWebResources(servletContext), properties));
                String contextPath = servletContext.getContextPath();
                ThemeContributorExtension.this._bundleWebResources.setServletContextPath(contextPath);
                serviceRegistrations.add(bundleContext.registerService(BundleWebResources.class, (Object)ThemeContributorExtension.this._bundleWebResources, properties));
                return serviceRegistrations;
            }

            public void modifiedService(ServiceReference<ServletContext> serviceReference, Collection<ServiceRegistration<?>> service) {
                this.removedService(serviceReference, service);
                this.addingService((ServiceReference)serviceReference);
            }

            public void removedService(ServiceReference<ServletContext> serviceReference, Collection<ServiceRegistration<?>> serviceRegistrations) {
                for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                    serviceRegistration.unregister();
                }
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    private class ThemeContributorPortalWebResources
    implements PortalWebResources {
        private final ServletContext _servletContext;

        public String getContextPath() {
            return this._servletContext.getContextPath();
        }

        public long getLastModified() {
            return ThemeContributorExtension.this._bundle.getLastModified();
        }

        public String getResourceType() {
            return "theme_contributor";
        }

        public ServletContext getServletContext() {
            return this._servletContext;
        }

        private ThemeContributorPortalWebResources(ServletContext servletContext) {
            this._servletContext = servletContext;
        }
    }
}

