/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.NPMRegistryImpl;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.dynamic.DynamicJSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModifiableJSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistryUpdate;
import java.util.Collection;

public class NPMRegistryUpdateImpl
implements NPMRegistryUpdate {
    private boolean _finished;
    private final NPMRegistryImpl _npmRegistryImpl;

    public NPMRegistryUpdateImpl(NPMRegistryImpl npmRegistryImpl) {
        this._npmRegistryImpl = npmRegistryImpl;
    }

    public void finish() {
        this._failIfFinished();
        this._finished = true;
        this._npmRegistryImpl.finishUpdate(this);
    }

    public JSModule registerJSModule(JSPackage jsPackage, String moduleName, Collection<String> dependencies, String js, String map) {
        this._failIfFinished();
        if (!(jsPackage instanceof ModifiableJSPackage)) {
            throw new IllegalArgumentException("Invalid JS package type " + String.valueOf(jsPackage.getClass()));
        }
        ModifiableJSPackage modifiableJSPackage = (ModifiableJSPackage)jsPackage;
        DynamicJSModule jsModule = new DynamicJSModule((JSPackage)modifiableJSPackage, moduleName, dependencies, js, map);
        modifiableJSPackage.addJSModule((JSModule)jsModule);
        return jsModule;
    }

    public void unregisterJSModule(JSModule jsModule) {
        this._failIfFinished();
        JSPackage jsPackage = jsModule.getJSPackage();
        if (!(jsPackage instanceof ModifiableJSPackage)) {
            throw new IllegalArgumentException("Invalid JS package type " + String.valueOf(jsPackage.getClass()));
        }
        ModifiableJSPackage modifiableJSPackage = (ModifiableJSPackage)jsPackage;
        modifiableJSPackage.removeJSModule(jsModule);
    }

    public void updateJSModule(JSModule jsModule, Collection<String> dependencies, String js, String map) {
        this._failIfFinished();
        JSPackage jsPackage = jsModule.getJSPackage();
        if (!(jsPackage instanceof ModifiableJSPackage)) {
            throw new IllegalArgumentException("Invalid JS package type " + String.valueOf(jsPackage.getClass()));
        }
        ModifiableJSPackage modifiableJSPackage = (ModifiableJSPackage)jsPackage;
        modifiableJSPackage.replaceJSModule((JSModule)new DynamicJSModule((JSPackage)modifiableJSPackage, jsModule.getName(), dependencies, js, map));
    }

    private synchronized void _failIfFinished() {
        if (this._finished) {
            throw new IllegalStateException("Update has been finished already");
        }
    }
}

