/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.resolution;

import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorModule;
import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackage;
import com.liferay.frontend.js.loader.modules.extender.internal.configuration.Details;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModule;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModuleNameMapper;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModulesMap;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModulesResolution;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.adapter.JSBrowserModule;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.adapter.JSConfigGeneratorBrowserModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilderFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.configuration.Details"}, immediate=true, service={BrowserModulesResolver.class})
public class BrowserModulesResolver {
    @Reference
    private AbsolutePortalURLBuilderFactory _absolutePortalURLBuilderFactory;
    private final Map<String, BrowserModule> _browserModulesMap = new ConcurrentHashMap<String, BrowserModule>();
    private Details _details;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private NPMRegistry _npmRegistry;
    private ServiceTracker<ServletContext, JSConfigGeneratorPackage> _serviceTracker;

    public BrowserModulesResolution resolve(List<String> moduleNames, HttpServletRequest httpServletRequest) {
        BrowserModulesResolution browserModulesResolution = new BrowserModulesResolution(this._jsonFactory, this._details.explainResolutions());
        BrowserModulesMap browserModulesMap = new BrowserModulesMap(browserModulesResolution, this._npmRegistry);
        for (String moduleName : moduleNames) {
            this._resolve(browserModulesMap, moduleName, browserModulesResolution, httpServletRequest);
        }
        this._populateMappedModuleNames(browserModulesResolution);
        return browserModulesResolution;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._details = (Details)ConfigurableUtil.createConfigurable(Details.class, properties);
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)("(&(objectClass=" + ServletContext.class.getName() + ")(osgi.web.contextpath=*))"), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServletContext, JSConfigGeneratorPackage>(){

            public JSConfigGeneratorPackage addingService(ServiceReference<ServletContext> serviceReference) {
                Bundle bundle = serviceReference.getBundle();
                URL url = bundle.getEntry("META-INF/config.json");
                if (url == null) {
                    return null;
                }
                JSConfigGeneratorPackage jsConfigGeneratorPackage = new JSConfigGeneratorPackage(BrowserModulesResolver.this._details.applyVersioning(), serviceReference.getBundle(), (String)serviceReference.getProperty("osgi.web.contextpath"));
                for (JSConfigGeneratorModule jsConfigGeneratorModule : jsConfigGeneratorPackage.getJSConfigGeneratorModules()) {
                    JSConfigGeneratorBrowserModule jsConfigGeneratorBrowserModule = new JSConfigGeneratorBrowserModule(jsConfigGeneratorModule);
                    BrowserModulesResolver.this._browserModulesMap.put(jsConfigGeneratorBrowserModule.getName(), jsConfigGeneratorBrowserModule);
                }
                return jsConfigGeneratorPackage;
            }

            public void modifiedService(ServiceReference<ServletContext> serviceReference, JSConfigGeneratorPackage jsConfigGeneratorPackage) {
            }

            public void removedService(ServiceReference<ServletContext> serviceReference, JSConfigGeneratorPackage jsConfigGeneratorPackage) {
                for (JSConfigGeneratorModule jsConfigGeneratorModule : jsConfigGeneratorPackage.getJSConfigGeneratorModules()) {
                    BrowserModulesResolver.this._browserModulesMap.remove(jsConfigGeneratorModule.getId());
                }
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private void _populateMappedModuleNames(BrowserModulesResolution browserModulesResolution) {
        HashSet<JSPackage> jsPackages = new HashSet<JSPackage>();
        for (String moduleName : browserModulesResolution.getResolvedModuleNames()) {
            JSPackage jsPackage = this._npmRegistry.getResolvedJSPackage(ModuleNameUtil.getPackageName((String)moduleName));
            if (jsPackage == null) continue;
            jsPackages.add(jsPackage);
        }
        for (JSPackage jsPackage : jsPackages) {
            for (JSModuleAlias jsModuleAlias : jsPackage.getJSModuleAliases()) {
                browserModulesResolution.putMappedModuleName(jsPackage.getResolvedId() + "/" + jsModuleAlias.getAlias(), jsPackage.getResolvedId() + "/" + jsModuleAlias.getModuleName(), true);
            }
        }
    }

    private boolean _processBrowserModule(BrowserModulesMap browserModulesMap, BrowserModule browserModule, BrowserModulesResolution browserModulesResolution, HttpServletRequest httpServletRequest) {
        String moduleName = browserModule.getName();
        if (browserModulesResolution.isProcessedModuleName(moduleName)) {
            return false;
        }
        browserModulesResolution.addProcessedModuleName(moduleName);
        HashMap<String, String> dependenciesMap = new HashMap<String, String>();
        browserModulesResolution.indentExplanation();
        for (String dependency : browserModule.getDependencies()) {
            if (ModuleNameUtil.isReservedModuleName((String)dependency)) continue;
            String dependencyModuleName = ModuleNameUtil.getDependencyPath((String)moduleName, (String)dependency);
            dependencyModuleName = BrowserModuleNameMapper.mapModuleName(this._npmRegistry, dependencyModuleName, browserModule.getDependenciesMap());
            dependenciesMap.put(dependency, dependencyModuleName);
            JSBrowserModule dependencyBrowserModule = browserModulesMap.get(dependencyModuleName);
            if (dependencyBrowserModule != null) {
                this._processBrowserModule(browserModulesMap, dependencyBrowserModule, browserModulesResolution, httpServletRequest);
                continue;
            }
            browserModulesResolution.addError(StringBundler.concat((String[])new String[]{"Missing dependency '", dependencyModuleName, "' of '", moduleName, "'"}));
        }
        browserModulesResolution.dedentExplanation();
        browserModulesResolution.putDependenciesMap(moduleName, dependenciesMap);
        JSONObject flagsJSONObject = browserModule.getFlagsJSONObject();
        if (flagsJSONObject != null) {
            browserModulesResolution.putModuleFlags(moduleName, flagsJSONObject);
        }
        AbsolutePortalURLBuilder absolutePortalURLBuilder = this._absolutePortalURLBuilderFactory.getAbsolutePortalURLBuilder(httpServletRequest);
        absolutePortalURLBuilder.ignoreCDNHost();
        browserModulesResolution.putPath(moduleName, absolutePortalURLBuilder.forResource(browserModule.getPath()).build());
        browserModulesResolution.addResolvedModuleName(moduleName);
        return true;
    }

    private void _resolve(BrowserModulesMap browserModulesMap, String moduleName, BrowserModulesResolution browserModulesResolution, HttpServletRequest httpServletRequest) {
        String mappedModuleName = BrowserModuleNameMapper.mapModuleName(this._npmRegistry, moduleName);
        JSBrowserModule browserModule = browserModulesMap.get(mappedModuleName);
        if (browserModule == null) {
            browserModulesResolution.addError(StringBundler.concat((String[])new String[]{"Missing required module '", moduleName, "'"}));
            return;
        }
        if (!moduleName.equals(mappedModuleName)) {
            browserModulesResolution.putMappedModuleName(moduleName, mappedModuleName, true);
        }
        this._processBrowserModule(browserModulesMap, browserModule, browserModulesResolution, httpServletRequest);
    }
}

