/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.bundle.config.extender.internal;

import com.liferay.frontend.js.bundle.config.extender.internal.JSBundleConfigPortalWebResources;
import com.liferay.frontend.js.bundle.config.extender.internal.JSBundleConfigTracker;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.minifier.MinifierUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.servlet.name=com.liferay.frontend.js.bundle.config.extender.internal.JSBundleConfigServlet", "osgi.http.whiteboard.servlet.pattern=/js_bundle_config", "service.ranking:Integer=2147482647"}, service={JSBundleConfigServlet.class, Servlet.class})
public class JSBundleConfigServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(JSBundleConfigServlet.class);
    private ComponentContext _componentContext;
    private JSBundleConfigTracker _jsBundleConfigTracker;
    @Reference
    private Portal _portal;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._componentContext.enableComponent(JSBundleConfigPortalWebResources.class.getName());
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        this._componentContext = componentContext;
    }

    protected JSBundleConfigTracker getJSBundleConfigTracker() {
        return this._jsBundleConfigTracker;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Collection<JSBundleConfigTracker.JSConfig> jsConfigs = this._jsBundleConfigTracker.getJSConfigs();
        if (!jsConfigs.isEmpty()) {
            printWriter.println("(function() {");
            for (JSBundleConfigTracker.JSConfig jsConfig : jsConfigs) {
                URL url = jsConfig.getURL();
                try {
                    InputStream inputStream = url.openStream();
                    Throwable throwable = null;
                    try {
                        printWriter.println("try {");
                        ServletContext servletContext = jsConfig.getServletContext();
                        printWriter.println(StringBundler.concat((String[])new String[]{"var MODULE_PATH = '", this._portal.getPathProxy(), servletContext.getContextPath(), "';"}));
                        printWriter.println(StringUtil.replace((String)StringUtil.read((InputStream)inputStream), (String)"//# sourceMappingURL=config.js.map", (String)""));
                        printWriter.println("} catch (error) {");
                        printWriter.println("console.error(error);");
                        printWriter.println("}");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    _log.error((Object)"Unable to open resource", (Throwable)exception);
                }
            }
            printWriter.println("}());");
        }
        printWriter.close();
        this._writeResponse(httpServletResponse, stringWriter.toString());
    }

    @Reference(unbind="-")
    protected void setJSBundleConfigTracker(JSBundleConfigTracker jsBundleConfigTracker) {
        this._jsBundleConfigTracker = jsBundleConfigTracker;
    }

    private void _writeResponse(HttpServletResponse httpServletResponse, String content) throws IOException {
        httpServletResponse.setContentType("text/javascript; charset=UTF-8");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        PrintWriter printWriter = new PrintWriter((OutputStream)servletOutputStream, true);
        printWriter.write(MinifierUtil.minifyJavaScript((String)"/o/js_bundle_config", (String)content));
        printWriter.close();
    }
}

