/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.bundle.config.extender.internal;

import com.liferay.frontend.js.bundle.config.extender.internal.JSBundleConfigPortalWebResources;
import com.liferay.frontend.js.bundle.config.extender.internal.JSBundleConfigTracker;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.log.Logger;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.servlet.name=com.liferay.frontend.js.bundle.config.extender.internal.JSBundleConfigServlet", "osgi.http.whiteboard.servlet.pattern=/js_bundle_config", "service.ranking:Integer=2147482647"}, service={JSBundleConfigServlet.class, Servlet.class})
public class JSBundleConfigServlet
extends HttpServlet {
    private ComponentContext _componentContext;
    private JSBundleConfigTracker _jsBundleConfigTracker;
    private Logger _logger;
    @Reference
    private Portal _portal;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._componentContext.enableComponent(JSBundleConfigPortalWebResources.class.getName());
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        this._logger = new Logger(componentContext.getBundleContext());
        this._componentContext = componentContext;
    }

    protected JSBundleConfigTracker getJSBundleConfigTracker() {
        return this._jsBundleConfigTracker;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/javascript; charset=UTF-8");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        PrintWriter printWriter = new PrintWriter((OutputStream)servletOutputStream, true);
        Collection<JSBundleConfigTracker.JSConfig> jsConfigs = this._jsBundleConfigTracker.getJSConfigs();
        if (!jsConfigs.isEmpty()) {
            printWriter.println("(function() {");
            for (JSBundleConfigTracker.JSConfig jsConfig : jsConfigs) {
                URL url = jsConfig.getURL();
                try {
                    InputStream inputStream = url.openStream();
                    Throwable throwable = null;
                    try {
                        servletOutputStream.println("try {");
                        ServletContext servletContext = jsConfig.getServletContext();
                        servletOutputStream.println(StringBundler.concat((String[])new String[]{"var MODULE_PATH = '", this._portal.getPathProxy(), servletContext.getContextPath(), "';"}));
                        StreamUtil.transfer((InputStream)inputStream, (OutputStream)servletOutputStream, (boolean)false);
                        servletOutputStream.println("} catch (error) {");
                        servletOutputStream.println("console.error(error);");
                        servletOutputStream.println("}");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    this._logger.log(1, "Unable to open resource", (Throwable)e);
                }
            }
            printWriter.println("}());");
        }
        printWriter.close();
    }

    @Reference(unbind="-")
    protected void setJSBundleConfigTracker(JSBundleConfigTracker jsBundleConfigTracker) {
        this._jsBundleConfigTracker = jsBundleConfigTracker;
    }
}

