/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.image.editor.integration.document.library.internal.portlet.action;

import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/edit_file_entry_with_image_editor"}, service={MVCActionCommand.class})
public class EditFileEntryImageEditorMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(bundle.symbolic.name=com.liferay.frontend.image.editor.integration.document.library)", unbind="-")
    private ResourceBundleLoader _resourceBundleLoader;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            this.updateFileEntry(actionRequest, actionResponse);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (PortalException pe) {
            this.handleUploadException((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        }
    }

    protected void handleUploadException(PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("success", (Object)Boolean.FALSE);
        try {
            JSONPortletResponseUtil.writeJSON((PortletRequest)portletRequest, (PortletResponse)portletResponse, (Object)jsonObject);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected FileEntry updateFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"fileEntryId");
        String sourceFileName = uploadPortletRequest.getFileName("imageEditorFileName");
        FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
        InputStream inputStream = uploadPortletRequest.getFileAsStream("imageEditorFileName");
        String contentType = uploadPortletRequest.getContentType("imageEditorFileName");
        long size = uploadPortletRequest.getSize("imageEditorFileName");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (UploadPortletRequest)uploadPortletRequest);
        fileEntry = this._dlAppService.updateFileEntry(fileEntryId, sourceFileName, contentType, fileEntry.getTitle(), fileEntry.getDescription(), "", false, inputStream, size, serviceContext);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("success", (Object)Boolean.TRUE);
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(LanguageUtil.getLanguageId((Locale)themeDisplay.getLocale()));
        SessionMessages.add((PortletRequest)actionRequest, (String)"requestProcessed", (Object)LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-image-was-edited-successfully"));
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        return fileEntry;
    }
}

