/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.image.editor.integration.document.library.display.context.logic;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptToolbarItem;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class ImageEditorDLDisplayContextHelper {
    private final FileEntry _fileEntry;
    private final FileVersion _fileVersion;
    private Boolean _isShowImageEditorAction;
    private final HttpServletRequest _request;
    private final ThemeDisplay _themeDisplay;

    public ImageEditorDLDisplayContextHelper(FileVersion fileVersion, HttpServletRequest request) {
        this._fileVersion = fileVersion;
        this._request = request;
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            FileEntry fileEntry = null;
            if (fileVersion != null) {
                fileEntry = fileVersion.getFileEntry();
            }
            this._fileEntry = fileEntry;
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to create image editor document library display context helper for file version " + fileVersion, (Throwable)pe);
        }
    }

    public JavaScriptMenuItem getJavacriptEditWithImageEditorMenuItem(ResourceBundle resourceBundle) throws PortalException {
        JavaScriptMenuItem javascriptMenuItem = new JavaScriptMenuItem();
        javascriptMenuItem.setKey("#edit-with-image-editor");
        javascriptMenuItem.setLabel(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"edit-with-image-editor"));
        javascriptMenuItem.setOnClick(this._getOnclickMethod());
        javascriptMenuItem.setJavaScript(this._getJavaScript());
        return javascriptMenuItem;
    }

    public JavaScriptToolbarItem getJavacriptEditWithImageEditorToolbarItem(ResourceBundle resourceBundle) throws PortalException {
        JavaScriptToolbarItem javascriptToolbarItem = new JavaScriptToolbarItem();
        javascriptToolbarItem.setKey("#edit-with-image-editor");
        javascriptToolbarItem.setLabel(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"edit-with-image-editor"));
        javascriptToolbarItem.setOnClick(this._getOnclickMethod());
        javascriptToolbarItem.setJavaScript(this._getJavaScript());
        return javascriptToolbarItem;
    }

    public boolean isShowActions() throws PortalException {
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        String portletName = portletDisplay.getPortletName();
        if (portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet")) {
            return true;
        }
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(this._themeDisplay.getLayout(), portletDisplay.getId()));
        TypedSettings typedSettings = new TypedSettings(settings);
        return typedSettings.getBooleanValue("showActions");
    }

    public boolean isShowImageEditorAction() throws PortalException {
        if (this._isShowImageEditorAction != null) {
            return this._isShowImageEditorAction;
        }
        this._isShowImageEditorAction = !this.isShowActions() ? Boolean.valueOf(false) : (!DLFileEntryPermission.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (FileEntry)this._fileEntry, (String)"UPDATE") || this._fileEntry.isCheckedOut() && !this._fileEntry.hasLock() ? Boolean.valueOf(false) : (!ArrayUtil.contains((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES, (Object)this._fileEntry.getMimeType()) ? Boolean.valueOf(false) : Boolean.valueOf(true)));
        return this._isShowImageEditorAction;
    }

    private String _getJavaScript() throws PortalException {
        String javaScript = "/com/liferay/frontend/image/editor/integration/document/library/display/context/dependencies/edit_with_image_editor_js.ftl";
        Class<?> clazz = this.getClass();
        URLTemplateResource urlTemplateResource = new URLTemplateResource(javaScript, clazz.getResource(javaScript));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        template.put((Object)"editLanguageKey", (Object)LanguageUtil.get((HttpServletRequest)this._request, (String)"edit"));
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        template.put((Object)"namespace", (Object)liferayPortletResponse.getNamespace());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }

    private LiferayPortletResponse _getLiferayPortletResponse() {
        PortletResponse portletResponse = (PortletResponse)this._request.getAttribute("javax.portlet.response");
        return PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse);
    }

    private String _getOnclickMethod() {
        String imageEditorPortletId = PortletProviderUtil.getPortletId((String)Image.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        LiferayPortletURL imageEditorURL = PortletURLFactoryUtil.create((HttpServletRequest)this._request, (String)imageEditorPortletId, (String)"RENDER_PHASE");
        imageEditorURL.setParameter("mvcRenderCommandName", "/image_editor/view");
        try {
            imageEditorURL.setWindowState(LiferayWindowState.POP_UP);
        }
        catch (Exception e) {
            throw new SystemException("Unable to set window state", (Throwable)e);
        }
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL editURL = liferayPortletResponse.createActionURL();
        editURL.setParameter("javax.portlet.action", "/document_library/edit_file_entry_with_image_editor");
        editURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        String fileEntryPreviewURL = DLUtil.getPreviewURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)this._themeDisplay, (String)"");
        StringBundler sb = new StringBundler(10);
        sb.append(liferayPortletResponse.getNamespace());
        sb.append("editWithImageEditor('");
        sb.append(imageEditorURL.toString());
        sb.append("', '");
        sb.append(editURL.toString());
        sb.append("', '");
        sb.append(this._fileEntry.getFileName());
        sb.append("', '");
        sb.append(fileEntryPreviewURL);
        sb.append("');");
        return sb.toString();
    }
}

