/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.image.editor.integration.document.library.display.context;

import com.liferay.frontend.image.editor.integration.document.library.display.context.logic.ImageEditorDLDisplayContextHelper;
import com.liferay.image.gallery.display.kernel.display.context.BaseIGViewFileVersionDisplayContext;
import com.liferay.image.gallery.display.kernel.display.context.IGViewFileVersionDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImageEditorIGViewFileVersionDisplayContext
extends BaseIGViewFileVersionDisplayContext {
    private static final UUID _UUID = UUID.fromString("1cc61284-8baf-4904-8a65-b7b3845e64d7");
    private final FileEntry _fileEntry;
    private final ImageEditorDLDisplayContextHelper _imageEditorDLDisplayContextHelper;
    private final ResourceBundleLoader _resourceBundleLoader;
    private final ThemeDisplay _themeDisplay;

    public ImageEditorIGViewFileVersionDisplayContext(IGViewFileVersionDisplayContext parentIGDisplayContext, HttpServletRequest request, HttpServletResponse response, FileVersion fileVersion, ResourceBundleLoader resourceBundleLoader) {
        super(_UUID, parentIGDisplayContext, request, response, fileVersion);
        this._resourceBundleLoader = resourceBundleLoader;
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            FileEntry fileEntry = null;
            if (fileVersion != null) {
                fileEntry = fileVersion.getFileEntry();
            }
            this._fileEntry = fileEntry;
            this._imageEditorDLDisplayContextHelper = new ImageEditorDLDisplayContextHelper(fileVersion, request);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to create image editor image gallery view file version display context for file version " + fileVersion, (Throwable)pe);
        }
    }

    public Menu getMenu() throws PortalException {
        Menu menu = super.getMenu();
        if (!this._imageEditorDLDisplayContextHelper.isShowImageEditorAction()) {
            return menu;
        }
        List menuItems = menu.getMenuItems();
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(LanguageUtil.getLanguageId((Locale)this._themeDisplay.getLocale()));
        ImageEditorDLDisplayContextHelper imageEditorDLDisplayContextHelper = new ImageEditorDLDisplayContextHelper(this.fileVersion, this.request);
        menuItems.add(imageEditorDLDisplayContextHelper.getJavacriptEditWithImageEditorMenuItem(resourceBundle));
        return menu;
    }
}

