"use strict";

Liferay.Loader.define("frontend-image-editor-capability-effects@2.0.7/EffectsComponent.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-promise', 'frontend-js-metal-web$metal', './EffectsComponent.soy', './EffectsControls.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalPromise = require("frontend-js-metal-web$metal-promise");

  var _metal = require("frontend-js-metal-web$metal");

  var _EffectsComponent = _interopRequireDefault(require("./EffectsComponent.soy"));

  var _EffectsControls = _interopRequireDefault(require("./EffectsControls.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Effects Component
   * @review
   */
  var EffectsComponent =
  /*#__PURE__*/
  function (_Component) {
    _inherits(EffectsComponent, _Component);

    function EffectsComponent() {
      _classCallCheck(this, EffectsComponent);

      return _possibleConstructorReturn(this, _getPrototypeOf(EffectsComponent).apply(this, arguments));
    }

    _createClass(EffectsComponent, [{
      key: "attached",

      /**
       * @inheritDoc
       * @review
       */
      value: function attached() {
        var _this = this;

        this.cache_ = {};

        _metal.async.nextTick(function () {
          _this.getImageEditorImageData().then(function (imageData) {
            return _metalPromise.CancellablePromise.resolve(_this.generateThumbnailImageData_(imageData));
          }).then(function (previewImageData) {
            return _this.generateThumbnails_(previewImageData);
          }).then(function () {
            return _this.prefetchEffects_();
          });
        });
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "detached",
      value: function detached() {
        this.cache_ = {};
      }
      /**
       * Returns whether the carousel can be scrolled towards the right
       * @private
       * @return {boolean} True if the carousel can be scrolled, false otherwise.
       * @review
       */

    }, {
      key: "canScrollForward_",
      value: function canScrollForward_() {
        var carousel = this.refs.carousel;
        var continer = this.refs.carouselContainer;
        var offset = Math.abs(parseInt(carousel.style.marginLeft || 0, 10));
        var viewportWidth = parseInt(continer.offsetWidth, 10);
        var maxContentWidth = parseInt(carousel.offsetWidth, 10);
        return offset + viewportWidth < maxContentWidth;
      }
      /**
       * Generates a specific thumbnail for a given effect.
       * @param  {String} effect The effect to generate the thumbnail for.
       * @param  {ImageData} imageData The image data to apply the effect to.
       * @return {CancellablePromise} A promise to be fullfilled when the
       * thumbnail has been generated.
       * @review
       */

    }, {
      key: "generateThumbnail_",
      value: function generateThumbnail_(effect, imageData) {
        var _this2 = this;

        var promise = this.spawnWorker_({
          effect: effect,
          imageData: imageData
        });
        promise.then(function (imageData) {
          var canvas = _this2.element.querySelector('#' + _this2.ref + effect + ' canvas');

          canvas.getContext('2d').putImageData(imageData, 0, 0);
        });
        return promise;
      }
      /**
       * Generates the complete set of thumbnails for the component effects.
       * @param  {ImageData} imageData The thumbnail image data (small version)
       * @return {CancellablePromise} A promise to be fullfilled when all thumbnails
       * have been generated.
       * @review
       */

    }, {
      key: "generateThumbnails_",
      value: function generateThumbnails_(imageData) {
        var _this3 = this;

        return _metalPromise.CancellablePromise.all(this.effects.map(function (effect) {
          return _this3.generateThumbnail_(effect, imageData);
        }));
      }
      /**
       * Generates a resized version of the image data to generate the
       * thumbnails more efficiently.
       * @param  {ImageData} imageData The original image data
       * @return {ImageData} The resized image data
       * @review
       */

    }, {
      key: "generateThumbnailImageData_",
      value: function generateThumbnailImageData_(imageData) {
        var thumbnailSize = this.thumbnailSize;
        var imageWidth = imageData.width;
        var imageHeight = imageData.height;
        var rawCanvas = document.createElement('canvas');
        rawCanvas.width = imageWidth;
        rawCanvas.height = imageHeight;
        rawCanvas.getContext('2d').putImageData(imageData, 0, 0);
        var commonSize = imageWidth > imageHeight ? imageHeight : imageWidth;
        var canvas = document.createElement('canvas');
        canvas.width = thumbnailSize;
        canvas.height = thumbnailSize;
        var context = canvas.getContext('2d');
        context.drawImage(rawCanvas, imageWidth - commonSize, imageHeight - commonSize, commonSize, commonSize, 0, 0, thumbnailSize, thumbnailSize);
        return context.getImageData(0, 0, thumbnailSize, thumbnailSize);
      }
      /**
       * Starts optimistically prefetching all the effect results.
       * @return {CancellablePromise} A promise to be fullfilled when all
       * the effects have been prefetched
       * @review
       */

    }, {
      key: "prefetchEffects_",
      value: function prefetchEffects_() {
        var _this4 = this;

        return new _metalPromise.CancellablePromise(function (resolve, reject) {
          if (!_this4.isDisposed()) {
            var missingEffects = _this4.effects.filter(function (effect) {
              return !_this4.cache_[effect];
            });

            if (!missingEffects.length) {
              resolve();
            } else {
              _this4.getImageEditorImageData().then(function (imageData) {
                return _this4.process(imageData, missingEffects[0]);
              }).then(function () {
                return _this4.prefetchEffects_();
              });
            }
          }
        });
      }
      /**
       * Applies the selected effect to the image.
       * @param  {ImageData} imageData ImageData representation of the image.
       * @return {CancellablePromise} A promise that will resolve when the webworker
       * finishes processing the image.
       * @review
       */

    }, {
      key: "preview",
      value: function preview(imageData) {
        return this.process(imageData);
      }
      /**
       * Notifies the editor that the component wants to generate a new
       * preview of the current image.
       * @param  {MouseEvent} event
       * @review
       */

    }, {
      key: "previewEffect",
      value: function previewEffect(event) {
        this.currentEffect_ = event.delegateTarget.getAttribute('data-effect');
        this.requestImageEditorPreview();
      }
      /**
       * Applies the selected effect to the image.
       * @param  {ImageData} imageData ImageData representation of the image.
       * @param {String} effectName The effect to apply to the image.
       * @return {CancellablePromise} A promise that will resolve when the webworker
       * finishes processing the image.
       * @review
       */

    }, {
      key: "process",
      value: function process(imageData, effectName) {
        var effect = effectName || this.currentEffect_;
        var promise = this.cache_[effect];

        if (!promise) {
          promise = this.spawnWorker_({
            effect: effect,
            imageData: imageData
          });
          this.cache_[effect] = promise;
        }

        return promise;
      }
      /**
       * Makes the carousel scroll left to reveal options off the visible area
       * @return void
       * @review
       */

    }, {
      key: "scrollLeft",
      value: function scrollLeft() {
        var carousel = this.refs.carousel;
        var itemWidth = this.refs.carouselFirstItem.offsetWidth || 0;
        var marginLeft = parseInt(carousel.style.marginLeft || 0, 10);

        if (marginLeft < 0) {
          var newMarginValue = Math.min(marginLeft + itemWidth, 0);
          this.carouselOffset = newMarginValue + 'px';
        }
      }
      /**
       * Makes the caousel scroll right to reveal options off the visible area
       * @return void
       * @review
       */

    }, {
      key: "scrollRight",
      value: function scrollRight() {
        if (this.canScrollForward_()) {
          var carousel = this.refs.carousel;
          var itemWidth = this.refs.carouselFirstItem.offsetWidth || 0;
          var marginLeft = parseInt(carousel.style.marginLeft || 0, 10);
          this.carouselOffset = marginLeft - itemWidth + 'px';
        }
      }
      /**
       * Spawns the a webworker to do the image processing in a different thread.
       * @param  {String} workerURI URI of the worker to spawn.
       * @param  {Object} message An object with the image and effect preset.
       * @return {CancellablePromise} A promise that will resolve when the webworker
       * finishes processing the image.
       * @review
       */

    }, {
      key: "spawnWorker_",
      value: function spawnWorker_(message) {
        var _this5 = this;

        return new _metalPromise.CancellablePromise(function (resolve, reject) {
          var processWorker = new Worker(_this5.modulePath + '/EffectsWorker.js');

          processWorker.onmessage = function (event) {
            return resolve(event.data);
          };

          processWorker.postMessage(message);
        });
      }
    }]);

    return EffectsComponent;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  EffectsComponent.STATE = {
    /**
     * Offset to the carousel item with the 'px' postfix
     * @review
     * @type {String}
     */
    carouselOffset: {
      validator: _metal.core.isString,
      value: '0'
    },

    /**
     * Array of available effects
     * @review
     * @type {Object}
     */
    effects: {
      validator: _metal.core.isArray,
      value: ['none', 'ruby', 'absinthe', 'chroma', 'atari', 'tripel', 'ailis', 'flatfoot', 'pyrexia', 'umbra', 'rouge', 'idyll', 'glimmer', 'elysium', 'nucleus', 'amber', 'paella', 'aureus', 'expanse', 'orchid']
    },

    /**
     * Injected helper to get the editor image data
     * @review
     * @type {Function}
     */
    getImageEditorImageData: {
      validator: _metal.core.isFunction
    },

    /**
     * Path of this module
     * @review
     * @type {Function}
     */
    modulePath: {
      validator: _metal.core.isString
    },

    /**
     * Injected helper to get the editor image data
     * @review
     * @type {Function}
     */
    requestImageEditorPreview: {
      validator: _metal.core.isFunction
    },

    /**
     * Size of the thumbnails. (size x size)
     * @review
     * @type {Number}
     */
    thumbnailSize: {
      validator: _metal.core.isNumber,
      value: 55
    }
  };

  _metalSoy["default"].register(EffectsComponent, _EffectsComponent["default"]);

  var _default = EffectsComponent;
  exports["default"] = _default;
  //# sourceMappingURL=EffectsComponent.es.js.map
});
//# sourceMappingURL=EffectsComponent.es.js.map