Liferay.Loader.define("frontend-image-editor-capability-effects@2.0.1/EffectsComponent.es", ['exports', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal-promise/src/promise/Promise', 'metal/src/metal', './EffectsComponent.soy', './EffectsControls.soy'], function (exports, _component, _Soy, _Promise, _metal, _EffectsComponent, _EffectsControls) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _EffectsComponent2 = _interopRequireDefault(_EffectsComponent);

	var _EffectsControls2 = _interopRequireDefault(_EffectsControls);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var EffectsComponent = function (_Component) {
		_inherits(EffectsComponent, _Component);

		function EffectsComponent() {
			_classCallCheck(this, EffectsComponent);

			return _possibleConstructorReturn(this, (EffectsComponent.__proto__ || Object.getPrototypeOf(EffectsComponent)).apply(this, arguments));
		}

		_createClass(EffectsComponent, [{
			key: 'attached',
			value: function attached() {
				var _this2 = this;

				this.cache_ = {};

				_metal.async.nextTick(function () {
					_this2.getImageEditorImageData().then(function (imageData) {
						return _Promise.CancellablePromise.resolve(_this2.generateThumbnailImageData_(imageData));
					}).then(function (previewImageData) {
						return _this2.generateThumbnails_(previewImageData);
					}).then(function () {
						return _this2.prefetchEffects_();
					});
				});
			}
		}, {
			key: 'detached',
			value: function detached() {
				this.cache_ = {};
			}
		}, {
			key: 'canScrollForward_',
			value: function canScrollForward_() {
				var carousel = this.refs.carousel;
				var continer = this.refs.carouselContainer;
				var offset = Math.abs(parseInt(carousel.style.marginLeft || 0, 10));
				var viewportWidth = parseInt(continer.offsetWidth, 10);
				var maxContentWidth = parseInt(carousel.offsetWidth, 10);

				return offset + viewportWidth < maxContentWidth;
			}
		}, {
			key: 'generateThumbnail_',
			value: function generateThumbnail_(effect, imageData) {
				var _this3 = this;

				var promise = this.spawnWorker_({
					effect: effect,
					imageData: imageData
				});

				promise.then(function (imageData) {
					var canvas = _this3.element.querySelector('#' + _this3.ref + effect + ' canvas');
					canvas.getContext('2d').putImageData(imageData, 0, 0);
				});

				return promise;
			}
		}, {
			key: 'generateThumbnails_',
			value: function generateThumbnails_(imageData) {
				var _this4 = this;

				return _Promise.CancellablePromise.all(this.effects.map(function (effect) {
					return _this4.generateThumbnail_(effect, imageData);
				}));
			}
		}, {
			key: 'generateThumbnailImageData_',
			value: function generateThumbnailImageData_(imageData) {
				var thumbnailSize = this.thumbnailSize;
				var imageWidth = imageData.width;
				var imageHeight = imageData.height;

				var rawCanvas = document.createElement('canvas');
				rawCanvas.width = imageWidth;
				rawCanvas.height = imageHeight;
				rawCanvas.getContext('2d').putImageData(imageData, 0, 0);

				var commonSize = imageWidth > imageHeight ? imageHeight : imageWidth;

				var canvas = document.createElement('canvas');
				canvas.width = thumbnailSize;
				canvas.height = thumbnailSize;

				var context = canvas.getContext('2d');
				context.drawImage(rawCanvas, imageWidth - commonSize, imageHeight - commonSize, commonSize, commonSize, 0, 0, thumbnailSize, thumbnailSize);

				return context.getImageData(0, 0, thumbnailSize, thumbnailSize);
			}
		}, {
			key: 'prefetchEffects_',
			value: function prefetchEffects_() {
				var _this5 = this;

				return new _Promise.CancellablePromise(function (resolve, reject) {
					if (!_this5.isDisposed()) {
						var missingEffects = _this5.effects.filter(function (effect) {
							return !_this5.cache_[effect];
						});

						if (!missingEffects.length) {
							resolve();
						} else {
							_this5.getImageEditorImageData().then(function (imageData) {
								return _this5.process(imageData, missingEffects[0]);
							}).then(function () {
								return _this5.prefetchEffects_();
							});
						}
					}
				});
			}
		}, {
			key: 'preview',
			value: function preview(imageData) {
				return this.process(imageData);
			}
		}, {
			key: 'previewEffect',
			value: function previewEffect(event) {
				this.currentEffect_ = event.delegateTarget.getAttribute('data-effect');
				this.requestImageEditorPreview();
			}
		}, {
			key: 'process',
			value: function process(imageData, effectName) {
				var effect = effectName || this.currentEffect_;
				var promise = this.cache_[effect];

				if (!promise) {
					promise = this.spawnWorker_({
						effect: effect,
						imageData: imageData
					});

					this.cache_[effect] = promise;
				}

				return promise;
			}
		}, {
			key: 'scrollLeft',
			value: function scrollLeft() {
				var carousel = this.refs.carousel;
				var itemWidth = this.refs.carouselFirstItem.offsetWidth || 0;
				var marginLeft = parseInt(carousel.style.marginLeft || 0, 10);

				if (marginLeft < 0) {
					var newMarginValue = Math.min(marginLeft + itemWidth, 0);

					this.carouselOffset = newMarginValue + 'px';
				}
			}
		}, {
			key: 'scrollRight',
			value: function scrollRight() {
				if (this.canScrollForward_()) {
					var carousel = this.refs.carousel;
					var itemWidth = this.refs.carouselFirstItem.offsetWidth || 0;
					var marginLeft = parseInt(carousel.style.marginLeft || 0, 10);

					this.carouselOffset = marginLeft - itemWidth + 'px';
				}
			}
		}, {
			key: 'spawnWorker_',
			value: function spawnWorker_(message) {
				var _this6 = this;

				return new _Promise.CancellablePromise(function (resolve, reject) {
					var processWorker = new Worker(_this6.modulePath + '/EffectsWorker.js');

					processWorker.onmessage = function (event) {
						return resolve(event.data);
					};
					processWorker.postMessage(message);
				});
			}
		}]);

		return EffectsComponent;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */
	EffectsComponent.STATE = {
		/**
   * Offset to the carousel item with the 'px' postfix
   * @review
   * @type {String}
   */
		carouselOffset: {
			validator: _metal.core.isString,
			value: '0'
		},

		/**
   * Array of available effects
   * @review
   * @type {Object}
   */
		effects: {
			validator: _metal.core.isArray,
			value: ['none', 'ruby', 'absinthe', 'chroma', 'atari', 'tripel', 'ailis', 'flatfoot', 'pyrexia', 'umbra', 'rouge', 'idyll', 'glimmer', 'elysium', 'nucleus', 'amber', 'paella', 'aureus', 'expanse', 'orchid']
		},

		/**
   * Injected helper to get the editor image data
   * @review
   * @type {Function}
   */
		getImageEditorImageData: {
			validator: _metal.core.isFunction
		},

		/**
   * Path of this module
   * @review
   * @type {Function}
   */
		modulePath: {
			validator: _metal.core.isString
		},

		/**
   * Injected helper to get the editor image data
   * @review
   * @type {Function}
   */
		requestImageEditorPreview: {
			validator: _metal.core.isFunction
		},

		/**
   * Size of the thumbnails. (size x size)
   * @review
   * @type {Number}
   */
		thumbnailSize: {
			validator: _metal.core.isNumber,
			value: 55
		}
	};

	_Soy2.default.register(EffectsComponent, _EffectsComponent2.default);

	exports.default = EffectsComponent;
});
//# sourceMappingURL=EffectsComponent.es.js.map
