var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));

// ../../../../../../../../../$/bridge/for/main/@clayui/button
var button_exports = {};
__export(button_exports, {
  default: () => button_default
});
__reExport(button_exports, clayui_button_star);
import * as clayui_button_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$button.js";
import __default__ from "../../frontend-taglib-clay/__liferay__/exports/@clayui$button.js";
var button_default = __default__;

// ../../../../../../../../../$/bridge/for/main/@clayui/loading-indicator
var loading_indicator_exports = {};
__export(loading_indicator_exports, {
  default: () => loading_indicator_default
});
__reExport(loading_indicator_exports, clayui_loading_indicator_star);
import * as clayui_loading_indicator_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$loading-indicator.js";
import __default__2 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$loading-indicator.js";
var loading_indicator_default = __default__2;

// ../../../../../../../../../$/bridge/for/main/@clayui/navigation-bar
var navigation_bar_exports = {};
__export(navigation_bar_exports, {
  default: () => navigation_bar_default
});
__reExport(navigation_bar_exports, clayui_navigation_bar_star);
import * as clayui_navigation_bar_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$navigation-bar.js";
import __default__3 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$navigation-bar.js";
var navigation_bar_default = __default__3;

// ../../../../../../../../../$/bridge/for/main/frontend-js-web
var frontend_js_web_exports = {};
__reExport(frontend_js_web_exports, liferay_star);
import * as liferay_star from "../../frontend-js-web/__liferay__/index.js";

// ../../../../../../../../../$/bridge/for/main/react
var react_exports = {};
__export(react_exports, {
  default: () => react_default
});
__reExport(react_exports, react_star);
import * as react_star from "../../frontend-js-react-web/__liferay__/exports/react.js";
import __default__4 from "../../frontend-js-react-web/__liferay__/exports/react.js";
var react_default = __default__4;

// src/main/resources/META-INF/resources/js/utils/constants.ts
var API_URL = {
  ACTIONS: "/o/data-set-manager/actions",
  CARDS_SECTIONS: "/o/data-set-manager/cards-sections",
  CLIENT_EXTENSION_FILTERS: "/o/data-set-manager/client-extension-filters",
  DATA_SETS: "/o/data-set-manager/data-sets",
  DATE_FILTERS: "/o/data-set-manager/date-filters",
  FDS_ENTRIES: "/o/data-set-manager/entries",
  LIST_SECTIONS: "/o/data-set-manager/list-sections",
  SELECTION_FILTERS: "/o/data-set-manager/selection-filters",
  SORTS: "/o/data-set-manager/sorts",
  TABLE_SECTIONS: "/o/data-set-manager/table-sections"
};
var FUZZY_OPTIONS = {
  post: "</strong>",
  pre: "<strong>"
};
var OBJECT_RELATIONSHIP = {
  DATA_SET_CARDS_SECTION: "fdsViewFDSCardsSectionRelationship",
  DATA_SET_CARDS_SECTION_ERC: "r_fdsViewFDSCardsSectionRelationship_c_fdsViewERC",
  DATA_SET_CLIENT_EXTENSION_FILTER: "fdsViewFDSClientExtensionFilter",
  DATA_SET_CLIENT_EXTENSION_FILTER_ID: "r_fdsViewFDSClientExtensionFilter_c_fdsViewId",
  DATA_SET_CREATION_ACTION: "fdsViewFDSCreationActionRelationship",
  DATA_SET_CREATION_ACTION_ID: "r_fdsViewFDSCreationActionRelationship_c_fdsViewId",
  DATA_SET_DATE_FILTER: "fdsViewFDSDateFilterRelationship",
  DATA_SET_DATE_FILTER_ID: "r_fdsViewFDSDateFilterRelationship_c_fdsViewId",
  DATA_SET_ITEM_ACTION: "fdsViewFDSItemActionRelationship",
  DATA_SET_ITEM_ACTION_ID: "r_fdsViewFDSItemActionRelationship_c_fdsViewId",
  DATA_SET_LIST_SECTION: "fdsViewFDSListSectionRelationship",
  DATA_SET_LIST_SECTION_ERC: "r_fdsViewFDSListSectionRelationship_c_fdsViewERC",
  DATA_SET_SELECTION_FILTER: "fdsViewFDSDynamicFilterRelationship",
  DATA_SET_SELECTION_FILTER_ID: "r_fdsViewFDSDynamicFilterRelationship_c_fdsViewId",
  DATA_SET_SORT: "fdsViewFDSSortRelationship",
  DATA_SET_SORT_ID: "r_fdsViewFDSSortRelationship_c_fdsViewId",
  DATA_SET_TABLE_SECTION: "fdsViewFDSFieldRelationship",
  DATA_SET_TABLE_SECTION_ID: "r_fdsViewFDSFieldRelationship_c_fdsViewId",
  FDS_ENTRY_FDS_VIEW: "fdsEntryFDSViewRelationship",
  FDS_ENTRY_FDS_VIEW_ID: "r_fdsEntryFDSViewRelationship_c_fdsEntryId"
};
var FDS_DEFAULT_PROPS = {
  pagination: {
    deltas: [{ label: 4 }, { label: 8 }, { label: 20 }, { label: 40 }, { label: 60 }],
    initialDelta: 8
  },
  style: "fluid"
};
var DEFAULT_VISUALIZATION_MODES = [
  {
    label: Liferay.Language.get("cards"),
    mode: "cards",
    thumbnail: "cards2",
    visualizationModeId: "defaultCards"
  },
  {
    label: Liferay.Language.get("list"),
    mode: "list",
    thumbnail: "list",
    visualizationModeId: "defaultList"
  },
  {
    label: Liferay.Language.get("table"),
    mode: "table",
    thumbnail: "table",
    visualizationModeId: "defaultTable"
  }
];
var ALLOWED_ENDPOINTS_PARAMETERS = ["scopeKey", "siteId", "userId"];

// ../../../../../../../../../$/bridge/for/main/@liferay/frontend-data-set-web
var frontend_data_set_web_exports = {};
__reExport(frontend_data_set_web_exports, liferay_star2);
import * as liferay_star2 from "../../frontend-data-set-web/__liferay__/index.js";

// src/main/resources/META-INF/resources/js/utils/openDefaultFailureToast.ts
function openDefaultFailureToast() {
  (0, frontend_js_web_exports.openToast)({
    message: Liferay.Language.get("your-request-failed-to-complete"),
    type: "danger"
  });
}

// src/main/resources/META-INF/resources/js/utils/getFields.ts
var INVALID_FIELDS = ["actions", "scopeKey", "x-class-name", "x-schema-name"];
var LOCALIZABLE_PROPERTY_SUFFIX = "_i18n";
function getValidFields({
  contextPath,
  schemaName,
  schemas
}) {
  const fields = [];
  const properties = schemas[schemaName]?.properties;
  properties && Object.keys(properties).map((propertyKey) => {
    const propertyValue = properties[propertyKey];
    if (INVALID_FIELDS.includes(propertyKey)) {
      return;
    }
    if (propertyKey.includes(LOCALIZABLE_PROPERTY_SUFFIX)) {
      return;
    }
    const type = propertyValue.type;
    if (propertyValue.items?.$ref) {
      const field = {
        label: propertyKey,
        name: `${contextPath}${propertyKey}${frontend_data_set_web_exports.FDS_ARRAY_FIELD_NAME_PARENT_SUFFIX}`,
        sortable: false,
        type: type ? type : "array"
      };
      if (!contextPath.includes(propertyKey)) {
        field.children = getValidFields({
          contextPath: `${contextPath}${propertyKey}${frontend_data_set_web_exports.FDS_ARRAY_FIELD_NAME_DELIMITER}`,
          schemaName: propertyValue.items.$ref.replace(
            /^.*\//,
            ""
          ),
          schemas
        });
      }
      fields.push(field);
      return;
    }
    if (propertyValue.$ref) {
      fields.push({
        children: getValidFields({
          contextPath: `${contextPath}${propertyKey}${frontend_data_set_web_exports.FDS_NESTED_FIELD_NAME_DELIMITER}`,
          schemaName: propertyValue.$ref.replace(/^.*\//, ""),
          schemas
        }),
        label: propertyKey,
        name: `${contextPath}${propertyKey}${frontend_data_set_web_exports.FDS_NESTED_FIELD_NAME_PARENT_SUFFIX}`,
        sortable: false,
        type: type ? type : "object"
      });
      return;
    }
    if (propertyValue.extensions && propertyValue.extensions["x-parent-map"] === "properties") {
      const schemaNames = Object.keys(schemas);
      const parentSchemaName = schemaNames.filter((schemaName2) => {
        return schemaName2.toLowerCase() === propertyKey.toLocaleLowerCase();
      });
      if (parentSchemaName.length) {
        fields.push({
          children: getValidFields({
            contextPath: `${contextPath}${propertyKey}${frontend_data_set_web_exports.FDS_NESTED_FIELD_NAME_DELIMITER}`,
            schemaName: parentSchemaName[0],
            schemas
          }),
          label: propertyKey,
          name: `${contextPath}${propertyKey}${frontend_data_set_web_exports.FDS_NESTED_FIELD_NAME_PARENT_SUFFIX}`,
          sortable: false,
          type: schemas[parentSchemaName[0]]?.type || "object"
        });
        return;
      }
    }
    fields.push({
      format: propertyValue.format,
      label: propertyKey,
      name: `${contextPath}${propertyKey}`,
      sortable: type !== "object" && type !== "array" && !contextPath.includes(frontend_data_set_web_exports.FDS_NESTED_FIELD_NAME_DELIMITER) && !contextPath.includes(frontend_data_set_web_exports.FDS_ARRAY_FIELD_NAME_DELIMITER),
      type
    });
  });
  return fields;
}
async function getFields({
  restApplication,
  restSchema
}) {
  const response = await (0, frontend_js_web_exports.fetch)(`/o${restApplication}/openapi.json`);
  if (!response.ok) {
    openDefaultFailureToast();
    return [];
  }
  const responseJSON = await response.json();
  const schemas = responseJSON?.components?.schemas;
  if (!schemas?.[restSchema]?.properties) {
    openDefaultFailureToast();
    return [];
  }
  return getValidFields({
    contextPath: "",
    schemaName: restSchema,
    schemas
  });
}

// ../../../../../../../../../$/bridge/for/main/@clayui/breadcrumb
var breadcrumb_exports = {};
__export(breadcrumb_exports, {
  default: () => breadcrumb_default
});
__reExport(breadcrumb_exports, clayui_breadcrumb_star);
import * as clayui_breadcrumb_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$breadcrumb.js";
import __default__5 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$breadcrumb.js";
var breadcrumb_default = __default__5;

// ../../../../../../../../../$/bridge/for/main/@clayui/layout
var layout_exports = {};
__export(layout_exports, {
  default: () => layout_default
});
__reExport(layout_exports, clayui_layout_star);
import * as clayui_layout_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$layout.js";
import __default__6 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$layout.js";
var layout_default = __default__6;

// ../../../../../../../../../$/bridge/for/main/@clayui/tabs
var tabs_exports = {};
__export(tabs_exports, {
  default: () => tabs_default
});
__reExport(tabs_exports, clayui_tabs_star);
import * as clayui_tabs_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$tabs.js";
import __default__7 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$tabs.js";
var tabs_default = __default__7;

// src/main/resources/META-INF/resources/js/utils/openDefaultSuccessToast.ts
function openDefaultFailureToast2() {
  (0, frontend_js_web_exports.openToast)({
    message: Liferay.Language.get("your-request-completed-successfully"),
    type: "success"
  });
}

// ../../../../../../../../../$/bridge/for/main/@clayui/form
var form_exports = {};
__export(form_exports, {
  default: () => form_default
});
__reExport(form_exports, clayui_form_star);
import * as clayui_form_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$form.js";
import __default__8 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$form.js";
var form_default = __default__8;

// ../../../../../../../../../$/bridge/for/main/@clayui/icon
var icon_exports = {};
__export(icon_exports, {
  default: () => icon_default
});
__reExport(icon_exports, clayui_icon_star);
import * as clayui_icon_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$icon.js";
import __default__9 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$icon.js";
var icon_default = __default__9;

// ../../../../../../../../../$/bridge/for/main/@clayui/panel
var panel_exports = {};
__export(panel_exports, {
  default: () => panel_default
});
__reExport(panel_exports, clayui_panel_star);
import * as clayui_panel_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$panel.js";
import __default__10 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$panel.js";
var panel_default = __default__10;

// ../../../../../../../../../$/bridge/for/main/classnames
var classnames_exports = {};
__export(classnames_exports, {
  default: () => classnames_default
});
__reExport(classnames_exports, classnames_star);
import * as classnames_star from "../../frontend-js-react-web/__liferay__/exports/classnames.js";
import __default__11 from "../../frontend-js-react-web/__liferay__/exports/classnames.js";
var classnames_default = __default__11;

// ../../../../../../../../../$/bridge/for/main/frontend-js-components-web
var frontend_js_components_web_exports = {};
__reExport(frontend_js_components_web_exports, liferay_star3);
import * as liferay_star3 from "../../frontend-js-components-web/__liferay__/index.js";

// src/main/resources/META-INF/resources/js/components/RequiredMark.tsx
var RequiredMark = () => /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("span", { className: "inline-item-after ml-1 reference-mark text-warning" }, /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "asterisk" })), /* @__PURE__ */ react_default.createElement("span", { className: "hide-accessible sr-only" }, Liferay.Language.get("required")));
var RequiredMark_default = RequiredMark;

// src/main/resources/META-INF/resources/js/components/Search.tsx
var Search = ({ onSearch, query }) => /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.Group, null, /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupItem, null, /* @__PURE__ */ react_default.createElement(
  form_exports.ClayInput,
  {
    insetAfter: true,
    onChange: (event) => onSearch(event.target.value),
    placeholder: Liferay.Language.get("search"),
    type: "text",
    value: query
  }
), /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupInsetItem, { after: true, tag: "span" }, /* @__PURE__ */ react_default.createElement(
  button_exports.ClayButtonWithIcon,
  {
    "aria-label": Liferay.Language.get("search"),
    displayType: "unstyled",
    symbol: "search"
  }
))));
var Search_default = Search;

// src/main/resources/META-INF/resources/js/components/ValidationFeedback.tsx
var ValidationFeedback = ({
  message = Liferay.Language.get("this-field-is-required")
}) => /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), message));
var ValidationFeedback_default = ValidationFeedback;

// src/main/resources/META-INF/resources/js/data_set/actions/components/ActionForm.tsx
var ACTION_METHOD = {
  DELETE: "DELETE",
  GET: "GET",
  PATCH: "PATCH",
  POST: "POST"
};
var ACTION_METHODS = () => {
  const methods = [];
  for (const method in ACTION_METHOD) {
    methods.push({ label: method, value: method });
  }
  return methods;
};
var ACTION_TYPE = {
  ASYNC: "async",
  HEADLESS: "headless",
  LINK: "link",
  MODAL: "modal",
  SIDEPANEL: "sidePanel"
};
var ACTION_TYPES = [
  {
    label: Liferay.Language.get("link"),
    value: ACTION_TYPE.LINK
  },
  {
    label: Liferay.Language.get("modal"),
    value: ACTION_TYPE.MODAL
  },
  {
    label: Liferay.Language.get("side-panel"),
    value: ACTION_TYPE.SIDEPANEL
  }
];
var ITEM_ACTION_TYPES = [
  {
    label: Liferay.Language.get("async"),
    value: ACTION_TYPE.ASYNC
  },
  {
    label: Liferay.Language.get("headless"),
    value: ACTION_TYPE.HEADLESS
  }
].concat(ACTION_TYPES);
var MESSAGE_TYPES = [
  {
    label: Liferay.Language.get("info"),
    value: "info"
  },
  {
    label: Liferay.Language.get("secondary"),
    value: "secondary"
  },
  {
    label: Liferay.Language.get("success"),
    value: "success"
  },
  {
    label: Liferay.Language.get("danger"),
    value: "danger"
  },
  {
    label: Liferay.Language.get("warning"),
    value: "warning"
  }
];
var MODAL_SIZES = [
  {
    label: Liferay.Language.get("full-screen"),
    value: "full-screen"
  },
  {
    label: Liferay.Language.get("large"),
    value: "lg"
  },
  {
    label: Liferay.Language.get("small"),
    value: "sm"
  }
];
var translationExists = ({ translations }) => {
  return Boolean(Object.keys(translations).find((key) => translations[key]));
};
var ActionForm = ({
  activeTab,
  dataSet,
  editing = false,
  initialValues,
  namespace,
  onCancel,
  onSave,
  spritemap
}) => {
  const [activeMessageTab, setActiveMessageTab] = (0, react_exports.useState)(0);
  const [availableIconSymbols, setAvailableIconSymbols] = (0, react_exports.useState)([]);
  const [
    confirmationMessageTranslations,
    setConfirmationMessageTranslations
  ] = (0, react_exports.useState)(initialValues?.confirmationMessage_i18n ?? {});
  const [errorMessageTranslations, setErrorMessageTranslations] = (0, react_exports.useState)(
    initialValues?.errorMessage_i18n ?? {}
  );
  const [labelTranslations, setLabelTranslations] = (0, react_exports.useState)(
    initialValues?.label_i18n ?? {}
  );
  const [labelValidationError, setLabelValidationError] = (0, react_exports.useState)(false);
  const [permissionKeyValidationError, setPermissionKeyValidationError] = (0, react_exports.useState)(false);
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(!editing);
  const [successMessageTranslations, setSuccessMessageTranslations] = (0, react_exports.useState)(initialValues?.successMessage_i18n ?? {});
  const [titleTranslations, setTitleTranslations] = (0, react_exports.useState)(
    initialValues?.title_i18n ?? {}
  );
  const [urlValidationError, setURLValidationError] = (0, react_exports.useState)(false);
  const [actionData, setActionData] = (0, react_exports.useState)({
    confirmationMessage: initialValues?.confirmationMessage ?? "",
    confirmationMessageType: initialValues?.confirmationMessageType ?? "warning",
    iconSymbol: initialValues?.icon ?? "",
    label: initialValues?.label ?? "",
    method: initialValues?.method ?? "",
    modalSize: initialValues?.modalSize ?? "",
    permissionKey: initialValues?.permissionKey ?? "",
    title: initialValues?.title ?? "",
    type: initialValues?.type ?? "link",
    url: initialValues?.url ?? ""
  });
  const handleActionTypeChange = (event) => {
    const type = event.target.value;
    setActionData({
      ...actionData,
      method: type === ACTION_TYPE.ASYNC ? ACTION_METHOD.DELETE : "",
      modalSize: type === ACTION_TYPE.MODAL ? MODAL_SIZES[0].value : "",
      type
    });
  };
  const saveAction = async () => {
    setSaveButtonDisabled(true);
    const {
      confirmationMessageType,
      iconSymbol,
      method,
      modalSize,
      permissionKey,
      type,
      url
    } = actionData;
    const relationship = activeTab === 0 ? OBJECT_RELATIONSHIP.DATA_SET_ITEM_ACTION_ID : OBJECT_RELATIONSHIP.DATA_SET_CREATION_ACTION_ID;
    const body = {
      confirmationMessage_i18n: confirmationMessageTranslations,
      icon: iconSymbol,
      label_i18n: labelTranslations,
      method,
      modalSize,
      permissionKey,
      [relationship]: dataSet.id,
      title_i18n: titleTranslations,
      type,
      url
    };
    if (Object.keys(confirmationMessageTranslations).length) {
      body.confirmationMessageType = confirmationMessageType;
    }
    if (actionData.type === ACTION_TYPE.ASYNC || actionData.type === ACTION_TYPE.HEADLESS) {
      body.errorMessage_i18n = errorMessageTranslations;
      body.successMessage_i18n = successMessageTranslations;
    }
    if (actionData.type === ACTION_TYPE.ASYNC) {
      body.method = method;
    }
    let apiURL = API_URL.ACTIONS;
    let fetchMethod = "POST";
    if (editing) {
      apiURL = `${apiURL}/${initialValues?.id}`;
      fetchMethod = "PUT";
    }
    const response = await (0, frontend_js_web_exports.fetch)(apiURL, {
      body: JSON.stringify(body),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method: fetchMethod
    });
    if (!response.ok) {
      setSaveButtonDisabled(false);
      openDefaultFailureToast();
      return;
    }
    setSaveButtonDisabled(false);
    openDefaultFailureToast2();
    onSave();
  };
  const validateForm = ({
    labelTranslations: labelTranslations2,
    permissionKey,
    url
  }) => {
    let valid = true;
    if (!url && actionData.type !== ACTION_TYPE.HEADLESS || !permissionKey && actionData.type === ACTION_TYPE.HEADLESS || !translationExists({
      translations: labelTranslations2
    })) {
      valid = false;
    }
    setSaveButtonDisabled(!valid);
  };
  (0, react_exports.useEffect)(() => {
    const getIcons = async () => {
      const response = await (0, frontend_js_web_exports.fetch)(spritemap);
      const responseText = await response.text();
      if (responseText.length) {
        const spritemapDocument = new DOMParser().parseFromString(
          responseText,
          "text/xml"
        );
        const symbolElements = spritemapDocument.querySelectorAll("symbol");
        const iconSymbols = Array.from(symbolElements).map(
          (element) => ({
            label: element.id,
            value: element.id
          })
        );
        setAvailableIconSymbols(iconSymbols);
      }
    };
    getIcons();
  }, [spritemap]);
  const iconFormElementId = `${namespace}Icon`;
  const confirmationMessageFormElementId = `${namespace}ConfirmationMessage`;
  const confirmationMessageTypeFormElementId = `${namespace}ConfirmationMessageType`;
  const errorMessageFormElementId = `${namespace}ErrorMessage`;
  const labelFormElementId = `${namespace}Label`;
  const methodFormElementId = `${namespace}Method`;
  const modalSizeFormElementId = `${namespace}ModalSize`;
  const permissionKeyFormElementId = `${namespace}PermissionKey`;
  const successMessageFormElementId = `${namespace}SuccessMessage`;
  const titleFormElementId = `${namespace}Title`;
  const typeFormElementId = `${namespace}Type`;
  const urlFormElementId = `${namespace}URL`;
  const ModalBody = ({ closeModal }) => {
    const [filteredIconSymbols, setFilteredIconSymbols] = (0, react_exports.useState)(
      availableIconSymbols
    );
    const [query, setQuery] = (0, react_exports.useState)("");
    const onSearch = (query2) => {
      setQuery(query2);
      const regexp = new RegExp(query2, "i");
      setFilteredIconSymbols(
        query2 ? availableIconSymbols.filter(
          (item) => String(item.value).match(regexp)
        ) : availableIconSymbols
      );
    };
    return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(Search_default, { onSearch, query }), /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, null, /* @__PURE__ */ react_default.createElement("ul", { className: "list-unstyled mt-4 row" }, filteredIconSymbols.map((item) => {
      return /* @__PURE__ */ react_default.createElement(
        "li",
        {
          className: "col-md-4",
          key: item.value,
          onClick: () => {
            setActionData({
              ...actionData,
              iconSymbol: item.value
            });
            closeModal();
          }
        },
        /* @__PURE__ */ react_default.createElement(
          icon_default,
          {
            className: "mr-2",
            spritemap,
            symbol: item.value
          }
        ),
        /* @__PURE__ */ react_default.createElement("span", null, item.label)
      );
    }))));
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("h2", { className: "mb-0 p-4" }, editing && initialValues?.label, !editing && activeTab === 0 && Liferay.Language.get("new-item-action"), !editing && activeTab === 1 && Liferay.Language.get("new-creation-action")), /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      collapsable: true,
      defaultExpanded: true,
      displayTitle: Liferay.Language.get("display-options"),
      displayType: "unstyled"
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement(layout_default.Row, null, /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 8 }, /* @__PURE__ */ react_default.createElement(
      frontend_js_components_web_exports.InputLocalized,
      {
        error: labelValidationError ? Liferay.Language.get(
          "this-field-is-required"
        ) : void 0,
        id: labelFormElementId,
        label: Liferay.Language.get("label"),
        onChange: (translations) => {
          setLabelTranslations(translations);
          setLabelValidationError(
            !translationExists({
              translations
            })
          );
          validateForm({
            labelTranslations: translations,
            permissionKey: actionData.permissionKey,
            url: actionData.url
          });
        },
        placeholder: Liferay.Language.get(
          "action-name"
        ),
        required: true,
        translations: labelTranslations
      }
    )), /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 4 }, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: iconFormElementId }, Liferay.Language.get("icon")), /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.Group, null, /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupItem, { prepend: true, shrink: true }, /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupText, null, /* @__PURE__ */ react_default.createElement(
      icon_default,
      {
        spritemap,
        symbol: actionData.iconSymbol
      }
    ))), /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupItem, { append: true }, /* @__PURE__ */ react_default.createElement(
      form_exports.ClayInput,
      {
        onChange: ({ target: { value } }) => setActionData({
          ...actionData,
          iconSymbol: value
        }),
        placeholder: Liferay.Language.get(
          "no-icon-selected"
        ),
        type: "text",
        value: actionData.iconSymbol
      }
    )), /* @__PURE__ */ react_default.createElement(
      button_exports.ClayButtonWithIcon,
      {
        "aria-label": Liferay.Language.get(
          actionData.iconSymbol !== "" ? "change-icon" : "add-icon"
        ),
        className: "ml-2",
        displayType: "secondary",
        id: iconFormElementId,
        onClick: () => (0, frontend_js_web_exports.openModal)({
          bodyComponent: ModalBody,
          containerProps: {
            className: "dsm-actions-icon-selection-modal"
          },
          size: "lg",
          title: Liferay.Language.get(
            "select-an-icon"
          )
        }),
        symbol: actionData.iconSymbol !== "" ? "change" : "plus"
      }
    ), actionData.iconSymbol !== "" && /* @__PURE__ */ react_default.createElement(
      button_exports.ClayButtonWithIcon,
      {
        "aria-label": Liferay.Language.get(
          "remove-icon"
        ),
        className: "ml-2",
        displayType: "secondary",
        onClick: () => setActionData({
          ...actionData,
          iconSymbol: ""
        }),
        symbol: "trash"
      }
    ))))))
  ), /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      collapsable: true,
      defaultExpanded: true,
      displayTitle: Liferay.Language.get("action-behavior"),
      displayType: "unstyled"
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement(layout_default.Row, { justify: "start" }, /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 4 }, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: typeFormElementId }, Liferay.Language.get("type"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
      form_exports.ClaySelectWithOption,
      {
        disabled: editing,
        id: typeFormElementId,
        onChange: (event) => handleActionTypeChange(event),
        options: activeTab === 0 ? ITEM_ACTION_TYPES : ACTION_TYPES,
        placeholder: Liferay.Language.get(
          "please-select-an-option"
        ),
        value: actionData.type
      }
    ))), actionData.type === ACTION_TYPE.ASYNC && /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 4 }, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: methodFormElementId }, Liferay.Language.get("method"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
      form_exports.ClaySelectWithOption,
      {
        id: methodFormElementId,
        onChange: (event) => setActionData({
          ...actionData,
          method: event.target.value
        }),
        options: ACTION_METHODS(),
        placeholder: Liferay.Language.get(
          "please-select-an-option"
        ),
        value: actionData.method
      }
    ))), actionData.type === ACTION_TYPE.MODAL && /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 4 }, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: modalSizeFormElementId }, Liferay.Language.get("variant"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
      form_exports.ClaySelectWithOption,
      {
        id: modalSizeFormElementId,
        onChange: (event) => setActionData({
          ...actionData,
          modalSize: event.target.value
        }),
        options: MODAL_SIZES,
        placeholder: Liferay.Language.get(
          "please-select-an-option"
        ),
        value: actionData.modalSize
      }
    )))), (actionData.type === ACTION_TYPE.MODAL || actionData.type === ACTION_TYPE.SIDEPANEL) && /* @__PURE__ */ react_default.createElement(layout_default.Row, null, /* @__PURE__ */ react_default.createElement(layout_default.Col, null, /* @__PURE__ */ react_default.createElement(
      frontend_js_components_web_exports.InputLocalized,
      {
        helpMessage: Liferay.Language.get(
          "side-panel-title-help"
        ),
        id: titleFormElementId,
        label: Liferay.Language.get("title"),
        onChange: (translations) => {
          setTitleTranslations(translations);
        },
        placeholder: actionData.type === ACTION_TYPE.MODAL ? Liferay.Language.get(
          "add-the-title-of-the-modal"
        ) : Liferay.Language.get(
          "add-the-title-of-the-side-panel"
        ),
        translations: titleTranslations
      }
    ))), actionData.type !== ACTION_TYPE.HEADLESS && /* @__PURE__ */ react_default.createElement(layout_default.Row, { justify: "start" }, /* @__PURE__ */ react_default.createElement(layout_default.Col, { lg: true }, /* @__PURE__ */ react_default.createElement(
      form_default.Group,
      {
        className: classnames_default({
          "has-error": urlValidationError
        })
      },
      /* @__PURE__ */ react_default.createElement("label", { htmlFor: urlFormElementId }, Liferay.Language.get("url"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)),
      /* @__PURE__ */ react_default.createElement(
        form_exports.ClayInput,
        {
          component: "textarea",
          id: urlFormElementId,
          onChange: (event) => {
            const url = event.target.value;
            setActionData({
              ...actionData,
              url
            });
            setURLValidationError(!url);
            validateForm({
              labelTranslations,
              permissionKey: actionData.permissionKey,
              url
            });
          },
          placeholder: Liferay.Language.get(
            "add-a-url-here"
          ),
          value: actionData.url
        }
      ),
      urlValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
    ))), /* @__PURE__ */ react_default.createElement(layout_default.Row, { justify: "start" }, /* @__PURE__ */ react_default.createElement(layout_default.Col, null, /* @__PURE__ */ react_default.createElement(
      form_default.Group,
      {
        className: classnames_default({
          "has-error": permissionKeyValidationError
        })
      },
      /* @__PURE__ */ react_default.createElement("label", { htmlFor: permissionKeyFormElementId }, Liferay.Language.get(
        "headless-action-key"
      ), actionData.type === ACTION_TYPE.HEADLESS && /* @__PURE__ */ react_default.createElement(RequiredMark_default, null), /* @__PURE__ */ react_default.createElement(
        "span",
        {
          className: "label-icon lfr-portal-tooltip ml-2",
          title: Liferay.Language.get(
            "headless-action-key-help"
          )
        },
        /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
      )),
      /* @__PURE__ */ react_default.createElement(
        form_exports.ClayInput,
        {
          id: permissionKeyFormElementId,
          onChange: (event) => {
            const permissionKey = event.target.value;
            setActionData({
              ...actionData,
              permissionKey
            });
            if (actionData.type === ACTION_TYPE.HEADLESS) {
              setPermissionKeyValidationError(
                !permissionKey
              );
            }
            validateForm({
              labelTranslations,
              permissionKey,
              url: actionData.url
            });
          },
          placeholder: Liferay.Language.get(
            "add-a-value-here"
          ),
          value: actionData.permissionKey
        }
      ),
      permissionKeyValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
    ))), activeTab === 0 && /* @__PURE__ */ react_default.createElement(layout_default.Row, null, /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 8 }, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
      frontend_js_components_web_exports.InputLocalized,
      {
        id: confirmationMessageFormElementId,
        label: Liferay.Language.get(
          "confirmation-message"
        ),
        onChange: setConfirmationMessageTranslations,
        placeholder: Liferay.Language.get(
          "add-a-message-here"
        ),
        tooltip: Liferay.Language.get(
          "the-user-will-see-this-message-before-performing-the-action"
        ),
        translations: confirmationMessageTranslations
      }
    ))), /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 4 }, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: confirmationMessageTypeFormElementId
      },
      Liferay.Language.get("message-type")
    ), /* @__PURE__ */ react_default.createElement(
      form_exports.ClaySelectWithOption,
      {
        id: confirmationMessageTypeFormElementId,
        onChange: (event) => setActionData({
          ...actionData,
          confirmationMessageType: event.target.value
        }),
        options: MESSAGE_TYPES,
        value: actionData.confirmationMessageType
      }
    )))))
  ), (actionData.type === ACTION_TYPE.ASYNC || actionData.type === ACTION_TYPE.HEADLESS) && /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      collapsable: true,
      defaultExpanded: true,
      displayTitle: Liferay.Language.get("status-messages"),
      displayType: "unstyled"
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement(form_default.Text, { className: "c-pb-3" }, Liferay.Language.get(
      "you-can-write-status-messages-related-to-this-action"
    )), /* @__PURE__ */ react_default.createElement(
      tabs_default,
      {
        activation: "automatic",
        active: activeMessageTab,
        onActiveChange: (tab) => {
          setActiveMessageTab(tab);
        }
      },
      /* @__PURE__ */ react_default.createElement(tabs_default.Item, null, Liferay.Language.get("success")),
      /* @__PURE__ */ react_default.createElement(tabs_default.Item, null, Liferay.Language.get("error"))
    ), /* @__PURE__ */ react_default.createElement(
      tabs_default.Content,
      {
        active: activeMessageTab,
        className: "action-messages",
        fade: true
      },
      /* @__PURE__ */ react_default.createElement(
        tabs_default.TabPane,
        {
          "aria-labelledby": Liferay.Language.get(
            "success"
          )
        },
        /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
          frontend_js_components_web_exports.InputLocalized,
          {
            id: successMessageFormElementId,
            label: Liferay.Language.get("message"),
            onChange: setSuccessMessageTranslations,
            placeholder: Liferay.Language.get(
              "add-a-message-here"
            ),
            tooltip: Liferay.Language.get(
              "the-user-will-see-this-message-if-the-action-is-successful"
            ),
            translations: successMessageTranslations
          }
        ))
      ),
      /* @__PURE__ */ react_default.createElement(
        tabs_default.TabPane,
        {
          "aria-labelledby": Liferay.Language.get("error")
        },
        /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
          frontend_js_components_web_exports.InputLocalized,
          {
            id: errorMessageFormElementId,
            label: Liferay.Language.get("message"),
            onChange: setErrorMessageTranslations,
            placeholder: Liferay.Language.get(
              "add-a-message-here"
            ),
            tooltip: Liferay.Language.get(
              "the-user-will-see-this-message-if-the-action-fails"
            ),
            translations: errorMessageTranslations
          }
        ))
      )
    ))
  ), /* @__PURE__ */ react_default.createElement(button_default.Group, { className: "pb-4 px-4", spaced: true }, /* @__PURE__ */ react_default.createElement(button_default, { disabled: saveButtonDisabled, onClick: saveAction }, Liferay.Language.get("save")), /* @__PURE__ */ react_default.createElement(button_default, { displayType: "secondary", onClick: onCancel }, Liferay.Language.get("cancel"))));
};
var ActionForm_default = ActionForm;

// ../../../../../../../../../$/bridge/for/main/@clayui/drop-down
var drop_down_exports = {};
__export(drop_down_exports, {
  default: () => drop_down_default
});
__reExport(drop_down_exports, clayui_drop_down_star);
import * as clayui_drop_down_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$drop-down.js";
import __default__12 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$drop-down.js";
var drop_down_default = __default__12;

// ../../../../../../../../../$/bridge/for/main/@clayui/empty-state
var empty_state_exports = {};
__export(empty_state_exports, {
  default: () => empty_state_default
});
__reExport(empty_state_exports, clayui_empty_state_star);
import * as clayui_empty_state_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$empty-state.js";
import __default__13 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$empty-state.js";
var empty_state_default = __default__13;

// ../../../../../../../../../$/bridge/for/main/@clayui/table
var table_exports = {};
__export(table_exports, {
  default: () => table_default
});
__reExport(table_exports, clayui_table_star);
import * as clayui_table_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$table.js";
import __default__14 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$table.js";
var table_default = __default__14;

// ../../../../../../../../../$/bridge/for/main/fuzzy
var fuzzy_exports = {};
__export(fuzzy_exports, {
  default: () => fuzzy_default
});
__reExport(fuzzy_exports, fuzzy_star);
import * as fuzzy_star from "../../frontend-js-dependencies-web/__liferay__/exports/fuzzy.js";
import __default__15 from "../../frontend-js-dependencies-web/__liferay__/exports/fuzzy.js";
var fuzzy_default = __default__15;

// ../../../../../../../../../$/bridge/for/main/react-dnd
var react_dnd_exports = {};
__export(react_dnd_exports, {
  default: () => react_dnd_default
});
__reExport(react_dnd_exports, react_dnd_star);
import * as react_dnd_star from "../../frontend-js-react-web/__liferay__/exports/react-dnd.js";
import __default__16 from "../../frontend-js-react-web/__liferay__/exports/react-dnd.js";
var react_dnd_default = __default__16;

// ../../../../../../../../../$/bridge/for/main/react-dnd-html5-backend
var react_dnd_html5_backend_exports = {};
__reExport(react_dnd_html5_backend_exports, react_dnd_html5_backend_star);
import * as react_dnd_html5_backend_star from "../../frontend-js-react-web/__liferay__/exports/react-dnd-html5-backend.js";

// src/main/resources/META-INF/resources/css/components/OrderableTable.scss
var link = document.createElement("link");
link.setAttribute("rel", "stylesheet");
link.setAttribute("type", "text/css");
link.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/components/OrderableTable.css"
);
document.querySelector("head").appendChild(link);

// src/main/resources/META-INF/resources/js/components/OrderableTable.tsx
var ROW_DRAGGABLE = "rowDraggable";
var Row = ({
  actions,
  fields,
  index,
  item,
  onDragCrossover,
  onDrop,
  query
}) => {
  const tableRowRef = (0, react_exports.useRef)(null);
  const [{ isDragging }, dragRef] = (0, react_dnd_exports.useDrag)({
    collect: (monitor) => ({
      isDragging: monitor.isDragging()
    }),
    item: {
      index,
      type: ROW_DRAGGABLE
    }
  });
  const onBlur = () => {
    const currentRow = tableRowRef?.current;
    if (currentRow) {
      const dragging = currentRow.classList.contains("dragging");
      if (dragging) {
        currentRow.classList.remove("dragging");
        onDrop();
      }
    }
  };
  const onKeyDown = (event) => {
    const currentRow = tableRowRef?.current;
    if (currentRow) {
      const dragging = currentRow.classList.contains("dragging");
      if (event.key === "Enter") {
        if (!dragging) {
          currentRow.classList.add("dragging");
          const draggedIndex = index;
          const targetIndex = index;
          onDragCrossover({ draggedIndex, targetIndex });
        } else {
          currentRow.classList.remove("dragging");
          onDrop();
        }
      } else if (event.key === "ArrowDown" && dragging) {
        const draggedIndex = index;
        const targetIndex = index + 1;
        onDragCrossover({ draggedIndex, targetIndex });
      } else if (event.key === "ArrowUp" && dragging) {
        const draggedIndex = index;
        const targetIndex = index - 1;
        if (targetIndex >= 0) {
          onDragCrossover({ draggedIndex, targetIndex });
        }
      } else if ((event.key === "Escape" || event.key === "Tab") && dragging) {
        currentRow.classList.remove("dragging");
        onDrop();
      }
    }
  };
  const [, dropRef] = (0, react_dnd_exports.useDrop)({
    accept: ROW_DRAGGABLE,
    hover(item2, monitor) {
      if (!tableRowRef.current || !onDragCrossover) {
        return;
      }
      const draggedIndex = item2.index;
      const targetIndex = index;
      if (draggedIndex === targetIndex) {
        return;
      }
      const targetSize = tableRowRef.current.getBoundingClientRect();
      const targetCenter = (targetSize.bottom - targetSize.top) / 2;
      const draggedOffset = monitor.getClientOffset();
      if (!draggedOffset) {
        return;
      }
      const draggedTop = draggedOffset.y - targetSize.top;
      if (draggedIndex < targetIndex && draggedTop < targetCenter || draggedIndex > targetIndex && draggedTop > targetCenter) {
        return;
      }
      onDragCrossover({ draggedIndex, targetIndex });
      item2.index = targetIndex;
    }
  });
  dragRef(dropRef(tableRowRef));
  return /* @__PURE__ */ react_default.createElement(
    table_default.Row,
    {
      className: classnames_default("orderable-table-row", {
        dragging: isDragging
      }),
      ref: tableRowRef
    },
    /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "drag-handle-cell" }, tableRowRef?.current?.classList.contains("dragging") ? /* @__PURE__ */ react_default.createElement("span", { "aria-live": "assertive", className: "sr-only" }, Liferay.Language.get(
      "use-up-and-down-arrows-to-move-the-field-and-press-enter-to-place-it-in-desired-position"
    )) : null, /* @__PURE__ */ react_default.createElement(
      button_exports.ClayButtonWithIcon,
      {
        "aria-label": Liferay.Util.sub(
          Liferay.Language.get("drag-x"),
          item.label || Liferay.Language.get("item")
        ),
        displayType: null,
        onBlur,
        onKeyDown,
        size: "sm",
        symbol: "drag"
      }
    )),
    fields.map((field) => {
      if (field.contentRenderer) {
        const Component = field.contentRenderer.component;
        return /* @__PURE__ */ react_default.createElement(table_default.Cell, { key: field.name }, /* @__PURE__ */ react_default.createElement(Component, { item, query }));
      }
      const itemFieldValue = String(item[field.name]);
      const fuzzyMatch = fuzzy_default.match(
        query,
        itemFieldValue,
        FUZZY_OPTIONS
      );
      return /* @__PURE__ */ react_default.createElement(
        table_default.Cell,
        {
          headingTitle: field.headingTitle,
          key: field.name
        },
        fuzzyMatch ? /* @__PURE__ */ react_default.createElement(
          "span",
          {
            dangerouslySetInnerHTML: {
              __html: fuzzyMatch.rendered
            }
          }
        ) : /* @__PURE__ */ react_default.createElement("span", null, itemFieldValue)
      );
    }),
    actions && /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "actions-cell" }, /* @__PURE__ */ react_default.createElement(
      drop_down_default,
      {
        trigger: /* @__PURE__ */ react_default.createElement(
          button_default,
          {
            className: "component-action",
            displayType: "unstyled"
          },
          /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "ellipsis-v" }),
          /* @__PURE__ */ react_default.createElement("span", { className: "sr-only" }, Liferay.Language.get("actions"))
        )
      },
      /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, null, actions.map(({ icon, label, onClick }) => /* @__PURE__ */ react_default.createElement(
        drop_down_default.Item,
        {
          key: label,
          onClick: () => onClick({
            item
          })
        },
        icon && /* @__PURE__ */ react_default.createElement("span", { className: "pr-2" }, /* @__PURE__ */ react_default.createElement(icon_default, { symbol: icon })),
        label
      )))
    ))
  );
};
var Table = ({
  actions,
  fields,
  items,
  onDragCrossover,
  onDrop,
  query
}) => {
  const [, dropRef] = (0, react_dnd_exports.useDrop)({
    accept: ROW_DRAGGABLE,
    drop() {
      onDrop();
    }
  });
  return /* @__PURE__ */ react_default.createElement(table_default, { className: "orderable-table", ref: dropRef }, /* @__PURE__ */ react_default.createElement(table_default.Head, null, /* @__PURE__ */ react_default.createElement(table_default.Row, null, /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "drag-handle-cell" }), fields.map((field) => /* @__PURE__ */ react_default.createElement(table_default.Cell, { headingCell: true, key: field.name }, field.label)), actions && /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "actions-cell" }))), /* @__PURE__ */ react_default.createElement(table_default.Body, null, items.map((item, index) => /* @__PURE__ */ react_default.createElement(
    Row,
    {
      actions,
      fields,
      index,
      item,
      key: item.id || index,
      onDragCrossover,
      onDrop,
      query
    }
  ))));
};
var OrderableTable = ({
  actions,
  className,
  creationMenuItems,
  creationMenuLabel = Liferay.Language.get("new"),
  fields,
  items: initialItems,
  noItemsButtonLabel,
  noItemsDescription,
  noItemsTitle,
  onOrderChange,
  title
}) => {
  const [items, setItems] = (0, react_exports.useState)(initialItems);
  const [order, setOrder] = (0, react_exports.useState)(
    initialItems.map((item) => item.id).join(",")
  );
  const [query, setQuery] = (0, react_exports.useState)("");
  (0, react_exports.useEffect)(() => setItems(initialItems), [initialItems]);
  const onSearch = (query2) => {
    setQuery(query2);
    const regexp = new RegExp(query2, "i");
    setItems(
      query2 ? initialItems.filter(
        (item) => fields.some((field) => {
          if (field.contentRenderer?.textMatch) {
            return String(
              field.contentRenderer.textMatch(item)
            ).match(regexp);
          }
          return String(item[field.name]).match(regexp);
        })
      ) || [] : initialItems
    );
  };
  return /* @__PURE__ */ react_default.createElement(
    layout_default.Sheet,
    {
      className: classnames_default("orderable-table-sheet", className)
    },
    title && /* @__PURE__ */ react_default.createElement(layout_default.SheetHeader, null, /* @__PURE__ */ react_default.createElement("h2", { className: "sheet-title" }, title)),
    /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, null, /* @__PURE__ */ react_default.createElement(frontend_js_components_web_exports.ManagementToolbar.Container, null, /* @__PURE__ */ react_default.createElement(frontend_js_components_web_exports.ManagementToolbar.ItemList, { expand: true }, /* @__PURE__ */ react_default.createElement(frontend_js_components_web_exports.ManagementToolbar.Item, { className: "nav-item-expand" }, /* @__PURE__ */ react_default.createElement(Search_default, { onSearch, query })), creationMenuItems?.length && /* @__PURE__ */ react_default.createElement(frontend_js_components_web_exports.ManagementToolbar.Item, null, creationMenuItems.length > 1 ? /* @__PURE__ */ react_default.createElement(
      drop_down_exports.ClayDropDownWithItems,
      {
        items: creationMenuItems,
        trigger: /* @__PURE__ */ react_default.createElement(
          button_exports.ClayButtonWithIcon,
          {
            "aria-label": creationMenuLabel,
            className: "nav-btn nav-btn-monospaced",
            symbol: "plus",
            title: creationMenuLabel
          }
        )
      }
    ) : /* @__PURE__ */ react_default.createElement(
      button_exports.ClayButtonWithIcon,
      {
        "aria-label": creationMenuItems[0].label ?? creationMenuLabel,
        className: "nav-btn nav-btn-monospaced",
        onClick: creationMenuItems[0].onClick,
        symbol: "plus",
        title: creationMenuItems[0].label ?? creationMenuLabel
      }
    )))), items.length ? /* @__PURE__ */ react_default.createElement(react_dnd_exports.DndProvider, { backend: react_dnd_html5_backend_exports.HTML5Backend }, /* @__PURE__ */ react_default.createElement(
      Table,
      {
        actions,
        fields,
        items,
        onDragCrossover: ({
          draggedIndex,
          targetIndex
        }) => {
          const orderedItems = [...items];
          if (draggedIndex !== targetIndex) {
            orderedItems.splice(draggedIndex, 1);
            orderedItems.splice(
              targetIndex,
              0,
              items[draggedIndex]
            );
          }
          setItems(orderedItems);
        },
        onDrop: () => {
          const newOrder = items.map((item) => item.id).join(",");
          if (newOrder !== order) {
            setOrder(newOrder);
            onOrderChange({ order: newOrder });
          }
        },
        query
      }
    )) : query ? /* @__PURE__ */ react_default.createElement(
      empty_state_default,
      {
        className: "text-center",
        description: Liferay.Language.get(
          "sorry,-no-results-were-found"
        ),
        title: Liferay.Language.get("no-results-found")
      }
    ) : /* @__PURE__ */ react_default.createElement(
      empty_state_default,
      {
        className: "text-center",
        description: noItemsDescription,
        title: noItemsTitle
      },
      creationMenuItems?.length && (creationMenuItems.length > 1 ? /* @__PURE__ */ react_default.createElement(
        drop_down_exports.ClayDropDownWithItems,
        {
          alignmentPosition: 4,
          items: creationMenuItems,
          trigger: /* @__PURE__ */ react_default.createElement(
            button_default,
            {
              "aria-label": creationMenuLabel,
              displayType: "secondary"
            },
            noItemsButtonLabel
          )
        }
      ) : /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: creationMenuItems[0].onClick
        },
        noItemsButtonLabel
      ))
    ))
  );
};
var OrderableTable_default = OrderableTable;

// src/main/resources/META-INF/resources/js/data_set/actions/components/ActionList.tsx
var ActionList = ({
  actions,
  createAction,
  creationMenuItemLabel,
  deleteAction,
  editAction,
  noItemsButtonLabel,
  updateActionsOrder
}) => {
  return /* @__PURE__ */ react_default.createElement(
    OrderableTable_default,
    {
      actions: [
        {
          icon: "pencil",
          label: Liferay.Language.get("edit"),
          onClick: editAction
        },
        {
          icon: "trash",
          label: Liferay.Language.get("delete"),
          onClick: deleteAction
        }
      ],
      className: "mt-0 p-1",
      creationMenuItems: [
        {
          label: creationMenuItemLabel,
          onClick: createAction
        }
      ],
      fields: [
        {
          label: Liferay.Language.get("icon"),
          name: "icon"
        },
        {
          label: Liferay.Language.get("label"),
          name: "label"
        },
        {
          label: Liferay.Language.get("type"),
          name: "type"
        }
      ],
      items: actions,
      noItemsButtonLabel,
      noItemsDescription: Liferay.Language.get(
        "start-creating-an-action-to-interact-with-your-data"
      ),
      noItemsTitle: Liferay.Language.get("no-actions-were-created"),
      onOrderChange: ({ order }) => {
        updateActionsOrder({
          order
        });
      }
    }
  );
};
var ActionList_default = ActionList;

// src/main/resources/META-INF/resources/css/Actions.scss
var link2 = document.createElement("link");
link2.setAttribute("rel", "stylesheet");
link2.setAttribute("type", "text/css");
link2.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/Actions.css"
);
document.querySelector("head").appendChild(link2);

// src/main/resources/META-INF/resources/js/utils/sortItems.ts
function sortItems(items, itemsOrder, useCreationDate = false) {
  const itemsOrderArray = itemsOrder?.split(",") || [];
  let included = [];
  let notIncluded = [];
  included = itemsOrderArray.map(
    (itemId) => items.find((item) => Number(item.id) === Number(itemId))
  ).filter(Boolean);
  notIncluded = items.filter(
    (item) => !itemsOrderArray.includes(String(item.id))
  );
  if (useCreationDate) {
    const creationDates = {};
    notIncluded.forEach((item) => {
      creationDates[item.id] = Date.parse(item.dateCreated);
    });
    notIncluded = notIncluded.sort(
      (item1, item2) => creationDates[item1.id] - creationDates[item2.id]
    );
  }
  return [...included, ...notIncluded];
}

// src/main/resources/META-INF/resources/js/data_set/actions/Actions.tsx
var SECTIONS = {
  CREATION_ACTIONS: "creation-actions",
  EDIT_CREATION_ACTION: "edit-creation-action",
  EDIT_ITEM_ACTION: "edit-item-action",
  ITEM_ACTIONS: "item-actions",
  NEW_CREATION_ACTION: "new-creation-action",
  NEW_ITEM_ACTION: "new-item-action"
};
var Actions = ({ dataSet, namespace, spritemap }) => {
  const [actions, setActions] = (0, react_exports.useState)([]);
  const [activeSection, setActiveSection] = (0, react_exports.useState)(SECTIONS.ITEM_ACTIONS);
  const [activeTab, setActiveTab] = (0, react_exports.useState)(0);
  const [loading, setLoading] = (0, react_exports.useState)(true);
  const [initialActionFormValues, setInitialActionFormValues] = (0, react_exports.useState)();
  const getBreadcrumbItems = () => {
    const breadcrumbItems = [
      {
        active: activeSection === SECTIONS.ITEM_ACTIONS || activeSection === SECTIONS.CREATION_ACTIONS,
        label: Liferay.Language.get("actions"),
        onClick: () => {
          const activeSection2 = activeTab === 0 ? SECTIONS.ITEM_ACTIONS : SECTIONS.CREATION_ACTIONS;
          setActiveSection(activeSection2);
        }
      }
    ];
    if (activeSection === SECTIONS.NEW_ITEM_ACTION) {
      breadcrumbItems.push({
        active: true,
        label: Liferay.Language.get("new-item-action"),
        onClick: () => setActiveSection(SECTIONS.NEW_ITEM_ACTION)
      });
    }
    if (activeSection === SECTIONS.EDIT_ITEM_ACTION || activeSection === SECTIONS.EDIT_CREATION_ACTION) {
      breadcrumbItems.push({
        active: true,
        label: initialActionFormValues?.label || ""
      });
    }
    if (activeSection === SECTIONS.NEW_CREATION_ACTION) {
      breadcrumbItems.push({
        active: true,
        label: Liferay.Language.get("new-creation-action"),
        onClick: () => setActiveSection(SECTIONS.NEW_CREATION_ACTION)
      });
    }
    return breadcrumbItems;
  };
  const loadActions = async ({ activeTab: activeTab2 }) => {
    setLoading(true);
    const relationShip = activeTab2 === 0 ? OBJECT_RELATIONSHIP.DATA_SET_ITEM_ACTION : OBJECT_RELATIONSHIP.DATA_SET_CREATION_ACTION;
    const relationshipID = activeTab2 === 0 ? OBJECT_RELATIONSHIP.DATA_SET_ITEM_ACTION_ID : OBJECT_RELATIONSHIP.DATA_SET_CREATION_ACTION_ID;
    const url = `${API_URL.ACTIONS}?filter=(${relationshipID} eq '${dataSet.id}')&nestedFields=${relationShip}&sort=dateCreated:asc`;
    if (activeTab2 === 0) {
      setActiveSection(SECTIONS.ITEM_ACTIONS);
    } else if (activeTab2 === 1) {
      setActiveSection(SECTIONS.CREATION_ACTIONS);
    }
    const response = await (0, frontend_js_web_exports.fetch)(url);
    if (!response.ok) {
      setLoading(false);
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    const storedActions = responseJSON.items;
    const actionTypeOrder = activeTab2 === 0 ? "fdsItemActionsOrder" : "fdsCreationActionsOrder";
    const fdsActionsOrder = storedActions?.[0]?.[relationShip]?.[actionTypeOrder];
    setActions(sortItems(storedActions, fdsActionsOrder));
    setLoading(false);
  };
  const createAction = () => {
    const activeSection2 = activeTab === 0 ? SECTIONS.NEW_ITEM_ACTION : SECTIONS.NEW_CREATION_ACTION;
    setActiveSection(activeSection2);
  };
  const deleteAction = ({ item }) => {
    (0, frontend_js_web_exports.openModal)({
      bodyHTML: Liferay.Language.get(
        "are-you-sure-you-want-to-delete-this-action"
      ),
      buttons: [
        {
          autoFocus: true,
          displayType: "secondary",
          label: Liferay.Language.get("cancel"),
          type: "cancel"
        },
        {
          displayType: "danger",
          label: Liferay.Language.get("delete"),
          onClick: ({ processClose }) => {
            processClose();
            (0, frontend_js_web_exports.fetch)(item.actions.delete.href, {
              method: item.actions.delete.method
            }).then(() => {
              openDefaultFailureToast2();
              loadActions({ activeTab });
            }).catch(() => openDefaultFailureToast());
          }
        }
      ],
      status: "danger",
      title: Liferay.Language.get("delete-action")
    });
  };
  const editAction = ({ item }) => {
    setInitialActionFormValues(item);
    const actionType = activeTab === 0 ? SECTIONS.EDIT_ITEM_ACTION : SECTIONS.EDIT_CREATION_ACTION;
    setActiveSection(actionType);
  };
  const updateActionsOrder = async ({ order }) => {
    let actionTypeOrder = activeTab === 0 ? "fdsItemActionsOrder" : "fdsCreationActionsOrder";
    let apiURL = API_URL.DATA_SETS;
    if (Liferay.FeatureFlags["LPD-15729"]) {
      actionTypeOrder = activeTab === 0 ? "itemActionsOrder" : "creationActionsOrder";
      apiURL = API_URL.DATA_SETS;
    }
    const response = await (0, frontend_js_web_exports.fetch)(
      `${apiURL}/by-external-reference-code/${dataSet.externalReferenceCode}`,
      {
        body: JSON.stringify({
          [actionTypeOrder]: order
        }),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    const storedActionsOrder = responseJSON?.[actionTypeOrder];
    if (actions && storedActionsOrder && storedActionsOrder === order) {
      setActions(sortItems(actions, storedActionsOrder));
      openDefaultFailureToast2();
    } else {
      openDefaultFailureToast();
    }
  };
  (0, react_exports.useEffect)(() => {
    loadActions({ activeTab: 0 });
  }, []);
  if (loading) {
    return /* @__PURE__ */ react_default.createElement(loading_indicator_default, null);
  }
  return /* @__PURE__ */ react_default.createElement(layout_default.ContainerFluid, null, /* @__PURE__ */ react_default.createElement(breadcrumb_default, { className: "my-2", items: getBreadcrumbItems() }), /* @__PURE__ */ react_default.createElement(layout_default.ContainerFluid, { className: "bg-white mb-4 p-0 rounded-sm" }, (activeSection === SECTIONS.ITEM_ACTIONS || activeSection === SECTIONS.CREATION_ACTIONS) && /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("h2", { className: "mb-0 p-4" }, Liferay.Language.get("actions")), /* @__PURE__ */ react_default.createElement(
    tabs_default,
    {
      activation: "automatic",
      active: activeTab,
      onActiveChange: (tab) => {
        setActiveTab(tab);
        loadActions({ activeTab: tab });
      }
    },
    /* @__PURE__ */ react_default.createElement(tabs_default.Item, null, Liferay.Language.get("item-actions")),
    /* @__PURE__ */ react_default.createElement(tabs_default.Item, null, Liferay.Language.get("creation-actions"))
  ), /* @__PURE__ */ react_default.createElement(tabs_default.Content, { active: activeTab, fade: true }, /* @__PURE__ */ react_default.createElement(
    tabs_default.TabPane,
    {
      "aria-labelledby": Liferay.Language.get(
        "actions"
      )
    },
    /* @__PURE__ */ react_default.createElement(
      ActionList_default,
      {
        actions,
        createAction,
        creationMenuItemLabel: Liferay.Language.get(
          "new-item-action"
        ),
        deleteAction,
        editAction,
        noItemsButtonLabel: Liferay.Language.get(
          "new-item-action"
        ),
        updateActionsOrder
      }
    )
  ), /* @__PURE__ */ react_default.createElement(
    tabs_default.TabPane,
    {
      "aria-labelledby": Liferay.Language.get(
        "new-creation-action"
      )
    },
    /* @__PURE__ */ react_default.createElement(
      ActionList_default,
      {
        actions,
        createAction,
        creationMenuItemLabel: Liferay.Language.get(
          "new-creation-action"
        ),
        deleteAction,
        editAction,
        noItemsButtonLabel: Liferay.Language.get(
          "new-creation-action"
        ),
        updateActionsOrder
      }
    )
  ))), (activeSection === SECTIONS.NEW_CREATION_ACTION || activeSection === SECTIONS.NEW_ITEM_ACTION) && /* @__PURE__ */ react_default.createElement(
    ActionForm_default,
    {
      activeTab,
      dataSet,
      namespace,
      onCancel: () => {
        setActiveSection(
          activeTab === 0 ? SECTIONS.ITEM_ACTIONS : SECTIONS.CREATION_ACTIONS
        );
      },
      onSave: () => {
        setActiveSection(
          activeTab === 0 ? SECTIONS.ITEM_ACTIONS : SECTIONS.CREATION_ACTIONS
        );
        loadActions({ activeTab });
      },
      spritemap
    }
  ), (activeSection === SECTIONS.EDIT_CREATION_ACTION || activeSection === SECTIONS.EDIT_ITEM_ACTION) && /* @__PURE__ */ react_default.createElement(
    ActionForm_default,
    {
      activeTab,
      dataSet,
      editing: true,
      initialValues: initialActionFormValues,
      namespace,
      onCancel: () => {
        setActiveSection(
          activeTab === 0 ? SECTIONS.ITEM_ACTIONS : SECTIONS.CREATION_ACTIONS
        );
      },
      onSave: () => {
        setActiveSection(
          activeTab === 0 ? SECTIONS.ITEM_ACTIONS : SECTIONS.CREATION_ACTIONS
        );
        loadActions({ activeTab });
      },
      spritemap
    }
  )));
};
var Actions_default = Actions;

// ../../../../../../../../../$/bridge/for/main/@clayui/list
var list_exports = {};
__export(list_exports, {
  default: () => list_default
});
__reExport(list_exports, clayui_list_star);
import * as clayui_list_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$list.js";
import __default__17 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$list.js";
var list_default = __default__17;

// src/main/resources/META-INF/resources/js/data_set/details/Details.tsx
var Details = ({
  backURL,
  dataSet,
  namespace,
  onDataSetUpdate
}) => {
  const [labelValidationError, setLabelValidationError] = (0, react_exports.useState)(false);
  const descriptionRef = (0, react_exports.useRef)(null);
  const labelRef = (0, react_exports.useRef)(null);
  const updateFDSView = async () => {
    const body = {
      description: descriptionRef.current?.value,
      label: labelRef.current?.value
    };
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.DATA_SETS}/by-external-reference-code/${dataSet.externalReferenceCode}`,
      {
        body: JSON.stringify(body),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    if (responseJSON?.id) {
      openDefaultFailureToast2();
      const controlMenuHeaderTitles = document.getElementsByClassName(
        "control-menu-level-1-heading"
      );
      if (controlMenuHeaderTitles.length === 1) {
        controlMenuHeaderTitles[0].innerHTML = Liferay.Util.escapeHTML(
          labelRef.current?.value ?? ""
        );
      }
      onDataSetUpdate(responseJSON);
    } else {
      openDefaultFailureToast();
    }
  };
  const { restApplication, restEndpoint, restSchema } = Liferay.FeatureFlags["LPD-15729"] ? dataSet : dataSet[OBJECT_RELATIONSHIP.FDS_ENTRY_FDS_VIEW];
  return /* @__PURE__ */ react_default.createElement(layout_default.Sheet, { className: "mt-3", size: "lg" }, /* @__PURE__ */ react_default.createElement(layout_default.SheetHeader, null, /* @__PURE__ */ react_default.createElement("h2", { className: "sheet-title" }, Liferay.Language.get("details"))), /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, null, /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": labelValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement("label", { htmlFor: `${namespace}dataSetLabelInput` }, Liferay.Language.get("name"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayInput,
      {
        defaultValue: dataSet.label,
        id: `${namespace}dataSetLabelInput`,
        onBlur: () => setLabelValidationError(!labelRef.current?.value),
        ref: labelRef,
        type: "text"
      }
    ),
    labelValidationError && /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), Liferay.Language.get("this-field-is-required")))
  ), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: `${namespace}dataSetDesctiptionInput` }, Liferay.Language.get("description")), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayInput,
    {
      defaultValue: dataSet.description,
      id: `${namespace}dataSetDesctiptionInput`,
      ref: descriptionRef,
      type: "text"
    }
  ))), /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, { className: "mb-4" }, /* @__PURE__ */ react_default.createElement("h3", { className: "sheet-subtitle" }, Liferay.Language.get("rest-information")), /* @__PURE__ */ react_default.createElement(list_default, { className: "flex-row flex-wrap" }, /* @__PURE__ */ react_default.createElement(list_default.Item, { className: "border-0 col-12 col-sm-6", flex: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { className: "justify-content-center" }, /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "api-web" })), /* @__PURE__ */ react_default.createElement(list_default.ItemField, { expand: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, null, Liferay.Language.get("application")), /* @__PURE__ */ react_default.createElement(list_default.ItemText, null, restApplication))), /* @__PURE__ */ react_default.createElement(list_default.Item, { className: "border-0 col-12 col-sm-6", flex: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { className: "justify-content-center" }, /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "diagram" })), /* @__PURE__ */ react_default.createElement(list_default.ItemField, null, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, null, Liferay.Language.get("schema")), /* @__PURE__ */ react_default.createElement(list_default.ItemText, null, restSchema))), /* @__PURE__ */ react_default.createElement(list_default.Item, { className: "border-0 col-12", flex: true }, /* @__PURE__ */ react_default.createElement(list_default.ItemField, { className: "justify-content-center" }, /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "nodes" })), /* @__PURE__ */ react_default.createElement(list_default.ItemField, null, /* @__PURE__ */ react_default.createElement(list_default.ItemTitle, null, Liferay.Language.get("endpoint")), /* @__PURE__ */ react_default.createElement(list_default.ItemText, null, restEndpoint))))), /* @__PURE__ */ react_default.createElement(layout_default.SheetFooter, null, /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(button_default, { onClick: updateFDSView }, Liferay.Language.get("save")), /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      displayType: "secondary",
      onClick: () => (0, frontend_js_web_exports.navigate)(backURL)
    },
    Liferay.Language.get("cancel")
  ))));
};
var Details_default = Details;

// ../../../../../../../../../$/bridge/for/main/@clayui/modal
var modal_exports = {};
__export(modal_exports, {
  default: () => modal_default
});
__reExport(modal_exports, clayui_modal_star);
import * as clayui_modal_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$modal.js";
import __default__18 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$modal.js";
var modal_default = __default__18;

// ../../../../../../../../../$/bridge/for/main/@clayui/alert
var alert_exports = {};
__export(alert_exports, {
  default: () => alert_default
});
__reExport(alert_exports, clayui_alert_star);
import * as clayui_alert_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$alert.js";
import __default__19 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$alert.js";
var alert_default = __default__19;

// ../../../../../../../../../$/bridge/for/main/@clayui/label
var label_exports = {};
__export(label_exports, {
  default: () => label_default
});
__reExport(label_exports, clayui_label_star);
import * as clayui_label_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$label.js";
import __default__20 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$label.js";
var label_default = __default__20;

// src/main/resources/META-INF/resources/js/data_set/filters/modals/Configuration.tsx
function Configuration({
  fieldInUseValidationError,
  fieldNames,
  fieldValidationError,
  fields,
  filter,
  labelValidationError,
  namespace,
  onBlur,
  onChangeField,
  onChangeLabel
}) {
  const [selectedField, setSelectedField] = (0, react_exports.useState)(
    fields.find((item) => item.name === filter?.fieldName)
  );
  const fdsFilterLabelTranslations = filter?.label_i18n ?? {};
  const [i18nFilterLabels, setI18nFilterLabels] = (0, react_exports.useState)(
    fdsFilterLabelTranslations
  );
  const inUseFields = fields.map(
    (item) => fieldNames?.includes(item.name) ? item.name : void 0
  );
  const nameFormElementId = `${namespace}Name`;
  const selectedFieldFormElementId = `${namespace}SelectedField`;
  const FieldNameDropdown = ({
    fields: fields2,
    onItemClick
  }) => {
    return /* @__PURE__ */ react_default.createElement(
      drop_down_default,
      {
        closeOnClick: true,
        menuElementAttrs: {
          className: "fds-field-name-dropdown-menu"
        },
        trigger: /* @__PURE__ */ react_default.createElement(
          button_default,
          {
            className: "form-control form-control-select form-control-select-secondary",
            displayType: "secondary",
            id: selectedFieldFormElementId
          },
          selectedField ? selectedField.label : Liferay.Language.get("select")
        )
      },
      /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, { items: fields2, role: "listbox" }, fields2.map((field) => /* @__PURE__ */ react_default.createElement(
        drop_down_default.Item,
        {
          className: "align-items-center d-flex justify-content-between",
          disabled: !!filter,
          key: field.name,
          onClick: () => onItemClick(field),
          roleItem: "option"
        },
        field.label,
        inUseFields.includes(field.name) && /* @__PURE__ */ react_default.createElement(label_default, { displayType: "info" }, Liferay.Language.get("in-use"))
      )))
    );
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, Liferay.FeatureFlags["LPD-10754"] && /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, { className: "mb-4" }, /* @__PURE__ */ react_default.createElement("h3", { className: "sheet-subtitle" }, Liferay.Language.get("configuration")), /* @__PURE__ */ react_default.createElement(form_default.Text, null, Liferay.Language.get(
    "add-a-name-for-your-filter-and-select-a-field-to-start-creating-it"
  ))), /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": labelValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      frontend_js_components_web_exports.InputLocalized,
      {
        id: nameFormElementId,
        label: Liferay.Language.get("name"),
        name: "label",
        onBlur,
        onChange: (values) => {
          onChangeLabel(values);
          setI18nFilterLabels(values);
        },
        placeholder: Liferay.Language.get("add-a-name"),
        required: Liferay.FeatureFlags["LPD-10754"],
        translations: i18nFilterLabels
      }
    ),
    Liferay.FeatureFlags["LPD-10754"] && labelValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  ), /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": fieldInUseValidationError || Liferay.FeatureFlags["LPD-10754"] && fieldValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement("label", { htmlFor: selectedFieldFormElementId }, Liferay.Language.get("filter-by"), Liferay.FeatureFlags["LPD-10754"] && /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)),
    /* @__PURE__ */ react_default.createElement(
      FieldNameDropdown,
      {
        fields,
        onItemClick: (item) => {
          const newVal = fields.find((field) => {
            return field.label === item.label;
          });
          if (newVal) {
            setSelectedField(newVal);
            onChangeField(newVal);
          }
        }
      }
    ),
    fieldInUseValidationError && /* @__PURE__ */ react_default.createElement(
      ValidationFeedback_default,
      {
        message: Liferay.Language.get(
          "this-field-is-being-used-by-another-filter"
        )
      }
    ),
    Liferay.FeatureFlags["LPD-10754"] && fieldValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  ));
}
var Configuration_default = Configuration;

// src/main/resources/META-INF/resources/js/data_set/filters/modals/Footer.tsx
function Footer({ closeModal, onSave, saveButtonDisabled }) {
  return /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled,
          onClick: () => onSave(),
          type: "submit"
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  );
}
var Footer_default = Footer;

// src/main/resources/META-INF/resources/js/data_set/filters/modals/ClientExtensionFilter.tsx
function Header() {
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, Liferay.Language.get("new-client-extension-filter"));
}
function Body({
  closeModal,
  fdsFilterClientExtensions,
  fieldNames,
  fields,
  filter,
  namespace,
  onSave
}) {
  const [clientExtensionValidationError, setClientExtensionValidationError] = (0, react_exports.useState)(false);
  const [fieldInUseValidationError, setFieldInUseValidationError] = (0, react_exports.useState)(false);
  const [fieldValidationError, setFieldValidationError] = (0, react_exports.useState)(false);
  const [labelValidationError, setLabelValidationError] = (0, react_exports.useState)(false);
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [selectedClientExtension, setSelectedClientExtension] = (0, react_exports.useState)(
    filter ? fdsFilterClientExtensions.find(
      (clientExtensionRenderer) => clientExtensionRenderer.externalReferenceCode === filter.fdsFilterClientExtensionERC
    ) : void 0
  );
  const fdsFilterLabelTranslations = filter?.label_i18n ?? {};
  const [i18nFilterLabels, setI18nFilterLabels] = (0, react_exports.useState)(
    fdsFilterLabelTranslations
  );
  const inUseFields = fields.map(
    (item) => fieldNames?.includes(item.name) ? item.name : void 0
  );
  const [selectedField, setSelectedField] = (0, react_exports.useState)(
    fields.find((item) => item.name === filter?.fieldName)
  );
  const fdsFilterClientExtensionFormElementId = `${namespace}fdsFilterClientExtensionERC`;
  const isi18nFilterLabelsValid = (i18nFilterLabels2) => {
    let isValid = true;
    if (!i18nFilterLabels2 || !Object.values(i18nFilterLabels2).length) {
      isValid = false;
    }
    Object.values(i18nFilterLabels2).forEach((value) => {
      if (!value) {
        isValid = false;
      }
    });
    return isValid;
  };
  const validate = () => {
    let isValid = true;
    if (Liferay.FeatureFlags["LPD-10754"]) {
      const isLabelValid = isi18nFilterLabelsValid(i18nFilterLabels);
      setLabelValidationError(!isLabelValid);
      isValid = isLabelValid;
    }
    if (!selectedField) {
      setFieldValidationError(true);
      isValid = false;
    }
    if (selectedField && !filter) {
      if (inUseFields.includes(selectedField?.name)) {
        setFieldInUseValidationError(true);
        isValid = false;
      }
    }
    if (!selectedClientExtension) {
      setClientExtensionValidationError(true);
      isValid = false;
    }
    return isValid;
  };
  const saveClientExtensionFilter = () => {
    setSaveButtonDisabled(true);
    const success = validate();
    if (success) {
      const formData = {
        fdsFilterClientExtensionERC: selectedClientExtension?.externalReferenceCode,
        fieldName: selectedField?.name,
        label_i18n: i18nFilterLabels
      };
      onSave(formData);
    } else {
      setSaveButtonDisabled(false);
    }
  };
  if (!fdsFilterClientExtensions.length) {
    return /* @__PURE__ */ react_default.createElement(alert_default, { displayType: "info", title: "Info" }, Liferay.Language.get(
      "no-frontend-data-set-filter-client-extensions-are-available.-add-a-client-extension-first-in-order-to-create-a-filter"
    ));
  }
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(
    Configuration_default,
    {
      fieldInUseValidationError,
      fieldNames,
      fieldValidationError,
      fields,
      filter,
      labelValidationError,
      namespace,
      onBlur: () => {
        setLabelValidationError(
          !isi18nFilterLabelsValid(i18nFilterLabels)
        );
      },
      onChangeField: (newValue) => {
        setSelectedField(newValue);
        setFieldValidationError(!newValue);
        setFieldInUseValidationError(
          newValue ? inUseFields.includes(newValue.name) : false
        );
      },
      onChangeLabel: (newValue) => {
        setI18nFilterLabels(newValue);
      }
    }
  ), !fieldInUseValidationError && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default("form-group-autofit", {
        "has-error": clientExtensionValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement("div", { className: classnames_default("form-group-item") }, /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: fdsFilterClientExtensionFormElementId
      },
      Liferay.Language.get("client-extension"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ), /* @__PURE__ */ react_default.createElement(
      drop_down_default,
      {
        closeOnClick: true,
        menuElementAttrs: {
          className: "fds-cell-renderers-dropdown-menu"
        },
        trigger: /* @__PURE__ */ react_default.createElement(
          button_default,
          {
            "aria-labelledby": `${namespace}cellRenderersLabel`,
            className: "form-control form-control-select form-control-select-secondary",
            displayType: "secondary",
            name: fdsFilterClientExtensionFormElementId
          },
          selectedClientExtension ? selectedClientExtension.name : Liferay.Language.get("select")
        )
      },
      /* @__PURE__ */ react_default.createElement(
        drop_down_default.ItemList,
        {
          items: fdsFilterClientExtensions,
          role: "listbox"
        },
        fdsFilterClientExtensions.map(
          (filterClientExtension) => /* @__PURE__ */ react_default.createElement(
            drop_down_default.Item,
            {
              className: "align-items-center d-flex justify-content-between",
              key: filterClientExtension.name,
              onClick: () => {
                setSelectedClientExtension(
                  filterClientExtension
                );
                setClientExtensionValidationError(
                  !filterClientExtension
                );
              },
              roleItem: "option"
            },
            filterClientExtension.name
          )
        )
      )
    ), clientExtensionValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null))
  )), /* @__PURE__ */ react_default.createElement(
    Footer_default,
    {
      closeModal,
      onSave: saveClientExtensionFilter,
      saveButtonDisabled
    }
  ));
}
var ClientExtensionFilter_default = {
  Body,
  Header
};

// ../../../../../../../../../$/bridge/for/main/@clayui/date-picker
var date_picker_exports = {};
__export(date_picker_exports, {
  default: () => date_picker_default
});
__reExport(date_picker_exports, clayui_date_picker_star);
import * as clayui_date_picker_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$date-picker.js";
import __default__21 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$date-picker.js";
var date_picker_default = __default__21;

// ../../../../../../../../../$/bridge/for/main/date-fns
var date_fns_exports = {};
__reExport(date_fns_exports, date_fns_star);
import * as date_fns_star from "../../frontend-js-dependencies-web/__liferay__/exports/date-fns.js";

// src/main/resources/META-INF/resources/js/data_set/filters/modals/DateRangeFilter.tsx
function Header2() {
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, Liferay.Language.get("new-date-range-filter"));
}
function Body2({
  closeModal,
  fieldNames,
  fields,
  filter,
  namespace,
  onSave
}) {
  const [fieldInUseValidationError, setFieldInUseValidationError] = (0, react_exports.useState)(false);
  const [fieldValidationError, setFieldValidationError] = (0, react_exports.useState)(false);
  const [labelValidationError, setLabelValidationError] = (0, react_exports.useState)(false);
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const fdsFilterLabelTranslations = filter?.label_i18n ?? {};
  const [i18nFilterLabels, setI18nFilterLabels] = (0, react_exports.useState)(
    fdsFilterLabelTranslations
  );
  const inUseFields = fields.map(
    (item) => fieldNames?.includes(item.name) ? item.name : void 0
  );
  const [selectedField, setSelectedField] = (0, react_exports.useState)(
    fields.find((item) => item.name === filter?.fieldName)
  );
  const [from, setFrom] = (0, react_exports.useState)(
    filter?.from ?? ""
  );
  const [to, setTo] = (0, react_exports.useState)(filter?.to ?? "");
  const [isValidDateRange, setIsValidDateRange] = (0, react_exports.useState)(true);
  const fromFormElementId = `${namespace}From`;
  const toFormElementId = `${namespace}To`;
  (0, react_exports.useEffect)(() => {
    let isValid = true;
    const dateTo = new Date(to);
    const dateFrom = new Date(from);
    if (to && from) {
      isValid = (0, date_fns_exports.isBefore)(dateFrom, dateTo) || (0, date_fns_exports.isEqual)(dateFrom, dateTo);
    }
    setIsValidDateRange(isValid);
  }, [from, to]);
  const isi18nFilterLabelsValid = (i18nFilterLabels2) => {
    let isValid = true;
    if (!i18nFilterLabels2 || !Object.values(i18nFilterLabels2).length) {
      isValid = false;
    }
    Object.values(i18nFilterLabels2).forEach((value) => {
      if (!value) {
        isValid = false;
      }
    });
    return isValid;
  };
  const validate = () => {
    let isValid = true;
    if (Liferay.FeatureFlags["LPD-10754"]) {
      const isLabelValid = isi18nFilterLabelsValid(i18nFilterLabels);
      setLabelValidationError(!isLabelValid);
      isValid = isLabelValid;
    }
    if (!selectedField) {
      setFieldValidationError(true);
      isValid = false;
    }
    if (selectedField && !filter) {
      if (inUseFields.includes(selectedField?.name)) {
        setFieldInUseValidationError(true);
        isValid = false;
      }
    }
    const dateTo = new Date(to);
    const dateFrom = new Date(from);
    if (to && from) {
      const isValidRange = (0, date_fns_exports.isBefore)(dateFrom, dateTo) || (0, date_fns_exports.isEqual)(dateFrom, dateTo);
      setIsValidDateRange(isValidRange);
      if (!isValidRange) {
        isValid = false;
      }
    }
    return isValid;
  };
  const saveDateRangeFilter = () => {
    setSaveButtonDisabled(true);
    const success = validate();
    if (success) {
      const formData = {
        fieldName: selectedField?.name,
        from,
        label_i18n: i18nFilterLabels,
        to,
        type: selectedField?.format
      };
      onSave(formData);
    } else {
      setSaveButtonDisabled(false);
    }
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(
    Configuration_default,
    {
      fieldInUseValidationError,
      fieldNames,
      fieldValidationError,
      fields,
      filter,
      labelValidationError,
      namespace,
      onBlur: () => {
        setLabelValidationError(
          !isi18nFilterLabelsValid(i18nFilterLabels)
        );
      },
      onChangeField: (newValue) => {
        setSelectedField(newValue);
        setFieldValidationError(!newValue);
        setFieldInUseValidationError(
          newValue ? inUseFields.includes(newValue.name) : false
        );
      },
      onChangeLabel: (newValue) => {
        setI18nFilterLabels(newValue);
      }
    }
  ), !fieldInUseValidationError && /* @__PURE__ */ react_default.createElement(form_default.Group, { className: "form-group-autofit" }, /* @__PURE__ */ react_default.createElement(
    "div",
    {
      className: classnames_default("form-group-item", {
        "has-error": !isValidDateRange
      })
    },
    /* @__PURE__ */ react_default.createElement("label", { htmlFor: fromFormElementId }, Liferay.Language.get("from")),
    /* @__PURE__ */ react_default.createElement(
      date_picker_default,
      {
        inputName: fromFormElementId,
        onChange: (value) => {
          setFrom(value);
        },
        placeholder: "YYYY-MM-DD",
        value: from ? (0, date_fns_exports.format)(new Date(from), "yyyy-MM-dd") : "",
        years: {
          end: (0, date_fns_exports.getYear)(/* @__PURE__ */ new Date()) + 25,
          start: (0, date_fns_exports.getYear)(/* @__PURE__ */ new Date()) - 50
        }
      }
    ),
    !isValidDateRange && /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), Liferay.Language.get(
      "date-range-is-invalid.-from-must-be-before-to"
    )))
  ), /* @__PURE__ */ react_default.createElement("div", { className: "form-group-item" }, /* @__PURE__ */ react_default.createElement("label", { htmlFor: toFormElementId }, Liferay.Language.get("to")), /* @__PURE__ */ react_default.createElement(
    date_picker_default,
    {
      inputName: toFormElementId,
      onChange: (value) => {
        setTo(value);
      },
      placeholder: "YYYY-MM-DD",
      value: to ? (0, date_fns_exports.format)(new Date(to), "yyyy-MM-dd") : "",
      years: {
        end: (0, date_fns_exports.getYear)(/* @__PURE__ */ new Date()) + 25,
        start: (0, date_fns_exports.getYear)(/* @__PURE__ */ new Date()) - 50
      }
    }
  )))), /* @__PURE__ */ react_default.createElement(
    Footer_default,
    {
      closeModal,
      onSave: saveDateRangeFilter,
      saveButtonDisabled
    }
  ));
}
var DateRangeFilter_default = {
  Body: Body2,
  Header: Header2
};

// ../../../../../../../../../$/bridge/for/main/@clayui/multi-select
var multi_select_exports = {};
__export(multi_select_exports, {
  default: () => multi_select_default
});
__reExport(multi_select_exports, clayui_multi_select_star);
import * as clayui_multi_select_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$multi-select.js";
import __default__22 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$multi-select.js";
var multi_select_default = __default__22;

// src/main/resources/META-INF/resources/js/components/CheckboxMultiSelect.tsx
var isChecked = (items, item) => {
  return !!items.find((val) => val.value === item.value);
};
function CheckboxMultiSelect({
  items,
  onItemsChange,
  sourceItems,
  value,
  ...otherProps
}) {
  const toggleItemChecked = (item) => {
    if (!isChecked(items, item)) {
      onItemsChange([
        ...items,
        sourceItems.find(
          (entry) => item.value === entry.value
        )
      ]);
    } else {
      onItemsChange(items.filter((entry) => item.value !== entry.value));
    }
  };
  return /* @__PURE__ */ react_default.createElement(
    multi_select_default,
    {
      allowsCustomLabel: false,
      items,
      onItemsChange,
      sourceItems,
      value,
      ...otherProps
    },
    (item) => /* @__PURE__ */ react_default.createElement(
      multi_select_default.Item,
      {
        key: item.value,
        onClick: (event) => {
          event.preventDefault();
          toggleItemChecked(item);
        },
        textValue: item.label
      },
      /* @__PURE__ */ react_default.createElement("div", { className: "autofit-row autofit-row-center" }, /* @__PURE__ */ react_default.createElement("div", { className: "autofit-col mr-3" }, /* @__PURE__ */ react_default.createElement(
        form_exports.ClayCheckbox,
        {
          "aria-label": item.label,
          checked: isChecked(items, item),
          className: "invisible",
          onClick: (event) => {
            event.stopPropagation();
            toggleItemChecked(item);
          }
        }
      )), /* @__PURE__ */ react_default.createElement("div", { className: "autofit-col" }, /* @__PURE__ */ react_default.createElement("span", null, item.label)))
    )
  );
}
var CheckboxMultiSelect_default = CheckboxMultiSelect;

// src/main/resources/META-INF/resources/js/utils/getAllPicklists.ts
async function getAllPicklists(page = 1, items = []) {
  const response = await (0, frontend_js_web_exports.fetch)(
    `/o/headless-admin-list-type/v1.0/list-type-definitions?pageSize=100&page=${page}`
  );
  if (!response.ok) {
    openDefaultFailureToast();
    return [];
  }
  const responseJSON = await response.json();
  items = [...items, ...responseJSON.items];
  if (responseJSON.lastPage > page) {
    items = await getAllPicklists(page + 1, items);
  }
  return items;
}

// src/main/resources/META-INF/resources/js/components/rest/RESTApplicationDropdownItem.tsx
function RESTApplicationDropdownItem({
  query,
  restApplication
}) {
  const fuzzyMatch = fuzzy_default.match(query, restApplication, FUZZY_OPTIONS);
  return /* @__PURE__ */ react_default.createElement(layout_default.ContentRow, null, fuzzyMatch ? /* @__PURE__ */ react_default.createElement(
    "span",
    {
      dangerouslySetInnerHTML: {
        __html: fuzzyMatch.rendered
      }
    }
  ) : /* @__PURE__ */ react_default.createElement("span", null, restApplication));
}

// src/main/resources/META-INF/resources/js/components/rest/RESTApplicationDropdownMenu.tsx
function RESTApplicationDropdownMenu({
  className,
  onItemClick,
  restApplications: initialRESTApplications
}) {
  const [restApplications, setRESTApplications] = (0, react_exports.useState)(
    initialRESTApplications || []
  );
  const [query, setQuery] = (0, react_exports.useState)("");
  const onSearch = (query2) => {
    setQuery(query2);
    const regexp = new RegExp(query2, "i");
    setRESTApplications(
      query2 ? initialRESTApplications.filter(
        (restApplication) => restApplication.match(regexp)
      ) || [] : initialRESTApplications
    );
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    drop_down_default.Search,
    {
      "aria-label": Liferay.Language.get("search"),
      className,
      onChange: onSearch,
      value: query
    }
  ), /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, { items: restApplications, role: "listbox" }, (item) => /* @__PURE__ */ react_default.createElement(
    drop_down_default.Item,
    {
      key: item,
      onClick: () => onItemClick(item),
      roleItem: "option"
    },
    /* @__PURE__ */ react_default.createElement(
      RESTApplicationDropdownItem,
      {
        query,
        restApplication: item
      }
    )
  )));
}

// src/main/resources/META-INF/resources/js/components/rest/RESTEndpointDropdownMenu.tsx
function RESTEndpointDropdownMenu({
  className,
  onItemClick,
  restEndpoints: initialRESTEndpoints
}) {
  const [restEndpoints, setRESTEndpoints] = (0, react_exports.useState)(
    initialRESTEndpoints || []
  );
  const [query, setQuery] = (0, react_exports.useState)("");
  const onSearch = (query2) => {
    setQuery(query2);
    const regexp = new RegExp(query2, "i");
    setRESTEndpoints(
      query2 ? initialRESTEndpoints.filter((restEndpoint) => {
        return restEndpoint.match(regexp);
      }) || [] : initialRESTEndpoints
    );
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    drop_down_default.Search,
    {
      "aria-label": Liferay.Language.get("search"),
      className,
      onChange: onSearch,
      value: query
    }
  ), /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, { items: restEndpoints, role: "listbox" }, (item) => {
    const fuzzymatch = fuzzy_default.match(query, item, FUZZY_OPTIONS);
    return /* @__PURE__ */ react_default.createElement(
      drop_down_default.Item,
      {
        key: item,
        onClick: () => onItemClick(item),
        roleItem: "option"
      },
      fuzzymatch ? /* @__PURE__ */ react_default.createElement(
        "span",
        {
          dangerouslySetInnerHTML: {
            __html: fuzzymatch.rendered
          }
        }
      ) : item
    );
  }));
}

// src/main/resources/META-INF/resources/js/components/rest/RESTSchemaDropdownMenu.tsx
function RESTSchemaDropdownMenu({
  onItemClick,
  restSchemas: initialRESTSchemas
}) {
  const [restSchemas, setRESTSchemas] = (0, react_exports.useState)(initialRESTSchemas);
  const [query, setQuery] = (0, react_exports.useState)("");
  const onSearch = (query2) => {
    setQuery(query2);
    const regexp = new RegExp(query2, "i");
    setRESTSchemas(
      query2 ? initialRESTSchemas.filter((restSchema) => {
        return restSchema.match(regexp);
      }) || [] : initialRESTSchemas
    );
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    drop_down_default.Search,
    {
      "aria-label": Liferay.Language.get("search"),
      onChange: onSearch,
      value: query
    }
  ), /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, { items: restSchemas, role: "listbox" }, (item) => {
    const fuzzymatch = fuzzy_default.match(query, item, FUZZY_OPTIONS);
    return /* @__PURE__ */ react_default.createElement(
      drop_down_default.Item,
      {
        key: item,
        onClick: () => onItemClick(item),
        roleItem: "option"
      },
      fuzzymatch ? /* @__PURE__ */ react_default.createElement(
        "span",
        {
          dangerouslySetInnerHTML: {
            __html: fuzzymatch.rendered
          }
        }
      ) : item
    );
  }));
}

// src/main/resources/META-INF/resources/js/data_set/filters/modals/selection_filter/source_type/ApiRestApplication.tsx
function ApiRestApplication({
  filter,
  itemKeyValidationError,
  itemLabelValidationError,
  namespace,
  onChange,
  requiredRESTApplicationValidationError,
  restApplications,
  restEndpointValidationError,
  restSchemaValidationError
}) {
  const [fields, setFields] = (0, react_exports.useState)([]);
  const [selectedItemKey, setSelectedItemKey] = (0, react_exports.useState)(
    filter?.itemKey ? filter.itemKey : ""
  );
  const [selectedItemLabel, setSelectedItemLabel] = (0, react_exports.useState)(
    filter?.itemLabel ? filter.itemLabel : ""
  );
  const [
    noEnpointsRESTApplicationValidationError,
    setNoEnpointsRESTApplicationValidationError
  ] = (0, react_exports.useState)(false);
  const [restSchemaEndpoints, setRESTSchemaEndpoints] = (0, react_exports.useState)(/* @__PURE__ */ new Map());
  const [selectedRESTApplication, setSelectedRESTApplication] = (0, react_exports.useState)(filter?.restApplication ? filter.restApplication : null);
  const [selectedRESTSchema, setSelectedRESTSchema] = (0, react_exports.useState)(
    filter?.restSchema ? filter.restSchema : null
  );
  const [selectedRESTEndpoint, setSelectedRESTEndpoint] = (0, react_exports.useState)(filter?.restEndpoint ? filter.restEndpoint : null);
  const isPathValid = (path, allowedParameters) => {
    const paramsMatcher = RegExp("{(.*?)}", "g");
    let matches;
    while ((matches = paramsMatcher.exec(path)) !== null) {
      if (!allowedParameters.includes(matches[1])) {
        return false;
      }
    }
    return true;
  };
  const getRESTSchemas = async (restApplication) => {
    if (!restApplication) {
      return;
    }
    const response = await (0, frontend_js_web_exports.fetch)(`/o${restApplication}/openapi.json`);
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJson = await response.json();
    const paths = Object.keys(responseJson.paths ?? []);
    const schemaNames = Object.keys(responseJson.components?.schemas ?? []);
    const schemaEndpoints = /* @__PURE__ */ new Map();
    schemaNames.forEach((schemaName) => {
      paths.forEach((path) => {
        if (!isPathValid(path, ALLOWED_ENDPOINTS_PARAMETERS)) {
          return;
        }
        if (responseJson.paths[path]?.get?.responses.default.content["application/json"]?.schema?.$ref?.endsWith(`/Page${schemaName}`)) {
          const endpoints = schemaEndpoints.get(schemaName) ?? [];
          endpoints.push(path);
          if (endpoints.length === 1) {
            schemaEndpoints.set(schemaName, endpoints);
          }
        }
      });
    });
    if (schemaEndpoints.size === 0) {
      setSelectedRESTSchema(null);
      setSelectedRESTEndpoint(null);
      setNoEnpointsRESTApplicationValidationError(true);
      onChange({
        selectedItemKey,
        selectedItemLabel,
        selectedRESTApplication: restApplication,
        selectedRESTEndpoint: null,
        selectedRESTSchema: null
      });
    } else if (schemaEndpoints.size === 1) {
      const schema = schemaEndpoints.keys().next().value;
      setSelectedRESTSchema(schema);
      const paths2 = schemaEndpoints.get(schema);
      if (paths2?.length === 1) {
        setSelectedRESTEndpoint(paths2[0]);
      }
      setNoEnpointsRESTApplicationValidationError(false);
      onChange({
        selectedItemKey,
        selectedItemLabel,
        selectedRESTApplication: restApplication,
        selectedRESTEndpoint: paths2?.length === 1 ? paths2[0] : selectedRESTEndpoint,
        selectedRESTSchema: schema
      });
    } else {
      setSelectedRESTSchema(null);
      setSelectedRESTEndpoint(null);
      setNoEnpointsRESTApplicationValidationError(false);
      onChange({
        selectedItemKey,
        selectedItemLabel,
        selectedRESTApplication: restApplication,
        selectedRESTEndpoint: null,
        selectedRESTSchema: null
      });
    }
    setRESTSchemaEndpoints(schemaEndpoints);
  };
  const RestApplicationDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu fds-filter-rest-application-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restApplicationsLabel`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restApplicationsSelect`
        },
        selectedRESTApplication ? /* @__PURE__ */ react_default.createElement(
          RESTApplicationDropdownItem,
          {
            query: "",
            restApplication: selectedRESTApplication
          }
        ) : Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTApplicationDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTApplication(item);
          getRESTSchemas(item);
          onChange({
            selectedItemKey,
            selectedItemLabel,
            selectedRESTApplication: item,
            selectedRESTEndpoint,
            selectedRESTSchema
          });
        },
        restApplications
      }
    )
  );
  const RestSchemaDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu fds-filter-rest-schema-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restSchema`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restSchemaSelect`
        },
        selectedRESTSchema || Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTSchemaDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTSchema(item);
          const endpoints = restSchemaEndpoints.get(item);
          let endpoint;
          if (endpoints?.length === 1) {
            endpoint = endpoints[0];
            setSelectedRESTEndpoint(endpoint);
          } else {
            endpoint = null;
          }
          onChange({
            selectedItemKey,
            selectedItemLabel,
            selectedRESTApplication,
            selectedRESTEndpoint: endpoints?.length === 1 ? endpoint : selectedRESTEndpoint,
            selectedRESTSchema: item
          });
        },
        restSchemas: Array.from(restSchemaEndpoints.keys())
      }
    )
  );
  const RestEndpointDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu fds-filter-rest-endpoint-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restEndpoint`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restEndpointSelect`
        },
        selectedRESTEndpoint || Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTEndpointDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTEndpoint(item);
          onChange({
            selectedItemKey,
            selectedItemLabel,
            selectedRESTApplication,
            selectedRESTEndpoint: item,
            selectedRESTSchema
          });
        },
        restEndpoints: restSchemaEndpoints.get(selectedRESTSchema ?? "") ?? []
      }
    )
  );
  (0, react_exports.useEffect)(() => {
    if (selectedRESTApplication && selectedRESTSchema) {
      getFields({
        restApplication: selectedRESTApplication,
        restSchema: selectedRESTSchema
      }).then((fields2) => {
        if (fields2) {
          setFields(
            fields2.filter(
              (field) => field.type !== "array" && field.type !== "object"
            )
          );
        }
      });
    }
  }, [selectedRESTApplication, selectedRESTSchema]);
  const ItemKeyDropdownMenu = ({
    itemKeys: initialItemKeys,
    onItemClick
  }) => {
    const [itemKeys, setItemKeys] = (0, react_exports.useState)(initialItemKeys);
    const [query, setQuery] = (0, react_exports.useState)("");
    const onSearch = (query2) => {
      setQuery(query2);
      const regexp = new RegExp(query2, "i");
      setItemKeys(
        query2 ? initialItemKeys.filter((itemKey) => {
          return itemKey?.match(regexp);
        }) || [] : initialItemKeys
      );
    };
    return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
      drop_down_default.Search,
      {
        "aria-label": Liferay.Language.get("search"),
        onChange: onSearch,
        value: query
      }
    ), /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, { items: itemKeys, role: "listbox" }, (item) => {
      const fuzzymatch = fuzzy_default.match(
        query,
        item,
        FUZZY_OPTIONS
      );
      return /* @__PURE__ */ react_default.createElement(
        drop_down_default.Item,
        {
          key: item,
          onClick: () => onItemClick(item),
          roleItem: "option"
        },
        fuzzymatch ? /* @__PURE__ */ react_default.createElement(
          "span",
          {
            dangerouslySetInnerHTML: {
              __html: fuzzymatch.rendered
            }
          }
        ) : item
      );
    }));
  };
  const ItemLabelDropdownMenu = ({
    itemLabels: initialItemLabels = [],
    onItemClick
  }) => {
    const [itemLabels, setItemLabels] = (0, react_exports.useState)(initialItemLabels);
    const [query, setQuery] = (0, react_exports.useState)("");
    const onSearch = (query2) => {
      setQuery(query2);
      const regexp = new RegExp(query2, "i");
      setItemLabels(
        query2 ? initialItemLabels.filter((itemLabel) => {
          return itemLabel?.match(regexp);
        }) || [] : initialItemLabels
      );
    };
    return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
      drop_down_default.Search,
      {
        "aria-label": Liferay.Language.get("search"),
        onChange: onSearch,
        value: query
      }
    ), /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, { items: itemLabels, role: "listbox" }, (item) => {
      const fuzzymatch = fuzzy_default.match(
        query,
        item,
        FUZZY_OPTIONS
      );
      return /* @__PURE__ */ react_default.createElement(
        drop_down_default.Item,
        {
          key: item,
          onClick: () => onItemClick(item),
          roleItem: "option"
        },
        fuzzymatch ? /* @__PURE__ */ react_default.createElement(
          "span",
          {
            dangerouslySetInnerHTML: {
              __html: fuzzymatch.rendered
            }
          }
        ) : item
      );
    }));
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, restApplications && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": requiredRESTApplicationValidationError || noEnpointsRESTApplicationValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restApplicationsSelect`,
        id: `${namespace}restApplicationsLabel`
      },
      Liferay.Language.get("rest-application"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestApplicationDropdown, null),
    requiredRESTApplicationValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null),
    noEnpointsRESTApplicationValidationError && /* @__PURE__ */ react_default.createElement(
      ValidationFeedback_default,
      {
        message: Liferay.Language.get(
          "there-are-no-usable-endpoints"
        )
      }
    )
  ), restSchemaEndpoints.size > 0 && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": restSchemaValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restSchemaSelect`,
        id: `${namespace}restSchema`
      },
      Liferay.Language.get("rest-schema"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestSchemaDropdown, null),
    restSchemaValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  ), selectedRESTSchema && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": restEndpointValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restEndpointSelect`,
        id: `${namespace}restEndpoint`
      },
      Liferay.Language.get("rest-endpoint"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestEndpointDropdown, null),
    restEndpointValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  ), selectedRESTSchema && /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default("form-group-autofit", {
        "has-error": itemKeyValidationError || itemLabelValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement("div", { className: "form-group-item" }, /* @__PURE__ */ react_default.createElement("label", null, Liferay.Language.get("item-key"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
      drop_down_default,
      {
        className: "fds-filter-item-key",
        menuElementAttrs: {
          className: "fds-entries-dropdown-menu"
        },
        trigger: /* @__PURE__ */ react_default.createElement(
          button_default,
          {
            className: "form-control form-control-select form-control-select-secondary",
            displayType: "secondary"
          },
          selectedItemKey ? /* @__PURE__ */ react_default.createElement(
            RESTApplicationDropdownItem,
            {
              query: "",
              restApplication: selectedItemKey
            }
          ) : Liferay.Language.get(
            "choose-an-option"
          )
        )
      },
      /* @__PURE__ */ react_default.createElement(
        ItemKeyDropdownMenu,
        {
          itemKeys: fields.map((field) => field.name),
          onItemClick: (item) => {
            setSelectedItemKey(item);
            onChange({
              selectedItemKey: item,
              selectedItemLabel,
              selectedRESTApplication,
              selectedRESTEndpoint,
              selectedRESTSchema
            });
          }
        }
      )
    ), itemKeyValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)),
    /* @__PURE__ */ react_default.createElement("div", { className: "form-group-item" }, /* @__PURE__ */ react_default.createElement("label", null, Liferay.Language.get("item-label"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
      drop_down_default,
      {
        className: "fds-filter-item-label",
        menuElementAttrs: {
          className: "fds-entries-dropdown-menu"
        },
        trigger: /* @__PURE__ */ react_default.createElement(
          button_default,
          {
            className: "form-control form-control-select form-control-select-secondary",
            displayType: "secondary"
          },
          selectedItemLabel ? /* @__PURE__ */ react_default.createElement(
            RESTApplicationDropdownItem,
            {
              query: "",
              restApplication: selectedItemLabel
            }
          ) : Liferay.Language.get(
            "choose-an-option"
          )
        )
      },
      /* @__PURE__ */ react_default.createElement(
        ItemLabelDropdownMenu,
        {
          itemLabels: fields.map(
            (field) => field.label
          ),
          onItemClick: (item) => {
            setSelectedItemLabel(item);
            onChange({
              selectedItemKey,
              selectedItemLabel: item,
              selectedRESTApplication,
              selectedRESTEndpoint,
              selectedRESTSchema
            });
          }
        }
      )
    ), itemLabelValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null))
  )));
}
var ApiRestApplication_default = ApiRestApplication;

// src/main/resources/META-INF/resources/js/data_set/filters/modals/selection_filter/source_type/ObjectPicklist.tsx
function ObjectPicklist({
  filter,
  namespace,
  onChange,
  sourceValidationError
}) {
  const [picklists, setPicklists] = (0, react_exports.useState)();
  const [selectedPicklist, setSelectedPicklist] = (0, react_exports.useState)();
  const objectPicklistFormElementId = `${namespace}ObjectPicklist`;
  (0, react_exports.useEffect)(() => {
    getAllPicklists().then((items) => {
      setPicklists(items);
    });
  }, []);
  (0, react_exports.useEffect)(() => {
    const picklist = picklists?.find(
      (item) => Liferay.FeatureFlags["LPD-10754"] ? String(item.externalReferenceCode) === filter?.source : String(item.externalReferenceCode) === filter?.listTypeDefinitionERC
    );
    if (picklist) {
      setSelectedPicklist(picklist);
    }
  }, [filter, picklists]);
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, picklists && !picklists.length ? /* @__PURE__ */ react_default.createElement(alert_default, { displayType: "info", title: "Info" }, Liferay.Language.get(
    "no-filter-sources-are-available.-create-a-picklist-or-a-vocabulary-for-this-type-of-filter"
  )) : /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": sourceValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement("label", { htmlFor: objectPicklistFormElementId }, Liferay.Language.get("picklist"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)),
    picklists && /* @__PURE__ */ react_default.createElement(
      form_exports.ClaySelectWithOption,
      {
        "aria-label": Liferay.Language.get("picklist"),
        name: objectPicklistFormElementId,
        onChange: (event) => {
          const picklist = picklists?.find(
            (item) => String(item.externalReferenceCode) === event.target.value
          );
          setSelectedPicklist(picklist);
          onChange(picklist);
        },
        options: [
          {
            disabled: true,
            label: Liferay.Language.get(
              "choose-an-option"
            ),
            value: ""
          },
          ...picklists.map((item) => ({
            label: item.name,
            value: item.externalReferenceCode
          }))
        ],
        required: true,
        title: Liferay.Language.get("source-options"),
        value: selectedPicklist?.externalReferenceCode || ""
      }
    ),
    sourceValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  ));
}
var ObjectPicklist_default = ObjectPicklist;

// src/main/resources/META-INF/resources/js/data_set/filters/modals/selection_filter/SelectionFilter.tsx
function Header3() {
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, Liferay.Language.get("new-selection-filter"));
}
function Body3({
  closeModal,
  fieldNames,
  fields,
  filter,
  namespace,
  onSave,
  restApplications
}) {
  const [fieldInUseValidationError, setFieldInUseValidationError] = (0, react_exports.useState)(false);
  const [fieldValidationError, setFieldValidationError] = (0, react_exports.useState)(false);
  const [labelValidationError, setLabelValidationError] = (0, react_exports.useState)(false);
  const [sourceValidationError, setSourceValidationError] = (0, react_exports.useState)(false);
  const [sourceTypeValidationError, setSourceTypeValidationError] = (0, react_exports.useState)(false);
  const [
    requiredRESTApplicationValidationError,
    setRequiredRESTApplicationValidationError
  ] = (0, react_exports.useState)(false);
  const [restSchemaValidationError, setRESTSchemaValidationError] = (0, react_exports.useState)(false);
  const [restEndpointValidationError, setRESTEndpointValidationError] = (0, react_exports.useState)(false);
  const [filteredSourceItems, setFilteredSourceItems] = (0, react_exports.useState)([]);
  const [preselectedValueInput, setPreselectedValueInput] = (0, react_exports.useState)("");
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [includeMode, setIncludeMode] = (0, react_exports.useState)("include");
  const inUseFields = fields.map(
    (item) => fieldNames?.includes(item.name) ? item.name : void 0
  );
  const [multiple, setMultiple] = (0, react_exports.useState)(
    filter?.multiple ?? true
  );
  const [picklists, setPicklists] = (0, react_exports.useState)([]);
  const [preselectedValues, setPreselectedValues] = (0, react_exports.useState)([]);
  const [selectedField, setSelectedField] = (0, react_exports.useState)(
    fields.find((item) => item.name === filter?.fieldName)
  );
  const [source, setSource] = (0, react_exports.useState)();
  const [sourceType, setSourceType] = (0, react_exports.useState)();
  const fdsFilterLabelTranslations = filter?.label_i18n ?? {};
  const [i18nFilterLabels, setI18nFilterLabels] = (0, react_exports.useState)(
    fdsFilterLabelTranslations
  );
  const [selectedRESTApplication, setSelectedRESTApplication] = (0, react_exports.useState)("");
  const [selectedRESTSchema, setSelectedRESTSchema] = (0, react_exports.useState)(
    ""
  );
  const [selectedRESTEndpoint, setSelectedRESTEndpoint] = (0, react_exports.useState)("");
  const [selectedItemKey, setSelectedItemKey] = (0, react_exports.useState)("");
  const [selectedItemLabel, setSelectedItemLabel] = (0, react_exports.useState)("");
  const [itemKeyValidationError, setItemKeyValidationError] = (0, react_exports.useState)(false);
  const [itemLabelValidationError, setItemLabelValidationError] = (0, react_exports.useState)(false);
  const includeModeFormElementId = `${namespace}IncludeMode`;
  const multipleFormElementId = `${namespace}Multiple`;
  const sourceOptionFormElementId = `${namespace}SourceOption`;
  const preselectedValuesFormElementId = `${namespace}PreselectedValues`;
  const isValidSingleMode = multiple || !multiple && !(preselectedValues.length > 1);
  async function getAPIValues(source2) {
    const response = await (0, frontend_js_web_exports.fetch)(`/o${source2}`);
    if (!response.ok) {
      openDefaultFailureToast();
      return [];
    }
    const responseJSON = await response.json();
    return responseJSON;
  }
  const isi18nFilterLabelsValid = (i18nFilterLabels2) => {
    let isValid = true;
    if (!i18nFilterLabels2 || !Object.values(i18nFilterLabels2).length) {
      isValid = false;
    }
    Object.values(i18nFilterLabels2).forEach((value) => {
      if (!value) {
        isValid = false;
      }
    });
    return isValid;
  };
  const validate = () => {
    let isValid = true;
    if (Liferay.FeatureFlags["LPD-10754"]) {
      const isLabelValid = isi18nFilterLabelsValid(i18nFilterLabels);
      setLabelValidationError(!isLabelValid);
      isValid = isLabelValid;
    }
    if (!selectedField) {
      setFieldValidationError(true);
      isValid = false;
    }
    if (selectedField && !filter) {
      if (inUseFields.includes(selectedField?.name)) {
        setFieldInUseValidationError(true);
        isValid = false;
      }
    }
    if (Liferay.FeatureFlags["LPD-10754"] && !sourceType) {
      setSourceTypeValidationError(true);
      isValid = false;
    }
    if (Liferay.FeatureFlags["LPD-10754"] && !source) {
      setSourceValidationError(true);
      isValid = false;
    }
    if (Liferay.FeatureFlags["LPD-10754"] && sourceType && sourceType === "API_HEADLESS" /* API_HEADLESS */) {
      if (!selectedItemKey) {
        setItemKeyValidationError(true);
        isValid = false;
      }
      if (!selectedItemLabel) {
        setItemLabelValidationError(true);
        isValid = false;
      }
      if (!selectedRESTApplication) {
        setRequiredRESTApplicationValidationError(true);
        isValid = false;
      }
      if (!selectedRESTSchema) {
        setRESTSchemaValidationError(true);
        isValid = false;
      }
      if (!selectedRESTEndpoint) {
        setRESTEndpointValidationError(true);
        isValid = false;
      }
    }
    return isValid;
  };
  const saveSelectionFilter = () => {
    setSaveButtonDisabled(true);
    const success = validate();
    if (success) {
      let formData = {
        fieldName: selectedField?.name,
        label_i18n: i18nFilterLabels
      };
      if (Liferay.FeatureFlags["LPD-10754"]) {
        if (sourceType === "API_HEADLESS" /* API_HEADLESS */) {
          formData = {
            ...formData,
            itemKey: selectedItemKey,
            itemLabel: selectedItemLabel,
            preselectedValues: JSON.stringify(
              preselectedValues.map((item) => item.value)
            ),
            restApplication: selectedRESTApplication,
            restEndpoint: selectedRESTEndpoint,
            restSchema: selectedRESTSchema,
            source,
            sourceType
          };
        }
        if (sourceType === "PICKLIST" /* PICKLIST */) {
          formData = {
            ...formData,
            preselectedValues: JSON.stringify(
              preselectedValues.map(
                (item) => item.externalReferenceCode
              )
            ),
            source: source?.externalReferenceCode,
            sourceType
          };
        }
      } else {
        formData = {
          ...formData,
          listTypeDefinitionERC: source?.externalReferenceCode
        };
      }
      formData = {
        ...formData,
        include: includeMode === "include",
        multiple
      };
      onSave(formData);
    } else {
      setSaveButtonDisabled(false);
    }
  };
  (0, react_exports.useEffect)(() => {
    if (source && sourceType === "API_HEADLESS" /* API_HEADLESS */) {
      getAPIValues(source).then((apiValues) => {
        setFilteredSourceItems(
          !apiValues.items.length ? [] : apiValues.items.filter(
            (item) => fuzzy_default.match(
              preselectedValueInput,
              item[selectedItemLabel]
            )
          ).map((item) => {
            return {
              label: item[selectedItemLabel],
              value: item[selectedItemKey]
            };
          })
        );
      });
    }
  }, [
    preselectedValueInput,
    selectedItemKey,
    selectedItemLabel,
    source,
    sourceType
  ]);
  (0, react_exports.useEffect)(() => {
    if (filter?.sourceType === "PICKLIST" /* PICKLIST */) {
      getAllPicklists().then((items) => {
        setPicklists(items);
        const picklist = items.find(
          (item) => Liferay.FeatureFlags["LPD-10754"] ? String(item.externalReferenceCode) === filter?.source : String(item.externalReferenceCode) === filter?.listTypeDefinitionERC
        );
        if (picklist) {
          setSource(picklist);
        }
      });
    }
  }, [filter]);
  (0, react_exports.useEffect)(() => {
    if (filter) {
      const selectionFilter = filter;
      if (selectionFilter.sourceType === "API_HEADLESS" /* API_HEADLESS */) {
        setSelectedRESTApplication(selectionFilter.restApplication);
        setSelectedRESTSchema(selectionFilter.restSchema);
        setSelectedRESTEndpoint(selectionFilter.restEndpoint);
        setSelectedItemKey(selectionFilter.itemKey);
        setSelectedItemLabel(selectionFilter.itemLabel);
        setSource(selectionFilter.source);
      }
    }
  }, [filter]);
  (0, react_exports.useEffect)(() => {
    if (filter) {
      const selectionFilter = filter;
      setSourceType(selectionFilter.sourceType);
      let validSavedPreselectedValues = [];
      if (source && sourceType === "API_HEADLESS" /* API_HEADLESS */) {
        validSavedPreselectedValues = filteredSourceItems.filter(
          (item) => JSON.parse(
            filter.preselectedValues || "[]"
          ).includes(item.value)
        );
      }
      if (source && sourceType === "PICKLIST" /* PICKLIST */) {
        validSavedPreselectedValues = source.listTypeEntries.filter(
          (item) => JSON.parse(
            filter.preselectedValues || "[]"
          ).includes(item.externalReferenceCode)
        );
      }
      setPreselectedValues(validSavedPreselectedValues);
      setIncludeMode(
        validSavedPreselectedValues?.length ? filter && filter.include ? "include" : "exclude" : "include"
      );
    }
  }, [filter, filteredSourceItems, source, sourceType]);
  (0, react_exports.useEffect)(() => {
    if (sourceType === "PICKLIST" /* PICKLIST */) {
      setFilteredSourceItems(
        !source ? [] : source.listTypeEntries.filter(
          (item) => fuzzy_default.match(preselectedValueInput, item.name)
        ).map((item) => ({
          label: item.name,
          value: String(item.externalReferenceCode)
        }))
      );
    }
  }, [preselectedValueInput, source, sourceType]);
  if (!Liferay.FeatureFlags["LPD-10754"] && sourceType === "API_HEADLESS" /* API_HEADLESS */ && !picklists.length) {
    return /* @__PURE__ */ react_default.createElement(alert_default, { displayType: "info", title: "Info" }, Liferay.Language.get(
      "no-filter-sources-are-available.-create-a-picklist-or-a-vocabulary-for-this-type-of-filter"
    ));
  }
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(
    Configuration_default,
    {
      fieldInUseValidationError,
      fieldNames,
      fieldValidationError,
      fields,
      filter,
      labelValidationError,
      namespace,
      onBlur: () => {
        setLabelValidationError(
          !isi18nFilterLabelsValid(i18nFilterLabels)
        );
      },
      onChangeField: (newValue) => {
        setSelectedField(newValue);
        setFieldValidationError(!newValue);
        setFieldInUseValidationError(
          newValue ? inUseFields.includes(newValue.name) : false
        );
      },
      onChangeLabel: (newValue) => {
        setI18nFilterLabels(newValue);
      }
    }
  ), !fieldInUseValidationError && /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, Liferay.FeatureFlags["LPD-10754"] && /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, { className: "mb-4" }, /* @__PURE__ */ react_default.createElement("h3", { className: "sheet-subtitle" }, Liferay.Language.get("filter-source")), /* @__PURE__ */ react_default.createElement(form_default.Text, null, Liferay.Language.get(
    "the-filter-source-determines-the-values-to-be-offered-in-this-filter-to-the-user"
  ))), /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": sourceTypeValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement("label", { htmlFor: sourceOptionFormElementId }, Liferay.Language.get("source"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClaySelectWithOption,
      {
        "aria-label": Liferay.Language.get(
          "choose-an-option"
        ),
        name: sourceOptionFormElementId,
        onChange: (event) => {
          const newSourceType = event.target.value;
          setSourceType(newSourceType);
          setSourceTypeValidationError(false);
          setSource(void 0);
          setPreselectedValueInput("");
          setPreselectedValues([]);
        },
        options: [
          {
            disabled: true,
            label: Liferay.Language.get(
              "choose-an-option"
            ),
            value: ""
          },
          {
            disabled: false,
            label: Liferay.Language.get(
              "api-rest-application"
            ),
            value: "API_HEADLESS" /* API_HEADLESS */
          },
          {
            disabled: false,
            label: Liferay.Language.get(
              "object-picklist"
            ),
            value: "PICKLIST" /* PICKLIST */
          }
        ],
        required: true,
        title: Liferay.Language.get("source"),
        value: sourceType || ""
      }
    ),
    sourceTypeValidationError && /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), Liferay.Language.get(
      "this-field-is-required"
    )))
  )), Liferay.FeatureFlags["LPD-10754"] ? /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, sourceType && sourceType === "PICKLIST" /* PICKLIST */ && /* @__PURE__ */ react_default.createElement(
    ObjectPicklist_default,
    {
      filter,
      namespace,
      onChange: (item) => {
        setSource(item);
        setSourceValidationError(false);
      },
      sourceValidationError
    }
  ), sourceType && sourceType === "API_HEADLESS" /* API_HEADLESS */ && /* @__PURE__ */ react_default.createElement(
    ApiRestApplication_default,
    {
      filter,
      itemKeyValidationError,
      itemLabelValidationError,
      namespace,
      onChange: ({
        selectedItemKey: selectedItemKey2,
        selectedItemLabel: selectedItemLabel2,
        selectedRESTApplication: selectedRESTApplication2,
        selectedRESTEndpoint: selectedRESTEndpoint2,
        selectedRESTSchema: selectedRESTSchema2
      }) => {
        let apiSource;
        if (selectedRESTApplication2 && selectedRESTEndpoint2) {
          apiSource = `${selectedRESTApplication2}${selectedRESTEndpoint2}`;
          setSource(apiSource);
          setSourceValidationError(
            false
          );
        }
        setSelectedRESTApplication(
          selectedRESTApplication2
        );
        setRequiredRESTApplicationValidationError(
          !selectedRESTApplication2
        );
        setSelectedRESTEndpoint(
          selectedRESTEndpoint2
        );
        setRESTEndpointValidationError(
          !selectedRESTEndpoint2
        );
        setSelectedRESTSchema(
          selectedRESTSchema2
        );
        setRESTSchemaValidationError(
          !selectedRESTSchema2
        );
        setSelectedItemKey(
          selectedItemKey2
        );
        setItemKeyValidationError(
          false
        );
        setSelectedItemLabel(
          selectedItemLabel2
        );
        setItemLabelValidationError(
          false
        );
      },
      requiredRESTApplicationValidationError,
      restApplications,
      restEndpointValidationError,
      restSchemaValidationError
    }
  ), source && /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, { className: "mb-4" }, /* @__PURE__ */ react_default.createElement("h3", { className: "sheet-subtitle" }, Liferay.Language.get(
    "filter-options"
  ))), /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": !isValidSingleMode
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: preselectedValuesFormElementId
      },
      Liferay.Language.get(
        "preselected-values"
      ),
      /* @__PURE__ */ react_default.createElement(
        "span",
        {
          className: "label-icon lfr-portal-tooltip ml-2",
          title: Liferay.Language.get(
            "choose-values-to-preselect-for-your-filters-source-option"
          )
        },
        /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
      )
    ),
    /* @__PURE__ */ react_default.createElement(
      CheckboxMultiSelect_default,
      {
        allowsCustomLabel: false,
        "aria-label": Liferay.Language.get(
          "preselected-values"
        ),
        inputName: preselectedValuesFormElementId,
        items: preselectedValues.map(
          (item) => {
            let valueItem;
            if (sourceType === "PICKLIST" /* PICKLIST */) {
              valueItem = {
                label: item.name,
                value: String(
                  item.externalReferenceCode
                )
              };
            }
            if (sourceType === "API_HEADLESS" /* API_HEADLESS */) {
              valueItem = {
                label: item[selectedItemLabel],
                value: item[selectedItemKey]
              };
            }
            return valueItem;
          }
        ),
        loadingState: 4,
        onChange: setPreselectedValueInput,
        onItemsChange: (selectedItems) => {
          let preselectedValues2;
          if (sourceType === "API_HEADLESS" /* API_HEADLESS */) {
            preselectedValues2 = selectedItems.map(
              ({
                value
              }) => {
                return filteredSourceItems.find(
                  (item) => String(
                    item.value
                  ) === String(
                    value
                  )
                );
              }
            );
          }
          if (sourceType === "PICKLIST" /* PICKLIST */) {
            preselectedValues2 = selectedItems.map(
              ({
                value
              }) => {
                return source.listTypeEntries.find(
                  (item) => String(
                    item.externalReferenceCode
                  ) === String(
                    value
                  )
                );
              }
            );
          }
          setPreselectedValues(
            preselectedValues2
          );
          setIncludeMode(
            preselectedValues2.length ? filter && filter.include ? "include" : "exclude" : "include"
          );
        },
        placeholder: Liferay.Language.get(
          "select-a-default-value-for-your-filter"
        ),
        sourceItems: filteredSourceItems,
        value: preselectedValueInput
      }
    ),
    !isValidSingleMode && /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), Liferay.Language.get(
      "only-one-value-is-allowed-in-single-selection-mode"
    )))
  ), /* @__PURE__ */ react_default.createElement(layout_default.Row, { justify: "start" }, /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 6 }, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    "label",
    {
      htmlFor: multipleFormElementId
    },
    Liferay.Language.get(
      "selection"
    ),
    /* @__PURE__ */ react_default.createElement(
      "span",
      {
        className: "label-icon lfr-portal-tooltip ml-2",
        title: Liferay.Language.get(
          "determines-how-many-preselected-values-for-the-filter-can-be-added"
        )
      },
      /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
    )
  ), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayRadioGroup,
    {
      name: multipleFormElementId,
      onChange: (newVal) => {
        const newMultiple = newVal === "true";
        setMultiple(
          newMultiple
        );
      },
      value: multiple ? "true" : "false"
    },
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayRadio,
      {
        label: Liferay.Language.get(
          "multiple"
        ),
        value: "true"
      }
    ),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayRadio,
      {
        label: Liferay.Language.get(
          "single"
        ),
        value: "false"
      }
    )
  ))), preselectedValues?.length > 0 && /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 6 }, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    "label",
    {
      htmlFor: includeModeFormElementId
    },
    Liferay.Language.get(
      "filter-mode"
    ),
    /* @__PURE__ */ react_default.createElement(
      "span",
      {
        className: "label-icon lfr-portal-tooltip ml-2",
        title: Liferay.Language.get(
          "include-returns-only-the-selected-values.-exclude-returns-all-except-the-selected-ones"
        )
      },
      /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
    )
  ), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayRadioGroup,
    {
      name: includeModeFormElementId,
      onChange: (val) => {
        setIncludeMode(
          val
        );
      },
      value: includeMode
    },
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayRadio,
      {
        label: Liferay.Language.get(
          "include"
        ),
        value: "include"
      }
    ),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayRadio,
      {
        label: Liferay.Language.get(
          "exclude"
        ),
        value: "exclude"
      }
    )
  )))))) : /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: sourceOptionFormElementId }, Liferay.Language.get("source-options"), /* @__PURE__ */ react_default.createElement(
    "span",
    {
      className: "label-icon lfr-portal-tooltip ml-2",
      title: Liferay.Language.get(
        "choose-a-picklist-to-associate-with-this-filter"
      )
    },
    /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
  )), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelectWithOption,
    {
      "aria-label": Liferay.Language.get(
        "source-options"
      ),
      name: sourceOptionFormElementId,
      onChange: (event) => {
        const picklist = picklists.find(
          (item) => String(
            item.externalReferenceCode
          ) === event.target.value
        );
        setSource(picklist);
        setPreselectedValues([]);
      },
      options: [
        {
          disabled: true,
          label: Liferay.Language.get(
            "select"
          ),
          value: ""
        },
        ...picklists.map((item) => ({
          label: item.name,
          value: item.externalReferenceCode
        }))
      ],
      title: Liferay.Language.get(
        "source-options"
      ),
      value: source?.externalReferenceCode || ""
    }
  )), source && /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    "label",
    {
      htmlFor: multipleFormElementId
    },
    Liferay.Language.get(
      "selection"
    ),
    /* @__PURE__ */ react_default.createElement(
      "span",
      {
        className: "label-icon lfr-portal-tooltip ml-2",
        title: Liferay.Language.get(
          "determines-how-many-preselected-values-for-the-filter-can-be-added"
        )
      },
      /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
    )
  ), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayRadioGroup,
    {
      name: multipleFormElementId,
      onChange: (newVal) => {
        setMultiple(
          newVal === "true"
        );
      },
      value: multiple ? "true" : "false"
    },
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayRadio,
      {
        label: Liferay.Language.get(
          "multiple"
        ),
        value: "true"
      }
    ),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayRadio,
      {
        label: Liferay.Language.get(
          "single"
        ),
        value: "false"
      }
    )
  )), /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": !isValidSingleMode
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: preselectedValuesFormElementId
      },
      Liferay.Language.get(
        "preselected-values"
      ),
      /* @__PURE__ */ react_default.createElement(
        "span",
        {
          className: "label-icon lfr-portal-tooltip ml-2",
          title: Liferay.Language.get(
            "choose-values-to-preselect-for-your-filters-source-option"
          )
        },
        /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
      )
    ),
    /* @__PURE__ */ react_default.createElement(
      CheckboxMultiSelect_default,
      {
        allowsCustomLabel: false,
        "aria-label": Liferay.Language.get(
          "preselected-values"
        ),
        inputName: preselectedValuesFormElementId,
        items: preselectedValues.map(
          (item) => ({
            label: item.name,
            value: String(
              item.externalReferenceCode
            )
          })
        ),
        loadingState: 4,
        onChange: setPreselectedValueInput,
        onItemsChange: (selectedItems) => {
          const preselectedValues2 = selectedItems.map(
            ({ value }) => {
              return source.listTypeEntries.find(
                (item) => String(
                  item.externalReferenceCode
                ) === String(
                  value
                )
              );
            }
          );
          setPreselectedValues(
            preselectedValues2
          );
          setIncludeMode(
            preselectedValues2.length ? filter && filter.include ? "include" : "exclude" : "include"
          );
        },
        placeholder: Liferay.Language.get(
          "select-a-default-value-for-your-filter"
        ),
        sourceItems: filteredSourceItems,
        value: preselectedValueInput
      }
    ),
    !isValidSingleMode && /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), Liferay.Language.get(
      "only-one-value-is-allowed-in-single-selection-mode"
    )))
  ), preselectedValues?.length > 0 && /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    "label",
    {
      htmlFor: includeModeFormElementId
    },
    Liferay.Language.get(
      "filter-mode"
    ),
    /* @__PURE__ */ react_default.createElement(
      "span",
      {
        className: "label-icon lfr-portal-tooltip ml-2",
        title: Liferay.Language.get(
          "include-returns-only-the-selected-values.-exclude-returns-all-except-the-selected-ones"
        )
      },
      /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
    )
  ), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayRadioGroup,
    {
      name: includeModeFormElementId,
      onChange: (val) => setIncludeMode(val),
      value: includeMode
    },
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayRadio,
      {
        label: Liferay.Language.get(
          "include"
        ),
        value: "include"
      }
    ),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayRadio,
      {
        label: Liferay.Language.get(
          "exclude"
        ),
        value: "exclude"
      }
    )
  )))))), /* @__PURE__ */ react_default.createElement(
    Footer_default,
    {
      closeModal,
      onSave: saveSelectionFilter,
      saveButtonDisabled
    }
  ));
}
var SelectionFilter_default = {
  Body: Body3,
  Header: Header3
};

// src/main/resources/META-INF/resources/css/Filters.scss
var link3 = document.createElement("link");
link3.setAttribute("rel", "stylesheet");
link3.setAttribute("type", "text/css");
link3.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/Filters.css"
);
document.querySelector("head").appendChild(link3);

// src/main/resources/META-INF/resources/js/data_set/filters/Filters.tsx
var FILTER_TYPES = {
  ["CLIENT_EXTENSION" /* CLIENT_EXTENSION */]: {
    Component: ClientExtensionFilter_default,
    availableFieldsFilter: (item) => !!item,
    displayType: Liferay.Language.get("client-extension-filter"),
    fdsViewRelationship: OBJECT_RELATIONSHIP.DATA_SET_CLIENT_EXTENSION_FILTER,
    fdsViewRelationshipId: OBJECT_RELATIONSHIP.DATA_SET_CLIENT_EXTENSION_FILTER_ID,
    label: Liferay.Language.get("client-extension"),
    url: API_URL.CLIENT_EXTENSION_FILTERS
  },
  ["DATE_RANGE" /* DATE_RANGE */]: {
    Component: DateRangeFilter_default,
    availableFieldsFilter: (item) => item.format === "date" /* DATE */ || item.format === "date-time" /* DATE_TIME */,
    displayType: Liferay.Language.get("date-filter"),
    fdsViewRelationship: OBJECT_RELATIONSHIP.DATA_SET_DATE_FILTER,
    fdsViewRelationshipId: OBJECT_RELATIONSHIP.DATA_SET_DATE_FILTER_ID,
    label: Liferay.Language.get("date-range"),
    url: API_URL.DATE_FILTERS
  },
  ["SELECTION" /* SELECTION */]: {
    Component: SelectionFilter_default,
    availableFieldsFilter: (item) => item.type === "string" /* STRING */ && !item.format,
    displayType: Liferay.Language.get("dynamic-filter"),
    fdsViewRelationship: OBJECT_RELATIONSHIP.DATA_SET_SELECTION_FILTER,
    fdsViewRelationshipId: OBJECT_RELATIONSHIP.DATA_SET_SELECTION_FILTER_ID,
    label: Liferay.Language.get("selection"),
    url: API_URL.SELECTION_FILTERS
  }
};
function AddFDSFilterModalContent({
  closeModal,
  dataSet,
  fdsFilterClientExtensions = [],
  fieldNames,
  fields,
  filter,
  filterType,
  namespace,
  onSave,
  restApplications
}) {
  const { Component, displayType, fdsViewRelationshipId } = FILTER_TYPES[filterType];
  const saveFDSFilter = async (formData) => {
    formData = {
      ...formData,
      [fdsViewRelationshipId]: dataSet.id
    };
    let url = FILTER_TYPES[filterType].url;
    let method = "POST";
    if (filter) {
      method = "PUT";
      url = `${url}/${filter.id}`;
    }
    const response = await (0, frontend_js_web_exports.fetch)(url, {
      body: JSON.stringify(formData),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method
    });
    if (!response.ok) {
      openDefaultFailureToast();
      return null;
    }
    const responseJSON = await response.json();
    openDefaultFailureToast2();
    onSave({ ...responseJSON, displayType, filterType });
    closeModal();
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, filter && (0, frontend_js_web_exports.sub)(Liferay.Language.get("edit-x-filter"), [filter.label]), !filter && /* @__PURE__ */ react_default.createElement(Component.Header, null)), /* @__PURE__ */ react_default.createElement(
    Component.Body,
    {
      closeModal,
      fdsFilterClientExtensions,
      fieldNames,
      fields,
      filter,
      namespace,
      onSave: (formData) => saveFDSFilter(formData),
      restApplications
    }
  ));
}
function Filters({
  dataSet,
  fdsFilterClientExtensions,
  fieldTreeItems: fields,
  namespace,
  restApplications
}) {
  const [filters, setFilters] = (0, react_exports.useState)([]);
  (0, react_exports.useEffect)(() => {
    const getFilters = async () => {
      const response = await (0, frontend_js_web_exports.fetch)(
        `${API_URL.DATA_SETS}/${dataSet.id}?nestedFields=${Object.values(FILTER_TYPES).map((filter) => filter.fdsViewRelationship).join(",")}`
      );
      const responseJSON = await response.json();
      let filtersOrdered = [];
      Object.keys(FILTER_TYPES).forEach((type) => {
        const filtersArray = responseJSON[FILTER_TYPES[type].fdsViewRelationship];
        filtersArray.forEach((filter) => {
          filtersOrdered.push({
            ...filter,
            displayType: FILTER_TYPES[type].displayType,
            filterType: type
          });
        });
      });
      filtersOrdered = sortItems(
        filtersOrdered,
        responseJSON.fdsFiltersOrder,
        true
      );
      setFilters(
        filtersOrdered.map((filter) => {
          return {
            ...filter,
            label: filter.label || ""
          };
        })
      );
    };
    getFilters();
  }, [dataSet]);
  const updateFDSFiltersOrder = async ({
    fdsFiltersOrder
  }) => {
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.DATA_SETS}/by-external-reference-code/${dataSet.externalReferenceCode}`,
      {
        body: JSON.stringify({
          fdsFiltersOrder
        }),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return null;
    }
    const responseJSON = await response.json();
    const storedFDSFiltersOrder = responseJSON?.fdsFiltersOrder;
    if (filters && storedFDSFiltersOrder && storedFDSFiltersOrder === fdsFiltersOrder) {
      setFilters(
        sortItems(
          filters,
          storedFDSFiltersOrder,
          true
        )
      );
      openDefaultFailureToast2();
    } else {
      openDefaultFailureToast();
    }
  };
  const onCreationButtonClick = (filterType) => {
    const availableFields = fields.filter(
      (item) => FILTER_TYPES[filterType].availableFieldsFilter(item)
    );
    if (!availableFields.length) {
      (0, frontend_js_web_exports.openModal)({
        bodyHTML: Liferay.Language.get(
          "there-are-no-fields-compatible-with-this-type-of-filter"
        ),
        buttons: [
          {
            displayType: "primary",
            label: Liferay.Language.get("close"),
            onClick: ({ processClose }) => {
              processClose();
            }
          }
        ],
        size: Liferay.FeatureFlags["LPD-10754"] ? "lg" : "md",
        status: "info",
        title: Liferay.Language.get("no-fields-available")
      });
    } else {
      (0, frontend_js_web_exports.openModal)({
        className: "overflow-auto",
        contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
          AddFDSFilterModalContent,
          {
            closeModal,
            dataSet,
            fdsFilterClientExtensions,
            fieldNames: filters.map((filter) => filter.fieldName),
            fields: availableFields,
            filterType,
            namespace,
            onSave: (newfilter) => {
              if (newfilter.label === void 0) {
                newfilter.label = "";
              }
              setFilters([...filters, newfilter]);
            },
            restApplications
          }
        ),
        disableAutoClose: true,
        size: Liferay.FeatureFlags["LPD-10754"] ? "lg" : "md"
      });
    }
  };
  const onEdit = ({ item }) => (0, frontend_js_web_exports.openModal)({
    className: "overflow-auto",
    contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
      AddFDSFilterModalContent,
      {
        closeModal,
        dataSet,
        fdsFilterClientExtensions,
        fieldNames: filters.map((filter) => filter.fieldName),
        fields,
        filter: item,
        filterType: item.filterType,
        namespace,
        onSave: (newfilter) => {
          const newFilters = filters.map((item2) => {
            if (item2.id === newfilter.id) {
              if (item2.filterType === "DATE_RANGE" /* DATE_RANGE */) {
                newfilter.from = newfilter.from || "";
                newfilter.to = newfilter.to || "";
              }
              return { ...item2, ...newfilter };
            }
            return item2;
          });
          setFilters(newFilters);
        },
        restApplications
      }
    ),
    disableAutoClose: true,
    size: Liferay.FeatureFlags["LPD-10754"] ? "lg" : "md"
  });
  const onDelete = async ({ item }) => {
    (0, frontend_js_web_exports.openModal)({
      bodyHTML: Liferay.Language.get(
        "are-you-sure-you-want-to-delete-this-filter"
      ),
      buttons: [
        {
          autoFocus: true,
          displayType: "secondary",
          label: Liferay.Language.get("cancel"),
          type: "cancel"
        },
        {
          displayType: "danger",
          label: Liferay.Language.get("delete"),
          onClick: ({ processClose }) => {
            processClose();
            const url = `${FILTER_TYPES[item.filterType].url}/${item.id}`;
            (0, frontend_js_web_exports.fetch)(url, {
              method: "DELETE"
            }).then(() => {
              openDefaultFailureToast2();
              setFilters(
                filters.filter(
                  (filter) => filter.id !== item.id
                )
              );
            }).catch(openDefaultFailureToast);
          }
        }
      ],
      size: Liferay.FeatureFlags["LPD-10754"] ? "lg" : "md",
      status: "warning",
      title: Liferay.Language.get("delete-filter")
    });
  };
  return /* @__PURE__ */ react_default.createElement(layout_default.ContainerFluid, null, /* @__PURE__ */ react_default.createElement(
    OrderableTable_default,
    {
      actions: [
        {
          icon: "pencil",
          label: Liferay.Language.get("edit"),
          onClick: onEdit
        },
        {
          icon: "trash",
          label: Liferay.Language.get("delete"),
          onClick: onDelete
        }
      ],
      creationMenuItems: Object.keys(FILTER_TYPES).map((type) => ({
        label: FILTER_TYPES[type].label,
        onClick: () => onCreationButtonClick(type)
      })),
      creationMenuLabel: Liferay.Language.get("new-filter"),
      fields: [
        {
          label: Liferay.Language.get("name"),
          name: "label"
        },
        {
          label: Liferay.Language.get("Field Name"),
          name: "fieldName"
        },
        {
          label: Liferay.Language.get("type"),
          name: "displayType"
        }
      ],
      items: filters,
      noItemsButtonLabel: Liferay.Language.get("new-filter"),
      noItemsDescription: Liferay.Language.get(
        "start-creating-a-filter-to-display-specific-data"
      ),
      noItemsTitle: Liferay.Language.get(
        "no-default-filters-were-created"
      ),
      onOrderChange: ({ order }) => {
        updateFDSFiltersOrder({ fdsFiltersOrder: order });
      },
      title: Liferay.Language.get("filters")
    }
  ));
}
var Filters_default = Filters;

// src/main/resources/META-INF/resources/js/data_set/pagination/Pagination.tsx
function Pagination({
  backURL,
  dataSet,
  namespace,
  onDataSetUpdate
}) {
  const [listOfItemsPerPage, setListOfItemsPerPage] = (0, react_exports.useState)(
    dataSet.listOfItemsPerPage
  );
  const [defaultItemsPerPage, setDefaultItemsPerPage] = (0, react_exports.useState)(
    dataSet.defaultItemsPerPage.toString()
  );
  const [
    incompatibleDefaultItemsPerPageValidationError,
    setIncompatibleDefaultItemsPerPageValidationError
  ] = (0, react_exports.useState)(false);
  const [
    invalidNumberInListOfItemsPerPageValidationError,
    setInvalidNumberInListOfItemsPerPageValidationError
  ] = (0, react_exports.useState)(false);
  const [
    requiredDefaultItemsPerPageValidationError,
    setRequiredDefaultItemsPerPageValidationError
  ] = (0, react_exports.useState)(false);
  const [
    requiredListOfItemsPerPageValidationError,
    setRequiredListOfItemsPerPageValidationError
  ] = (0, react_exports.useState)(false);
  const [
    invalidListOfItemsPerPageLengthValidationError,
    setInvalidListOfItemsPerPageLengthValidationError
  ] = (0, react_exports.useState)(false);
  const listOfItemsPerPageRef = (0, react_exports.useRef)(null);
  const defaultItemsPerPageRef = (0, react_exports.useRef)(null);
  const getItemsPerPageArray = () => {
    return listOfItemsPerPage.split(",").map((size) => size.trim());
  };
  const listOfItemsPerPageFieldValidation = (itemsPerPageArray) => {
    if (itemsPerPageArray.length > 25) {
      setInvalidListOfItemsPerPageLengthValidationError(true);
    } else {
      setInvalidListOfItemsPerPageLengthValidationError(false);
    }
    const invalidNumber = itemsPerPageArray.some((element) => {
      const isPositiveInteger = /^\d+$/.test(element);
      const item = parseInt(element, 10);
      return !isPositiveInteger || item < 1 || item > 1e3;
    });
    setInvalidNumberInListOfItemsPerPageValidationError(invalidNumber);
  };
  const compatibilityValidation = (itemsPerPageArray) => {
    if (!itemsPerPageArray.includes(defaultItemsPerPage)) {
      setIncompatibleDefaultItemsPerPageValidationError(true);
    } else {
      setIncompatibleDefaultItemsPerPageValidationError(false);
    }
  };
  const handleSaveClick = async () => {
    const getItemsPerPageString = () => {
      const uniqueItemsPerPageArray = [
        ...new Set(getItemsPerPageArray())
      ];
      const sortedItemsPerPageArray = uniqueItemsPerPageArray.map((element) => parseInt(element, 10)).sort((a, b) => a - b);
      return sortedItemsPerPageArray.join(", ");
    };
    const itemsPerPage = getItemsPerPageString();
    const body = {
      defaultItemsPerPage,
      label: dataSet.label,
      listOfItemsPerPage: itemsPerPage
    };
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.DATA_SETS}/by-external-reference-code/${dataSet.externalReferenceCode}`,
      {
        body: JSON.stringify(body),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    if (responseJSON?.id) {
      openDefaultFailureToast2();
      onDataSetUpdate(responseJSON);
    } else {
      openDefaultFailureToast();
    }
  };
  const listOfItemsPerPageValidationError = requiredListOfItemsPerPageValidationError || invalidNumberInListOfItemsPerPageValidationError || invalidListOfItemsPerPageLengthValidationError;
  const defaultItemsPerPageValidationError = incompatibleDefaultItemsPerPageValidationError || requiredDefaultItemsPerPageValidationError;
  return /* @__PURE__ */ react_default.createElement(layout_default.Sheet, { className: "mt-3", size: "lg" }, /* @__PURE__ */ react_default.createElement(layout_default.SheetHeader, null, /* @__PURE__ */ react_default.createElement("h2", { className: "sheet-title" }, Liferay.Language.get("pagination")), /* @__PURE__ */ react_default.createElement("div", { className: "sheet-text" }, Liferay.Language.get(
    "data-set-view-pagination-description"
  ))), /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, null, /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default(
        listOfItemsPerPageValidationError && "has-error"
      )
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}dataSetListOfItemsPerPageTextarea`
      },
      Liferay.Language.get("list-of-items-per-page"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayInput,
      {
        component: "textarea",
        id: `${namespace}dataSetListOfItemsPerPageTextarea`,
        onBlur: () => {
          const itemsPerPageArray = getItemsPerPageArray();
          listOfItemsPerPageFieldValidation(
            itemsPerPageArray
          );
          compatibilityValidation(itemsPerPageArray);
          setRequiredListOfItemsPerPageValidationError(
            !listOfItemsPerPageRef.current?.value
          );
        },
        onChange: (event) => setListOfItemsPerPage(event.target.value),
        ref: listOfItemsPerPageRef,
        required: true,
        type: "text",
        value: listOfItemsPerPage
      }
    ),
    listOfItemsPerPageValidationError && /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), requiredListOfItemsPerPageValidationError ? Liferay.Language.get(
      "this-field-is-required"
    ) : invalidNumberInListOfItemsPerPageValidationError ? Liferay.Language.get(
      "this-field-contains-an-invalid-number"
    ) : Liferay.Language.get(
      "this-field-contains-more-than-25-elements"
    ))),
    /* @__PURE__ */ react_default.createElement(form_default.Text, null, Liferay.Language.get("list-of-items-per-page-help"))
  ), /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default(
        defaultItemsPerPageValidationError && "has-error"
      )
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}dataSetDefaultItemsPerPageInput`
      },
      Liferay.Language.get("default-items-per-page"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayInput,
      {
        id: `${namespace}dataSetDefaultItemsPerPageInput`,
        onBlur: () => {
          compatibilityValidation(getItemsPerPageArray());
          setRequiredDefaultItemsPerPageValidationError(
            !defaultItemsPerPageRef.current?.value
          );
        },
        onChange: (event) => setDefaultItemsPerPage(event.target.value),
        ref: defaultItemsPerPageRef,
        type: "number",
        value: defaultItemsPerPage
      }
    ),
    defaultItemsPerPageValidationError && /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), requiredDefaultItemsPerPageValidationError ? Liferay.Language.get(
      "this-field-is-required"
    ) : Liferay.Language.get(
      "the-default-value-must-exist-in-the-list-of-items-per-page"
    ))),
    /* @__PURE__ */ react_default.createElement(form_default.Text, null, Liferay.Language.get("default-items-per-page-help"))
  )), /* @__PURE__ */ react_default.createElement(layout_default.SheetFooter, null, /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      disabled: listOfItemsPerPageValidationError || defaultItemsPerPageValidationError,
      onClick: handleSaveClick
    },
    Liferay.Language.get("save")
  ), /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      displayType: "secondary",
      onClick: () => (0, frontend_js_web_exports.navigate)(backURL)
    },
    Liferay.Language.get("cancel")
  ))));
}
var Pagination_default = Pagination;

// ../../../../../../../../../$/bridge/for/main/@clayui/core
var core_exports = {};
__reExport(core_exports, clayui_core_star);
import * as clayui_core_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$core.js";

// ../../../../../../../../../$/bridge/for/main/@clayui/link
var link_exports = {};
__export(link_exports, {
  default: () => link_default
});
__reExport(link_exports, clayui_link_star);
import * as clayui_link_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$link.js";
import __default__23 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$link.js";
var link_default = __default__23;

// ../../../../../../../../../$/bridge/for/main/@clayui/tooltip
var tooltip_exports = {};
__export(tooltip_exports, {
  default: () => tooltip_default
});
__reExport(tooltip_exports, clayui_tooltip_star);
import * as clayui_tooltip_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$tooltip.js";
import __default__24 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$tooltip.js";
var tooltip_default = __default__24;

// src/main/resources/META-INF/resources/js/data_set/settings/Settings.tsx
var NOT_CONFIGURED_VISUALIZATION_MODE = {
  label: Liferay.Language.get("go-to-visualization-modes"),
  thumbnail: "plus",
  type: Liferay.Language.get("not-configured")
};
var Settings = ({
  backURL,
  dataSet,
  onActiveSectionChange,
  onDataSetUpdate,
  spritemap
}) => {
  const [defaultVisualizationMode, setDefaultVisualizationMode] = (0, react_exports.useState)(
    NOT_CONFIGURED_VISUALIZATION_MODE.type
  );
  const [loading, setLoading] = (0, react_exports.useState)(true);
  const [visualizationModes, setVisualizationModes] = (0, react_exports.useState)([]);
  const getActiveVisualizationModes = async () => {
    const fields = [
      OBJECT_RELATIONSHIP.DATA_SET_CARDS_SECTION,
      OBJECT_RELATIONSHIP.DATA_SET_LIST_SECTION,
      OBJECT_RELATIONSHIP.DATA_SET_TABLE_SECTION
    ].join(",");
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.DATA_SETS}/by-external-reference-code/${dataSet.externalReferenceCode}?fields=${fields}&nestedFields=${fields}`
    );
    if (!response.ok) {
      openDefaultFailureToast();
      setVisualizationModes([]);
      setLoading(false);
      return;
    }
    const responseJSON = await response.json();
    const {
      fdsViewFDSCardsSectionRelationship: cards,
      fdsViewFDSFieldRelationship: table,
      fdsViewFDSListSectionRelationship: list
    } = responseJSON;
    const activeViews = [];
    DEFAULT_VISUALIZATION_MODES.forEach(
      (view) => {
        if (view.mode === "cards" && cards && cards.length) {
          activeViews.push(view);
        }
        if (view.mode === "list" && list && list.length) {
          activeViews.push(view);
        }
        if (view.mode === "table" && table && table.length) {
          activeViews.push(view);
        }
      }
    );
    setVisualizationModes(activeViews);
    setDefaultVisualizationMode(() => {
      if (activeViews.find(
        (view) => view.mode === dataSet.defaultVisualizationMode
      )) {
        return dataSet.defaultVisualizationMode;
      } else {
        return activeViews.length ? activeViews[0].mode : NOT_CONFIGURED_VISUALIZATION_MODE.type;
      }
    });
    setLoading(false);
  };
  const updateFDSViewSettings = async () => {
    const body = {
      defaultVisualizationMode
    };
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.DATA_SETS}/by-external-reference-code/${dataSet.externalReferenceCode}`,
      {
        body: JSON.stringify(body),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    if (responseJSON?.id) {
      openDefaultFailureToast2();
      onDataSetUpdate(responseJSON);
    } else {
      openDefaultFailureToast();
    }
  };
  (0, react_exports.useEffect)(() => {
    getActiveVisualizationModes();
  }, []);
  return /* @__PURE__ */ react_default.createElement(layout_default.Sheet, { className: "mt-3", size: "lg" }, /* @__PURE__ */ react_default.createElement(layout_default.SheetHeader, { className: "mb-4" }, /* @__PURE__ */ react_default.createElement("h2", { className: "sheet-title" }, Liferay.Language.get("settings"))), /* @__PURE__ */ react_default.createElement(layout_default.SheetSection, null, /* @__PURE__ */ react_default.createElement("h3", { className: "sheet-subtitle" }, Liferay.Language.get("fragment-defaults")), /* @__PURE__ */ react_default.createElement(layout_default.Row, { className: "align-items-center justify-content-between" }, /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 8 }, /* @__PURE__ */ react_default.createElement("div", null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: "view-mode-picker", id: "view-mode" }, Liferay.Language.get(
    "default-visualization-mode"
  )), /* @__PURE__ */ react_default.createElement(tooltip_exports.ClayTooltipProvider, null, /* @__PURE__ */ react_default.createElement(
    "span",
    {
      className: "ml-1 text-secondary",
      "data-tooltip-align": "top",
      title: Liferay.Language.get(
        "default-visualization-mode-tooltip"
      )
    },
    /* @__PURE__ */ react_default.createElement(
      icon_default,
      {
        spritemap,
        symbol: "question-circle-full"
      }
    )
  ))), /* @__PURE__ */ react_default.createElement("div", null, Liferay.Language.get(
    "default-visualization-mode-help"
  ))), /* @__PURE__ */ react_default.createElement(layout_default.Col, { size: 4 }, !loading && /* @__PURE__ */ react_default.createElement(
    core_exports.Picker,
    {
      "aria-labelledby": "view-mode",
      className: "mb-2",
      disabled: !visualizationModes.length,
      id: "view-mode-picker",
      items: visualizationModes,
      onSelectionChange: (option) => {
        if (option !== NOT_CONFIGURED_VISUALIZATION_MODE.type) {
          setDefaultVisualizationMode(
            option
          );
        }
      },
      placeholder: NOT_CONFIGURED_VISUALIZATION_MODE.type,
      selectedKey: defaultVisualizationMode
    },
    visualizationModes.length ? ({ label, mode, thumbnail }) => /* @__PURE__ */ react_default.createElement(core_exports.Option, { key: mode, textValue: label }, /* @__PURE__ */ react_default.createElement(
      icon_default,
      {
        className: "mr-3",
        symbol: thumbnail
      }
    ), label) : /* @__PURE__ */ react_default.createElement(
      drop_down_default.Group,
      {
        header: Liferay.Language.get(
          "not-configured"
        )
      },
      /* @__PURE__ */ react_default.createElement(
        core_exports.Option,
        {
          key: NOT_CONFIGURED_VISUALIZATION_MODE.type,
          textValue: NOT_CONFIGURED_VISUALIZATION_MODE.type
        },
        /* @__PURE__ */ react_default.createElement(layout_default.Row, null, /* @__PURE__ */ react_default.createElement(layout_default.Col, null, /* @__PURE__ */ react_default.createElement(core_exports.Text, { size: 3 }, NOT_CONFIGURED_VISUALIZATION_MODE.label)))
      )
    )
  ), !loading && !visualizationModes.length && /* @__PURE__ */ react_default.createElement(
    link_default,
    {
      borderless: true,
      onClick: () => onActiveSectionChange(1),
      onKeyPress: () => onActiveSectionChange(1),
      tabIndex: 0,
      weight: "semi-bold"
    },
    /* @__PURE__ */ react_default.createElement("span", { className: "inline-item inline-item-before" }, /* @__PURE__ */ react_default.createElement(
      icon_default,
      {
        spritemap,
        symbol: "shortcut"
      }
    )),
    Liferay.Language.get(
      "go-to-visualization-modes"
    )
  )))), /* @__PURE__ */ react_default.createElement(layout_default.SheetFooter, null, /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(button_default, { onClick: updateFDSViewSettings }, Liferay.Language.get("save")), /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      displayType: "secondary",
      onClick: () => (0, frontend_js_web_exports.navigate)(backURL)
    },
    Liferay.Language.get("cancel")
  ))));
};
var Settings_default = Settings;

// src/main/resources/META-INF/resources/js/data_set/sorting/Sorting.tsx
var ORDER_TYPE = {
  ASCENDING: {
    label: Liferay.Language.get("ascending"),
    value: "asc"
  },
  DESCENDING: {
    label: Liferay.Language.get("descending"),
    value: "desc"
  }
};
var ORDER_TYPE_OPTIONS = [ORDER_TYPE.ASCENDING, ORDER_TYPE.DESCENDING];
var DefaultComponent = ({ item }) => {
  return /* @__PURE__ */ react_default.createElement(label_default, { displayType: item.default ? "success" : "secondary" }, item.default ? Liferay.Language.get("yes") : Liferay.Language.get("no"));
};
var AddFDSSortModalContent = ({
  closeModal,
  dataSet,
  fields,
  namespace,
  onSave
}) => {
  const [labelI18n, setLabelI18n] = (0, react_exports.useState)({});
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [selectedFieldName, setSelectedFieldName] = (0, react_exports.useState)("");
  const [selectedOrderType, setSelectedOrderType] = (0, react_exports.useState)(
    ORDER_TYPE.ASCENDING.value
  );
  const [useAsDefaultSorting, setUseAsDefaultSorting] = (0, react_exports.useState)(false);
  const handleSave = async () => {
    setSaveButtonDisabled(true);
    const field = fields.find(
      (item) => item.name === selectedFieldName
    );
    if (!field) {
      openDefaultFailureToast();
      return;
    }
    const response = await (0, frontend_js_web_exports.fetch)(API_URL.SORTS, {
      body: JSON.stringify({
        [OBJECT_RELATIONSHIP.DATA_SET_SORT_ID]: dataSet.id,
        default: useAsDefaultSorting,
        fieldName: selectedFieldName,
        label_i18n: labelI18n,
        orderType: selectedOrderType
      }),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method: "POST"
    });
    if (!response.ok) {
      setSaveButtonDisabled(false);
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    openDefaultFailureToast2();
    onSave(responseJSON);
    closeModal();
  };
  const fdsSortLabelInput = `${namespace}fdsSortLabelInput`;
  const fdsSortFieldNameInputId = `${namespace}fdsSortFieldNameInput`;
  const fdsSortOrderTypeInputId = `${namespace}fdsSortOrderTypeInput`;
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, Liferay.Language.get("new-sorting-option")), /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement("p", { className: "text-secondary" }, Liferay.Language.get(
    "create-a-sorting-option-for-the-dataset-fragment"
  )), /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.InputLocalized,
    {
      id: fdsSortLabelInput,
      label: Liferay.Language.get("label"),
      name: "label",
      onChange: setLabelI18n,
      placeholder: Liferay.Language.get("add-a-label"),
      required: true,
      translations: labelI18n
    }
  ), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: fdsSortFieldNameInputId }, Liferay.Language.get("sort-by"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelectWithOption,
    {
      "aria-label": Liferay.Language.get("sort-by"),
      name: fdsSortFieldNameInputId,
      onChange: (event) => {
        setSelectedFieldName(event.target.value);
      },
      options: [
        {
          disabled: true,
          label: Liferay.Language.get("choose-an-option"),
          value: ""
        },
        ...fields.map((item) => ({
          label: item.label,
          value: item.name
        }))
      ],
      title: Liferay.Language.get("sort-by"),
      value: selectedFieldName
    }
  )), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    form_exports.ClayCheckbox,
    {
      "aria-label": Liferay.Language.get(
        "use-as-default-sorting"
      ),
      checked: useAsDefaultSorting,
      inline: true,
      label: Liferay.Language.get("use-as-default-sorting"),
      onChange: () => setUseAsDefaultSorting((value) => !value)
    }
  )), useAsDefaultSorting && /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: fdsSortOrderTypeInputId }, Liferay.Language.get("order-type"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelectWithOption,
    {
      "aria-label": Liferay.Language.get("order-type"),
      id: fdsSortOrderTypeInputId,
      onChange: (event) => setSelectedOrderType(event.target.value),
      options: ORDER_TYPE_OPTIONS
    }
  ))), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled || !selectedFieldName || !labelI18n[Liferay.ThemeDisplay.getDefaultLanguageId()],
          onClick: handleSave
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
var EditFDSSortModalContent = ({
  closeModal,
  fdsSort,
  fields,
  namespace,
  onSave
}) => {
  const [labelI18n, setLabelI18n] = (0, react_exports.useState)(fdsSort.label_i18n);
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [selectedFieldName, setSelectedFieldName] = (0, react_exports.useState)(
    fdsSort.fieldName
  );
  const [selectedOrderType, setSelectedOrderType] = (0, react_exports.useState)(
    fdsSort.orderType
  );
  const [useAsDefaultSorting, setUseAsDefaultSorting] = (0, react_exports.useState)(
    fdsSort.default
  );
  const handleSave = async () => {
    setSaveButtonDisabled(true);
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.SORTS}/by-external-reference-code/${fdsSort.externalReferenceCode}`,
      {
        body: JSON.stringify({
          default: useAsDefaultSorting,
          fieldName: selectedFieldName,
          label_i18n: labelI18n,
          orderType: selectedOrderType
        }),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      setSaveButtonDisabled(false);
      openDefaultFailureToast();
      return;
    }
    const editedFDSSort = await response.json();
    closeModal();
    openDefaultFailureToast2();
    onSave({ editedFDSSort });
  };
  const fdsSortLabelInput = `${namespace}fdsSortLabelInput`;
  const fdsSortFieldNameInputId = `${namespace}fdsSortFieldNameInput`;
  const fdsSortOrderTypeInputId = `${namespace}fdsSortOrderTypeInput`;
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, Liferay.Util.sub(
    Liferay.Language.get("edit-x-sorting"),
    fdsSort.label
  )), /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("p", { className: "text-secondary" }, Liferay.Language.get(
    "create-a-sorting-option-for-the-dataset-fragment.-add-a-label-name-and-choose-a-field-to-be-displayed-in-the-sorting-dropdown"
  )), /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.InputLocalized,
    {
      id: fdsSortLabelInput,
      label: Liferay.Language.get("label"),
      name: "label",
      onChange: setLabelI18n,
      placeholder: Liferay.Language.get("add-a-label"),
      required: true,
      translations: labelI18n
    }
  ), /* @__PURE__ */ react_default.createElement("label", { htmlFor: fdsSortFieldNameInputId }, Liferay.Language.get("sort-by"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelectWithOption,
    {
      "aria-label": Liferay.Language.get("sort-by"),
      name: fdsSortFieldNameInputId,
      onChange: (event) => {
        setSelectedFieldName(event.target.value);
      },
      options: [
        {
          disabled: true,
          label: Liferay.Language.get("choose-an-option"),
          value: ""
        },
        ...fields.map((item) => ({
          label: item.label,
          value: item.name
        }))
      ],
      title: Liferay.Language.get("sort-by"),
      value: selectedFieldName
    }
  )), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    form_exports.ClayCheckbox,
    {
      "aria-label": Liferay.Language.get(
        "use-as-default-sorting"
      ),
      checked: useAsDefaultSorting,
      inline: true,
      label: Liferay.Language.get("use-as-default-sorting"),
      onChange: () => setUseAsDefaultSorting((value) => !value)
    }
  )), useAsDefaultSorting && /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: fdsSortOrderTypeInputId }, Liferay.Language.get("order-type"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelectWithOption,
    {
      "aria-label": Liferay.Language.get("order-type"),
      id: fdsSortOrderTypeInputId,
      onChange: (event) => setSelectedOrderType(event.target.value),
      options: ORDER_TYPE_OPTIONS,
      value: selectedOrderType
    }
  ))), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled || !selectedFieldName || !labelI18n[Liferay.ThemeDisplay.getDefaultLanguageId()],
          onClick: handleSave
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
var Sorting = ({
  dataSet,
  fieldTreeItems,
  namespace
}) => {
  const fields = fieldTreeItems.filter((field) => field.sortable);
  const [fdsSorts, setFDSSorts] = (0, react_exports.useState)([]);
  const [loading, setLoading] = (0, react_exports.useState)(true);
  (0, react_exports.useEffect)(() => {
    const getFDSSort = async () => {
      const response = await (0, frontend_js_web_exports.fetch)(
        `${API_URL.SORTS}?filter=(${OBJECT_RELATIONSHIP.DATA_SET_SORT_ID} eq '${dataSet.id}')&nestedFields=${OBJECT_RELATIONSHIP.DATA_SET_SORT}&sort=dateCreated:asc`
      );
      const responseJSON = await response.json();
      const storedFDSSorts = responseJSON.items;
      setFDSSorts(
        sortItems(
          storedFDSSorts,
          // @ts-ignore
          storedFDSSorts?.[0]?.[OBJECT_RELATIONSHIP.DATA_SET_SORT]?.fdsSortsOrder
        )
      );
      setLoading(false);
    };
    getFDSSort();
  }, [dataSet]);
  const handleCreation = () => (0, frontend_js_web_exports.openModal)({
    contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
      AddFDSSortModalContent,
      {
        closeModal,
        dataSet,
        fields,
        namespace,
        onSave: (newSort) => setFDSSorts([...fdsSorts, newSort])
      }
    )
  });
  const handleDelete = ({ item }) => {
    (0, frontend_js_web_exports.openModal)({
      bodyHTML: Liferay.Language.get(
        "are-you-sure-you-want-to-delete-this-sorting?-fragments-using-it-will-be-affected"
      ),
      buttons: [
        {
          autoFocus: true,
          displayType: "secondary",
          label: Liferay.Language.get("cancel"),
          type: "cancel"
        },
        {
          displayType: "danger",
          label: Liferay.Language.get("delete"),
          onClick: async ({
            processClose
          }) => {
            processClose();
            const url = `${API_URL.SORTS}/${item.id}`;
            const response = await (0, frontend_js_web_exports.fetch)(url, {
              method: "DELETE"
            });
            if (!response.ok) {
              openDefaultFailureToast();
              return;
            }
            openDefaultFailureToast2();
            setFDSSorts(
              fdsSorts?.filter(
                (fdsSort) => fdsSort.id !== item.id
              ) || []
            );
          }
        }
      ],
      status: "warning",
      title: Liferay.Language.get("delete-filter")
    });
  };
  const handleEdit = ({ item }) => {
    (0, frontend_js_web_exports.openModal)({
      contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
        EditFDSSortModalContent,
        {
          closeModal,
          fdsSort: item,
          fields,
          namespace,
          onSave: ({ editedFDSSort }) => {
            setFDSSorts(
              fdsSorts?.map((fdsSort) => {
                if (fdsSort.id === editedFDSSort.id) {
                  return editedFDSSort;
                }
                return fdsSort;
              }) || []
            );
          }
        }
      )
    });
  };
  const updateFDSSortsOrder = async ({
    fdsSortsOrder
  }) => {
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.DATA_SETS}/by-external-reference-code/${dataSet.externalReferenceCode}`,
      {
        body: JSON.stringify({
          fdsSortsOrder
        }),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    const storedFDSSortsOrder = responseJSON?.fdsSortsOrder;
    if (fdsSorts && storedFDSSortsOrder && storedFDSSortsOrder === fdsSortsOrder) {
      setFDSSorts(sortItems(fdsSorts, storedFDSSortsOrder));
      openDefaultFailureToast2();
    } else {
      openDefaultFailureToast();
    }
  };
  return /* @__PURE__ */ react_default.createElement(layout_default.ContainerFluid, null, loading ? /* @__PURE__ */ react_default.createElement(loading_indicator_default, null) : /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(alert_default, { className: "c-mt-5", displayType: "info" }, Liferay.Language.get(
    "the-hierarchy-of-the-sorting-options-will-be-defined-by-the-vertical-order-of-the-fields"
  )), /* @__PURE__ */ react_default.createElement(
    OrderableTable_default,
    {
      actions: [
        {
          icon: "pencil",
          label: Liferay.Language.get("edit"),
          onClick: handleEdit
        },
        {
          icon: "trash",
          label: Liferay.Language.get("delete"),
          onClick: handleDelete
        }
      ],
      creationMenuItems: [
        {
          label: Liferay.Language.get("new-sort"),
          onClick: handleCreation
        }
      ],
      fields: [
        {
          headingTitle: true,
          label: Liferay.Language.get("label"),
          name: "label"
        },
        {
          label: Liferay.Language.get("sort-by"),
          name: "fieldName"
        },
        {
          contentRenderer: {
            component: DefaultComponent
          },
          label: Liferay.Language.get("default"),
          name: "default"
        }
      ],
      items: fdsSorts,
      noItemsButtonLabel: Liferay.Language.get(
        "new-sorting-option"
      ),
      noItemsDescription: Liferay.Language.get(
        "create-a-sorting-option-to-order-the-data-in-the-fragment"
      ),
      noItemsTitle: Liferay.Language.get(
        "no-sorting-created-yet"
      ),
      onOrderChange: ({ order }) => {
        updateFDSSortsOrder({ fdsSortsOrder: order });
      },
      title: Liferay.Language.get("sorting")
    }
  )));
};
var Sorting_default = Sorting;

// src/main/resources/META-INF/resources/js/data_set/sorting/SortingDeprecated.tsx
var SORTING_DIRECTION = {
  ASCENDING: {
    label: Liferay.Language.get("ascending"),
    value: "asc"
  },
  DESCENDING: {
    label: Liferay.Language.get("descending"),
    value: "desc"
  }
};
var SORTING_OPTIONS = [
  SORTING_DIRECTION.ASCENDING,
  SORTING_DIRECTION.DESCENDING
];
var sortingDirectionTextMatch = (item) => {
  return item.sortingDirection === SORTING_DIRECTION.ASCENDING.value ? SORTING_DIRECTION.ASCENDING.label : SORTING_DIRECTION.DESCENDING.label;
};
var SortingDirectionComponent = ({ item, query }) => {
  const itemFieldValue = item.sortingDirection === SORTING_DIRECTION.ASCENDING.value ? SORTING_DIRECTION.ASCENDING.label : SORTING_DIRECTION.DESCENDING.label;
  const fuzzyMatch = fuzzy_default.match(query, itemFieldValue, FUZZY_OPTIONS);
  return /* @__PURE__ */ react_default.createElement("span", null, fuzzyMatch ? /* @__PURE__ */ react_default.createElement(
    "span",
    {
      dangerouslySetInnerHTML: {
        __html: fuzzyMatch.rendered
      }
    }
  ) : /* @__PURE__ */ react_default.createElement("span", null, itemFieldValue));
};
var AddFDSSortModalContent2 = ({
  closeModal,
  dataSet,
  fields,
  onSave
}) => {
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [selectedField, setSelectedField] = (0, react_exports.useState)();
  const [selectedSortingDirection, setSelectedSortingDirection] = (0, react_exports.useState)(SORTING_DIRECTION.ASCENDING.value);
  const handleSave = async () => {
    setSaveButtonDisabled(true);
    const field = fields.find(
      (item) => item.name === selectedField
    );
    if (!field) {
      openDefaultFailureToast();
      return;
    }
    const response = await (0, frontend_js_web_exports.fetch)(API_URL.SORTS, {
      body: JSON.stringify({
        [OBJECT_RELATIONSHIP.DATA_SET_SORT_ID]: dataSet.id,
        fieldName: selectedField,
        sortingDirection: selectedSortingDirection
      }),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method: "POST"
    });
    if (!response.ok) {
      setSaveButtonDisabled(false);
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    openDefaultFailureToast2();
    onSave(responseJSON);
    closeModal();
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, Liferay.Language.get("new-sorting-option")), /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: "field" }, Liferay.Language.get("field"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelectWithOption,
    {
      "aria-label": Liferay.Language.get("field"),
      defaultValue: "",
      name: "field",
      onChange: (event) => {
        setSelectedField(event.target.value);
      },
      options: [
        {
          disabled: true,
          label: Liferay.Language.get("choose-an-option"),
          value: ""
        },
        ...fields.map((item) => ({
          label: item.label,
          value: item.name
        }))
      ],
      title: Liferay.Language.get("field"),
      value: selectedField
    }
  )), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: "sorting" }, Liferay.Language.get("sorting"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelectWithOption,
    {
      "aria-label": Liferay.Language.get("sorting"),
      id: "sorting",
      onChange: (event) => setSelectedSortingDirection(event.target.value),
      options: SORTING_OPTIONS
    }
  ))), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled || !selectedField,
          onClick: handleSave
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
var EditFDSSortModalContent2 = ({
  closeModal,
  fdsSort,
  namespace,
  onSave
}) => {
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [selectedSortingDirection, setSelectedSortingDirection] = (0, react_exports.useState)(
    fdsSort.sortingDirection
  );
  const handleSave = async () => {
    setSaveButtonDisabled(true);
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.SORTS}/by-external-reference-code/${fdsSort.externalReferenceCode}`,
      {
        body: JSON.stringify({
          sortingDirection: selectedSortingDirection
        }),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      setSaveButtonDisabled(false);
      openDefaultFailureToast();
      return;
    }
    const editedFDSSort = await response.json();
    closeModal();
    openDefaultFailureToast2();
    onSave({ editedFDSSort });
  };
  const fdsSortFieldNameInputId = `${namespace}fdsSortFieldNameInput`;
  const fdsSortSortingDirectionInputId = `${namespace}fdsSortSortingDirectionInput`;
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, Liferay.Util.sub(
    Liferay.Language.get("edit-x-sorting"),
    fdsSort.fieldName
  )), /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    "label",
    {
      className: "disabled",
      htmlFor: fdsSortFieldNameInputId
    },
    Liferay.Language.get("field")
  ), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayInput,
    {
      "aria-label": Liferay.Language.get("field"),
      disabled: true,
      name: fdsSortFieldNameInputId,
      title: Liferay.Language.get("field"),
      value: fdsSort.fieldName
    }
  )), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: fdsSortSortingDirectionInputId }, Liferay.Language.get("sorting"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)), /* @__PURE__ */ react_default.createElement(
    form_exports.ClaySelectWithOption,
    {
      "aria-label": Liferay.Language.get("sorting"),
      id: fdsSortSortingDirectionInputId,
      onChange: (event) => setSelectedSortingDirection(event.target.value),
      options: SORTING_OPTIONS,
      value: selectedSortingDirection
    }
  ))), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled,
          onClick: handleSave
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
var SortingDeprecated = ({
  dataSet,
  fieldTreeItems,
  namespace
}) => {
  const fields = fieldTreeItems.filter((field) => field.sortable);
  const [fdsSorts, setFDSSorts] = (0, react_exports.useState)([]);
  const [loading, setLoading] = (0, react_exports.useState)(true);
  (0, react_exports.useEffect)(() => {
    const getFDSSort = async () => {
      const response = await (0, frontend_js_web_exports.fetch)(
        `${API_URL.SORTS}?filter=(${OBJECT_RELATIONSHIP.DATA_SET_SORT_ID} eq '${dataSet.id}')&nestedFields=${OBJECT_RELATIONSHIP.DATA_SET_SORT}&sort=dateCreated:asc`
      );
      const responseJSON = await response.json();
      const storedFDSSorts = responseJSON.items;
      setFDSSorts(
        sortItems(
          storedFDSSorts,
          // @ts-ignore
          storedFDSSorts?.[0]?.[OBJECT_RELATIONSHIP.DATA_SET_SORT]?.fdsSortsOrder
        )
      );
      setLoading(false);
    };
    getFDSSort();
  }, [dataSet]);
  const handleCreation = () => (0, frontend_js_web_exports.openModal)({
    contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
      AddFDSSortModalContent2,
      {
        closeModal,
        dataSet,
        fields,
        onSave: (newSort) => setFDSSorts([...fdsSorts, newSort])
      }
    )
  });
  const handleDelete = ({ item }) => {
    (0, frontend_js_web_exports.openModal)({
      bodyHTML: Liferay.Language.get(
        "are-you-sure-you-want-to-delete-this-sorting?-fragments-using-it-will-be-affected"
      ),
      buttons: [
        {
          autoFocus: true,
          displayType: "secondary",
          label: Liferay.Language.get("cancel"),
          type: "cancel"
        },
        {
          displayType: "danger",
          label: Liferay.Language.get("delete"),
          onClick: async ({
            processClose
          }) => {
            processClose();
            const url = `${API_URL.SORTS}/${item.id}`;
            const response = await (0, frontend_js_web_exports.fetch)(url, {
              method: "DELETE"
            });
            if (!response.ok) {
              openDefaultFailureToast();
              return;
            }
            openDefaultFailureToast2();
            setFDSSorts(
              fdsSorts?.filter(
                (fdsSort) => fdsSort.id !== item.id
              ) || []
            );
          }
        }
      ],
      status: "warning",
      title: Liferay.Language.get("delete-filter")
    });
  };
  const handleEdit = ({ item }) => {
    (0, frontend_js_web_exports.openModal)({
      contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
        EditFDSSortModalContent2,
        {
          closeModal,
          fdsSort: item,
          fields,
          namespace,
          onSave: ({ editedFDSSort }) => {
            setFDSSorts(
              fdsSorts?.map((fdsSort) => {
                if (fdsSort.id === editedFDSSort.id) {
                  return editedFDSSort;
                }
                return fdsSort;
              }) || []
            );
          }
        }
      )
    });
  };
  const updateFDSSortsOrder = async ({
    fdsSortsOrder
  }) => {
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.DATA_SETS}/by-external-reference-code/${dataSet.externalReferenceCode}`,
      {
        body: JSON.stringify({
          fdsSortsOrder
        }),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJSON = await response.json();
    const storedFDSSortsOrder = responseJSON?.fdsSortsOrder;
    if (fdsSorts && storedFDSSortsOrder && storedFDSSortsOrder === fdsSortsOrder) {
      setFDSSorts(sortItems(fdsSorts, storedFDSSortsOrder));
      openDefaultFailureToast2();
    } else {
      openDefaultFailureToast();
    }
  };
  return /* @__PURE__ */ react_default.createElement(layout_default.ContainerFluid, null, loading ? /* @__PURE__ */ react_default.createElement(loading_indicator_default, null) : /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(alert_default, { className: "c-mt-5", displayType: "info" }, Liferay.Language.get(
    "the-hierarchy-of-the-default-sorting-will-be-defined-by-the-vertical-order-of-the-fields"
  )), /* @__PURE__ */ react_default.createElement(
    OrderableTable_default,
    {
      actions: [
        {
          icon: "pencil",
          label: Liferay.Language.get("edit"),
          onClick: handleEdit
        },
        {
          icon: "trash",
          label: Liferay.Language.get("delete"),
          onClick: handleDelete
        }
      ],
      creationMenuItems: [
        {
          label: Liferay.Language.get(
            "new-sorting-option"
          ),
          onClick: handleCreation
        }
      ],
      fields: [
        {
          headingTitle: true,
          label: Liferay.Language.get("name"),
          name: "fieldName"
        },
        {
          contentRenderer: {
            component: SortingDirectionComponent,
            textMatch: sortingDirectionTextMatch
          },
          label: Liferay.Language.get("value"),
          name: "sortingDirection"
        }
      ],
      items: fdsSorts,
      noItemsButtonLabel: Liferay.Language.get(
        "new-sorting-option"
      ),
      noItemsDescription: Liferay.Language.get(
        "start-creating-a-sort-to-display-specific-data"
      ),
      noItemsTitle: Liferay.Language.get(
        "no-default-sort-created-yet"
      ),
      onOrderChange: ({ order }) => {
        updateFDSSortsOrder({ fdsSortsOrder: order });
      },
      title: Liferay.Language.get("sorting")
    }
  )));
};
var SortingDeprecated_default = SortingDeprecated;

// src/main/resources/META-INF/resources/css/CardsVisualizationMode.scss
var link4 = document.createElement("link");
link4.setAttribute("rel", "stylesheet");
link4.setAttribute("type", "text/css");
link4.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/CardsVisualizationMode.css"
);
document.querySelector("head").appendChild(link4);

// ../../../../../../../../../$/bridge/for/main/@clayui/management-toolbar
var management_toolbar_exports = {};
__export(management_toolbar_exports, {
  default: () => management_toolbar_default
});
__reExport(management_toolbar_exports, clayui_management_toolbar_star);
import * as clayui_management_toolbar_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$management-toolbar.js";
import __default__25 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$management-toolbar.js";
var management_toolbar_default = __default__25;

// src/main/resources/META-INF/resources/js/components/AutoSearch.tsx
var AutoSearch = ({ onSearch, query }) => {
  const [focused, setFocused] = (0, react_exports.useState)(false);
  return /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.Group, null, /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupItem, null, !focused && /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupInsetItem, { before: true, tag: "span" }, /* @__PURE__ */ react_default.createElement(
    icon_default,
    {
      className: "inline-item inline-item-before",
      focusable: "false",
      role: "presentation",
      symbol: "search"
    }
  )), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayInput,
    {
      insetAfter: focused,
      insetBefore: !focused,
      onChange: (event) => onSearch(event.target.value),
      onFocus: () => setFocused(true),
      placeholder: Liferay.Language.get("search"),
      type: "text",
      value: query
    }
  ), focused && /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupInsetItem, { after: true, tag: "span" }, /* @__PURE__ */ react_default.createElement(
    button_exports.ClayButtonWithIcon,
    {
      "aria-label": Liferay.Language.get("clear-search"),
      borderless: true,
      displayType: "secondary",
      monospaced: false,
      onClick: () => {
        onSearch("");
        setFocused(false);
      },
      size: "sm",
      symbol: "times",
      title: Liferay.Language.get("clear-search")
    }
  ))));
};
var AutoSearch_default = AutoSearch;

// src/main/resources/META-INF/resources/css/components/FieldSelectModalContent.scss
var link5 = document.createElement("link");
link5.setAttribute("rel", "stylesheet");
link5.setAttribute("type", "text/css");
link5.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/components/FieldSelectModalContent.css"
);
document.querySelector("head").appendChild(link5);

// src/main/resources/META-INF/resources/js/components/FieldSelectModalContent.tsx
function visit(fields, callback) {
  fields.forEach((field) => {
    callback(field);
    if (field.children) {
      visit(field.children, callback);
    }
  });
}
var initializeFields = ({
  fields: initialFields,
  selectedFields
}) => {
  const selectedKeys = /* @__PURE__ */ new Set();
  const fields = Array.from(initialFields);
  visit(fields, (field) => {
    const selectedField = selectedFields.find(
      (selectedField2) => selectedField2.name === field.name
    );
    if (selectedField) {
      selectedKeys.add(selectedField.name);
      field.savedId = selectedField.id;
    }
    field.initialChildren = field.children;
    field.id = field.name;
  });
  return [selectedKeys, fields];
};
function filterFields({
  fields,
  onFilter,
  onMatch,
  query
}) {
  const filteredItems = [];
  const regexp = new RegExp(query, "i");
  fields.forEach((field) => {
    const match = field.label ? regexp.test(field.label) : false;
    const filteredChildren = field.children?.length ? filterFields({ fields: field.children, onFilter, onMatch, query }) : [];
    if (match || field.children?.length && filteredChildren.length) {
      filteredItems.push({
        ...field,
        children: filteredChildren,
        query
      });
      if (onFilter) {
        onFilter(field);
      }
    }
    if (match && onMatch) {
      onMatch(field);
    }
  });
  return filteredItems;
}
function applyFilter({
  fields,
  query
} = {}) {
  if (!query || !fields) {
    return {
      counter: 0,
      filteredItems: fields ?? [],
      filteredKeys: []
    };
  }
  let counter = 0;
  const filteredKeys = [];
  const filteredItems = filterFields({
    fields,
    onFilter: ({ id }) => {
      if (id) {
        filteredKeys.push(id);
      }
    },
    onMatch: () => counter++,
    query
  });
  return {
    counter,
    filteredItems,
    filteredKeys
  };
}
var Highlight = ({ query, text }) => {
  if (!query || !text) {
    return /* @__PURE__ */ react_default.createElement("span", { className: "field-label font-weight-normal pl-1 text-3" }, text ?? "");
  }
  const indexMatch = text.search(RegExp(query, "i"));
  if (indexMatch > -1) {
    return /* @__PURE__ */ react_default.createElement("span", { className: "field-label font-weight-normal pl-1 text-3" }, text.substring(0, indexMatch), /* @__PURE__ */ react_default.createElement("mark", { className: "bg-transparent border-0 font-weight-bold p-0 shadow-none" }, text.substring(indexMatch, indexMatch + query.length)), text.substring(indexMatch + query.length));
  }
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, text);
};
var FieldSelectModalContent = ({
  closeModal,
  fieldTreeItems,
  onSaveButtonClick,
  saveButtonDisabled,
  selectedFields,
  selectionMode = "single"
}) => {
  const [initialFields, setInitialFields] = (0, react_exports.useState)(fieldTreeItems);
  const [selectedKeys, setSelectedKeys] = (0, react_exports.useState)(
    /* @__PURE__ */ new Set()
  );
  const [fields, setFields] = (0, react_exports.useState)(
    initialFields
  );
  const [query, setQuery] = (0, react_exports.useState)("");
  const [expandedKeys, setExpandedKeys] = (0, react_exports.useState)([]);
  (0, react_exports.useEffect)(() => {
    if (fields) {
      const [initialSelectedKeys, updatedFields] = initializeFields({
        fields,
        selectedFields
      });
      setSelectedKeys(initialSelectedKeys);
      setFields(updatedFields);
    }
  }, []);
  const onSearch = (query2) => {
    setQuery(query2);
    const { filteredItems, filteredKeys } = applyFilter({
      fields: initialFields ?? [],
      query: query2
    });
    setFields(filteredItems);
    setExpandedKeys(filteredKeys);
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, (0, frontend_js_web_exports.sub)(
    Liferay.Language.get("select-x"),
    Liferay.Language.get("field")
  )), /* @__PURE__ */ react_default.createElement(modal_default.Body, { className: "field-select-modal pt-0 px-0" }, fields === null ? /* @__PURE__ */ react_default.createElement(loading_indicator_default, null) : /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(management_toolbar_default, null, /* @__PURE__ */ react_default.createElement(
    management_toolbar_default.Search,
    {
      onSubmit: (event) => event.preventDefault()
    },
    /* @__PURE__ */ react_default.createElement(AutoSearch_default, { onSearch, query })
  )), selectedKeys.size > 0 && /* @__PURE__ */ react_default.createElement(management_toolbar_exports.ClayResultsBar, null, /* @__PURE__ */ react_default.createElement(management_toolbar_exports.ClayResultsBar.Item, { expand: true }, /* @__PURE__ */ react_default.createElement("span", { className: "component-text text-truncate-inline" }, /* @__PURE__ */ react_default.createElement("span", { className: "text-truncate" }, selectedKeys.size, "\xA0", selectedKeys.size === 1 ? Liferay.Language.get(
    "item-selected"
  ) : Liferay.Language.get(
    "items-selected"
  )))), /* @__PURE__ */ react_default.createElement(management_toolbar_exports.ClayResultsBar.Item, null, /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      className: "component-link tbar-link",
      displayType: "unstyled",
      onClick: () => {
        selectedKeys.clear();
        onSearch("");
      }
    },
    Liferay.Language.get("deselect-all")
  ))), /* @__PURE__ */ react_default.createElement(
    "div",
    {
      className: `container-fluid container-fluid-max-xl px-4 py-2 selection-mode-${selectionMode}`
    },
    /* @__PURE__ */ react_default.createElement(
      core_exports.TreeView,
      {
        className: "bg-light",
        expandedKeys: new Set(expandedKeys),
        items: fields,
        nestedKey: "children",
        onExpandedChange: (keys) => {
          setExpandedKeys(Array.from(keys));
        },
        onItemsChange: (items) => setInitialFields(
          items
        ),
        onSelectionChange: setSelectedKeys,
        selectedKeys,
        selectionMode,
        showExpanderOnHover: false
      },
      ({
        children,
        initialChildren,
        label,
        query: query2
      }) => /* @__PURE__ */ react_default.createElement(core_exports.TreeView.Item, null, selectionMode === "single" ? /* @__PURE__ */ react_default.createElement(
        core_exports.TreeView.ItemStack,
        {
          disabled: !!initialChildren?.length,
          expanderDisabled: false
        },
        /* @__PURE__ */ react_default.createElement(form_exports.ClayCheckbox, { checked: true }),
        /* @__PURE__ */ react_default.createElement(
          Highlight,
          {
            query: query2,
            text: label
          }
        )
      ) : /* @__PURE__ */ react_default.createElement(core_exports.TreeView.ItemStack, null, /* @__PURE__ */ react_default.createElement(form_exports.ClayCheckbox, { checked: true }, /* @__PURE__ */ react_default.createElement(
        Highlight,
        {
          query: query2,
          text: label
        }
      ))), /* @__PURE__ */ react_default.createElement(core_exports.TreeView.Group, { items: children }, ({ label: label2 }) => /* @__PURE__ */ react_default.createElement(core_exports.TreeView.Item, null, /* @__PURE__ */ react_default.createElement(form_exports.ClayCheckbox, { checked: true }, selectionMode === "multiple" && /* @__PURE__ */ react_default.createElement(
        Highlight,
        {
          query: query2,
          text: label2
        }
      )), selectionMode === "single" && /* @__PURE__ */ react_default.createElement(
        Highlight,
        {
          query: query2,
          text: label2
        }
      ))))
    )
  ))), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled,
          onClick: () => {
            const selectedFields2 = [];
            visit(
              initialFields || [],
              (field) => {
                if (selectedKeys.has(field.name)) {
                  selectedFields2.push({
                    ...field,
                    id: field.savedId
                  });
                }
              }
            );
            onSaveButtonClick({
              selectedFields: selectedFields2
            });
          }
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
var FieldSelectModalContent_default = FieldSelectModalContent;

// src/main/resources/META-INF/resources/js/data_set/visualization_modes/components/FieldAssignmentControls.tsx
function FieldAssignmentControls({
  field,
  label,
  onClearSelection,
  openSelectFieldModal
}) {
  return field ? /* @__PURE__ */ react_default.createElement(
    drop_down_exports.ClayDropDownWithItems,
    {
      items: [
        {
          label: Liferay.Language.get("change-assignment"),
          onClick: openSelectFieldModal,
          symbolLeft: "change"
        },
        {
          label: Liferay.Language.get("clear-assignment"),
          onClick: onClearSelection,
          symbolLeft: "times-circle"
        }
      ],
      trigger: /* @__PURE__ */ react_default.createElement(
        button_exports.ClayButtonWithIcon,
        {
          "aria-label": (0, frontend_js_web_exports.sub)(
            Liferay.Language.get("view-x-options"),
            label
          ),
          displayType: "secondary",
          size: "sm",
          symbol: "ellipsis-v",
          title: (0, frontend_js_web_exports.sub)(Liferay.Language.get("view-x-options"), label)
        }
      )
    }
  ) : /* @__PURE__ */ react_default.createElement(
    button_exports.ClayButtonWithIcon,
    {
      "aria-label": Liferay.Language.get("assign-field"),
      displayType: "secondary",
      onClick: openSelectFieldModal,
      symbol: "plus",
      title: Liferay.Language.get("assign-field")
    }
  );
}
var FieldAssignmentControls_default = FieldAssignmentControls;

// src/main/resources/META-INF/resources/js/data_set/visualization_modes/modes/Cards.tsx
function Cards(props) {
  const { dataSet, fieldTreeItems } = props;
  const [cardsSections, setCardsSections] = (0, react_exports.useState)([
    { fieldTreeItems, label: Liferay.Language.get("title"), name: "title" },
    {
      fieldTreeItems,
      label: Liferay.Language.get("description"),
      name: "description"
    },
    { fieldTreeItems, label: Liferay.Language.get("image"), name: "image" },
    { fieldTreeItems, label: Liferay.Language.get("symbol"), name: "symbol" }
  ]);
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const getFDSCardsSections = async () => {
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.CARDS_SECTIONS}?filter=(${OBJECT_RELATIONSHIP.DATA_SET_CARDS_SECTION_ERC} eq '${dataSet.externalReferenceCode}')`
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return null;
    }
    const responseJSON = await response.json();
    const fdsCardsSections = responseJSON?.items;
    if (!fdsCardsSections) {
      openDefaultFailureToast();
      return null;
    }
    setCardsSections(
      cardsSections.map((cardsSection) => {
        const fdsCardsSection = fdsCardsSections.find(
          (fdsCardsSection2) => fdsCardsSection2.name === cardsSection.name
        );
        if (!fdsCardsSection) {
          return {
            fieldTreeItems,
            label: cardsSection.label,
            name: cardsSection.name
          };
        }
        return {
          ...cardsSection,
          externalReferenceCode: fdsCardsSection.externalReferenceCode,
          field: {
            name: fdsCardsSection.fieldName
          }
        };
      })
    );
  };
  const clearFDSCardSection = async ({
    cardsSection,
    closeModal
  }) => {
    if (!cardsSection.externalReferenceCode) {
      if (closeModal) {
        closeModal();
      }
      return;
    }
    setSaveButtonDisabled(true);
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.CARDS_SECTIONS}/by-external-reference-code/${cardsSection.externalReferenceCode}`,
      { method: "DELETE" }
    );
    setSaveButtonDisabled(false);
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    if (closeModal) {
      closeModal();
    }
    setCardsSections(
      cardsSections.map((section) => {
        if (section.name !== cardsSection.name) {
          return section;
        }
        const nextCardSection = { ...cardsSection };
        delete nextCardSection.externalReferenceCode;
        delete nextCardSection.field;
        return nextCardSection;
      })
    );
    openDefaultFailureToast2();
  };
  const saveFDSCardsSection = async ({
    cardsSection,
    closeModal,
    field
  }) => {
    setSaveButtonDisabled(true);
    let method = "POST";
    let url = API_URL.CARDS_SECTIONS;
    if (cardsSection.externalReferenceCode) {
      method = "PATCH";
      url = `${API_URL.CARDS_SECTIONS}/by-external-reference-code/${cardsSection.externalReferenceCode}`;
    }
    const response = await (0, frontend_js_web_exports.fetch)(url, {
      body: JSON.stringify({
        [OBJECT_RELATIONSHIP.DATA_SET_CARDS_SECTION_ERC]: dataSet.externalReferenceCode,
        fieldName: field.name,
        name: cardsSection.name
      }),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method
    });
    setSaveButtonDisabled(false);
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const fdsCardSection = await response.json();
    closeModal();
    setCardsSections(
      cardsSections.map((cardSection) => {
        if (cardSection.name !== fdsCardSection.name) {
          return cardSection;
        }
        return {
          ...cardSection,
          externalReferenceCode: fdsCardSection.externalReferenceCode,
          field: {
            name: fdsCardSection.fieldName
          }
        };
      })
    );
    openDefaultFailureToast2();
  };
  (0, react_exports.useEffect)(() => {
    getFDSCardsSections();
  }, []);
  return /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, { className: "c-gap-4 cards-visualization-mode" }, /* @__PURE__ */ react_default.createElement(
    alert_default,
    {
      displayType: "info",
      title: `${Liferay.Language.get("info")}:`,
      variant: "stripe"
    },
    Liferay.Language.get(
      "this-visualization-mode-will-not-be-shown-until-you-assign-at-least-one-field-to-a-card-element"
    )
  ), /* @__PURE__ */ react_default.createElement(table_default, { className: "mb-0" }, /* @__PURE__ */ react_default.createElement(table_default.Head, null, /* @__PURE__ */ react_default.createElement(table_default.Row, null, /* @__PURE__ */ react_default.createElement(
    table_default.Cell,
    {
      className: "cards-section-label",
      headingCell: true
    },
    Liferay.Language.get("card-element")
  ), /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "field-name", headingCell: true }, Liferay.Language.get("field")))), /* @__PURE__ */ react_default.createElement(table_default.Body, null, cardsSections.map((cardsSection) => /* @__PURE__ */ react_default.createElement(
    CardsSection,
    {
      cardsSection,
      key: cardsSection.name,
      modalProps: props,
      onClearSelection: () => {
        clearFDSCardSection({ cardsSection });
      },
      onSelect: ({ closeModal, selectedField }) => {
        selectedField ? saveFDSCardsSection({
          cardsSection,
          closeModal,
          field: selectedField
        }) : clearFDSCardSection({
          cardsSection,
          closeModal
        });
      },
      saveButtonDisabled
    }
  )))));
}
function CardsSection({
  cardsSection,
  modalProps,
  onClearSelection,
  onSelect,
  saveButtonDisabled
}) {
  const { field, fieldTreeItems, label } = cardsSection;
  const openSelectFieldModal = () => {
    (0, frontend_js_web_exports.openModal)({
      contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
        FieldSelectModalContent_default,
        {
          ...modalProps,
          closeModal,
          fieldTreeItems,
          onSaveButtonClick: ({
            selectedFields
          }) => {
            onSelect({
              closeModal,
              selectedField: selectedFields[0]
            });
          },
          saveButtonDisabled,
          selectedFields: field ? [field] : []
        }
      ),
      size: "full-screen"
    });
  };
  return /* @__PURE__ */ react_default.createElement(table_default.Row, null, /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "cards-section-label" }, /* @__PURE__ */ react_default.createElement("strong", null, label)), /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "field-name" }, /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.Group, { small: true }, /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupItem, null, /* @__PURE__ */ react_default.createElement(
    "p",
    {
      className: classnames_default(
        "align-items-center d-flex mb-0",
        { "text-secondary": !field }
      )
    },
    field ? field.label || field.name : Liferay.Language.get("not-assigned")
  )), /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupItem, { shrink: true }, /* @__PURE__ */ react_default.createElement(
    FieldAssignmentControls_default,
    {
      field,
      label,
      onClearSelection,
      openSelectFieldModal
    }
  )))));
}

// src/main/resources/META-INF/resources/css/ListVisualizationMode.scss
var link6 = document.createElement("link");
link6.setAttribute("rel", "stylesheet");
link6.setAttribute("type", "text/css");
link6.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/ListVisualizationMode.css"
);
document.querySelector("head").appendChild(link6);

// src/main/resources/META-INF/resources/js/data_set/visualization_modes/modes/List.tsx
function List(props) {
  const { dataSet, fieldTreeItems } = props;
  const [listSections, setListSections] = (0, react_exports.useState)([
    { fieldTreeItems, label: Liferay.Language.get("title"), name: "title" },
    {
      fieldTreeItems,
      label: Liferay.Language.get("description"),
      name: "description"
    },
    { fieldTreeItems, label: Liferay.Language.get("image"), name: "image" },
    { fieldTreeItems, label: Liferay.Language.get("symbol"), name: "symbol" }
  ]);
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const getFDSListSections = async () => {
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.LIST_SECTIONS}?filter=(${OBJECT_RELATIONSHIP.DATA_SET_LIST_SECTION_ERC} eq '${dataSet.externalReferenceCode}')`
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return null;
    }
    const responseJSON = await response.json();
    const fdsListSections = responseJSON?.items;
    if (!fdsListSections) {
      openDefaultFailureToast();
      return null;
    }
    setListSections(
      listSections.map((listSection) => {
        const fdsListSection = fdsListSections.find(
          (fdsListSection2) => fdsListSection2.name === listSection.name
        );
        if (!fdsListSection) {
          return {
            fieldTreeItems,
            label: listSection.label,
            name: listSection.name
          };
        }
        return {
          ...listSection,
          externalReferenceCode: fdsListSection.externalReferenceCode,
          field: {
            name: fdsListSection.fieldName
          }
        };
      })
    );
  };
  const clearFDSListSection = async ({
    closeModal,
    listSection
  }) => {
    if (!listSection.externalReferenceCode) {
      if (closeModal) {
        closeModal();
      }
      return;
    }
    setSaveButtonDisabled(true);
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.LIST_SECTIONS}/by-external-reference-code/${listSection.externalReferenceCode}`,
      { method: "DELETE" }
    );
    setSaveButtonDisabled(false);
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    if (closeModal) {
      closeModal();
    }
    setListSections(
      listSections.map((section) => {
        if (section.name !== listSection.name) {
          return section;
        }
        const nextListSection = { ...listSection };
        delete nextListSection.externalReferenceCode;
        delete nextListSection.field;
        return nextListSection;
      })
    );
    openDefaultFailureToast2();
  };
  const saveFDSListSection = async ({
    closeModal,
    field,
    listSection
  }) => {
    setSaveButtonDisabled(true);
    let method = "POST";
    let url = API_URL.LIST_SECTIONS;
    if (listSection.externalReferenceCode) {
      method = "PATCH";
      url = `${API_URL.LIST_SECTIONS}/by-external-reference-code/${listSection.externalReferenceCode}`;
    }
    const response = await (0, frontend_js_web_exports.fetch)(url, {
      body: JSON.stringify({
        [OBJECT_RELATIONSHIP.DATA_SET_LIST_SECTION_ERC]: dataSet.externalReferenceCode,
        fieldName: field.name,
        name: listSection.name
      }),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method
    });
    setSaveButtonDisabled(false);
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const fdsListSection = await response.json();
    closeModal();
    setListSections(
      listSections.map((listSection2) => {
        if (listSection2.name !== fdsListSection.name) {
          return listSection2;
        }
        return {
          ...listSection2,
          externalReferenceCode: fdsListSection.externalReferenceCode,
          field: {
            name: fdsListSection.fieldName
          }
        };
      })
    );
    openDefaultFailureToast2();
  };
  (0, react_exports.useEffect)(() => {
    getFDSListSections();
  }, []);
  return /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, { className: "c-gap-4 list-visualization-mode" }, /* @__PURE__ */ react_default.createElement(
    alert_default,
    {
      displayType: "info",
      title: `${Liferay.Language.get("info")}:`,
      variant: "stripe"
    },
    Liferay.Language.get(
      "this-visualization-mode-will-not-be-shown-until-you-assign-at-least-one-field-to-a-list-element"
    )
  ), /* @__PURE__ */ react_default.createElement(table_default, { className: "mb-0" }, /* @__PURE__ */ react_default.createElement(table_default.Head, null, /* @__PURE__ */ react_default.createElement(table_default.Row, null, /* @__PURE__ */ react_default.createElement(
    table_default.Cell,
    {
      className: "list-section-label",
      headingCell: true
    },
    Liferay.Language.get("list-element")
  ), /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "field-name", headingCell: true }, Liferay.Language.get("field")))), /* @__PURE__ */ react_default.createElement(table_default.Body, null, listSections.map((listSection) => /* @__PURE__ */ react_default.createElement(
    ListSection,
    {
      key: listSection.name,
      listSection,
      modalProps: props,
      onClearSelection: () => {
        clearFDSListSection({ listSection });
      },
      onSelect: ({ closeModal, selectedField }) => {
        selectedField ? saveFDSListSection({
          closeModal,
          field: selectedField,
          listSection
        }) : clearFDSListSection({
          closeModal,
          listSection
        });
      },
      saveButtonDisabled
    }
  )))));
}
function ListSection({
  listSection,
  modalProps,
  onClearSelection,
  onSelect,
  saveButtonDisabled
}) {
  const { field, fieldTreeItems, label } = listSection;
  const openSelectFieldModal = () => {
    (0, frontend_js_web_exports.openModal)({
      contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
        FieldSelectModalContent_default,
        {
          ...modalProps,
          closeModal,
          fieldTreeItems,
          onSaveButtonClick: ({
            selectedFields
          }) => {
            onSelect({
              closeModal,
              selectedField: selectedFields[0]
            });
          },
          saveButtonDisabled,
          selectedFields: field ? [field] : []
        }
      ),
      size: "full-screen"
    });
  };
  return /* @__PURE__ */ react_default.createElement(table_default.Row, null, /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "list-section-label" }, /* @__PURE__ */ react_default.createElement("strong", null, label)), /* @__PURE__ */ react_default.createElement(table_default.Cell, { className: "field-name" }, /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.Group, { small: true }, /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupItem, null, /* @__PURE__ */ react_default.createElement(
    "p",
    {
      className: classnames_default(
        "align-items-center d-flex mb-0",
        { "text-secondary": !field }
      )
    },
    field ? field.label || field.name : Liferay.Language.get("not-assigned")
  )), /* @__PURE__ */ react_default.createElement(form_exports.ClayInput.GroupItem, { shrink: true }, /* @__PURE__ */ react_default.createElement(
    FieldAssignmentControls_default,
    {
      field,
      label,
      onClearSelection,
      openSelectFieldModal
    }
  )))));
}

// src/main/resources/META-INF/resources/css/TableVisualizationMode.scss
var link7 = document.createElement("link");
link7.setAttribute("rel", "stylesheet");
link7.setAttribute("type", "text/css");
link7.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/TableVisualizationMode.css"
);
document.querySelector("head").appendChild(link7);

// src/main/resources/META-INF/resources/js/data_set/visualization_modes/modes/Table.tsx
var defaultLanguageId = Liferay.ThemeDisplay.getDefaultLanguageId();
var getRendererLabel = ({
  cetRenderers = [],
  rendererName
}) => {
  let clientExtensionRenderer;
  const internalRenderer = frontend_data_set_web_exports.FDS_INTERNAL_CELL_RENDERERS.find(
    (renderer) => {
      return renderer.name === rendererName;
    }
  );
  if (internalRenderer?.label) {
    return internalRenderer.label;
  } else {
    clientExtensionRenderer = cetRenderers.find(
      (renderer) => {
        return renderer.externalReferenceCode === rendererName;
      }
    );
    if (clientExtensionRenderer?.name) {
      return clientExtensionRenderer.name;
    }
    return rendererName;
  }
};
var RendererLabelCellRendererComponent = ({
  cetRenderers = [],
  item,
  query
}) => {
  const itemFieldValue = getRendererLabel({
    cetRenderers,
    rendererName: item.renderer
  });
  const fuzzyMatch = fuzzy_default.match(query, itemFieldValue, FUZZY_OPTIONS);
  return /* @__PURE__ */ react_default.createElement("span", null, fuzzyMatch ? /* @__PURE__ */ react_default.createElement(
    "span",
    {
      dangerouslySetInnerHTML: {
        __html: fuzzyMatch.rendered
      }
    }
  ) : /* @__PURE__ */ react_default.createElement("span", null, itemFieldValue));
};
var EditFDSFieldModalContent = ({
  closeModal,
  fdsClientExtensionCellRenderers,
  fdsField,
  namespace,
  onSaveButtonClick,
  sortable
}) => {
  const [selectedFDSFieldRenderer, setSelectedFDSFieldRenderer] = (0, react_exports.useState)(
    fdsField.renderer ?? "default"
  );
  const [fdsFieldSortable, setFSDFieldSortable] = (0, react_exports.useState)(
    fdsField.sortable
  );
  const fdsInternalCellRendererNames = frontend_data_set_web_exports.FDS_INTERNAL_CELL_RENDERERS.map(
    (cellRenderer) => cellRenderer.name
  );
  const fdsFieldTranslations = fdsField.label_i18n;
  const [i18nFieldLabels, setI18nFieldLabels] = (0, react_exports.useState)(fdsFieldTranslations);
  const editFDSField = async () => {
    const body = {
      label_i18n: i18nFieldLabels,
      renderer: selectedFDSFieldRenderer,
      rendererType: !fdsInternalCellRendererNames.includes(
        selectedFDSFieldRenderer
      ) ? "clientExtension" : "internal",
      sortable: fdsFieldSortable
    };
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.TABLE_SECTIONS}/by-external-reference-code/${fdsField.externalReferenceCode}`,
      {
        body: JSON.stringify(body),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const editedFDSField = await response.json();
    closeModal();
    onSaveButtonClick({ editedFDSField });
    openDefaultFailureToast2();
  };
  const fdsFieldNameInputId = `${namespace}fdsFieldNameInput`;
  const fdsFieldLabelInputId = `${namespace}fdsFieldLabelInput`;
  const fdsFieldRendererSelectId = `${namespace}fdsFieldRendererSelectId`;
  const options = frontend_data_set_web_exports.FDS_INTERNAL_CELL_RENDERERS.map(
    (renderer) => ({
      label: renderer.label,
      value: renderer.name
    })
  );
  options.push(
    ...fdsClientExtensionCellRenderers.map((item) => ({
      label: item.name,
      value: item.externalReferenceCode
    }))
  );
  const CellRendererDropdown = ({
    cellRenderers,
    namespace: namespace2,
    onItemClick
  }) => {
    const fdsClientExtensionCellRenderersERCs = fdsClientExtensionCellRenderers.map(
      (cellRendererCET) => cellRendererCET.externalReferenceCode
    );
    return /* @__PURE__ */ react_default.createElement(
      drop_down_default,
      {
        menuElementAttrs: {
          className: "fds-cell-renderers-dropdown-menu"
        },
        trigger: /* @__PURE__ */ react_default.createElement(
          button_default,
          {
            "aria-labelledby": `${namespace2}cellRenderersLabel`,
            className: "form-control form-control-select form-control-select-secondary",
            displayType: "secondary",
            id: fdsFieldRendererSelectId
          },
          selectedFDSFieldRenderer ? getRendererLabel({
            cetRenderers: fdsClientExtensionCellRenderers,
            rendererName: selectedFDSFieldRenderer
          }) : Liferay.Language.get("choose-an-option")
        )
      },
      /* @__PURE__ */ react_default.createElement(drop_down_default.ItemList, { items: cellRenderers, role: "listbox" }, cellRenderers.map((cellRenderer) => /* @__PURE__ */ react_default.createElement(
        drop_down_default.Item,
        {
          className: "align-items-center d-flex justify-content-between",
          key: cellRenderer.value,
          onClick: () => onItemClick(cellRenderer.value),
          roleItem: "option"
        },
        cellRenderer.label,
        fdsClientExtensionCellRenderersERCs.includes(
          cellRenderer.value
        ) && /* @__PURE__ */ react_default.createElement(label_default, { displayType: "info" }, Liferay.Language.get("client-extension"))
      )))
    );
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, Liferay.Util.sub(
    Liferay.Language.get("edit-x"),
    fdsField.label_i18n[defaultLanguageId] ?? fdsField.name
  )), /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: fdsFieldNameInputId }, Liferay.Language.get("name")), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayInput,
    {
      disabled: true,
      id: fdsFieldNameInputId,
      type: "text",
      value: fdsField.name
    }
  )), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.InputLocalized,
    {
      id: fdsFieldLabelInputId,
      label: Liferay.Language.get("label"),
      name: "label",
      onChange: setI18nFieldLabels,
      translations: i18nFieldLabels
    }
  )), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: fdsFieldRendererSelectId }, Liferay.Language.get("renderer")), /* @__PURE__ */ react_default.createElement(
    CellRendererDropdown,
    {
      cellRenderers: options,
      namespace,
      onItemClick: (item) => setSelectedFDSFieldRenderer(item)
    }
  )), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement(
    form_exports.ClayCheckbox,
    {
      checked: fdsFieldSortable,
      disabled: !sortable,
      inline: true,
      label: Liferay.Language.get("sortable"),
      onChange: ({ target: { checked } }) => setFSDFieldSortable(checked)
    }
  ), fdsField.type !== "object" /* OBJECT */ && /* @__PURE__ */ react_default.createElement(
    "span",
    {
      className: "label-icon lfr-portal-tooltip ml-2",
      title: Liferay.Language.get(
        "if-checked,-data-set-items-can-be-sorted-by-this-field"
      )
    },
    /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "question-circle-full" })
  ))), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(button_default, { onClick: () => editFDSField() }, Liferay.Language.get("save")), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
function Table2(props) {
  const {
    dataSet,
    fdsClientExtensionCellRenderers,
    fieldTreeItems,
    namespace,
    saveFDSFieldsURL,
    title
  } = props;
  const [fdsFields, setFDSFields] = (0, react_exports.useState)(null);
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const getFDSFields = async () => {
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.TABLE_SECTIONS}?filter=(${OBJECT_RELATIONSHIP.DATA_SET_TABLE_SECTION_ID} eq '${dataSet.id}')&nestedFields=${OBJECT_RELATIONSHIP.DATA_SET_TABLE_SECTION}&sort=dateCreated:asc`
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return null;
    }
    const responseJSON = await response.json();
    const storedFDSFields = responseJSON?.items;
    if (!storedFDSFields) {
      openDefaultFailureToast();
      return null;
    }
    const fdsFieldsOrder = (
      // @ts-ignore
      storedFDSFields?.[0]?.[OBJECT_RELATIONSHIP.DATA_SET_TABLE_SECTION]?.fdsFieldsOrder
    );
    setFDSFields(sortItems(storedFDSFields, fdsFieldsOrder));
  };
  const onDeleteButtonClick = ({ item }) => {
    (0, frontend_js_web_exports.openModal)({
      bodyHTML: Liferay.Language.get(
        "are-you-sure-you-want-to-delete-this-field?-fragments-using-it-will-be-affected"
      ),
      buttons: [
        {
          autoFocus: true,
          displayType: "secondary",
          label: Liferay.Language.get("cancel"),
          type: "cancel"
        },
        {
          displayType: "warning",
          label: Liferay.Language.get("delete"),
          onClick: async ({
            processClose
          }) => {
            processClose();
            const url = `${API_URL.TABLE_SECTIONS}/${item.id}`;
            const response = await (0, frontend_js_web_exports.fetch)(url, { method: "DELETE" });
            if (!response.ok) {
              openDefaultFailureToast();
              return;
            }
            openDefaultFailureToast2();
            setFDSFields(
              fdsFields?.filter(
                (fdsField) => fdsField.id !== item.id
              ) || []
            );
          }
        }
      ],
      status: "warning",
      title: Liferay.Language.get("delete-filter")
    });
  };
  const saveFDSFields = async ({
    closeModal,
    fields
  }) => {
    setSaveButtonDisabled(true);
    const creationData = [];
    const deletionIds = [];
    fields.forEach((field) => {
      if (!field.id) {
        creationData.push({
          name: field.name,
          sortable: field.sortable || false,
          type: field.type || "string"
        });
      }
    });
    fdsFields?.forEach((fdsField) => {
      if (!fields.find((field) => field.name === fdsField.name)) {
        deletionIds.push(fdsField.id);
      }
    });
    const formData = new FormData();
    formData.append(
      `${namespace}creationData`,
      JSON.stringify(creationData)
    );
    deletionIds.forEach((id) => {
      formData.append(`${namespace}deletionIds`, String(id));
    });
    formData.append(`${namespace}dataSetId`, dataSet.id);
    const response = await (0, frontend_js_web_exports.fetch)(saveFDSFieldsURL, {
      body: formData,
      method: "POST"
    });
    setSaveButtonDisabled(false);
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const createdFDSFields = await response.json();
    closeModal();
    const newFDSFields = [];
    fdsFields?.forEach((fdsField) => {
      if (!deletionIds.includes(fdsField.id)) {
        newFDSFields.push(fdsField);
      }
    });
    createdFDSFields.forEach((fdsField) => {
      newFDSFields.push(fdsField);
    });
    setFDSFields(newFDSFields);
    openDefaultFailureToast2();
  };
  const updateFDSFieldsOrder = async ({
    fdsFieldsOrder
  }) => {
    const body = {
      fdsFieldsOrder
    };
    const response = await (0, frontend_js_web_exports.fetch)(
      `${API_URL.DATA_SETS}/by-external-reference-code/${dataSet.externalReferenceCode}`,
      {
        body: JSON.stringify(body),
        headers: {
          "Accept": "application/json",
          "Content-Type": "application/json"
        },
        method: "PATCH"
      }
    );
    if (!response.ok) {
      openDefaultFailureToast();
      return null;
    }
    const responseJSON = await response.json();
    const storedFDSFieldsOrder = responseJSON?.fdsFieldsOrder;
    if (fdsFields && storedFDSFieldsOrder && storedFDSFieldsOrder === fdsFieldsOrder) {
      setFDSFields(
        sortItems(fdsFields, storedFDSFieldsOrder)
      );
      openDefaultFailureToast2();
    } else {
      openDefaultFailureToast();
    }
  };
  (0, react_exports.useEffect)(() => {
    getFDSFields();
  }, []);
  const onCreationButtonClick = () => {
    (0, frontend_js_web_exports.openModal)({
      contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
        FieldSelectModalContent_default,
        {
          ...props,
          closeModal,
          fieldTreeItems,
          onSaveButtonClick: ({
            selectedFields
          }) => {
            saveFDSFields({ closeModal, fields: selectedFields });
          },
          saveButtonDisabled,
          selectedFields: fdsFields ? fdsFields.map((fdsField) => ({
            id: String(fdsField.id),
            name: fdsField.name
          })) : [],
          selectionMode: "multiple"
        }
      ),
      size: "full-screen"
    });
  };
  const onEditButtonClick = ({ item }) => {
    (0, frontend_js_web_exports.openModal)({
      className: "overflow-auto",
      contentComponent: ({ closeModal }) => /* @__PURE__ */ react_default.createElement(
        EditFDSFieldModalContent,
        {
          closeModal,
          fdsClientExtensionCellRenderers,
          fdsField: item,
          namespace,
          onSaveButtonClick: ({
            editedFDSField
          }) => {
            setFDSFields(
              fdsFields?.map((fdsField) => {
                if (fdsField.name === editedFDSField.name) {
                  return editedFDSField;
                }
                return fdsField;
              }) || null
            );
          },
          sortable: isSortable(fieldTreeItems, item)
        }
      )
    });
  };
  return fdsFields ? /* @__PURE__ */ react_default.createElement(layout_default.ContentCol, { className: "c-gap-4 table-visualization-mode" }, /* @__PURE__ */ react_default.createElement(
    alert_default,
    {
      displayType: "info",
      title: `${Liferay.Language.get("info")}:`,
      variant: "stripe"
    },
    Liferay.Language.get(
      "this-visualization-mode-will-not-be-shown-until-you-assign-at-least-one-field"
    )
  ), /* @__PURE__ */ react_default.createElement(
    OrderableTable_default,
    {
      actions: [
        {
          icon: "pencil",
          label: Liferay.Language.get("edit"),
          onClick: onEditButtonClick
        },
        {
          icon: "trash",
          label: Liferay.Language.get("delete"),
          onClick: onDeleteButtonClick
        }
      ],
      creationMenuItems: [
        {
          label: Liferay.Language.get("add-fields"),
          onClick: onCreationButtonClick
        }
      ],
      fields: [
        {
          label: Liferay.Language.get("name"),
          name: "name"
        },
        {
          label: Liferay.Language.get("label"),
          name: "label"
        },
        {
          label: Liferay.Language.get("type"),
          name: "type"
        },
        {
          contentRenderer: {
            component: ({ item, query }) => /* @__PURE__ */ react_default.createElement(
              RendererLabelCellRendererComponent,
              {
                cetRenderers: fdsClientExtensionCellRenderers,
                item,
                query
              }
            ),
            textMatch: (item) => getRendererLabel({
              cetRenderers: fdsClientExtensionCellRenderers,
              rendererName: item.renderer
            })
          },
          label: Liferay.Language.get("renderer"),
          name: "renderer"
        },
        {
          label: Liferay.Language.get("sortable"),
          name: "sortable"
        }
      ],
      items: fdsFields,
      noItemsButtonLabel: Liferay.Language.get("add-fields"),
      noItemsDescription: Liferay.Language.get(
        "add-fields-to-show-in-your-view"
      ),
      noItemsTitle: Liferay.Language.get("no-fields-added-yet"),
      onOrderChange: ({ order }) => {
        updateFDSFieldsOrder({
          fdsFieldsOrder: order
        });
      },
      title
    }
  )) : /* @__PURE__ */ react_default.createElement(loading_indicator_default, null);
}
function isSortable(fieldTreeItems, selectedItem) {
  let isSortable2 = false;
  visit(fieldTreeItems, (fieldTreeItem) => {
    if (fieldTreeItem.name === selectedItem.name) {
      isSortable2 = fieldTreeItem.sortable || false;
      return;
    }
  });
  return isSortable2;
}
var Table_default = Table2;

// src/main/resources/META-INF/resources/js/data_set/visualization_modes/VisualizationModes.tsx
var VISUALIZATION_MODE_COMPONENT_MAP = {
  cards: Cards,
  list: List,
  table: Table_default
};
var ORDERED_DEFAULT_VISUALIZATION_MODES = [
  ...DEFAULT_VISUALIZATION_MODES
].reverse();
function VisualizationModes(props) {
  const [activeVisualizationModeIndex, setActiveVisualizationModeIndex] = (0, react_exports.useState)(0);
  return /* @__PURE__ */ react_default.createElement(layout_default.ContainerFluid, { className: "mt-3 visualization-modes" }, /* @__PURE__ */ react_default.createElement(layout_default.Sheet, null, /* @__PURE__ */ react_default.createElement(layout_default.SheetHeader, { className: "mb-4" }, /* @__PURE__ */ react_default.createElement("h2", { className: "mb-0" }, Liferay.Language.get("visualization-modes"))), /* @__PURE__ */ react_default.createElement(
    tabs_default,
    {
      activation: "automatic",
      active: activeVisualizationModeIndex,
      onActiveChange: setActiveVisualizationModeIndex
    },
    ORDERED_DEFAULT_VISUALIZATION_MODES.map(
      (visualizationMode) => /* @__PURE__ */ react_default.createElement(
        tabs_default.Item,
        {
          key: visualizationMode.visualizationModeId
        },
        visualizationMode.label
      )
    )
  ), /* @__PURE__ */ react_default.createElement(tabs_default.Content, { active: activeVisualizationModeIndex, fade: true }, ORDERED_DEFAULT_VISUALIZATION_MODES.map(
    (visualizationMode) => {
      const Component = VISUALIZATION_MODE_COMPONENT_MAP[visualizationMode.mode];
      return /* @__PURE__ */ react_default.createElement(
        tabs_default.TabPane,
        {
          className: "px-0",
          key: visualizationMode.visualizationModeId
        },
        /* @__PURE__ */ react_default.createElement(Component, { ...props })
      );
    }
  ))));
}

// src/main/resources/META-INF/resources/js/data_set/DataSet.tsx
var NAVIGATION_BAR_ITEMS = [
  {
    Component: Details_default,
    label: Liferay.Language.get("details")
  },
  {
    Component: VisualizationModes,
    label: Liferay.Language.get("visualization-modes")
  },
  {
    Component: Filters_default,
    label: Liferay.Language.get("filters")
  },
  Liferay.FeatureFlags["LPD-19465"] ? {
    Component: Sorting_default,
    label: Liferay.Language.get("sorting")
  } : {
    Component: SortingDeprecated_default,
    label: Liferay.Language.get("sorting")
  },
  {
    Component: Actions_default,
    label: Liferay.Language.get("actions")
  },
  {
    Component: Pagination_default,
    label: Liferay.Language.get("pagination")
  },
  {
    Component: Settings_default,
    label: Liferay.Language.get("settings")
  }
];
var DataSet = ({
  backURL,
  dataSetERC,
  fdsClientExtensionCellRenderers,
  fdsFilterClientExtensions,
  fdsViewId,
  namespace,
  restApplications,
  saveFDSFieldsURL,
  spritemap
}) => {
  const [activeIndex, setActiveIndex] = (0, react_exports.useState)(0);
  const [dataSet, setDataSet] = (0, react_exports.useState)();
  const [fieldTreeItems, setFieldTreeItems] = (0, react_exports.useState)(
    []
  );
  const [loading, setLoading] = (0, react_exports.useState)(true);
  (0, react_exports.useEffect)(() => {
    const getDataSet = async () => {
      const url = Liferay.FeatureFlags["LPD-15729"] ? `${API_URL.DATA_SETS}/by-external-reference-code/${dataSetERC}` : `${API_URL.DATA_SETS}/${fdsViewId}?nestedFields=${OBJECT_RELATIONSHIP.FDS_ENTRY_FDS_VIEW}`;
      const response = await (0, frontend_js_web_exports.fetch)(url, {
        headers: {
          Accept: "application/json"
        }
      });
      const responseJSON = await response.json();
      if (responseJSON?.id) {
        setDataSet(responseJSON);
        const { restApplication, restSchema } = Liferay.FeatureFlags["LPD-15729"] ? responseJSON : responseJSON[OBJECT_RELATIONSHIP.FDS_ENTRY_FDS_VIEW];
        getFields({ restApplication, restSchema }).then((fields) => {
          setFieldTreeItems(fields);
          setLoading(false);
        });
      } else {
        openDefaultFailureToast();
      }
    };
    getDataSet();
  }, [dataSetERC, fdsViewId]);
  const Content = NAVIGATION_BAR_ITEMS[activeIndex].Component;
  return /* @__PURE__ */ react_default.createElement("div", { className: "cadmin fds-view" }, /* @__PURE__ */ react_default.createElement(
    navigation_bar_default,
    {
      triggerLabel: NAVIGATION_BAR_ITEMS[activeIndex].label
    },
    NAVIGATION_BAR_ITEMS.map((item, index) => /* @__PURE__ */ react_default.createElement(
      navigation_bar_default.Item,
      {
        active: index === activeIndex,
        key: index
      },
      /* @__PURE__ */ react_default.createElement(button_default, { onClick: () => setActiveIndex(index) }, item.label)
    ))
  ), loading ? /* @__PURE__ */ react_default.createElement(loading_indicator_default, null) : dataSet && /* @__PURE__ */ react_default.createElement(
    Content,
    {
      backURL,
      dataSet,
      fdsClientExtensionCellRenderers,
      fdsFilterClientExtensions,
      fieldTreeItems,
      namespace,
      onActiveSectionChange: (tab) => setActiveIndex(tab),
      onDataSetUpdate: (updatedDataSet) => {
        setDataSet({ ...dataSet, ...updatedDataSet });
      },
      restApplications,
      saveFDSFieldsURL,
      spritemap
    }
  ));
};
var DataSet_default = DataSet;

// src/main/resources/META-INF/resources/css/DataSets.scss
var link8 = document.createElement("link");
link8.setAttribute("rel", "stylesheet");
link8.setAttribute("type", "text/css");
link8.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/DataSets.css"
);
document.querySelector("head").appendChild(link8);

// src/main/resources/META-INF/resources/js/DataSets.tsx
var LIST_OF_ITEMS_PER_PAGE = "4, 8, 20, 40, 60";
var DEFAULT_ITEMS_PER_PAGE = 20;
var LabelInput = ({
  labelValidationError,
  namespace,
  onBlur,
  onChange,
  value
}) => /* @__PURE__ */ react_default.createElement(
  form_default.Group,
  {
    className: classnames_default({
      "has-error": labelValidationError
    })
  },
  /* @__PURE__ */ react_default.createElement("label", { htmlFor: `${namespace}labelInput` }, Liferay.Language.get("name"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)),
  /* @__PURE__ */ react_default.createElement(
    form_exports.ClayInput,
    {
      id: `${namespace}labelInput`,
      onBlur,
      onChange: (event) => onChange(event.target.value),
      type: "text",
      value
    }
  ),
  labelValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
);
var NewDataSetModalContent = ({
  closeModal,
  loadData,
  namespace,
  restApplications
}) => {
  const [label, setLabel] = (0, react_exports.useState)("");
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [labelValidationError, setLabelValidationError] = (0, react_exports.useState)(false);
  const [
    requiredRESTApplicationValidationError,
    setRequiredRESTApplicationValidationError
  ] = (0, react_exports.useState)(false);
  const [
    noEnpointsRESTApplicationValidationError,
    setNoEnpointsRESTApplicationValidationError
  ] = (0, react_exports.useState)(false);
  const [restSchemaValidationError, setRESTSchemaValidationError] = (0, react_exports.useState)(false);
  const [restEndpointValidationError, setRESTEndpointValidationError] = (0, react_exports.useState)(false);
  const [restSchemaEndpoints, setRESTSchemaEndpoints] = (0, react_exports.useState)(/* @__PURE__ */ new Map());
  const [selectedRESTApplication, setSelectedRESTApplication] = (0, react_exports.useState)();
  const [selectedRESTSchema, setSelectedRESTSchema] = (0, react_exports.useState)();
  const [selectedRESTEndpoint, setSelectedRESTEndpoint] = (0, react_exports.useState)();
  const saveDataSet = async () => {
    if (!selectedRESTApplication) {
      return;
    }
    selectedRESTApplication;
    const body = {
      defaultItemsPerPage: DEFAULT_ITEMS_PER_PAGE,
      label,
      listOfItemsPerPage: LIST_OF_ITEMS_PER_PAGE,
      restApplication: selectedRESTApplication,
      restEndpoint: selectedRESTEndpoint,
      restSchema: selectedRESTSchema
    };
    const response = await (0, frontend_js_web_exports.fetch)(API_URL.DATA_SETS, {
      body: JSON.stringify(body),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method: "POST"
    });
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const dataSet = await response.json();
    if (dataSet?.id) {
      closeModal();
      openDefaultFailureToast2();
      loadData();
    } else {
      setSaveButtonDisabled(false);
      openDefaultFailureToast();
    }
  };
  const isPathValid = (path, allowedParameters) => {
    const paramsMatcher = RegExp("{(.*?)}", "g");
    let matches;
    while ((matches = paramsMatcher.exec(path)) !== null) {
      if (!allowedParameters.includes(matches[1])) {
        return false;
      }
    }
    return true;
  };
  const getRESTSchemas = async (restApplication) => {
    if (!restApplication) {
      return;
    }
    const response = await (0, frontend_js_web_exports.fetch)(`/o${restApplication}/openapi.json`);
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJson = await response.json();
    const paths = Object.keys(responseJson.paths ?? []);
    const schemaNames = Object.keys(responseJson.components?.schemas ?? []);
    const schemaEndpoints = /* @__PURE__ */ new Map();
    schemaNames.forEach((schemaName) => {
      paths.forEach((path) => {
        if (!isPathValid(path, ALLOWED_ENDPOINTS_PARAMETERS)) {
          return;
        }
        if (responseJson.paths[path]?.get?.responses.default.content["application/json"]?.schema?.$ref?.endsWith(`/Page${schemaName}`)) {
          const endpoints = schemaEndpoints.get(schemaName) ?? [];
          endpoints.push(path);
          if (endpoints.length === 1) {
            schemaEndpoints.set(schemaName, endpoints);
          }
        }
      });
    });
    if (schemaEndpoints.size === 0) {
      setSelectedRESTSchema(null);
      setSelectedRESTEndpoint(null);
      setNoEnpointsRESTApplicationValidationError(true);
    } else if (schemaEndpoints.size === 1) {
      const schema = schemaEndpoints.keys().next().value;
      setSelectedRESTSchema(schema);
      const paths2 = schemaEndpoints.get(schema);
      if (paths2?.length === 1) {
        setSelectedRESTEndpoint(paths2[0]);
      }
      setNoEnpointsRESTApplicationValidationError(false);
    } else {
      setSelectedRESTSchema(null);
      setSelectedRESTEndpoint(null);
      setNoEnpointsRESTApplicationValidationError(false);
    }
    setRESTSchemaEndpoints(schemaEndpoints);
  };
  const validate = () => {
    if (!label) {
      setLabelValidationError(true);
      return false;
    }
    if (!selectedRESTApplication) {
      setRequiredRESTApplicationValidationError(true);
      return false;
    }
    if (noEnpointsRESTApplicationValidationError) {
      return false;
    }
    if (!selectedRESTSchema) {
      setRESTSchemaValidationError(true);
      return false;
    }
    if (!selectedRESTEndpoint) {
      setRESTEndpointValidationError(true);
      return false;
    }
    return true;
  };
  const RestApplicationDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restApplicationsLabel`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restApplicationsSelect`
        },
        selectedRESTApplication ? /* @__PURE__ */ react_default.createElement(
          RESTApplicationDropdownItem,
          {
            query: "",
            restApplication: selectedRESTApplication
          }
        ) : Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTApplicationDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTApplication(item);
          setRequiredRESTApplicationValidationError(false);
          getRESTSchemas(item);
        },
        restApplications
      }
    )
  );
  const RestSchemaDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restSchema`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restSchemaSelect`
        },
        selectedRESTSchema || Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTSchemaDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTSchema(item);
          const endpoints = restSchemaEndpoints.get(item);
          if (endpoints?.length === 1) {
            setSelectedRESTEndpoint(endpoints[0]);
          } else {
            setSelectedRESTEndpoint(null);
          }
          setRESTSchemaValidationError(false);
        },
        restSchemas: Array.from(restSchemaEndpoints.keys())
      }
    )
  );
  const RestEndpointDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restEndpoint`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restEndpointSelect`
        },
        selectedRESTEndpoint || Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTEndpointDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTEndpoint(item);
          setRESTEndpointValidationError(false);
        },
        restEndpoints: restSchemaEndpoints.get(selectedRESTSchema ?? "") ?? []
      }
    )
  );
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, Liferay.Language.get("new-data-set")), /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(
    LabelInput,
    {
      labelValidationError,
      namespace,
      onBlur: () => {
        setLabelValidationError(!label);
      },
      onChange: setLabel,
      value: label
    }
  ), restApplications && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": requiredRESTApplicationValidationError || noEnpointsRESTApplicationValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restApplicationsSelect`,
        id: `${namespace}restApplicationsLabel`
      },
      Liferay.Language.get("rest-application"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestApplicationDropdown, null),
    requiredRESTApplicationValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null),
    noEnpointsRESTApplicationValidationError && /* @__PURE__ */ react_default.createElement(
      ValidationFeedback_default,
      {
        message: Liferay.Language.get(
          "there-are-no-usable-endpoints"
        )
      }
    )
  ), restSchemaEndpoints.size > 0 && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": restSchemaValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restSchemaSelect`,
        id: `${namespace}restSchema`
      },
      Liferay.Language.get("rest-schema"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestSchemaDropdown, null),
    restSchemaValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  ), selectedRESTSchema && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": restEndpointValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restEndpointSelect`,
        id: `${namespace}restEndpoint`
      },
      Liferay.Language.get("rest-endpoint"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestEndpointDropdown, null),
    restEndpointValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  )), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled,
          onClick: () => {
            setSaveButtonDisabled(true);
            const success = validate();
            if (success) {
              saveDataSet();
            } else {
              setSaveButtonDisabled(false);
            }
          }
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
var DataSets = ({
  editDataSetURL,
  namespace,
  permissionsURL,
  restApplications
}) => {
  const creationMenu = {
    primaryItems: [
      {
        label: Liferay.Language.get("new-data-set"),
        onClick: ({ loadData }) => {
          (0, frontend_js_web_exports.openModal)({
            contentComponent: ({
              closeModal
            }) => /* @__PURE__ */ react_default.createElement(
              NewDataSetModalContent,
              {
                closeModal,
                loadData,
                namespace,
                restApplications
              }
            )
          });
        }
      }
    ]
  };
  const getEditURL = (itemData) => {
    const url = new URL(editDataSetURL);
    url.searchParams.set(
      `${namespace}dataSetERC`,
      itemData.externalReferenceCode
    );
    url.searchParams.set(`${namespace}dataSetLabel`, itemData.label);
    return url;
  };
  const onEditClick = ({ itemData }) => {
    (0, frontend_js_web_exports.navigate)(getEditURL(itemData));
  };
  const onDeleteClick = ({
    itemData,
    loadData
  }) => {
    (0, frontend_js_web_exports.openModal)({
      bodyHTML: Liferay.Language.get(
        "deleting-a-data-set-is-an-action-that-cannot-be-reversed"
      ),
      buttons: [
        {
          autoFocus: true,
          displayType: "secondary",
          label: Liferay.Language.get("cancel"),
          type: "cancel"
        },
        {
          displayType: "danger",
          label: Liferay.Language.get("delete"),
          onClick: ({ processClose }) => {
            processClose();
            (0, frontend_js_web_exports.fetch)(itemData.actions.delete.href, {
              method: itemData.actions.delete.method
            }).then(() => {
              openDefaultFailureToast2();
              loadData();
            }).catch(openDefaultFailureToast);
          }
        }
      ],
      status: "danger",
      title: Liferay.Language.get("delete-data-set")
    });
  };
  const views2 = [
    {
      contentRenderer: "table",
      name: "table",
      schema: {
        fields: [
          {
            actionId: "edit",
            contentRenderer: "actionLink",
            fieldName: "label",
            label: Liferay.Language.get("name"),
            sortable: true
          },
          {
            fieldName: "restApplication",
            label: Liferay.Language.get("rest-application"),
            sortable: true
          },
          {
            fieldName: "restSchema",
            label: Liferay.Language.get("rest-schema"),
            sortable: true
          },
          {
            fieldName: "restEndpoint",
            label: Liferay.Language.get("rest-endpoint"),
            sortable: true
          },
          {
            contentRenderer: "dateTime",
            fieldName: "dateModified",
            label: Liferay.Language.get("modified-date"),
            sortable: true
          }
        ]
      }
    }
  ];
  return /* @__PURE__ */ react_default.createElement("div", { className: "data-sets" }, /* @__PURE__ */ react_default.createElement(
    frontend_data_set_web_exports.FrontendDataSet,
    {
      ...FDS_DEFAULT_PROPS,
      apiURL: API_URL.DATA_SETS,
      creationMenu,
      emptyState: {
        description: Liferay.Language.get(
          "start-creating-one-to-show-your-data"
        ),
        image: "/states/empty_state.svg",
        title: Liferay.Language.get("no-data-sets-created")
      },
      id: `${namespace}DataSets`,
      itemsActions: [
        {
          data: {
            id: "edit",
            permissionKey: "get"
          },
          icon: "pencil",
          label: Liferay.Language.get("edit"),
          onClick: onEditClick
        },
        {
          separator: true,
          type: "group"
        },
        {
          data: {
            permissionKey: "permissions",
            size: "full-screen",
            title: Liferay.Language.get("permissions")
          },
          href: permissionsURL,
          icon: "password-policies",
          label: Liferay.Language.get("permissions"),
          target: "modal"
        },
        {
          separator: true,
          type: "group"
        },
        {
          data: {
            permissionKey: "delete"
          },
          icon: "trash",
          label: Liferay.Language.get("delete"),
          onClick: onDeleteClick
        }
      ],
      sorts: [{ direction: "desc", key: "dateCreated" }],
      views: views2
    }
  ));
};
var DataSets_default = DataSets;

// ../../../../../../../../../$/bridge/for/main/@clayui/badge
var badge_exports = {};
__export(badge_exports, {
  default: () => badge_default
});
__reExport(badge_exports, clayui_badge_star);
import * as clayui_badge_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$badge.js";
import __default__26 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$badge.js";
var badge_default = __default__26;

// src/main/resources/META-INF/resources/css/FDSEntries.scss
var link9 = document.createElement("link");
link9.setAttribute("rel", "stylesheet");
link9.setAttribute("type", "text/css");
link9.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/css/FDSEntries.css"
);
document.querySelector("head").appendChild(link9);

// src/main/resources/META-INF/resources/js/FDSEntries.tsx
var VIEWS_COUNT_TABLE_CELL_RENDERER_NAME = "viewsCountTableCellRenderer";
var ViewsCountTableCell = ({ itemData }) => {
  const count = itemData[OBJECT_RELATIONSHIP.FDS_ENTRY_FDS_VIEW].length;
  return /* @__PURE__ */ react_default.createElement(badge_default, { displayType: !count ? "warning" : "info", label: count });
};
var FDSEntryLabelInput = ({
  labelValidationError,
  namespace,
  onBlur,
  onChange,
  value
}) => /* @__PURE__ */ react_default.createElement(
  form_default.Group,
  {
    className: classnames_default({
      "has-error": labelValidationError
    })
  },
  /* @__PURE__ */ react_default.createElement("label", { htmlFor: `${namespace}fdsEntryLabelInput` }, Liferay.Language.get("name"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)),
  /* @__PURE__ */ react_default.createElement(
    form_exports.ClayInput,
    {
      id: `${namespace}fdsEntryLabelInput`,
      onBlur,
      onChange: (event) => onChange(event.target.value),
      type: "text",
      value
    }
  ),
  labelValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
);
var AddFDSEntryModalContent = ({
  closeModal,
  loadData,
  namespace,
  restApplications
}) => {
  const [fdsEntryLabel, setFDSEntryLabel] = (0, react_exports.useState)("");
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [labelValidationError, setLabelValidationError] = (0, react_exports.useState)(false);
  const [
    requiredRESTApplicationValidationError,
    setRequiredRESTApplicationValidationError
  ] = (0, react_exports.useState)(false);
  const [
    noEnpointsRESTApplicationValidationError,
    setNoEnpointsRESTApplicationValidationError
  ] = (0, react_exports.useState)(false);
  const [restSchemaValidationError, setRESTSchemaValidationError] = (0, react_exports.useState)(false);
  const [restEndpointValidationError, setRESTEndpointValidationError] = (0, react_exports.useState)(false);
  const [restSchemaEndpoints, setRESTSchemaEndpoints] = (0, react_exports.useState)(/* @__PURE__ */ new Map());
  const [selectedRESTApplication, setSelectedRESTApplication] = (0, react_exports.useState)();
  const [selectedRESTSchema, setSelectedRESTSchema] = (0, react_exports.useState)();
  const [selectedRESTEndpoint, setSelectedRESTEndpoint] = (0, react_exports.useState)();
  const addFDSEntry = async () => {
    if (!selectedRESTApplication) {
      return;
    }
    selectedRESTApplication;
    const body = {
      label: fdsEntryLabel,
      restApplication: selectedRESTApplication,
      restEndpoint: selectedRESTEndpoint,
      restSchema: selectedRESTSchema
    };
    const response = await (0, frontend_js_web_exports.fetch)(API_URL.FDS_ENTRIES, {
      body: JSON.stringify(body),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method: "POST"
    });
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const fdsEntry = await response.json();
    if (fdsEntry?.id) {
      closeModal();
      openDefaultFailureToast2();
      loadData();
    } else {
      setSaveButtonDisabled(false);
      openDefaultFailureToast();
    }
  };
  const isPathValid = (path, allowedParameters) => {
    const paramsMatcher = RegExp("{(.*?)}", "g");
    let matches;
    while ((matches = paramsMatcher.exec(path)) !== null) {
      if (!allowedParameters.includes(matches[1])) {
        return false;
      }
    }
    return true;
  };
  const getRESTSchemas = async (restApplication) => {
    if (!restApplication) {
      return;
    }
    const response = await (0, frontend_js_web_exports.fetch)(`/o${restApplication}/openapi.json`);
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const responseJson = await response.json();
    const paths = Object.keys(responseJson.paths ?? []);
    const schemaNames = Object.keys(responseJson.components?.schemas ?? []);
    const schemaEndpoints = /* @__PURE__ */ new Map();
    schemaNames.forEach((schemaName) => {
      paths.forEach((path) => {
        if (!isPathValid(path, ALLOWED_ENDPOINTS_PARAMETERS)) {
          return;
        }
        if (responseJson.paths[path]?.get?.responses.default.content["application/json"]?.schema?.$ref?.endsWith(`/Page${schemaName}`)) {
          const endpoints = schemaEndpoints.get(schemaName) ?? [];
          endpoints.push(path);
          if (endpoints.length === 1) {
            schemaEndpoints.set(schemaName, endpoints);
          }
        }
      });
    });
    if (schemaEndpoints.size === 0) {
      setSelectedRESTSchema(null);
      setSelectedRESTEndpoint(null);
      setNoEnpointsRESTApplicationValidationError(true);
    } else if (schemaEndpoints.size === 1) {
      const schema = schemaEndpoints.keys().next().value;
      setSelectedRESTSchema(schema);
      const paths2 = schemaEndpoints.get(schema);
      if (paths2?.length === 1) {
        setSelectedRESTEndpoint(paths2[0]);
      }
      setNoEnpointsRESTApplicationValidationError(false);
    } else {
      setSelectedRESTSchema(null);
      setSelectedRESTEndpoint(null);
      setNoEnpointsRESTApplicationValidationError(false);
    }
    setRESTSchemaEndpoints(schemaEndpoints);
  };
  const validate = () => {
    if (!fdsEntryLabel) {
      setLabelValidationError(true);
      return false;
    }
    if (!selectedRESTApplication) {
      setRequiredRESTApplicationValidationError(true);
      return false;
    }
    if (noEnpointsRESTApplicationValidationError) {
      return false;
    }
    if (!selectedRESTSchema) {
      setRESTSchemaValidationError(true);
      return false;
    }
    if (!selectedRESTEndpoint) {
      setRESTEndpointValidationError(true);
      return false;
    }
    return true;
  };
  const RestApplicationDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restApplicationsLabel`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restApplicationsSelect`
        },
        selectedRESTApplication ? /* @__PURE__ */ react_default.createElement(
          RESTApplicationDropdownItem,
          {
            query: "",
            restApplication: selectedRESTApplication
          }
        ) : Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTApplicationDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTApplication(item);
          setRequiredRESTApplicationValidationError(false);
          getRESTSchemas(item);
        },
        restApplications
      }
    )
  );
  const RestSchemaDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restSchema`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restSchemaSelect`
        },
        selectedRESTSchema || Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTSchemaDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTSchema(item);
          const endpoints = restSchemaEndpoints.get(item);
          if (endpoints?.length === 1) {
            setSelectedRESTEndpoint(endpoints[0]);
          } else {
            setSelectedRESTEndpoint(null);
          }
          setRESTSchemaValidationError(false);
        },
        restSchemas: Array.from(restSchemaEndpoints.keys())
      }
    )
  );
  const RestEndpointDropdown = () => /* @__PURE__ */ react_default.createElement(
    drop_down_default,
    {
      menuElementAttrs: {
        className: "fds-entries-dropdown-menu"
      },
      trigger: /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          "aria-labelledby": `${namespace}restEndpoint`,
          className: "form-control form-control-select form-control-select-secondary",
          displayType: "secondary",
          id: `${namespace}restEndpointSelect`
        },
        selectedRESTEndpoint || Liferay.Language.get("choose-an-option")
      )
    },
    /* @__PURE__ */ react_default.createElement(
      RESTEndpointDropdownMenu,
      {
        onItemClick: (item) => {
          setSelectedRESTEndpoint(item);
          setRESTEndpointValidationError(false);
        },
        restEndpoints: restSchemaEndpoints.get(selectedRESTSchema ?? "") ?? []
      }
    )
  );
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, Liferay.Language.get("new-data-set")), /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(
    FDSEntryLabelInput,
    {
      labelValidationError,
      namespace,
      onBlur: () => {
        setLabelValidationError(!fdsEntryLabel);
      },
      onChange: setFDSEntryLabel,
      value: fdsEntryLabel
    }
  ), restApplications && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": requiredRESTApplicationValidationError || noEnpointsRESTApplicationValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restApplicationsSelect`,
        id: `${namespace}restApplicationsLabel`
      },
      Liferay.Language.get("rest-application"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestApplicationDropdown, null),
    requiredRESTApplicationValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null),
    noEnpointsRESTApplicationValidationError && /* @__PURE__ */ react_default.createElement(
      ValidationFeedback_default,
      {
        message: Liferay.Language.get(
          "there-are-no-usable-endpoints"
        )
      }
    )
  ), restSchemaEndpoints.size > 0 && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": restSchemaValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restSchemaSelect`,
        id: `${namespace}restSchema`
      },
      Liferay.Language.get("rest-schema"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestSchemaDropdown, null),
    restSchemaValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  ), selectedRESTSchema && /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": restEndpointValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement(
      "label",
      {
        htmlFor: `${namespace}restEndpointSelect`,
        id: `${namespace}restEndpoint`
      },
      Liferay.Language.get("rest-endpoint"),
      /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)
    ),
    /* @__PURE__ */ react_default.createElement(RestEndpointDropdown, null),
    restEndpointValidationError && /* @__PURE__ */ react_default.createElement(ValidationFeedback_default, null)
  )), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled,
          onClick: () => {
            setSaveButtonDisabled(true);
            const success = validate();
            if (success) {
              addFDSEntry();
            } else {
              setSaveButtonDisabled(false);
            }
          }
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
var FDSEntries = ({
  fdsViewsURL,
  namespace,
  permissionsURL,
  restApplications
}) => {
  const creationMenu = {
    primaryItems: [
      {
        label: Liferay.Language.get("new-data-set"),
        onClick: ({ loadData }) => {
          (0, frontend_js_web_exports.openModal)({
            contentComponent: ({
              closeModal
            }) => /* @__PURE__ */ react_default.createElement(
              AddFDSEntryModalContent,
              {
                closeModal,
                loadData,
                namespace,
                restApplications
              }
            )
          });
        }
      }
    ]
  };
  const getEditURL = (itemData) => {
    const url = new URL(fdsViewsURL);
    url.searchParams.set(`${namespace}fdsEntryId`, itemData.id);
    url.searchParams.set(`${namespace}fdsEntryLabel`, itemData.label);
    return url;
  };
  const onEditClick = ({ itemData }) => {
    (0, frontend_js_web_exports.navigate)(getEditURL(itemData));
  };
  const onDeleteClick = ({
    itemData,
    loadData
  }) => {
    (0, frontend_js_web_exports.openModal)({
      bodyHTML: Liferay.Language.get(
        "deleting-a-data-set-is-an-action-that-cannot-be-reversed"
      ),
      buttons: [
        {
          autoFocus: true,
          displayType: "secondary",
          label: Liferay.Language.get("cancel"),
          type: "cancel"
        },
        {
          displayType: "danger",
          label: Liferay.Language.get("delete"),
          onClick: ({ processClose }) => {
            processClose();
            (0, frontend_js_web_exports.fetch)(itemData.actions.delete.href, {
              method: itemData.actions.delete.method
            }).then(() => {
              openDefaultFailureToast2();
              loadData();
            }).catch(openDefaultFailureToast);
          }
        }
      ],
      status: "danger",
      title: Liferay.Language.get("delete-data-set")
    });
  };
  const views2 = [
    {
      contentRenderer: "table",
      name: "table",
      schema: {
        fields: [
          {
            actionId: "edit",
            contentRenderer: "actionLink",
            fieldName: "label",
            label: Liferay.Language.get("name"),
            sortable: true
          },
          {
            fieldName: "restApplication",
            label: Liferay.Language.get("rest-application"),
            sortable: true
          },
          {
            fieldName: "restSchema",
            label: Liferay.Language.get("rest-schema"),
            sortable: true
          },
          {
            fieldName: "restEndpoint",
            label: Liferay.Language.get("rest-endpoint"),
            sortable: true
          },
          {
            contentRenderer: "dateTime",
            fieldName: "dateModified",
            label: Liferay.Language.get("modified-date"),
            sortable: true
          }
        ]
      }
    }
  ];
  return /* @__PURE__ */ react_default.createElement("div", { className: "fds-entries" }, /* @__PURE__ */ react_default.createElement(
    frontend_data_set_web_exports.FrontendDataSet,
    {
      ...FDS_DEFAULT_PROPS,
      apiURL: `${API_URL.FDS_ENTRIES}?nestedFields=${OBJECT_RELATIONSHIP.FDS_ENTRY_FDS_VIEW}`,
      creationMenu,
      customRenderers: {
        tableCell: [
          {
            component: ViewsCountTableCell,
            name: VIEWS_COUNT_TABLE_CELL_RENDERER_NAME,
            type: "internal"
          }
        ]
      },
      emptyState: {
        description: Liferay.Language.get(
          "start-creating-one-to-show-your-data"
        ),
        image: "/states/empty_state.svg",
        title: Liferay.Language.get("no-data-sets-created")
      },
      id: `${namespace}FDSEntries`,
      itemsActions: [
        {
          data: {
            id: "edit",
            permissionKey: "get"
          },
          icon: "pencil",
          label: Liferay.Language.get("edit"),
          onClick: onEditClick
        },
        {
          separator: true,
          type: "group"
        },
        {
          data: {
            permissionKey: "permissions",
            size: "full-screen",
            title: Liferay.Language.get("permissions")
          },
          href: permissionsURL,
          icon: "password-policies",
          label: Liferay.Language.get("permissions"),
          target: "modal"
        },
        {
          separator: true,
          type: "group"
        },
        {
          data: {
            permissionKey: "delete"
          },
          icon: "trash",
          label: Liferay.Language.get("delete"),
          onClick: onDeleteClick
        }
      ],
      sorts: [{ direction: "desc", key: "dateCreated" }],
      views: views2
    }
  ));
};
var FDSEntries_default = FDSEntries;

// src/main/resources/META-INF/resources/js/FDSViews.tsx
var LIST_OF_ITEMS_PER_PAGE2 = "4, 8, 20, 40, 60";
var DEFAULT_ITEMS_PER_PAGE2 = 20;
var AddFDSViewModalContent = ({
  closeModal,
  fdsEntryId,
  loadData,
  namespace
}) => {
  const [saveButtonDisabled, setSaveButtonDisabled] = (0, react_exports.useState)(false);
  const [labelValidationError, setLabelValidationError] = (0, react_exports.useState)(false);
  const fdsViewDescriptionRef = (0, react_exports.useRef)(null);
  const fdsViewLabelRef = (0, react_exports.useRef)(null);
  const addFDSView = async () => {
    const body = {
      defaultItemsPerPage: DEFAULT_ITEMS_PER_PAGE2,
      description: fdsViewDescriptionRef.current?.value,
      label: fdsViewLabelRef.current?.value,
      listOfItemsPerPage: LIST_OF_ITEMS_PER_PAGE2,
      r_fdsEntryFDSViewRelationship_c_fdsEntryId: fdsEntryId,
      symbol: "catalog"
    };
    const response = await (0, frontend_js_web_exports.fetch)(API_URL.DATA_SETS, {
      body: JSON.stringify(body),
      headers: {
        "Accept": "application/json",
        "Content-Type": "application/json"
      },
      method: "POST"
    });
    if (!response.ok) {
      openDefaultFailureToast();
      return;
    }
    const fdsView = await response.json();
    if (fdsView?.id) {
      closeModal();
      openDefaultFailureToast2();
      loadData();
    } else {
      setSaveButtonDisabled(false);
      openDefaultFailureToast();
    }
  };
  const validate = () => {
    if (!fdsViewLabelRef.current?.value) {
      setLabelValidationError(true);
      return false;
    }
    return true;
  };
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(modal_default.Header, null, Liferay.Language.get("new-data-set-view")), /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(
    form_default.Group,
    {
      className: classnames_default({
        "has-error": labelValidationError
      })
    },
    /* @__PURE__ */ react_default.createElement("label", { htmlFor: `${namespace}fdsViewLabelInput` }, Liferay.Language.get("name"), /* @__PURE__ */ react_default.createElement(RequiredMark_default, null)),
    /* @__PURE__ */ react_default.createElement(
      form_exports.ClayInput,
      {
        id: `${namespace}fdsViewLabelInput`,
        onBlur: () => setLabelValidationError(
          !fdsViewLabelRef.current?.value
        ),
        ref: fdsViewLabelRef,
        type: "text"
      }
    ),
    labelValidationError && /* @__PURE__ */ react_default.createElement(form_default.FeedbackGroup, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackItem, null, /* @__PURE__ */ react_default.createElement(form_default.FeedbackIndicator, { symbol: "exclamation-full" }), Liferay.Language.get("this-field-is-required")))
  ), /* @__PURE__ */ react_default.createElement(form_default.Group, null, /* @__PURE__ */ react_default.createElement("label", { htmlFor: `${namespace}fdsViewDesctiptionInput` }, Liferay.Language.get("description")), /* @__PURE__ */ react_default.createElement(
    form_exports.ClayInput,
    {
      id: `${namespace}fdsViewDesctiptionInput`,
      ref: fdsViewDescriptionRef,
      type: "text"
    }
  ))), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          disabled: saveButtonDisabled,
          onClick: () => {
            setSaveButtonDisabled(true);
            const success = validate();
            if (success) {
              addFDSView();
            }
          }
        },
        Liferay.Language.get("save")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          displayType: "secondary",
          onClick: () => closeModal()
        },
        Liferay.Language.get("cancel")
      ))
    }
  ));
};
var FDSViews = ({
  fdsEntryId,
  fdsEntryLabel,
  fdsViewURL,
  namespace
}) => {
  const getEditURL = (itemData) => {
    const url = new URL(fdsViewURL);
    url.searchParams.set(`${namespace}fdsEntryId`, fdsEntryId);
    url.searchParams.set(`${namespace}fdsEntryLabel`, fdsEntryLabel);
    url.searchParams.set(`${namespace}fdsViewId`, itemData.id);
    url.searchParams.set(`${namespace}fdsViewLabel`, itemData.label);
    return url;
  };
  const onEditClick = ({ itemData }) => {
    (0, frontend_js_web_exports.navigate)(getEditURL(itemData));
  };
  const onDeleteClick = ({
    itemData,
    loadData
  }) => {
    (0, frontend_js_web_exports.openModal)({
      bodyHTML: Liferay.Language.get(
        "deleting-a-data-set-view-is-an-action-that-cannot-be-reversed"
      ),
      buttons: [
        {
          autoFocus: true,
          displayType: "secondary",
          label: Liferay.Language.get("cancel"),
          type: "cancel"
        },
        {
          displayType: "danger",
          label: Liferay.Language.get("delete"),
          onClick: ({ processClose }) => {
            processClose();
            (0, frontend_js_web_exports.fetch)(`${API_URL.DATA_SETS}/${itemData.id}`, {
              method: "DELETE"
            }).then(() => {
              openDefaultFailureToast2();
              loadData();
            }).catch(openDefaultFailureToast);
          }
        }
      ],
      status: "danger",
      title: Liferay.Language.get("delete-data-set-view")
    });
  };
  const creationMenu = {
    primaryItems: [
      {
        label: Liferay.Language.get("new-data-set-view"),
        onClick: ({ loadData }) => {
          (0, frontend_js_web_exports.openModal)({
            contentComponent: ({
              closeModal
            }) => /* @__PURE__ */ react_default.createElement(
              AddFDSViewModalContent,
              {
                closeModal,
                fdsEntryId,
                loadData,
                namespace
              }
            )
          });
        }
      }
    ]
  };
  const TitleRenderer = ({ itemData }) => {
    return /* @__PURE__ */ react_default.createElement("div", { className: "table-list-title" }, /* @__PURE__ */ react_default.createElement(link_default, { href: getEditURL(itemData).toString() }, itemData.label));
  };
  const views2 = [
    {
      contentRenderer: "list",
      name: "list",
      schema: {
        description: "description",
        symbol: "symbol",
        title: "label",
        titleRenderer: {
          component: TitleRenderer,
          label: Liferay.Language.get("title"),
          name: "title",
          type: "internal"
        }
      }
    }
  ];
  return /* @__PURE__ */ react_default.createElement("div", { className: "fds-views" }, /* @__PURE__ */ react_default.createElement(
    frontend_data_set_web_exports.FrontendDataSet,
    {
      ...FDS_DEFAULT_PROPS,
      apiURL: `${API_URL.DATA_SETS}/?filter=(${OBJECT_RELATIONSHIP.FDS_ENTRY_FDS_VIEW_ID} eq '${fdsEntryId}')`,
      creationMenu,
      emptyState: {
        description: Liferay.Language.get(
          "start-creating-one-to-show-your-data"
        ),
        image: "/states/empty_state.svg",
        title: Liferay.Language.get("no-views-created")
      },
      header: {
        title: Liferay.Language.get("views")
      },
      id: `${namespace}FDSViews`,
      itemsActions: [
        {
          icon: "pencil",
          label: Liferay.Language.get("edit"),
          onClick: onEditClick
        },
        {
          separator: true,
          type: "group"
        },
        {
          icon: "trash",
          label: Liferay.Language.get("delete"),
          onClick: onDeleteClick
        }
      ],
      sorts: [{ direction: "desc", key: "dateModified" }],
      views: views2
    }
  ));
};
var FDSViews_default = FDSViews;

// src/main/resources/META-INF/resources/item/selector/FDSAdminItemSelector.scss
var link10 = document.createElement("link");
link10.setAttribute("rel", "stylesheet");
link10.setAttribute("type", "text/css");
link10.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/frontend-data-set-admin-web/item/selector/FDSAdminItemSelector.css"
);
document.querySelector("head").appendChild(link10);

// src/main/resources/META-INF/resources/item/selector/FDSAdminItemSelector.tsx
var views = [
  {
    contentRenderer: "list",
    name: "list",
    schema: {
      description: "description",
      symbol: "symbol",
      title: "label"
    }
  }
];
var FDSAdminItemSelector = ({
  className,
  classNameId,
  namespace
}) => {
  const [selectedItem, setSelectedItem] = (0, react_exports.useState)();
  return /* @__PURE__ */ react_default.createElement("div", { className: "fds-admin-item-selector" }, /* @__PURE__ */ react_default.createElement(modal_default.Body, null, /* @__PURE__ */ react_default.createElement(
    frontend_data_set_web_exports.FrontendDataSet,
    {
      ...FDS_DEFAULT_PROPS,
      apiURL: API_URL.DATA_SETS,
      id: `${namespace}FDSAdminItemSelector`,
      onSelect: ({
        selectedItems
      }) => {
        setSelectedItem({
          externalReferenceCode: selectedItems[0].externalReferenceCode,
          id: selectedItems[0].id
        });
      },
      selectedItemsKey: "id",
      selectionType: "single",
      views
    }
  )), /* @__PURE__ */ react_default.createElement(
    modal_default.Footer,
    {
      last: /* @__PURE__ */ react_default.createElement(button_default.Group, { spaced: true }, /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          className: "btn-cancel",
          displayType: "secondary"
        },
        Liferay.Language.get("cancel")
      ), /* @__PURE__ */ react_default.createElement(
        button_default,
        {
          className: "item-preview selector-button",
          "data-value": `{
								"className": "${className}", 
								"classNameId": "${classNameId}", 
								"classPK": "${selectedItem?.id}", 
								"externalReferenceCode": "${selectedItem?.externalReferenceCode}"}`
        },
        Liferay.Language.get("save")
      ))
    }
  ));
};
var FDSAdminItemSelector_default = FDSAdminItemSelector;
export {
  DataSet_default as DataSet,
  DataSets_default as DataSets,
  FDSAdminItemSelector_default as FDSAdminItemSelector,
  FDSEntries_default as FDSEntries,
  FDSViews_default as FDSViews
};
//# sourceMappingURL=index.js.map
