/**
 * Copyright (C) 2014-2017 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.commons.collection.attr;

import javax.annotation.Nonnull;

import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsMap;

/**
 * Base interface for objects having read-only attributes
 *
 * @author Philip Helger
 * @param <KEYTYPE>
 *        Key type
 * @param <VALUETYPE>
 *        Value type
 */
@FunctionalInterface
public interface IHasAttributes <KEYTYPE, VALUETYPE>
{
  /**
   * @return The read-only attribute container. Never <code>null</code>.
   */
  @Nonnull
  @ReturnsImmutableObject
  IAttributeContainer <KEYTYPE, VALUETYPE> getAttributes ();

  /**
   * @return The map with all contained attributes. Never <code>null</code> but
   *         maybe empty.
   */
  @Nonnull
  @ReturnsMutableCopy
  default ICommonsMap <KEYTYPE, VALUETYPE> getAllAttributes ()
  {
    return getAttributes ().getAllAttributes ();
  }
}
