/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.parser;

import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=link"}, service={EditableElementParser.class})
public class LinkEditableElementParser
implements EditableElementParser {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public JSONObject getAttributes(Element element) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        Elements elements = element.getElementsByTag("a");
        if (ListUtil.isEmpty((List)elements)) {
            return jsonObject;
        }
        Element replaceableElement = (Element)elements.get(0);
        String href = replaceableElement.attr("href");
        if (Validator.isNotNull((String)href)) {
            jsonObject.put("href", href);
        }
        return jsonObject;
    }

    public String getValue(Element element) {
        Elements elements = element.getElementsByTag("a");
        if (ListUtil.isEmpty((List)elements)) {
            return "";
        }
        Element replaceableElement = (Element)elements.get(0);
        String html = replaceableElement.html();
        if (Validator.isNull((String)html.trim())) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            return this._language.get(resourceBundle, "example-link");
        }
        return html;
    }

    public void replace(Element element, String value) {
        this.replace(element, value, null);
    }

    public void replace(Element element, String value, JSONObject configJSONObject) {
        String buttonType;
        String targetValue;
        String target;
        Elements elements = element.getElementsByTag("a");
        if (ListUtil.isEmpty((List)elements)) {
            return;
        }
        Element replaceableElement = (Element)elements.get(0);
        if (configJSONObject == null) {
            replaceableElement.html(value);
            return;
        }
        String hrefValue = configJSONObject.getString("href");
        if (Validator.isNotNull((String)hrefValue)) {
            element.attr("href", hrefValue);
        }
        if (StringUtil.equalsIgnoreCase((String)(target = configJSONObject.getString("target")), (String)"_parent") || StringUtil.equalsIgnoreCase((String)target, (String)"_top")) {
            configJSONObject.put("target", "_self");
        }
        if (Validator.isNotNull((String)(targetValue = configJSONObject.getString("target")))) {
            element.attr("target", targetValue);
        }
        if (!(buttonType = configJSONObject.getString("buttonType")).isEmpty()) {
            for (String className : replaceableElement.classNames()) {
                if (!className.startsWith("btn-") && !Objects.equals(className, "btn")) continue;
                replaceableElement.removeClass(className);
            }
            if (Objects.equals(buttonType, "link")) {
                replaceableElement.addClass("link");
            } else {
                String buttonTypeValue = configJSONObject.getString("buttonType");
                if (Validator.isNotNull((String)buttonTypeValue)) {
                    element.addClass("btn btn-" + buttonTypeValue);
                }
            }
        }
        replaceableElement.html(value);
    }

    public void validate(Element element) throws FragmentEntryContentException {
        Elements elements = element.getElementsByTag("a");
        if (elements.size() != 1) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(this._language.format(resourceBundle, "each-editable-link-element-must-contain-an-a-tag", new Object[]{"<em>", "</em>"}, false));
        }
        String html = element.html();
        if (html.contains("<lfr-drop-zone") || html.contains("<lfr-widget-")) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(this._language.get(resourceBundle, "editable-link-element-cannot-include-drop-zones-or-widgets-in-it"));
        }
    }
}

