/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.feature.flag.test.util;

import com.liferay.portal.kernel.feature.flag.FeatureFlagManager;
import com.liferay.portal.kernel.feature.flag.constants.FeatureFlagConstants;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.Objects;
import java.util.Properties;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class FeatureFlagTestHelper {
    public static final String FEATURE_FLAG_KEY_1 = "FAKE-123";
    public static final String FEATURE_FLAG_KEY_2 = "FAKE-456";
    public static final String FEATURE_FLAG_KEY_SYSTEM = "FAKE-000";
    private final FeatureFlagManager _featureFlagManager;
    private final Object _featureFlagsBagProviderObject;

    public FeatureFlagTestHelper() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(FeatureFlagTestHelper.class);
        BundleContext bundleContext = bundle.getBundleContext();
        Bundle featureFlagWebBundle = null;
        for (Bundle curBundle : bundleContext.getBundles()) {
            if (!Objects.equals(curBundle.getSymbolicName(), "com.liferay.feature.flag.web")) continue;
            featureFlagWebBundle = curBundle;
        }
        Assert.assertNotNull(featureFlagWebBundle);
        this._featureFlagsBagProviderObject = bundleContext.getService(bundleContext.getServiceReference(featureFlagWebBundle.loadClass("com.liferay.feature.flag.web.internal.feature.flag.FeatureFlagsBagProvider")));
        Assert.assertNotNull((Object)this._featureFlagsBagProviderObject);
        this._featureFlagManager = (FeatureFlagManager)bundleContext.getService(bundleContext.getServiceReference(FeatureFlagManager.class));
        Assert.assertNotNull((Object)this._featureFlagManager);
        Properties properties = PropsUtil.getProperties();
        properties.setProperty(FeatureFlagConstants.getKey((String[])new String[]{FEATURE_FLAG_KEY_1}), Boolean.FALSE.toString());
        properties.setProperty(FeatureFlagConstants.getKey((String[])new String[]{FEATURE_FLAG_KEY_2}), Boolean.FALSE.toString());
        properties.setProperty(FeatureFlagConstants.getKey((String[])new String[]{FEATURE_FLAG_KEY_SYSTEM}), Boolean.FALSE.toString());
        properties.setProperty(FeatureFlagConstants.getKey((String[])new String[]{FEATURE_FLAG_KEY_SYSTEM, "system"}), Boolean.TRUE.toString());
        this._clearCache();
    }

    public boolean getFeatureFlagValue(long companyId, String featureFlagKey) {
        return this._featureFlagManager.isEnabled(companyId, featureFlagKey);
    }

    public void setFeatureFlagValue(long companyId, String featureFlagKey, boolean enabled) {
        ReflectionTestUtil.invoke((Object)this._featureFlagsBagProviderObject, (String)"setEnabled", (Class[])new Class[]{Long.TYPE, String.class, Boolean.TYPE}, (Object[])new Object[]{companyId, featureFlagKey, enabled});
    }

    public void tearDown() {
        this._clearCache();
    }

    private void _clearCache() {
        ReflectionTestUtil.invoke((Object)this._featureFlagsBagProviderObject, (String)"clearCache", (Class[])new Class[0], (Object[])new Object[0]);
    }
}

