/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.rest.internal.resource.v1_0.factory;

import com.liferay.exportimport.rest.internal.security.permission.LiberalPermissionChecker;
import com.liferay.exportimport.rest.resource.v1_0.ImportProcessResource;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;

@Component(property={"resource.locator.key=/export-import/v1.0/ImportProcess"}, service={ImportProcessResource.Factory.class})
public class ImportProcessResourceFactoryImpl
implements ImportProcessResource.Factory {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(scope=ReferenceScope.PROTOTYPE_REQUIRED)
    private ComponentServiceObjects<ImportProcessResource> _componentServiceObjects;
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SortParserProvider _sortParserProvider;
    @Reference
    private UserLocalService _userLocalService;

    public ImportProcessResource.Builder create() {
        return new ImportProcessResource.Builder(){
            private boolean _checkPermissions = true;
            private HttpServletRequest _httpServletRequest;
            private HttpServletResponse _httpServletResponse;
            private Locale _preferredLocale;
            private UriInfo _uriInfo;
            private User _user;

            public ImportProcessResource build() {
                if (this._user == null) {
                    throw new IllegalArgumentException("User is not set");
                }
                Function<InvocationHandler, ImportProcessResource> importProcessResourceProxyProviderFunction = ResourceProxyProviderFunctionHolder._importProcessResourceProxyProviderFunction;
                return importProcessResourceProxyProviderFunction.apply((proxy, method, arguments) -> ImportProcessResourceFactoryImpl.this._invoke(method, arguments, this._checkPermissions, this._httpServletRequest, this._httpServletResponse, this._preferredLocale, this._uriInfo, this._user));
            }

            public ImportProcessResource.Builder checkPermissions(boolean checkPermissions) {
                this._checkPermissions = checkPermissions;
                return this;
            }

            public ImportProcessResource.Builder httpServletRequest(HttpServletRequest httpServletRequest) {
                this._httpServletRequest = httpServletRequest;
                return this;
            }

            public ImportProcessResource.Builder httpServletResponse(HttpServletResponse httpServletResponse) {
                this._httpServletResponse = httpServletResponse;
                return this;
            }

            public ImportProcessResource.Builder preferredLocale(Locale preferredLocale) {
                this._preferredLocale = preferredLocale;
                return this;
            }

            public ImportProcessResource.Builder uriInfo(UriInfo uriInfo) {
                this._uriInfo = uriInfo;
                return this;
            }

            public ImportProcessResource.Builder user(User user) {
                this._user = user;
                return this;
            }
        };
    }

    private static Function<InvocationHandler, ImportProcessResource> _getProxyProviderFunction() {
        Class proxyClass = ProxyUtil.getProxyClass((ClassLoader)ImportProcessResource.class.getClassLoader(), (Class[])new Class[]{ImportProcessResource.class});
        try {
            Constructor constructor = proxyClass.getConstructor(InvocationHandler.class);
            return invocationHandler -> {
                try {
                    return (ImportProcessResource)constructor.newInstance(invocationHandler);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new InternalError(reflectiveOperationException);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException);
        }
    }

    private Object _invoke(Method method, Object[] arguments, boolean checkPermissions, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale preferredLocale, UriInfo uriInfo, User user) throws Throwable {
        String name = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (checkPermissions) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(user));
        } else {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)new LiberalPermissionChecker(user));
        }
        ImportProcessResource importProcessResource = (ImportProcessResource)this._componentServiceObjects.getService();
        importProcessResource.setContextAcceptLanguage((AcceptLanguage)new AcceptLanguageImpl(httpServletRequest, preferredLocale, user));
        Company company = this._companyLocalService.getCompany(user.getCompanyId());
        importProcessResource.setContextCompany(company);
        importProcessResource.setContextHttpServletRequest(httpServletRequest);
        importProcessResource.setContextHttpServletResponse(httpServletResponse);
        importProcessResource.setContextUriInfo(uriInfo);
        importProcessResource.setContextUser(user);
        importProcessResource.setExpressionConvert(this._expressionConvert);
        importProcessResource.setFilterParserProvider(this._filterParserProvider);
        importProcessResource.setGroupLocalService(this._groupLocalService);
        importProcessResource.setResourceActionLocalService(this._resourceActionLocalService);
        importProcessResource.setResourcePermissionLocalService(this._resourcePermissionLocalService);
        importProcessResource.setRoleLocalService(this._roleLocalService);
        importProcessResource.setSortParserProvider(this._sortParserProvider);
        try {
            Object object = method.invoke((Object)importProcessResource, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            this._componentServiceObjects.ungetService((Object)importProcessResource);
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private class AcceptLanguageImpl
    implements AcceptLanguage {
        private final HttpServletRequest _httpServletRequest;
        private final Locale _preferredLocale;
        private final User _user;

        public AcceptLanguageImpl(HttpServletRequest httpServletRequest, Locale preferredLocale, User user) {
            this._httpServletRequest = httpServletRequest;
            this._preferredLocale = preferredLocale;
            this._user = user;
        }

        public List<Locale> getLocales() {
            return Arrays.asList(this.getPreferredLocale());
        }

        public String getPreferredLanguageId() {
            return LocaleUtil.toLanguageId((Locale)this.getPreferredLocale());
        }

        public Locale getPreferredLocale() {
            Locale locale;
            if (this._preferredLocale != null) {
                return this._preferredLocale;
            }
            if (this._httpServletRequest != null && (locale = (Locale)this._httpServletRequest.getAttribute("LOCALE")) != null) {
                return locale;
            }
            return this._user.getLocale();
        }

        public boolean isAcceptAllLanguages() {
            return false;
        }
    }

    private static class ResourceProxyProviderFunctionHolder {
        private static final Function<InvocationHandler, ImportProcessResource> _importProcessResourceProxyProviderFunction = ImportProcessResourceFactoryImpl._getProxyProviderFunction();

        private ResourceProxyProviderFunctionHolder() {
        }
    }
}

