/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.changeset.internal.manager;

import com.liferay.exportimport.changeset.Changeset;
import com.liferay.exportimport.changeset.ChangesetEnvironment;
import com.liferay.exportimport.changeset.ChangesetManager;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactory;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ChangesetManager.class})
public class ChangesetManagerImpl
implements ChangesetManager {
    private static final Log _log = LogFactoryUtil.getLog(ChangesetManagerImpl.class);
    private Map<String, Changeset> _changesets = new HashMap<String, Changeset>();
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportConfigurationParameterMapFactory _exportImportConfigurationParameterMapFactory;
    @Reference
    private ExportImportConfigurationSettingsMapFactory _exportImportConfigurationSettingsMapFactory;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Staging _staging;
    @Reference
    private UserLocalService _userLocalService;

    public void addChangeset(Changeset changeset) {
        Objects.nonNull(changeset);
        String changesetUuid = changeset.getUuid();
        if (this._changesets.containsKey(changesetUuid)) {
            return;
        }
        this._changesets.put(changesetUuid, changeset);
    }

    public void clearChangesets() {
        this._changesets = new HashMap<String, Changeset>();
    }

    public boolean hasChangeset(String changesetUuid) {
        return this._changesets.containsKey(changesetUuid);
    }

    public Optional<Changeset> peekChangeset(String changesetUuid) {
        return Optional.ofNullable(this._changesets.get(changesetUuid));
    }

    public Optional<Changeset> popChangeset(String changesetUuid) {
        Changeset changeset = this._changesets.remove(changesetUuid);
        return Optional.ofNullable(changeset);
    }

    public long publishChangeset(Changeset changeset, ChangesetEnvironment changesetEnvironment) {
        this.addChangeset(changeset);
        long groupId = changesetEnvironment.getGroupId();
        Group scopeGroup = this._groupLocalService.fetchGroup(groupId);
        if (!scopeGroup.isStagingGroup() && !scopeGroup.isStagedRemotely()) {
            return 0L;
        }
        String portletId = changesetEnvironment.getPortletId();
        if (!scopeGroup.isStagedPortlet(portletId)) {
            return 0L;
        }
        long liveGroupId = 0L;
        if (scopeGroup.isStagingGroup()) {
            liveGroupId = scopeGroup.getLiveGroupId();
        } else if (scopeGroup.isStagedRemotely()) {
            liveGroupId = scopeGroup.getRemoteLiveGroupId();
        }
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap();
        parameterMap.put("changesetUuid", new String[]{changeset.getUuid()});
        Map envParameterMap = changesetEnvironment.getParameterMap();
        Set entrySet = envParameterMap.entrySet();
        Stream entryStream = entrySet.stream();
        entryStream.forEach(entry -> parameterMap.put(entry.getKey(), new String[]{(String)entry.getValue()}));
        User user = this._userLocalService.fetchUser(changesetEnvironment.getUserId());
        Map settingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishPortletSettingsMap(user, groupId, changesetEnvironment.getPlid(), liveGroupId, changesetEnvironment.getPlid(), "com_liferay_exportimport_web_portlet_ChangesetPortlet", parameterMap);
        try {
            ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), portletId, 8, settingsMap);
            return this._staging.publishPortlet(user.getUserId(), exportImportConfiguration);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to publish changeset: " + portalException.getMessage()));
            }
            return 0L;
        }
    }
}

