/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.dynamic.data.mapping.util.comparator.TemplateVersionVersionComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.language.LanguageResources;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=200"}, service={ConstraintResolver.class})
public class DDMTemplateVersionConstraintResolver
implements ConstraintResolver<DDMTemplateVersion> {
    @Reference
    protected DDMTemplateLocalService ddmTemplateLocalService;
    @Reference
    protected DDMTemplateVersionLocalService ddmTemplateVersionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateVersionConstraintResolver.class);

    public String getConflictDescriptionKey() {
        return "duplicate-dynamic-data-mapping-template-version";
    }

    public Class<DDMTemplateVersion> getModelClass() {
        return DDMTemplateVersion.class;
    }

    public String getResolutionDescriptionKey() {
        return "the-dynamic-data-mapping-template-version-was-updated-to-latest";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle((Locale)locale);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"templateId", "version"};
    }

    public void resolveConflict(ConstraintResolverContext<DDMTemplateVersion> constraintResolverContext) throws PortalException {
        DDMTemplateVersion ddmTemplateVersion = (DDMTemplateVersion)constraintResolverContext.getSourceCTModel();
        String latestVersion = "0.0";
        try {
            latestVersion = (String)constraintResolverContext.getInTarget(() -> {
                DDMTemplateVersion latestProductionTemplateVersion = this.ddmTemplateVersionLocalService.getLatestTemplateVersion(ddmTemplateVersion.getTemplateId());
                return latestProductionTemplateVersion.getVersion();
            });
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return;
        }
        List ddmTemplateVersions = ListUtil.filter((List)ListUtil.sort((List)this.ddmTemplateVersionLocalService.getTemplateVersions(ddmTemplateVersion.getTemplateId()), (Comparator)new TemplateVersionVersionComparator(false)), templateVersion -> templateVersion.getCtCollectionId() == ddmTemplateVersion.getCtCollectionId());
        double currentVersion = MathUtil.format((double)(GetterUtil.getDouble((String)latestVersion) + 0.1 * (double)ddmTemplateVersions.size()), (int)1, (int)1);
        CTPersistence ctPersistence = this.ddmTemplateVersionLocalService.getCTPersistence();
        for (DDMTemplateVersion templateVersion2 : ddmTemplateVersions) {
            templateVersion2.setVersion(String.valueOf(currentVersion));
            this.ddmTemplateVersionLocalService.updateDDMTemplateVersion(templateVersion2);
            ctPersistence.flush();
            currentVersion = MathUtil.format((double)(currentVersion - 0.1), (int)1, (int)1);
        }
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getDDMTemplate(ddmTemplateVersion.getTemplateId());
        DDMTemplateVersion latestPublicationTemplateVersion = this.ddmTemplateVersionLocalService.getLatestTemplateVersion(ddmTemplateVersion.getTemplateId());
        ddmTemplate.setVersion(latestPublicationTemplateVersion.getVersion());
        this.ddmTemplateLocalService.updateDDMTemplate(ddmTemplate);
    }
}

