/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.result.contributor;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import java.util.Locale;
import java.util.ResourceBundle;

public class DDMFormInstanceRecordModelSummaryContributor
implements ModelSummaryContributor {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordModelSummaryContributor.class);
    private final DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    private final Language _language;

    public DDMFormInstanceRecordModelSummaryContributor(DDMFormInstanceLocalService ddmFormInstanceLocalService, Language language) {
        this._ddmFormInstanceLocalService = ddmFormInstanceLocalService;
        this._language = language;
    }

    public Summary getSummary(Document document, Locale locale, String snippet) {
        long ddmFormInstanceId = GetterUtil.getLong((String)document.get("formInstanceId"));
        String prefix = "snippet_";
        String description = document.get(locale, prefix + "description", "description");
        Summary summary = new Summary(this._getTitle(ddmFormInstanceId, locale), description);
        summary.setMaxContentLength(200);
        return summary;
    }

    private ResourceBundle _getResourceBundle(Locale defaultLocale) {
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        return portalResourceBundleLoader.loadResourceBundle(defaultLocale);
    }

    private String _getTitle(long ddmFormInstanceId, Locale locale) {
        try {
            DDMFormInstance ddmFormInstance = this._ddmFormInstanceLocalService.getFormInstance(ddmFormInstanceId);
            String ddmFormInstanceName = ddmFormInstance.getName(locale);
            return this._language.format(this._getResourceBundle(locale), "form-record-for-form-x", (Object)ddmFormInstanceName, false);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return "";
        }
    }
}

