/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.XPath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.form.deserializer.type=xsd"}, service={DDMFormDeserializer.class})
public class DDMFormXSDDeserializer
implements DDMFormDeserializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormXSDDeserializer.class);
    @Reference
    private SAXReader _saxReader;

    public DDMFormDeserializerDeserializeResponse deserialize(DDMFormDeserializerDeserializeRequest ddmFormDeserializerDeserializeRequest) {
        DDMForm ddmForm = new DDMForm();
        DDMFormDeserializerDeserializeResponse.Builder builder = DDMFormDeserializerDeserializeResponse.Builder.newBuilder((DDMForm)ddmForm);
        try {
            Document document = this._saxReader.read(ddmFormDeserializerDeserializeRequest.getContent());
            this.setDDMFormAvailableLocales(document.getRootElement(), ddmForm);
            this.setDDMFormDefaultLocale(document.getRootElement(), ddmForm);
            this.setDDMFormFields(document.getRootElement(), ddmForm);
            this.setDDMFormLocalizedValuesDefaultLocale(ddmForm);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            builder = builder.exception(exception);
        }
        return builder.build();
    }

    protected void addOptionValueLabels(Element dynamicElementElement, DDMFormFieldOptions ddmFormFieldOptions, String optionValue) {
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            String languageId = metadataElement.attributeValue("locale");
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            Element labelElement = this._fetchMetadataEntry(metadataElement, "label");
            ddmFormFieldOptions.addOptionLabel(optionValue, locale, labelElement.getText());
        }
    }

    protected Set<Locale> getAvailableLocales(Element rootElement) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        String availableLanguageIds = rootElement.attributeValue("available-locales");
        for (String availableLanguageId : StringUtil.split((String)availableLanguageIds)) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)availableLanguageId);
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected DDMFormField getDDMFormField(Element dynamicElementElement) {
        String name = dynamicElementElement.attributeValue("name");
        String type = dynamicElementElement.attributeValue("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        this._setDDMFormFieldDataType(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldIndexType(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldLocalizable(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldMultiple(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldNamespace(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldReadOnly(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldReference(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldRepeatable(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldRequired(dynamicElementElement, ddmFormField);
        this._setDDMFormFieldShowLabel(dynamicElementElement, ddmFormField);
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            this._setDDMFormFieldMetadata(metadataElement, ddmFormField);
        }
        if (type.equals("radio") || type.equals("select")) {
            this.setDDMFormFieldOptions(dynamicElementElement, ddmFormField);
        } else {
            this.setNestedDDMFormField(dynamicElementElement, ddmFormField);
        }
        return ddmFormField;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(List<Element> dynamicElementElements) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (Element dynamicElementElement : dynamicElementElements) {
            String value = dynamicElementElement.attributeValue("value");
            ddmFormFieldOptions.addOption(value);
            ddmFormFieldOptions.addOptionReference(value, dynamicElementElement.attributeValue("reference"));
            this.addOptionValueLabels(dynamicElementElement, ddmFormFieldOptions, value);
        }
        return ddmFormFieldOptions;
    }

    protected List<DDMFormField> getDDMFormFields(Element rootElement) {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (Element dynamicElement : rootElement.elements("dynamic-element")) {
            ddmFormFields.add(this.getDDMFormField(dynamicElement));
        }
        return ddmFormFields;
    }

    protected Locale getDefaultLocale(Element rootElement) {
        String defaultLanguageId = rootElement.attributeValue("default-locale");
        return LocaleUtil.fromLanguageId((String)defaultLanguageId);
    }

    protected void setDDMFormAvailableLocales(Element rootElement, DDMForm ddmForm) {
        ddmForm.setAvailableLocales(this.getAvailableLocales(rootElement));
    }

    protected void setDDMFormDefaultLocale(Element rootElement, DDMForm ddmForm) {
        ddmForm.setDefaultLocale(this.getDefaultLocale(rootElement));
    }

    protected void setDDMFormFieldLocalizedValueDefaultLocale(LocalizedValue localizedValue, Locale defaultLocale) {
        if (localizedValue == null) {
            return;
        }
        localizedValue.setDefaultLocale(defaultLocale);
    }

    protected void setDDMFormFieldLocalizedValuesDefaultLocale(DDMFormField ddmFormField, Locale defaultLocale) {
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getLabel(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getPredefinedValue(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getStyle(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getTip(), defaultLocale);
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions != null) {
            ddmFormFieldOptions.setDefaultLocale(defaultLocale);
        }
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this.setDDMFormFieldLocalizedValuesDefaultLocale(nestedDDMFormField, defaultLocale);
        }
    }

    protected void setDDMFormFieldOptions(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setDDMFormFieldOptions(this.getDDMFormFieldOptions(dynamicElementElement.elements("dynamic-element")));
    }

    protected void setDDMFormFields(Element rootElement, DDMForm ddmForm) {
        ddmForm.setDDMFormFields(this.getDDMFormFields(rootElement));
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMForm ddmForm) {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this.setDDMFormFieldLocalizedValuesDefaultLocale(ddmFormField, ddmForm.getDefaultLocale());
        }
    }

    protected void setNestedDDMFormField(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setNestedDDMFormFields(this.getDDMFormFields(dynamicElementElement));
    }

    private Element _fetchMetadataEntry(Element parentElement, String entryName) {
        XPath xPathSelector = this._saxReader.createXPath("entry[@name=" + HtmlUtil.escapeXPathAttribute((String)entryName) + "]");
        return (Element)xPathSelector.selectSingleNode((Object)parentElement);
    }

    private void _setDDMFormFieldDataType(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setDataType(dynamicElementElement.attributeValue("dataType"));
    }

    private void _setDDMFormFieldIndexType(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setIndexType(dynamicElementElement.attributeValue("indexType"));
    }

    private void _setDDMFormFieldLocalizable(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setLocalizable(GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("localizable"), (boolean)true));
    }

    private void _setDDMFormFieldMetadata(Element metadataElement, DDMFormField ddmFormField) {
        Element tipElement;
        Element styleElement;
        Element predefinedValueElement;
        String languageId = metadataElement.attributeValue("locale");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        Element labelElement = this._fetchMetadataEntry(metadataElement, "label");
        if (labelElement != null) {
            LocalizedValue label = ddmFormField.getLabel();
            label.addString(locale, labelElement.getText());
        }
        if ((predefinedValueElement = this._fetchMetadataEntry(metadataElement, "predefinedValue")) != null) {
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            predefinedValue.addString(locale, predefinedValueElement.getText());
        }
        if ((styleElement = this._fetchMetadataEntry(metadataElement, "style")) != null) {
            LocalizedValue style = ddmFormField.getStyle();
            style.addString(locale, styleElement.getText());
        }
        if ((tipElement = this._fetchMetadataEntry(metadataElement, "tip")) != null) {
            LocalizedValue tip = ddmFormField.getTip();
            tip.addString(locale, tipElement.getText());
        }
    }

    private void _setDDMFormFieldMultiple(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setMultiple(GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("multiple")));
    }

    private void _setDDMFormFieldNamespace(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setFieldNamespace(dynamicElementElement.attributeValue("fieldNamespace"));
    }

    private void _setDDMFormFieldReadOnly(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setReadOnly(GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("readOnly")));
    }

    private void _setDDMFormFieldReference(Element dynamicElementElement, DDMFormField ddmFormField) {
        String fieldReference = dynamicElementElement.attributeValue("fieldReference");
        if (Validator.isNotNull((String)fieldReference)) {
            ddmFormField.setFieldReference(fieldReference);
        }
    }

    private void _setDDMFormFieldRepeatable(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setRepeatable(GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("repeatable")));
    }

    private void _setDDMFormFieldRequired(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setRequired(GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("required")));
    }

    private void _setDDMFormFieldShowLabel(Element dynamicElementElement, DDMFormField ddmFormField) {
        ddmFormField.setShowLabel(GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("showLabel"), (boolean)true));
    }
}

