/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate"}, service={ModelDocumentContributor.class})
public class DDMTemplateModelDocumentContributor
implements ModelDocumentContributor<DDMTemplate> {
    @Reference
    protected DDMTemplateVersionLocalService ddmTemplateVersionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateModelDocumentContributor.class);
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private Localization _localization;

    public void contribute(Document document, DDMTemplate ddmTemplate) {
        block5: {
            block4: {
                document.addKeyword("classNameId", ddmTemplate.getClassNameId());
                document.addKeyword("classPK", ddmTemplate.getClassPK());
                document.addKeyword("language", ddmTemplate.getLanguage());
                document.addKeyword("mode", ddmTemplate.getMode());
                document.addKeyword("resourceClassNameId", ddmTemplate.getResourceClassNameId());
                try {
                    DDMTemplateVersion templateVersion = this.ddmTemplateVersionLocalService.getTemplateVersion(ddmTemplate.getTemplateId(), ddmTemplate.getVersion());
                    document.addKeyword("status", templateVersion.getStatus());
                    document.addKeyword("version", templateVersion.getVersion());
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Throwable)portalException);
                }
            }
            try {
                document.addKeyword("resourcePermissionName", this._ddmPermissionSupport.getTemplateModelResourceName(ddmTemplate.getResourceClassNameId()));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)portalException);
            }
        }
        document.addKeyword("type", ddmTemplate.getType());
        document.addLocalizedText("description", this._localization.populateLocalizationMap(ddmTemplate.getDescriptionMap(), ddmTemplate.getDefaultLanguageId(), ddmTemplate.getGroupId()));
        document.addLocalizedText("name", this._localization.populateLocalizationMap(ddmTemplate.getNameMap(), ddmTemplate.getDefaultLanguageId(), ddmTemplate.getGroupId()));
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = this._localization.getAvailableLanguageIds(content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

