/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.internal.io.DDMFormRuleJSONSerializer;
import com.liferay.dynamic.data.mapping.internal.io.util.DDMFormFieldSerializerUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.LocalizedValueUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.form.layout.serializer.type=json"}, service={DDMFormLayoutSerializer.class})
public class DDMFormLayoutJSONSerializer
implements DDMFormLayoutSerializer {
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    @Reference
    private JSONFactory _jsonFactory;

    public DDMFormLayoutSerializerSerializeResponse serialize(DDMFormLayoutSerializerSerializeRequest ddmFormLayoutSerializerSerializeRequest) {
        DDMFormLayout ddmFormLayout = ddmFormLayoutSerializerSerializeRequest.getDDMFormLayout();
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addDefaultLanguageId(jsonObject, ddmFormLayout.getDefaultLocale());
        this._addPages(jsonObject, ddmFormLayout.getDDMFormLayoutPages());
        this._addPaginationMode(jsonObject, ddmFormLayout.getPaginationMode());
        this.addRules(jsonObject, ddmFormLayout.getDDMFormRules());
        if (Validator.isNotNull((String)ddmFormLayout.getDefinitionSchemaVersion())) {
            jsonObject.put("definitionSchemaVersion", ddmFormLayout.getDefinitionSchemaVersion());
        }
        DDMFormFieldSerializerUtil.serialize(ddmFormLayout.getDDMFormFields(), this._ddmFormFieldTypeServicesRegistry, this._jsonFactory, jsonObject);
        DDMFormLayoutSerializerSerializeResponse.Builder builder = DDMFormLayoutSerializerSerializeResponse.Builder.newBuilder((String)jsonObject.toString());
        return builder.build();
    }

    protected void addDefaultLanguageId(JSONObject jsonObject, Locale defaultLocale) {
        jsonObject.put("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void addRules(JSONObject jsonObject, List<DDMFormRule> ddmFormRules) {
        if (ListUtil.isEmpty(ddmFormRules)) {
            return;
        }
        jsonObject.put("rules", DDMFormRuleJSONSerializer.serialize(ddmFormRules));
    }

    protected JSONObject toJSONObject(DDMFormLayoutColumn ddmFormLayoutColumn) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("size", ddmFormLayoutColumn.getSize());
        this._addFieldNames(jsonObject, ddmFormLayoutColumn.getDDMFormFieldNames());
        return jsonObject;
    }

    protected JSONObject toJSONObject(DDMFormLayoutPage ddmFormLayoutPage) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this._addDescription(jsonObject, ddmFormLayoutPage.getDescription());
        this._addRows(jsonObject, ddmFormLayoutPage.getDDMFormLayoutRows());
        this._addTitle(jsonObject, ddmFormLayoutPage.getTitle());
        return jsonObject;
    }

    protected JSONObject toJSONObject(DDMFormLayoutRow ddmFormLayoutRow) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this._addColumns(jsonObject, ddmFormLayoutRow.getDDMFormLayoutColumns());
        return jsonObject;
    }

    private void _addColumns(JSONObject jsonObject, List<DDMFormLayoutColumn> ddmFormLayoutColumns) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutColumns) {
            jsonArray.put(this.toJSONObject(ddmFormLayoutColumn));
        }
        jsonObject.put("columns", jsonArray);
    }

    private void _addDescription(JSONObject pageJSONObject, LocalizedValue description) {
        Map values = description.getValues();
        if (values.isEmpty()) {
            return;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Locale availableLocale : description.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), description.getString(availableLocale));
        }
        pageJSONObject.put("description", jsonObject);
    }

    private void _addFieldNames(JSONObject jsonObject, List<String> ddmFormFieldNames) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (String ddmFormFieldName : ddmFormFieldNames) {
            jsonArray.put(ddmFormFieldName);
        }
        jsonObject.put("fieldNames", jsonArray);
    }

    private void _addPages(JSONObject jsonObject, List<DDMFormLayoutPage> ddmFormLayoutPages) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayoutPages) {
            jsonArray.put(this.toJSONObject(ddmFormLayoutPage));
        }
        jsonObject.put("pages", jsonArray);
    }

    private void _addPaginationMode(JSONObject jsonObject, String paginationMode) {
        jsonObject.put("paginationMode", paginationMode);
    }

    private void _addRows(JSONObject jsonObject, List<DDMFormLayoutRow> ddmFormLayoutRows) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            jsonArray.put(this.toJSONObject(ddmFormLayoutRow));
        }
        jsonObject.put("rows", jsonArray);
    }

    private void _addTitle(JSONObject pageJSONObject, LocalizedValue title) {
        if (MapUtil.isEmpty((Map)title.getValues())) {
            return;
        }
        pageJSONObject.put("title", LocalizedValueUtil.toJSONObject((LocalizedValue)title));
    }
}

