/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_4_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMFieldUpgradeProcess
extends UpgradeProcess {
    private static final int _MAX_LENGTH_FIELD_NAME = 255;
    private static final Log _log = LogFactoryUtil.getLog(DDMFieldUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(SQLTransformer.transform((String)"select ctCollectionId, fieldId, fieldName from DDMField where LENGTH(fieldName) > ?"));
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMField set fieldName = ? where ctCollectionId = ? and fieldId = ?");){
            selectPreparedStatement.setInt(1, 255);
            ResultSet resultSet = selectPreparedStatement.executeQuery();
            while (resultSet.next()) {
                String fieldName = resultSet.getString("fieldName");
                updatePreparedStatement.setString(1, StringUtil.shorten((String)fieldName, (int)255));
                updatePreparedStatement.setLong(2, resultSet.getLong("ctCollectionId"));
                updatePreparedStatement.setLong(3, resultSet.getLong("fieldId"));
                updatePreparedStatement.addBatch();
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Truncated the ", fieldName, " value for field ID ", resultSet.getLong("fieldId"), " because it is too long"}));
            }
            updatePreparedStatement.executeBatch();
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.alterColumnType((String)"DDMField", (String)"fieldName", (String)"VARCHAR(255) null")};
    }
}

