/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_1;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;

public class ResourcePermissionUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME = "com.liferay.journal.model.JournalArticle";
    private final ResourceActions _resourceActions;

    public ResourcePermissionUpgradeProcess(ResourceActions resourceActions) {
        this._resourceActions = resourceActions;
    }

    protected void doUpgrade() throws Exception {
        this._updateResourcePermissions(DDMStructure.class.getName());
        this._updateResourcePermissions(DDMTemplate.class.getName());
    }

    private String _getNewCompositeModelName(String ddmModelClassName) {
        return this._resourceActions.getCompositeModelName(new String[]{ddmModelClassName, _CLASS_NAME});
    }

    private String _getOldCompositeModelName(String ddmModelClassName) {
        return "com.liferay.journal.model.JournalArticle-" + ddmModelClassName;
    }

    private void _updateResourcePermissions(String ddmModelClassName) throws Exception {
        String newCompositeModelName = this._getNewCompositeModelName(ddmModelClassName);
        String oldCompositeModelName = this._getOldCompositeModelName(ddmModelClassName);
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("update ResourcePermission set name = ? where name = ?");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("update ResourcePermission set primKey = ? where primKey = ?");){
            preparedStatement1.setString(1, newCompositeModelName);
            preparedStatement1.setString(2, oldCompositeModelName);
            preparedStatement1.executeUpdate();
            preparedStatement2.setString(1, newCompositeModelName);
            preparedStatement2.setString(2, oldCompositeModelName);
            preparedStatement2.executeUpdate();
        }
    }
}

