/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueJSONSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.form.values.serializer.type=json"}, service={DDMFormValuesSerializer.class})
public class DDMFormValuesJSONSerializer
implements DDMFormValuesSerializer {
    @Reference
    private JSONFactory _jsonFactory;
    private ServiceTrackerMap<String, DDMFormFieldValueJSONSerializer> _serviceTrackerMap;

    public DDMFormValuesSerializerSerializeResponse serialize(DDMFormValuesSerializerSerializeRequest ddmFormValuesSerializerSerializeRequest) {
        DDMFormValues ddmFormValues = ddmFormValuesSerializerSerializeRequest.getDDMFormValues();
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addAvailableLanguageIds(jsonObject, ddmFormValues.getAvailableLocales());
        this.addDefaultLanguageId(jsonObject, ddmFormValues.getDefaultLocale());
        DDMForm ddmForm = ddmFormValues.getDDMForm();
        this._addFieldValues(jsonObject, ddmForm.getDDMFormFieldsMap(true), ddmFormValues.getDDMFormFieldValues());
        DDMFormValuesSerializerSerializeResponse.Builder builder = DDMFormValuesSerializerSerializeResponse.Builder.newBuilder((String)jsonObject.toString());
        return builder.build();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDMFormFieldValueJSONSerializer.class, (String)"ddm.form.field.type.name");
    }

    protected void addAvailableLanguageIds(JSONObject jsonObject, Set<Locale> availableLocales) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (Locale availableLocale : availableLocales) {
            jsonArray.put(LocaleUtil.toLanguageId((Locale)availableLocale));
        }
        jsonObject.put("availableLanguageIds", jsonArray);
    }

    protected void addDefaultLanguageId(JSONObject jsonObject, Locale defaultLocale) {
        jsonObject.put("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected JSONObject toJSONObject(Map<String, DDMFormField> ddmFormFieldsMap, DDMFormFieldValue ddmFormFieldValue) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("fieldReference", ddmFormFieldValue.getFieldReference()).put("instanceId", ddmFormFieldValue.getInstanceId()).put("name", ddmFormFieldValue.getName());
        this._addNestedFieldValues(jsonObject, ddmFormFieldsMap, ddmFormFieldValue.getNestedDDMFormFieldValues());
        this._addValue(jsonObject, ddmFormFieldsMap.get(ddmFormFieldValue.getName()), ddmFormFieldValue);
        return jsonObject;
    }

    protected JSONObject toJSONObject(Value value) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Locale availableLocale : value.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), value.getString(availableLocale));
        }
        return jsonObject;
    }

    private void _addFieldValues(JSONObject jsonObject, Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormFieldValues) {
        jsonObject.put("fieldValues", this._toJSONArray(ddmFormFieldsMap, ddmFormFieldValues));
    }

    private void _addNestedFieldValues(JSONObject jsonObject, Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> nestedDDMFormFieldValues) {
        if (nestedDDMFormFieldValues.isEmpty()) {
            return;
        }
        jsonObject.put("nestedFieldValues", this._toJSONArray(ddmFormFieldsMap, nestedDDMFormFieldValues));
    }

    private void _addValue(JSONObject jsonObject, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return;
        }
        DDMFormFieldValueJSONSerializer ddmFormFieldValueJSONSerializer = this._getDDMFormFieldValueJSONSerializer(ddmFormField);
        if (ddmFormFieldValueJSONSerializer != null) {
            jsonObject.put("value", ddmFormFieldValueJSONSerializer.serialize(ddmFormField, value));
        } else if (value.isLocalized()) {
            jsonObject.put("value", this.toJSONObject(value));
        } else {
            jsonObject.put("value", value.getString(LocaleUtil.ROOT));
        }
    }

    private DDMFormFieldValueJSONSerializer _getDDMFormFieldValueJSONSerializer(DDMFormField ddmFormField) {
        if (ddmFormField == null) {
            return null;
        }
        return (DDMFormFieldValueJSONSerializer)this._serviceTrackerMap.getService((Object)ddmFormField.getType());
    }

    private JSONArray _toJSONArray(Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormFieldValues) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            jsonArray.put(this.toJSONObject(ddmFormFieldsMap, ddmFormFieldValue));
        }
        return jsonArray;
    }
}

