/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.internal.search.util.DDMSearchUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureLayoutLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureLayoutPersistence;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructureLayout"}, service={AopService.class})
public class DDMStructureLayoutLocalServiceImpl
extends DDMStructureLayoutLocalServiceBaseImpl {
    @Reference
    private DDMFormLayoutValidator _ddmFormLayoutValidator;
    @Reference(target="(ddm.form.layout.deserializer.type=json)")
    private DDMFormLayoutDeserializer _jsonDDMFormLayoutDeserializer;
    @Reference(target="(ddm.form.layout.serializer.type=json)")
    private DDMFormLayoutSerializer _jsonDDMFormLayoutSerializer;
    @Reference
    private UserLocalService _userLocalService;

    @Deprecated
    public DDMStructureLayout addStructureLayout(long userId, long groupId, long structureVersionId, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        return this.addStructureLayout(userId, groupId, 0L, null, structureVersionId, ddmFormLayout, serviceContext);
    }

    public DDMStructureLayout addStructureLayout(long userId, long groupId, long classNameId, String structureLayoutKey, long structureVersionId, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validate(ddmFormLayout);
        long structureLayoutId = this.counterLocalService.increment();
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.create(structureLayoutId);
        structureLayout.setUuid(serviceContext.getUuid());
        structureLayout.setGroupId(groupId);
        structureLayout.setCompanyId(user.getCompanyId());
        structureLayout.setUserId(user.getUserId());
        structureLayout.setUserName(user.getFullName());
        structureLayout.setClassNameId(classNameId);
        structureLayout.setStructureLayoutKey(GetterUtil.getString((String)structureLayoutKey, (String)String.valueOf(this.counterLocalService.increment())));
        structureLayout.setStructureVersionId(structureVersionId);
        structureLayout.setDefinition(this._serialize(ddmFormLayout));
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructureLayout addStructureLayout(long userId, long groupId, long classNameId, String structureLayoutKey, long structureVersionId, Map<Locale, String> name, Map<Locale, String> description, String definition, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long structureLayoutId = this.counterLocalService.increment();
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.create(structureLayoutId);
        structureLayout.setUuid(serviceContext.getUuid());
        structureLayout.setGroupId(groupId);
        structureLayout.setCompanyId(user.getCompanyId());
        structureLayout.setUserId(user.getUserId());
        structureLayout.setUserName(user.getFullName());
        structureLayout.setCreateDate(new Date());
        structureLayout.setModifiedDate(new Date());
        structureLayout.setClassNameId(classNameId);
        structureLayout.setStructureLayoutKey(GetterUtil.getString((String)structureLayoutKey, (String)String.valueOf(this.counterLocalService.increment())));
        structureLayout.setStructureVersionId(structureVersionId);
        structureLayout.setNameMap(name);
        structureLayout.setDescriptionMap(description);
        structureLayout.setDefinition(definition);
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    public void deleteDDMStructureLayouts(long classNameId, DDMStructureVersion ddmStructureVersion) throws PortalException {
        for (DDMStructureLayout ddmStructureLayout : this.ddmStructureLayoutPersistence.findByG_C_SV(ddmStructureVersion.getGroupId(), classNameId, ddmStructureVersion.getStructureVersionId())) {
            this.deleteDDMStructureLayout(ddmStructureLayout);
        }
    }

    @SystemEvent(type=1)
    public void deleteStructureLayout(DDMStructureLayout structureLayout) {
        this.deleteDDMStructureLayout(structureLayout);
    }

    public void deleteStructureLayout(long structureLayoutId) throws PortalException {
        this.deleteDDMStructureLayout(structureLayoutId);
    }

    public DDMStructureLayout fetchStructureLayout(long structureLayoutId) {
        return this.ddmStructureLayoutPersistence.fetchByPrimaryKey(structureLayoutId);
    }

    public DDMStructureLayout fetchStructureLayout(long groupId, long classNameId, String structureLayoutKey) {
        return this.ddmStructureLayoutPersistence.fetchByG_C_S(groupId, classNameId, GetterUtil.getString((String)structureLayoutKey));
    }

    public DDMStructureLayout getStructureLayout(long structureLayoutId) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
    }

    public DDMStructureLayout getStructureLayout(long groupId, long classNameId, String structureLayoutKey) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByG_C_S(groupId, classNameId, GetterUtil.getString((String)structureLayoutKey));
    }

    public DDMStructureLayout getStructureLayoutByStructureVersionId(long structureVersionId) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByStructureVersionId(structureVersionId);
    }

    public DDMFormLayout getStructureLayoutDDMFormLayout(DDMStructureLayout structureLayout) {
        DDMFormLayoutDeserializerDeserializeRequest.Builder builder = DDMFormLayoutDeserializerDeserializeRequest.Builder.newBuilder((String)structureLayout.getDefinition());
        DDMFormLayoutDeserializerDeserializeResponse ddmFormLayoutDeserializerDeserializeResponse = this._jsonDDMFormLayoutDeserializer.deserialize(builder.build());
        return ddmFormLayoutDeserializerDeserializeResponse.getDDMFormLayout();
    }

    public List<DDMStructureLayout> getStructureLayouts(long groupId, int start, int end) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByGroupId(groupId, start, end);
    }

    public List<DDMStructureLayout> getStructureLayouts(long groupId, long classNameId, int start, int end, OrderByComparator<DDMStructureLayout> orderByComparator) {
        return this.ddmStructureLayoutPersistence.findByG_C(groupId, classNameId, start, end, orderByComparator);
    }

    public List<DDMStructureLayout> getStructureLayouts(long groupId, long classNameId, long structureVersionId) {
        return this.ddmStructureLayoutPersistence.findByG_C_SV(groupId, classNameId, structureVersionId);
    }

    public List<DDMStructureLayout> getStructureLayouts(long groupId, long classNameId, long structureVersionId, int start, int end, OrderByComparator<DDMStructureLayout> orderByComparator) {
        return this.ddmStructureLayoutPersistence.findByG_C_SV(groupId, classNameId, structureVersionId, start, end, orderByComparator);
    }

    public int getStructureLayoutsCount(long groupId) {
        return this.ddmStructureLayoutPersistence.countByGroupId(groupId);
    }

    public int getStructureLayoutsCount(long groupId, long classNameId) {
        return this.ddmStructureLayoutPersistence.countByG_C(groupId, classNameId);
    }

    public int getStructureLayoutsCount(long groupId, long classNameId, long structureVersionId) {
        return this.ddmStructureLayoutPersistence.countByG_C_SV(groupId, classNameId, structureVersionId);
    }

    public List<DDMStructureLayout> search(long companyId, long[] groupIds, long classNameId, String keywords, int start, int end, OrderByComparator<DDMStructureLayout> orderByComparator) throws PortalException {
        SearchContext searchContext = DDMSearchUtil.buildStructureLayoutSearchContext(companyId, groupIds, classNameId, keywords, keywords, "", null, -1, start, end, orderByComparator);
        return DDMSearchUtil.doSearch(searchContext, DDMStructureLayout.class, arg_0 -> ((DDMStructureLayoutPersistence)this.ddmStructureLayoutPersistence).findByPrimaryKey(arg_0));
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords) throws PortalException {
        SearchContext searchContext = DDMSearchUtil.buildStructureLayoutSearchContext(companyId, groupIds, classNameId, keywords, keywords, "", null, -1, -1, -1, null);
        return DDMSearchUtil.doSearchCount(searchContext, DDMStructureLayout.class);
    }

    public DDMStructureLayout updateStructureLayout(long structureLayoutId, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
        this._validate(ddmFormLayout);
        structureLayout.setDefinition(this._serialize(ddmFormLayout));
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructureLayout updateStructureLayout(long structureLayoutId, long structureVersionId, Map<Locale, String> name, Map<Locale, String> description, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
        structureLayout.setModifiedDate(new Date());
        structureLayout.setStructureVersionId(structureVersionId);
        structureLayout.setNameMap(name);
        structureLayout.setDescriptionMap(description);
        structureLayout.setDefinition(definition);
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    private String _serialize(DDMFormLayout ddmFormLayout) {
        DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._jsonDDMFormLayoutSerializer.serialize(builder.build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    private void _validate(DDMFormLayout ddmFormLayout) throws PortalException {
        this._ddmFormLayoutValidator.validate(ddmFormLayout);
    }
}

