/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_8_0;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMContentUpgradeProcess
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final JSONFactory _jsonFactory;

    public DDMContentUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMContent.ctCollectionId, DDMContent.contentId, ", "DDMContent.data_, ", "DDMStructureVersion.structureVersionId, ", "DDMStructureVersion.definition from DDMContent inner ", "join DDMFormInstanceRecordVersion on ", "DDMContent.contentId = ", "DDMFormInstanceRecordVersion.storageId inner join ", "DDMFormInstanceVersion on ", "DDMFormInstanceRecordVersion.formInstanceId = ", "DDMFormInstanceVersion.formInstanceId and ", "DDMFormInstanceRecordVersion.formInstanceVersion = ", "DDMFormInstanceVersion.version inner join ", "DDMStructureVersion on ", "DDMFormInstanceVersion.structureVersionId = ", "DDMStructureVersion.structureVersionId"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where ctCollectionId = ? and contentId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String newData;
                String data;
                DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)resultSet.getString("definition"));
                List fieldSetDDMFormFields = ListUtil.filter((List)ddmForm.getDDMFormFields(), ddmFormField -> Objects.equals(ddmFormField.getType(), "fieldset"));
                if (fieldSetDDMFormFields.isEmpty() || (data = resultSet.getString("data_")).equals(newData = this._upgradeDDMContentData(data, fieldSetDDMFormFields))) continue;
                preparedStatement2.setString(1, newData);
                preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
                preparedStatement2.setLong(3, resultSet.getLong("contentId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private boolean _hasDDMFormField(DDMFormField ddmFormField, JSONArray fieldValuesJSONArray) {
        String ddmFormFieldName = ddmFormField.getName();
        for (JSONObject fieldValueJSONObject : fieldValuesJSONArray) {
            if (!ddmFormFieldName.equals(fieldValueJSONObject.getString("name"))) continue;
            return true;
        }
        return false;
    }

    private String _upgradeDDMContentData(String data, List<DDMFormField> fieldSetDDMFormFields) throws Exception {
        JSONObject dataJSONObject = this._jsonFactory.createJSONObject(data);
        JSONArray fieldValuesJSONArray = dataJSONObject.getJSONArray("fieldValues");
        for (DDMFormField fieldSetDDMFormField : fieldSetDDMFormFields) {
            if (this._hasDDMFormField(fieldSetDDMFormField, fieldValuesJSONArray)) continue;
            Map nestedDDMFormFieldsMap = fieldSetDDMFormField.getNestedDDMFormFieldsMap();
            Set nestedDDMFormFieldNames = nestedDDMFormFieldsMap.keySet();
            JSONArray nestedFieldValuesJSONArray = this._jsonFactory.createJSONArray();
            JSONArray newFieldValuesJSONArray = this._jsonFactory.createJSONArray();
            for (JSONObject fieldValueJSONObject : fieldValuesJSONArray) {
                if (nestedDDMFormFieldNames.contains(fieldValueJSONObject.getString("name"))) {
                    nestedFieldValuesJSONArray.put(fieldValueJSONObject);
                    continue;
                }
                newFieldValuesJSONArray.put(fieldValueJSONObject);
            }
            newFieldValuesJSONArray.put(JSONUtil.put((String)"instanceId", (Object)StringUtil.randomString((int)8)).put("name", fieldSetDDMFormField.getName()).put("nestedFieldValues", nestedFieldValuesJSONArray));
            fieldValuesJSONArray = newFieldValuesJSONArray;
        }
        dataJSONObject.put("fieldValues", fieldValuesJSONArray);
        return dataJSONObject.toString();
    }
}

