/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord"}, service={ModelDocumentContributor.class})
public class DDMFormInstanceRecordModelDocumentContributor
implements ModelDocumentContributor<DDMFormInstanceRecord> {
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected DDMIndexer ddmIndexer;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordModelDocumentContributor.class);

    public void contribute(Document document, DDMFormInstanceRecord ddmFormInstanceRecord) {
        block2: {
            try {
                DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = ddmFormInstanceRecord.getFormInstanceRecordVersion();
                DDMFormInstance ddmFormInstance = ddmFormInstanceRecordVersion.getFormInstance();
                document.addKeyword("classNameId", this.classNameLocalService.getClassNameId(DDMFormInstance.class));
                document.addKeyword("classPK", ddmFormInstance.getFormInstanceId());
                document.addKeyword("classTypeId", ddmFormInstanceRecordVersion.getFormInstanceId());
                document.addKeyword("relatedEntry", true);
                document.addKeyword("status", ddmFormInstanceRecordVersion.getStatus());
                document.addKeyword("version", ddmFormInstanceRecordVersion.getVersion());
                document.addKeyword("formInstanceId", ddmFormInstance.getFormInstanceId());
                DDMStructure ddmStructure = ddmFormInstance.getStructure();
                DDMFormValues ddmFormValues = ddmFormInstanceRecordVersion.getDDMFormValues();
                this._addContent(ddmFormInstanceRecordVersion, ddmFormValues, document);
                this.ddmIndexer.addAttributes(document, ddmStructure, ddmFormValues);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _addContent(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, DDMFormValues ddmFormValues, Document document) throws Exception {
        Set locales = ddmFormValues.getAvailableLocales();
        for (Locale locale : locales) {
            document.addText("ddmContent_" + LocaleUtil.toLanguageId((Locale)locale), this._extractContent(ddmFormInstanceRecordVersion, locale));
        }
    }

    private String _extractContent(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, Locale locale) throws Exception {
        DDMFormValues ddmFormValues = ddmFormInstanceRecordVersion.getDDMFormValues();
        if (ddmFormValues == null) {
            return "";
        }
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecordVersion.getFormInstance();
        return this.ddmIndexer.extractIndexableAttributes(ddmFormInstance.getStructure(), ddmFormValues, locale);
    }
}

