/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_6_1;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.friendly.url.resolver.FileEntryFriendlyURLResolver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class DDMFieldAttributeUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(DDMFieldAttributeUpgradeProcess.class);
    private static final Pattern _pattern = Pattern.compile("((?:/?[^\\s]*)/documents/(\\d+)/(\\d+)/([^/?]+)(?:/([-0-9a-fA-F]+))?(?:\\?.*$)?)|((?:/?[^\\s]*)/documents/(d)/(.*)/([_A-Za-z0-9-]+)?(?:\\?.*$)?)");
    private final ClassNameLocalService _classNameLocalService;
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final FileEntryFriendlyURLResolver _fileEntryFriendlyURLResolver;
    private final GroupLocalService _groupLocalService;
    private final UserLocalService _userLocalService;

    public DDMFieldAttributeUpgradeProcess(ClassNameLocalService classNameLocalService, DLFileEntryLocalService dlFileEntryLocalService, FileEntryFriendlyURLResolver fileEntryFriendlyURLResolver, GroupLocalService groupLocalService, UserLocalService userLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._fileEntryFriendlyURLResolver = fileEntryFriendlyURLResolver;
        this._groupLocalService = groupLocalService;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        long classNameId = this._classNameLocalService.getClassNameId("com.liferay.journal.model.JournalArticle");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMFieldAttribute.companyId, ", "DDMFieldAttribute.ctCollectionId, ", "DDMFieldAttribute.fieldAttributeId, ", "DDMFieldAttribute.smallAttributeValue, ", "DDMFieldAttribute.largeAttributeValue from DDMStructure ", "inner join DDMStructureVersion on ", "DDMStructure.ctCollectionId = ", "DDMStructureVersion.ctCollectionId and ", "DDMStructure.structureId = ", "DDMStructureVersion.structureId inner join DDMField on ", "DDMStructureVersion.ctCollectionId = ", "DDMField.ctCollectionId and ", "DDMStructureVersion.structureVersionId = ", "DDMField.structureVersionId inner join DDMFieldAttribute ", "on DDMField.ctCollectionId = ", "DDMFieldAttribute.ctCollectionId and DDMField.fieldId = ", "DDMFieldAttribute.fieldId where DDMStructure.classNameId ", "= ? and DDMField.fieldType = 'rich_text'"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update DDMFieldAttribute set smallAttributeValue = ?, largeAttributeValue = ? where ctCollectionId = ? and fieldAttributeId = ?");){
            preparedStatement1.setLong(1, classNameId);
            ResultSet resultSet = preparedStatement1.executeQuery();
            while (resultSet.next()) {
                long companyId = resultSet.getLong(1);
                preparedStatement2.setString(1, this._transform(companyId, resultSet.getString(4)));
                preparedStatement2.setString(2, this._transform(companyId, resultSet.getString(5)));
                preparedStatement2.setLong(3, resultSet.getLong(2));
                preparedStatement2.setLong(4, resultSet.getLong(3));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private DLFileEntry _getDLFileEntry(long companyId, Matcher matcher) throws PortalException {
        if (Objects.equals("d", matcher.group(7))) {
            String groupName = matcher.group(8);
            Group group = this._getGroup(companyId, groupName);
            String friendlyURL = matcher.group(9);
            FileEntry fileEntry = this._fileEntryFriendlyURLResolver.resolveFriendlyURL(group.getGroupId(), friendlyURL);
            return (DLFileEntry)fileEntry.getModel();
        }
        if (matcher.group(5) != null) {
            long groupId = GetterUtil.getLong((String)matcher.group(2));
            String uuid = matcher.group(5);
            return this._dlFileEntryLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
        }
        long groupId = GetterUtil.getLong((String)matcher.group(2));
        long folderId = GetterUtil.getLong((String)matcher.group(3));
        String title = matcher.group(4);
        try {
            return this._dlFileEntryLocalService.getFileEntry(groupId, folderId, title);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
            return this._dlFileEntryLocalService.getFileEntryByFileName(groupId, folderId, title);
        }
    }

    private long _getDLFileEntryId(long companyId, String src) throws PortalException {
        if (src.startsWith("data:image/")) {
            return 0L;
        }
        if (!src.contains("/documents")) {
            return 0L;
        }
        Matcher matcher = _pattern.matcher(src);
        if (matcher.find()) {
            try {
                DLFileEntry dlFileEntry = this._getDLFileEntry(companyId, matcher);
                return dlFileEntry.getFileEntryId();
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Missing file entry for URL " + src), (Throwable)portalException);
                }
                return 0L;
            }
        }
        return 0L;
    }

    private Group _getGroup(long companyId, String name) throws PortalException {
        Group group = this._groupLocalService.fetchFriendlyURLGroup(companyId, "/" + name);
        if (group != null) {
            return group;
        }
        User user = this._userLocalService.getUserByScreenName(companyId, name);
        return user.getGroup();
    }

    private Document _parseDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        outputSettings.syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings(outputSettings);
        return document;
    }

    private String _transform(long companyId, String html) throws PortalException {
        if (html == null || !html.contains("/documents/") || !html.contains("<img")) {
            return html;
        }
        Document document = this._parseDocument(html);
        for (Element imgElement : document.select("img:not(picture > img)")) {
            long fileEntryId;
            if (imgElement.hasAttr("data-fileentryid") || (fileEntryId = this._getDLFileEntryId(companyId, imgElement.attr("src"))) == 0L) continue;
            imgElement.attr("data-fileentryid", String.valueOf(fileEntryId));
        }
        if (html.contains("<html>") || html.contains("<head>")) {
            return document.html();
        }
        Element body = document.body();
        return body.html();
    }
}

