/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMFormFieldValidationUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormFieldValidationUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ? ");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement preparedStatement3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.dynamic.data.mapping.model.DDMFormInstance"));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    ResultSet resultSet2;
                    block71: {
                        String definition = resultSet.getString("definition");
                        preparedStatement2.setString(1, this._updateValidation(definition));
                        long structureId = resultSet.getLong("structureId");
                        preparedStatement2.setLong(2, structureId);
                        preparedStatement2.addBatch();
                        preparedStatement3.setLong(1, structureId);
                        resultSet2 = preparedStatement3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (resultSet2.next()) {
                                definition = resultSet2.getString("definition");
                                preparedStatement4.setString(1, this._updateValidation(definition));
                                long structureVersionId = resultSet2.getLong("structureVersionId");
                                preparedStatement4.setLong(2, structureVersionId);
                                preparedStatement4.addBatch();
                            }
                            if (resultSet2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (resultSet2 == null) throw throwable3;
                                if (throwable == null) {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                try {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            resultSet2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    resultSet2.close();
                }
            }
            preparedStatement2.executeBatch();
            preparedStatement4.executeBatch();
            return;
        }
    }

    private void _addParameterValue(String value, JSONObject validationJSONObject, String defaultLanguageId) {
        JSONObject parameterJSONObject = validationJSONObject.getJSONObject("parameter");
        if (!parameterJSONObject.has(defaultLanguageId)) {
            parameterJSONObject.put(defaultLanguageId, value);
        }
    }

    private String _getExpressionName(String expressionValue) {
        String name = "";
        if (expressionValue.startsWith("contains")) {
            name = "contains";
        } else if (expressionValue.startsWith("NOT(contains")) {
            name = "notContains";
        } else if (expressionValue.startsWith("isEmailAddress")) {
            name = "email";
        } else if (expressionValue.startsWith("match")) {
            name = "regularExpression";
        } else if (expressionValue.startsWith("isURL")) {
            name = "url";
        }
        return name;
    }

    private String _getParameterValueFromExpression(String expressionValue) {
        String[] parts = expressionValue.split("\"");
        if (parts.length > 1) {
            return parts[1];
        }
        return "";
    }

    private String _updateValidation(String definition) throws PortalException {
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldsJSONArray = definitionJSONObject.getJSONArray("fields");
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            if (!fieldJSONObject.has("validation")) continue;
            JSONObject validationJSONObject = fieldJSONObject.getJSONObject("validation");
            if (validationJSONObject == null) {
                fieldJSONObject.remove("validation");
                continue;
            }
            JSONObject expressionJSONObject = validationJSONObject.getJSONObject("expression");
            String expressionValue = expressionJSONObject.getString("value");
            if (Validator.isNull((String)expressionValue)) {
                fieldJSONObject.remove("validation");
                continue;
            }
            if (Validator.isNotNull((String)expressionJSONObject.getString("name"))) continue;
            expressionJSONObject.put("name", this._getExpressionName(expressionValue));
            String parameterValue = this._getParameterValueFromExpression(expressionValue);
            this._addParameterValue(parameterValue, validationJSONObject, definitionJSONObject.getString("defaultLanguageId"));
            if (!Validator.isNotNull((String)parameterValue)) continue;
            expressionJSONObject.put("value", StringUtil.replace((String)expressionValue, (String)parameterValue, (String)"{parameter}"));
        }
        return definitionJSONObject.toString();
    }
}

