/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateElementException;
import com.liferay.dynamic.data.mapping.exception.StructureNameException;
import com.liferay.dynamic.data.mapping.internal.DDMStructureImpl;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManager;
import com.liferay.dynamic.data.mapping.kernel.RequiredStructureException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMStructureManager.class})
public class DDMStructureManagerImpl
implements DDMStructureManager {
    @Reference
    private DDM _ddm;
    @Reference
    private DDMBeanTranslator _ddmBeanTranslator;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, com.liferay.dynamic.data.mapping.kernel.DDMForm ddmForm, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        try {
            DDMForm translatedDDMForm = this._ddmBeanTranslator.translate(ddmForm);
            com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(userId, groupId, parentStructureKey, classNameId, structureKey, nameMap, descriptionMap, translatedDDMForm, this._ddm.getDefaultDDMFormLayout(translatedDDMForm), storageType, type, serviceContext);
            return new DDMStructureImpl(ddmStructure);
        }
        catch (PortalException portalException) {
            throw this.translate(portalException);
        }
    }

    public void deleteStructure(long structureId) throws PortalException {
        try {
            this._ddmStructureLocalService.deleteStructure(structureId);
        }
        catch (PortalException portalException) {
            throw this.translate(portalException);
        }
    }

    public DDMStructure fetchStructure(long structureId) {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(structureId);
        if (ddmStructure == null) {
            return null;
        }
        return new DDMStructureImpl(ddmStructure);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, classNameId, structureKey);
        if (ddmStructure == null) {
            return null;
        }
        return new DDMStructureImpl(ddmStructure);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId) {
        ArrayList<DDMStructure> ddmStructures = new ArrayList<DDMStructure>();
        List structures = this._ddmStructureLocalService.getClassStructures(companyId, classNameId);
        for (com.liferay.dynamic.data.mapping.model.DDMStructure structure : structures) {
            ddmStructures.add(new DDMStructureImpl(structure));
        }
        return ddmStructures;
    }

    public DDMStructure updateStructure(long userId, long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, com.liferay.dynamic.data.mapping.kernel.DDMForm ddmForm, ServiceContext serviceContext) throws PortalException {
        try {
            DDMForm copyDDMForm = this._ddmBeanTranslator.translate(ddmForm);
            com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.updateStructure(userId, structureId, parentStructureId, nameMap, descriptionMap, copyDDMForm, this._ddm.getDefaultDDMFormLayout(copyDDMForm), serviceContext);
            return new DDMStructureImpl(ddmStructure);
        }
        catch (PortalException portalException) {
            throw this.translate(portalException);
        }
    }

    public void updateStructureKey(long structureId, String structureKey) throws PortalException {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(structureId);
        ddmStructure.setStructureKey(structureKey);
        this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
    }

    protected PortalException translate(PortalException portalException) {
        if (portalException instanceof NoSuchStructureException) {
            return new com.liferay.dynamic.data.mapping.kernel.NoSuchStructureException(portalException.getMessage(), portalException.getCause());
        }
        if (portalException instanceof com.liferay.dynamic.data.mapping.exception.RequiredStructureException) {
            return new RequiredStructureException(portalException.getMessage(), portalException.getCause());
        }
        if (portalException instanceof StructureDefinitionException) {
            return new com.liferay.dynamic.data.mapping.kernel.StructureDefinitionException(portalException.getMessage(), portalException.getCause());
        }
        if (portalException instanceof StructureDuplicateElementException) {
            return new StructureDuplicateElementException(portalException.getMessage(), portalException.getCause());
        }
        if (portalException instanceof StructureNameException) {
            return new StructureNameException(portalException.getMessage(), portalException.getCause());
        }
        return portalException;
    }
}

