/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.BaseStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageAdapter;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=100"}, service={StorageAdapter.class})
public class DefaultStorageAdapter
extends BaseStorageAdapter {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private DDMFieldLocalService _ddmFieldLocalService;
    @Reference
    private DDMFormValuesValidator _ddmFormValuesValidator;
    @Reference
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;

    public String getStorageType() {
        return StorageType.DEFAULT.toString();
    }

    protected long doCreate(long companyId, long ddmStructureId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        this._validate(ddmFormValues, serviceContext);
        long primaryKey = this._counterLocalService.increment();
        this._ddmFieldLocalService.updateDDMFormValues(ddmStructureId, primaryKey, ddmFormValues);
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(ddmStructureId);
        this._ddmStorageLinkLocalService.addStorageLink(this._classNameLocalService.getClassNameId(DDMContent.class), primaryKey, ddmStructureVersion.getStructureVersionId(), serviceContext);
        return primaryKey;
    }

    protected void doDeleteByClass(long classPK) {
        this._ddmFieldLocalService.deleteDDMFormValues(classPK);
        this._ddmStorageLinkLocalService.deleteClassStorageLink(classPK);
    }

    protected void doDeleteByDDMStructure(long ddmStructureId) {
        this._ddmFieldLocalService.deleteDDMFields(ddmStructureId);
        this._ddmStorageLinkLocalService.deleteStructureStorageLinks(ddmStructureId);
    }

    protected DDMFormValues doGetDDMFormValues(long classPK) throws PortalException {
        DDMStructure ddmStructure = this._getDDMStructure(classPK);
        return this._ddmFieldLocalService.getDDMFormValues(ddmStructure.createFullHierarchyDDMForm(), classPK);
    }

    protected void doUpdate(long classPK, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        this._validate(ddmFormValues, serviceContext);
        DDMStructure ddmStructure = this._getDDMStructure(classPK);
        this._ddmFieldLocalService.updateDDMFormValues(ddmStructure.getStructureId(), classPK, ddmFormValues);
    }

    private DDMStructure _getDDMStructure(long storageId) throws PortalException {
        DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.getClassStorageLink(storageId);
        return this._ddmStructureLocalService.getDDMStructure(ddmStorageLink.getStructureId());
    }

    private void _validate(DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateDDMFormValues"), (boolean)true)) {
            this._ddmFormValuesValidator.validate(ddmFormValues);
        }
    }
}

