/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.internal.search.helper.DDMSearchHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureTable;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructurePersistence;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddm", "json.web.service.context.path=DDMStructure"}, service={AopService.class})
public class DDMStructureServiceImpl
extends DDMStructureServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureServiceImpl.class);
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private DDMSearchHelper _ddmSearchHelper;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure)")
    private ModelResourcePermission<DDMStructure> _ddmStructureModelResourcePermission;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;

    public DDMStructure addStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    public DDMStructure addStructure(long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, classNameId, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, serviceContext);
    }

    public DDMStructure addStructure(long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, parentStructureKey, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    public DDMStructure copyStructure(long sourceStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMStructure sourceStructure = this.ddmStructurePersistence.findByPrimaryKey(sourceStructureId);
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sourceStructure, "VIEW");
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), sourceStructure.getClassNameId());
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), sourceStructureId, nameMap, descriptionMap, serviceContext);
    }

    public DDMStructure copyStructure(long sourceStructureId, ServiceContext serviceContext) throws PortalException {
        DDMStructure sourceStructure = this.ddmStructurePersistence.findByPrimaryKey(sourceStructureId);
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sourceStructure, "VIEW");
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), sourceStructure.getClassNameId());
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), sourceStructureId, serviceContext);
    }

    public void deleteStructure(long structureId) throws PortalException {
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "DELETE");
        this.ddmStructureLocalService.deleteStructure(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
        if (ddmStructure != null) {
            this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmStructure, "VIEW");
        }
        return ddmStructure;
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, classNameId, structureKey, includeAncestorStructures);
        if (ddmStructure != null) {
            this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmStructure, "VIEW");
        }
        return ddmStructure;
    }

    public DDMStructure getStructure(long structureId) throws PortalException {
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        DDMStructure structure = this.ddmStructureLocalService.getStructure(groupId, classNameId, structureKey);
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)structure, "VIEW");
        return structure;
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure structure = this.ddmStructureLocalService.getStructure(groupId, classNameId, structureKey, includeAncestorStructures);
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)structure, "VIEW");
        return structure;
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int status) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, "", "", "", null, status, -1, -1, null);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, "", "", "", null, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.getStructures(companyId, groupIds, classNameId, "", -1, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        Table tempDDMStructureTable = DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{DDMStructureTable.INSTANCE.structureId}).from((Table)DDMStructureTable.INSTANCE).where(this._getPredicate(companyId, groupIds, classNameId, keywords)).as("tempDDMStructure", (Table)DDMStructureTable.INSTANCE);
        return (List)this.ddmStructurePersistence.dslQuery(DSLQueryFactoryUtil.select((Table)DDMStructureTable.INSTANCE).from(tempDDMStructureTable).innerJoinON((Table)DDMStructureTable.INSTANCE, DDMStructureTable.INSTANCE.structureId.eq((Expression)tempDDMStructureTable.getColumn("structureId", Long.class))).orderBy((Table)DDMStructureTable.INSTANCE, orderByComparator).limit(start, end));
    }

    public int getStructuresCount(long companyId, long[] groupIds, long classNameId) {
        return this.getStructuresCount(companyId, groupIds, classNameId, "", -1);
    }

    public int getStructuresCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        return this.ddmStructurePersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)DDMStructureTable.INSTANCE.structureId).from((Table)DDMStructureTable.INSTANCE).where(this._getPredicate(companyId, groupIds, classNameId, keywords)));
    }

    public void revertStructure(long structureId, String version, ServiceContext serviceContext) throws PortalException {
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        this.ddmStructureLocalService.revertStructure(this.getUserId(), structureId, version, serviceContext);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, long classPK, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) throws PortalException {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, classPK, keywords, keywords, "", null, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructureLocalService)this.ddmStructureLocalService).fetchStructure(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String keywords, int type, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, keywords, keywords, "", type, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, keywords, keywords, "", null, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructureLocalService)this.ddmStructureLocalService).fetchStructure(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, name, description, storageType, type, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, long classPK, String keywords, int status) throws PortalException {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, classPK, keywords, keywords, "", null, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return 0;
        }
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, keywords, keywords, "", null, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return 0;
        }
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords, int type, int status) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, keywords, keywords, "", type, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return 0;
        }
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, name, description, storageType, type, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            return 0;
        }
    }

    public DDMStructure updateStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)structure, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(this.getUserId(), groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext);
    }

    public DDMStructure updateStructure(long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(this.getUserId(), structureId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext);
    }

    private Predicate _getPredicate(long companyId, long[] groupIds, long classNameId, String keywords) {
        Predicate predicate = DDMStructureTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)DDMStructureTable.INSTANCE.classNameId.eq((Object)classNameId)).and((Expression)DDMStructureTable.INSTANCE.type.eq((Object)0)).and((Expression)this._inlineSQLHelper.getPermissionWherePredicate(this._ddmPermissionSupport.getStructureModelResourceName(classNameId), DDMStructureTable.INSTANCE.structureId, groupIds));
        Predicate groupIdsPredicate = null;
        for (long groupId : groupIds) {
            Predicate groupIdPredicate = DDMStructureTable.INSTANCE.groupId.eq((Object)groupId);
            groupIdsPredicate = groupIdsPredicate == null ? groupIdPredicate : groupIdsPredicate.or((Expression)groupIdPredicate);
        }
        if (groupIdsPredicate != null) {
            predicate = predicate.and((Expression)groupIdsPredicate.withParentheses());
        }
        Predicate keywordsPredicate = null;
        for (String keyword : this._customSQL.keywords(keywords, true)) {
            if (keyword == null) continue;
            Predicate keywordPredicate = DSLFunctionFactoryUtil.lower((Expression)DSLFunctionFactoryUtil.castText((Expression)DDMStructureTable.INSTANCE.name)).like(keyword).or((Expression)DSLFunctionFactoryUtil.lower((Expression)DSLFunctionFactoryUtil.castClobText((Expression)DDMStructureTable.INSTANCE.description)).like(keyword));
            keywordsPredicate = keywordsPredicate == null ? keywordPredicate : keywordsPredicate.or((Expression)keywordPredicate);
        }
        if (keywordsPredicate != null) {
            predicate = predicate.and((Expression)keywordsPredicate.withParentheses());
        }
        return predicate;
    }
}

