/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_4_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class DDMFieldUpgradeProcess
extends UpgradeProcess {
    private static final int _MAX_LENGTH_FIELD_NAME = 255;
    private static final Log _log = LogFactoryUtil.getLog(DDMFieldUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMField set fieldName = ? where fieldId = ?");
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select fieldId, fieldName from DDMField");){
            while (resultSet.next()) {
                String fieldName = resultSet.getString("fieldName");
                if (fieldName == null || fieldName.length() <= 255) continue;
                long fieldId = resultSet.getLong("fieldId");
                preparedStatement.setString(1, StringUtil.shorten((String)fieldName, (int)255));
                preparedStatement.setLong(2, fieldId);
                preparedStatement.addBatch();
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Truncated the ", fieldName, " value for field ID ", fieldId, " because it is too long"}));
            }
            preparedStatement.executeBatch();
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.alterColumnType((String)"DDMField", (String)"fieldName", (String)"VARCHAR(255) null")};
    }
}

