/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_0;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFieldsCounter;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.view.count.service.ViewCountEntryLocalService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynamicDataMappingUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_DDM_STRUCTURE = "com.liferay.dynamic.data.mapping.model.DDMStructure";
    private static final String _CLASS_NAME_DDM_TEMPLATE = "com.liferay.dynamic.data.mapping.model.DDMTemplate";
    private static final String[] _DLFOLDER_GROUP_PERMISSIONS = new String[]{"ADD_DOCUMENT", "ADD_SHORTCUT", "ADD_SUBFOLDER", "SUBSCRIBE", "VIEW"};
    private static final String[] _DLFOLDER_GUEST_PERMISSIONS = new String[]{"VIEW"};
    private static final String[] _DLFOLDER_OWNER_PERMISSIONS = new String[]{"ACCESS", "ADD_DOCUMENT", "ADD_SHORTCUT", "ADD_SUBFOLDER", "DELETE", "PERMISSIONS", "SUBSCRIBE", "UPDATE", "VIEW"};
    private static final String _INVALID_FIELD_NAME_CHARS_REGEX = "([\\p{Punct}&&[^_]]|\\p{Space})+";
    private static final Log _log = LogFactoryUtil.getLog(DynamicDataMappingUpgradeProcess.class);
    private static final Pattern _invalidFieldNameCharsPattern = Pattern.compile("([\\p{Punct}&&[^_]]|\\p{Space})+");
    private final AssetEntryLocalService _assetEntryLocalService;
    private final ClassNameLocalService _classNameLocalService;
    private final DDM _ddm;
    private long _ddmContentClassNameId;
    private final DDMFormDeserializer _ddmFormJSONDeserializer;
    private final DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    private final Map<Long, DDMForm> _ddmForms = new HashMap<Long, DDMForm>();
    private final DDMFormSerializer _ddmFormSerializer;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final DDMFormDeserializer _ddmFormXSDDeserializer;
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final DLFileVersionLocalService _dlFileVersionLocalService;
    private final DLFolderLocalService _dlFolderLocalService;
    private final ModelPermissions _dlFolderModelPermissions;
    private final ExpandoRowLocalService _expandoRowLocalService;
    private long _expandoStorageAdapterClassNameId;
    private final ExpandoTableLocalService _expandoTableLocalService;
    private final ExpandoValueLocalService _expandoValueLocalService;
    private final Map<Long, DDMForm> _fullHierarchyDDMForms = new HashMap<Long, DDMForm>();
    private final ResourceLocalService _resourceLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final Store _store;
    private final Map<Long, Long> _structureClassNameIds = new HashMap<Long, Long>();
    private final Map<Long, Map<String, String>> _structureInvalidDDMFormFieldNamesMap = new HashMap<Long, Map<String, String>>();
    private Map<String, String> _structureModelResourceNames;
    private Map<String, String> _templateModelResourceNames;
    private final Map<Long, Long> _templateResourceClassNameIds = new HashMap<Long, Long>();
    private final ViewCountEntryLocalService _viewCountEntryLocalService;

    public DynamicDataMappingUpgradeProcess(AssetEntryLocalService assetEntryLocalService, ClassNameLocalService classNameLocalService, DDM ddm, DDMFormDeserializer ddmFormJSONDeserializer, DDMFormDeserializer ddmFormXSDDeserializer, DDMFormLayoutSerializer ddmFormLayoutSerializer, DDMFormSerializer ddmFormSerializer, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer, DLFileEntryLocalService dlFileEntryLocalService, DLFileVersionLocalService dlFileVersionLocalService, DLFolderLocalService dlFolderLocalService, ExpandoRowLocalService expandoRowLocalService, ExpandoTableLocalService expandoTableLocalService, ExpandoValueLocalService expandoValueLocalService, ResourceActions resourceActions, ResourceLocalService resourceLocalService, ResourcePermissionLocalService resourcePermissionLocalService, Store store, ViewCountEntryLocalService viewCountEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._classNameLocalService = classNameLocalService;
        this._ddm = ddm;
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
        this._ddmFormXSDDeserializer = ddmFormXSDDeserializer;
        this._ddmFormLayoutSerializer = ddmFormLayoutSerializer;
        this._ddmFormSerializer = ddmFormSerializer;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._dlFileVersionLocalService = dlFileVersionLocalService;
        this._dlFolderLocalService = dlFolderLocalService;
        this._expandoRowLocalService = expandoRowLocalService;
        this._expandoTableLocalService = expandoTableLocalService;
        this._expandoValueLocalService = expandoValueLocalService;
        this._resourceLocalService = resourceLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._store = store;
        this._viewCountEntryLocalService = viewCountEntryLocalService;
        this._dlFolderModelPermissions = ModelPermissionsFactory.create((String[])_DLFOLDER_GROUP_PERMISSIONS, (String[])_DLFOLDER_GUEST_PERMISSIONS, (String)DLFolder.class.getName());
        this._dlFolderModelPermissions.addRolePermissions("Owner", _DLFOLDER_OWNER_PERMISSIONS);
        this._initModelResourceNames(resourceActions);
    }

    protected void addDynamicContentElements(Element dynamicElementElement, String name, String data) {
        Map localizationMap = LocalizationUtil.getLocalizationMap((String)data);
        for (Map.Entry entry : localizationMap.entrySet()) {
            String[] values = StringUtil.split((String)((String)entry.getValue()));
            if (name.startsWith("_")) {
                values = new String[]{(String)entry.getValue()};
            }
            for (String value : values) {
                Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
                dynamicContentElement.addAttribute("language-id", LanguageUtil.getLanguageId((Locale)((Locale)entry.getKey())));
                dynamicContentElement.addCDATA(value.trim());
            }
        }
    }

    protected String createNewDDMFormFieldName(String fieldName, Set<String> existingFieldNames) throws Exception {
        String newFieldName = fieldName.replaceAll(_INVALID_FIELD_NAME_CHARS_REGEX, "");
        if (Validator.isNotNull((String)newFieldName)) {
            String updatedFieldName = newFieldName;
            int i = 1;
            while (existingFieldNames.contains(updatedFieldName)) {
                updatedFieldName = newFieldName + i;
                ++i;
            }
            return updatedFieldName;
        }
        throw new UpgradeException(String.format("Unable to automatically update field name \"%s\" because it only contains invalid characters", fieldName, newFieldName));
    }

    protected DDMForm deserialize(String content, String type) throws Exception {
        DDMFormDeserializer ddmFormDeserializer = null;
        if (StringUtil.equalsIgnoreCase((String)type, (String)"json")) {
            ddmFormDeserializer = this._ddmFormJSONDeserializer;
        } else if (StringUtil.equalsIgnoreCase((String)type, (String)"xsd")) {
            ddmFormDeserializer = this._ddmFormXSDDeserializer;
        }
        return DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)ddmFormDeserializer, (String)content);
    }

    protected void doUpgrade() throws Exception {
        this._setUpClassNameIds();
        this._upgradeExpandoStorageAdapter();
        this._upgradeStructuresAndAddStructureVersionsAndLayouts();
        this._upgradeTemplatesAndAddTemplateVersions();
        this._upgradeXMLStorageAdapter();
        this._upgradeFieldTypeReferences();
        this._upgradeStructuresPermissions();
        this._upgradeTemplatesPermissions();
    }

    protected DDMFormValues getDDMFormValues(long companyId, DDMForm ddmForm, String xml) throws Exception {
        DDMFormValuesXSDDeserializer ddmFormValuesXSDDeserializer = new DDMFormValuesXSDDeserializer(companyId);
        return ddmFormValuesXSDDeserializer.deserialize(ddmForm, xml);
    }

    protected boolean isInvalidFieldName(String fieldName) {
        Matcher matcher = _invalidFieldNameCharsPattern.matcher(fieldName);
        return matcher.find();
    }

    protected void populateStructureInvalidDDMFormFieldNamesMap(long structureId, DDMForm ddmForm) {
        HashMap<String, String> ddmFormFieldNamesMap = new HashMap<String, String>();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            String oldName = (String)ddmFormField.getProperty("oldName");
            if (oldName == null) continue;
            ddmFormFieldNamesMap.put(oldName, ddmFormField.getName());
        }
        this._structureInvalidDDMFormFieldNamesMap.put(structureId, ddmFormFieldNamesMap);
    }

    protected String renameInvalidDDMFormFieldNames(long structureId, String string) {
        Map<String, String> ddmFormFieldNamesMap = this._structureInvalidDDMFormFieldNamesMap.get(structureId);
        if (ddmFormFieldNamesMap == null || ddmFormFieldNamesMap.isEmpty()) {
            return string;
        }
        Set<String> oldFieldNames = ddmFormFieldNamesMap.keySet();
        String[] oldSub = oldFieldNames.toArray(new String[0]);
        String[] newSub = new String[oldFieldNames.size()];
        for (int i = 0; i < oldSub.length; ++i) {
            newSub[i] = ddmFormFieldNamesMap.get(oldSub[i]);
        }
        return StringUtil.replace((String)string, (String[])oldSub, (String[])newSub);
    }

    protected String toJSON(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._ddmFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    protected String toXML(Map<String, String> expandoValuesMap) {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        for (Map.Entry<String, String> entry : expandoValuesMap.entrySet()) {
            Element dynamicElementElement = rootElement.addElement("dynamic-element");
            String name = entry.getKey();
            String data = entry.getValue();
            dynamicElementElement.addAttribute("name", name);
            dynamicElementElement.addAttribute("default-language-id", LocalizationUtil.getDefaultLanguageId((String)data));
            this.addDynamicContentElements(dynamicElementElement, name, data);
        }
        return document.asXML();
    }

    private void _deleteExpandoData(Set<Long> expandoRowIds) throws PortalException {
        HashSet<Long> expandoTableIds = new HashSet<Long>();
        for (long expandoRowId : expandoRowIds) {
            ExpandoRow expandoRow = this._expandoRowLocalService.fetchExpandoRow(expandoRowId);
            if (expandoRow == null) continue;
            expandoTableIds.add(expandoRow.getTableId());
        }
        for (long expandoTableId : expandoTableIds) {
            try {
                this._expandoTableLocalService.deleteTable(expandoTableId);
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable delete expando table", (Throwable)portalException);
                throw portalException;
            }
        }
    }

    private List<String> _getDDMDateFieldNames(DDMForm ddmForm) throws Exception {
        ArrayList<String> ddmDateFieldNames = new ArrayList<String>();
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            String dataType = ddmFormField.getType();
            if (!dataType.equals("ddm-date")) continue;
            ddmDateFieldNames.add(ddmFormField.getName());
        }
        return ddmDateFieldNames;
    }

    /*
     * Loose catch block
     */
    private DDMForm _getDDMForm(long structureId) throws Exception {
        DDMForm ddmForm = this._ddmForms.get(structureId);
        if (ddmForm != null) {
            return ddmForm;
        }
        Throwable throwable = null;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select parentStructureId, definition, storageType from DDMStructure where structureId = ?");){
            Throwable throwable2;
            ResultSet resultSet;
            block33: {
                DDMForm dDMForm;
                block34: {
                    block35: {
                        DDMForm parentDDMForm;
                        Set commonDDMFormFieldNames;
                        preparedStatement.setLong(1, structureId);
                        resultSet = preparedStatement.executeQuery();
                        throwable2 = null;
                        if (!resultSet.next()) break block33;
                        String definition = resultSet.getString("definition");
                        String storageType = resultSet.getString("storageType");
                        ddmForm = storageType.equals("expando") || storageType.equals("xml") ? this.deserialize(definition, "xsd") : this.deserialize(definition, "json");
                        try {
                            this._validateDDMFormFieldNames(ddmForm);
                        }
                        catch (DDMFormValidationException.MustNotDuplicateFieldName mndfn) {
                            throw new UpgradeException(String.format("The field name '%s' from structure ID %d is defined more than once", mndfn.getFieldName(), structureId));
                        }
                        long parentStructureId = resultSet.getLong("parentStructureId");
                        if (parentStructureId > 0L && !(commonDDMFormFieldNames = SetUtil.intersect(this._getDDMFormFieldsNames(parentDDMForm = this._getDDMForm(parentStructureId)), this._getDDMFormFieldsNames(ddmForm))).isEmpty()) {
                            throw new UpgradeException("Duplicate DDM form field names: " + StringUtil.merge((Collection)commonDDMFormFieldNames));
                        }
                        DDMForm updatedDDMForm = this._updateDDMFormFields(ddmForm);
                        this._ddmForms.put(structureId, updatedDDMForm);
                        dDMForm = updatedDDMForm;
                        if (resultSet == null) break block34;
                        if (throwable2 == null) break block35;
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block34;
                    }
                    resultSet.close();
                }
                return dDMForm;
            }
            try {
                block36: {
                    if (resultSet != null) {
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                    break block36;
                    catch (Throwable throwable5) {
                        try {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (resultSet != null) {
                                if (throwable2 != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                } else {
                                    resultSet.close();
                                }
                            }
                            throw throwable6;
                        }
                    }
                }
                throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
    }

    private Set<String> _getDDMFormFieldsNames(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        HashSet<String> ddmFormFieldsNames = new HashSet<String>();
        for (String ddmFormFieldName : ddmFormFieldsMap.keySet()) {
            ddmFormFieldsNames.add(StringUtil.toLowerCase((String)ddmFormFieldName));
        }
        return ddmFormFieldsNames;
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> _getDDMTemplateScriptMap(long structureId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String _getDefaultDDMFormLayoutDefinition(DDMForm ddmForm) {
        DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
        DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(builder.build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    private Map<String, String> _getExpandoValuesMap(long expandoRowId) throws PortalException {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        List expandoValues = this._expandoValueLocalService.getRowValues(expandoRowId);
        for (ExpandoValue expandoValue : expandoValues) {
            ExpandoColumn expandoColumn = expandoValue.getColumn();
            fieldsMap.put(expandoColumn.getName(), expandoValue.getData());
        }
        return fieldsMap;
    }

    /*
     * Loose catch block
     */
    private DDMForm _getFullHierarchyDDMForm(long structureId) throws Exception {
        DDMForm fullHierarchyDDMForm = this._fullHierarchyDDMForms.get(structureId);
        if (fullHierarchyDDMForm != null) {
            return fullHierarchyDDMForm;
        }
        Throwable throwable = null;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select parentStructureId from DDMStructure where structureId = ?");){
            Throwable throwable2;
            ResultSet resultSet;
            block31: {
                DDMForm dDMForm;
                block32: {
                    block33: {
                        preparedStatement.setLong(1, structureId);
                        resultSet = preparedStatement.executeQuery();
                        throwable2 = null;
                        if (!resultSet.next()) break block31;
                        long parentStructureId = resultSet.getLong("parentStructureId");
                        fullHierarchyDDMForm = this._getDDMForm(structureId);
                        if (parentStructureId > 0L) {
                            DDMForm parentDDMForm = this._getFullHierarchyDDMForm(parentStructureId);
                            List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
                            ddmFormFields.addAll(parentDDMForm.getDDMFormFields());
                        }
                        this._fullHierarchyDDMForms.put(structureId, fullHierarchyDDMForm);
                        dDMForm = fullHierarchyDDMForm;
                        if (resultSet == null) break block32;
                        if (throwable2 == null) break block33;
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block32;
                    }
                    resultSet.close();
                }
                return dDMForm;
            }
            try {
                block34: {
                    if (resultSet != null) {
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                    break block34;
                    catch (Throwable throwable5) {
                        try {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (resultSet != null) {
                                if (throwable2 != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                } else {
                                    resultSet.close();
                                }
                            }
                            throw throwable6;
                        }
                    }
                }
                throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
    }

    private String _getStructureModelResourceName(long classNameId) throws Exception {
        String className = PortalUtil.getClassName((long)classNameId);
        String structureModelResourceName = this._structureModelResourceNames.get(className);
        if (structureModelResourceName == null) {
            throw new UpgradeException(StringBundler.concat((String[])new String[]{"Model ", className, " does not support DDM structure ", "permission checking"}));
        }
        return structureModelResourceName;
    }

    private String _getTemplateModelResourceName(long classNameId) throws Exception {
        String className = PortalUtil.getClassName((long)classNameId);
        String templateModelResourceName = this._templateModelResourceNames.get(className);
        if (templateModelResourceName == null) {
            throw new UpgradeException(StringBundler.concat((String[])new String[]{"Model ", className, " does not support DDM template ", "permission checking"}));
        }
        return templateModelResourceName;
    }

    private Long _getTemplateResourceClassNameId(long classNameId, long classPK) {
        if (classNameId != PortalUtil.getClassNameId(DDMStructure.class)) {
            return PortalUtil.getClassNameId((String)"com.liferay.portlet.display.template.PortletDisplayTemplate");
        }
        if (classPK == 0L) {
            return PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle");
        }
        return this._structureClassNameIds.get(classPK);
    }

    /*
     * Exception decompiling
     */
    private boolean _hasStructureVersion(long structureId, String version) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean _hasTemplateVersion(long templateId, String version) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _initModelResourceNames(ResourceActions resourceActions) {
        this._structureModelResourceNames = HashMapBuilder.put((Object)"com.liferay.document.library.kernel.model.DLFileEntry", (Object)resourceActions.getCompositeModelName(new String[]{"com.liferay.document.library.kernel.model.DLFileEntry", _CLASS_NAME_DDM_STRUCTURE})).put((Object)"com.liferay.document.library.kernel.model.DLFileEntryMetadata", (Object)resourceActions.getCompositeModelName(new String[]{"com.liferay.document.library.kernel.model.DLFileEntryMetadata", _CLASS_NAME_DDM_STRUCTURE})).put((Object)"com.liferay.document.library.kernel.util.RawMetadataProcessor", (Object)_CLASS_NAME_DDM_STRUCTURE).put((Object)"com.liferay.dynamic.data.lists.model.DDLRecordSet", (Object)resourceActions.getCompositeModelName(new String[]{"com.liferay.dynamic.data.lists.model.DDLRecordSet", _CLASS_NAME_DDM_STRUCTURE})).put((Object)"com.liferay.journal.model.JournalArticle", (Object)resourceActions.getCompositeModelName(new String[]{"com.liferay.journal.model.JournalArticle", _CLASS_NAME_DDM_STRUCTURE})).put((Object)"com.liferay.portlet.dynamicdatalists.model.DDLRecordSet", (Object)resourceActions.getCompositeModelName(new String[]{"com.liferay.dynamic.data.lists.model.DDLRecordSet", _CLASS_NAME_DDM_STRUCTURE})).build();
        this._templateModelResourceNames = HashMapBuilder.put((Object)"com.liferay.dynamic.data.lists.model.DDLRecordSet", (Object)resourceActions.getCompositeModelName(new String[]{"com.liferay.dynamic.data.lists.model.DDLRecordSet", _CLASS_NAME_DDM_TEMPLATE})).put((Object)"com.liferay.journal.model.JournalArticle", (Object)resourceActions.getCompositeModelName(new String[]{"com.liferay.journal.model.JournalArticle", _CLASS_NAME_DDM_TEMPLATE})).put((Object)"com.liferay.portlet.display.template.PortletDisplayTemplate", (Object)_CLASS_NAME_DDM_TEMPLATE).put((Object)"com.liferay.portlet.dynamicdatalists.model.DDLRecordSet", (Object)resourceActions.getCompositeModelName(new String[]{"com.liferay.dynamic.data.lists.model.DDLRecordSet", _CLASS_NAME_DDM_TEMPLATE})).build();
    }

    private void _setUpClassNameIds() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._ddmContentClassNameId = PortalUtil.getClassNameId(DDMContent.class);
            this._expandoStorageAdapterClassNameId = PortalUtil.getClassNameId((String)"com.liferay.portlet.dynamicdatamapping.storage.ExpandoStorageAdapter");
        }
    }

    private void _transformFieldTypeDDMFormFields(long groupId, long companyId, long userId, String userName, Timestamp createDate, long entryId, String entryVersion, String entryModelName, DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new FileUploadDDMFormFieldValueTransformer(groupId, companyId, userId, userName, createDate, entryId, entryVersion, entryModelName));
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new DateDDMFormFieldValueTransformer());
        ddmFormValuesTransformer.transform();
    }

    private DDMForm _updateDDMFormFields(DDMForm ddmForm) throws Exception {
        DDMForm copyDDMForm = new DDMForm(ddmForm);
        Map ddmFormFieldsMap = copyDDMForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            String dataType;
            String fieldName = ddmFormField.getName();
            if (this.isInvalidFieldName(fieldName)) {
                String newFieldName = this.createNewDDMFormFieldName(fieldName, ddmFormFieldsMap.keySet());
                ddmFormField.setName(newFieldName);
                ddmFormField.setProperty("oldName", (Object)fieldName);
            }
            if (Objects.equals(dataType = ddmFormField.getDataType(), "file-upload")) {
                ddmFormField.setDataType("document-library");
                ddmFormField.setType("ddm-documentlibrary");
                continue;
            }
            if (!Objects.equals(dataType, "image")) continue;
            ddmFormField.setFieldNamespace("ddm");
            ddmFormField.setType("ddm-image");
        }
        return copyDDMForm;
    }

    private void _updateDDMStructureStorageType() throws Exception {
        this.runSQL("update DDMStructure set storageType = 'xml' where storageType = 'expando'");
    }

    private void _updateStructureStorageType() throws Exception {
        this.runSQL("update DDMStructure set storageType='json' where storageType = 'xml'");
    }

    private void _updateStructureVersionStorageType() throws Exception {
        this.runSQL("update DDMStructureVersion set storageType='json' where storageType = 'xml'");
    }

    private void _updateTemplateScript(long templateId, String script) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DDMTemplate set script = ? where templateId = ?");){
            preparedStatement.setString(1, script);
            preparedStatement.setLong(2, templateId);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to update dynamic data mapping template with template ID " + templateId));
            throw exception;
        }
    }

    private String _updateTemplateScriptDateAssignStatement(String dateFieldName, String language, String script) {
        StringBundler oldTemplateScriptSB = new StringBundler(7);
        StringBundler newTemplateScriptSB = new StringBundler(5);
        if (language.equals("ftl")) {
            oldTemplateScriptSB.append("<#assign\\s+");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_Data\\s*=\\s*getterUtil\\s*.");
            oldTemplateScriptSB.append("\\s*getLong\\s*\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append(".\\s*getData\\s*\\(\\s*\\)");
            oldTemplateScriptSB.append("\\s*\\)\\s*/?>");
            newTemplateScriptSB.append("<#assign ");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_Data = getterUtil.getString(");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append(".getData()) />");
        } else if (language.equals("vm")) {
            dateFieldName = "\\$" + dateFieldName;
            oldTemplateScriptSB.append("#set\\s+\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_Data\\s*=\\s*\\$getterUtil.");
            oldTemplateScriptSB.append("getLong\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append(".getData\\(\\)\\s*\\)\\s*\\)");
            newTemplateScriptSB.append("#set (");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_Data = \\$getterUtil.getString(");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append(".getData()))");
        }
        return script.replaceAll(oldTemplateScriptSB.toString(), newTemplateScriptSB.toString());
    }

    private void _updateTemplateScriptDateFields(long structureId, DDMForm ddmForm) throws Exception {
        List<String> ddmDateFieldNames = this._getDDMDateFieldNames(ddmForm);
        if (ddmDateFieldNames.isEmpty()) {
            return;
        }
        Map<String, String> ddmTemplateScriptMap = this._getDDMTemplateScriptMap(structureId);
        for (Map.Entry<String, String> entrySet : ddmTemplateScriptMap.entrySet()) {
            String[] templateIdAndLanguage = StringUtil.split((String)entrySet.getKey(), (String)"$");
            long ddmTemplateId = GetterUtil.getLong((String)templateIdAndLanguage[0]);
            String language = templateIdAndLanguage[1];
            String script = entrySet.getValue();
            for (String ddmDateFieldName : ddmDateFieldNames) {
                script = this._updateTemplateScriptDateAssignStatement(ddmDateFieldName, language, script);
                script = this._updateTemplateScriptDateIfStatement(ddmDateFieldName, language, script);
                script = this._updateTemplateScriptDateParseStatement(ddmDateFieldName, language, script);
                script = this._updateTemplateScriptDateGetDateStatement(language, script);
            }
            this._updateTemplateScript(ddmTemplateId, script);
        }
    }

    private String _updateTemplateScriptDateGetDateStatement(String language, String script) {
        StringBundler oldTemplateScriptSB = new StringBundler(3);
        String newTemplateScript = null;
        if (language.equals("ftl")) {
            oldTemplateScriptSB.append("dateUtil.getDate\\((.*)");
            oldTemplateScriptSB.append("locale[,\\s]*timeZoneUtil.");
            oldTemplateScriptSB.append("getTimeZone\\(\"UTC\"\\)\\s*\\)");
            newTemplateScript = "dateUtil.getDate($1locale)";
        } else if (language.equals("vm")) {
            oldTemplateScriptSB.append("dateUtil.getDate\\((.*)");
            oldTemplateScriptSB.append("\\$locale[,\\s]*\\$timeZoneUtil.");
            oldTemplateScriptSB.append("getTimeZone\\(\"UTC\"\\)\\s*\\)");
            newTemplateScript = "dateUtil.getDate($1\\$locale)";
        }
        return script.replaceAll(oldTemplateScriptSB.toString(), newTemplateScript);
    }

    private String _updateTemplateScriptDateIfStatement(String dateFieldName, String language, String script) {
        String oldTemplateScript = "";
        String newTemplateScript = "";
        if (language.equals("ftl")) {
            oldTemplateScript = StringBundler.concat((String[])new String[]{"<#if\\s*\\(?\\s*", dateFieldName, "_Data\\s*>\\s*0\\s*\\)?", "\\s*>"});
            newTemplateScript = "<#if validator.isNotNull(" + dateFieldName + "_Data)>";
        } else if (language.equals("vm")) {
            dateFieldName = "\\$" + dateFieldName;
            oldTemplateScript = "#if\\s*\\(\\s*" + dateFieldName + "_Data\\s*>\\s*0\\s*\\)";
            newTemplateScript = "#if (\\$validator.isNotNull(" + dateFieldName + "_Data))";
        }
        return script.replaceAll(oldTemplateScript, newTemplateScript);
    }

    private String _updateTemplateScriptDateParseStatement(String dateFieldName, String language, String script) {
        StringBundler oldTemplateScriptSB = new StringBundler(6);
        StringBundler newTemplateScriptSB = new StringBundler(5);
        if (language.equals("ftl")) {
            oldTemplateScriptSB.append("<#assign\\s+");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_DateObj\\s*=\\s*dateUtil\\s*.");
            oldTemplateScriptSB.append("\\s*newDate\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_Data\\s*\\)\\s*/?>");
            newTemplateScriptSB.append("<#assign ");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_DateObj = dateUtil.parseDate(\"yyyy-MM-dd\", ");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_Data, locale) />");
        } else if (language.equals("vm")) {
            dateFieldName = "\\$" + dateFieldName;
            oldTemplateScriptSB.append("#set\\s*\\(");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_DateObj\\s*=\\s*\\$dateUtil.");
            oldTemplateScriptSB.append("newDate\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_Data\\s*\\)\\s*\\)");
            newTemplateScriptSB.append("#set (");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_DateObj = \\$dateUtil.parseDate(\"yyyy-MM-dd\", ");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_Data, \\$locale))");
        }
        return script.replaceAll(oldTemplateScriptSB.toString(), newTemplateScriptSB.toString());
    }

    private void _upgradeDDLFieldTypeReferences() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDLRecordVersion.*, DDMContent.data_, ", "DDMStructure.structureId from DDLRecordVersion inner ", "join DDLRecordSet on DDLRecordVersion.recordSetId = ", "DDLRecordSet.recordSetId inner join DDMContent on  ", "DDLRecordVersion.DDMStorageId = DDMContent.contentId ", "inner join DDMStructure on DDLRecordSet.DDMStructureId = ", "DDMStructure.structureId"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_= ? where contentId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp createDate = resultSet.getTimestamp("createDate");
                long entryId = resultSet.getLong("recordId");
                String entryVersion = resultSet.getString("version");
                long contentId = resultSet.getLong("ddmStorageId");
                String data_ = resultSet.getString("data_");
                long ddmStructureId = resultSet.getLong("structureId");
                DDMForm ddmForm = this._getFullHierarchyDDMForm(ddmStructureId);
                DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)data_, (DDMForm)ddmForm, (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
                this._transformFieldTypeDDMFormFields(groupId, companyId, userId, userName, createDate, entryId, entryVersion, "DDLRecord", ddmFormValues);
                preparedStatement2.setString(1, this.toJSON(ddmFormValues));
                preparedStatement2.setLong(2, contentId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _upgradeDLFieldTypeReferences() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DLFileVersion.*, DDMContent.contentId, ", "DDMContent.data_, DDMStructure.structureId from ", "DLFileEntryMetadata inner join DDMContent on ", "DLFileEntryMetadata.DDMStorageId = DDMContent.contentId ", "inner join DDMStructure on ", "DLFileEntryMetadata.DDMStructureId = DDMStructure.", "structureId inner join DLFileVersion on ", "DLFileEntryMetadata.fileVersionId = DLFileVersion.", "fileVersionId and DLFileEntryMetadata.fileEntryId = ", "DLFileVersion.fileEntryId"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_= ? where contentId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp createDate = resultSet.getTimestamp("createDate");
                long entryId = resultSet.getLong("fileEntryId");
                String entryVersion = resultSet.getString("version");
                long contentId = resultSet.getLong("contentId");
                String data_ = resultSet.getString("data_");
                long ddmStructureId = resultSet.getLong("structureId");
                DDMForm ddmForm = this._getFullHierarchyDDMForm(ddmStructureId);
                DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)data_, (DDMForm)ddmForm, (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
                this._transformFieldTypeDDMFormFields(groupId, companyId, userId, userName, createDate, entryId, entryVersion, "DLFileEntry", ddmFormValues);
                preparedStatement2.setString(1, this.toJSON(ddmFormValues));
                preparedStatement2.setLong(2, contentId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _upgradeExpandoStorageAdapter() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructure.*, DDMStorageLink.* from ", "DDMStorageLink inner join DDMStructure on ", "DDMStorageLink.structureId = ", "DDMStructure.structureId where ", "DDMStructure.storageType = 'expando'"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMContent (uuid_, contentId, ", "groupId, companyId, userId, userName, ", "createDate, modifiedDate, name, description, ", "data_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"}));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStorageLink set classNameId = ? where classNameId = ? and classPK = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            HashSet<Long> expandoRowIds = new HashSet<Long>();
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp createDate = resultSet.getTimestamp("createDate");
                long expandoRowId = resultSet.getLong("classPK");
                String xml = this.toXML(this._getExpandoValuesMap(expandoRowId));
                preparedStatement2.setString(1, PortalUUIDUtil.generate());
                preparedStatement2.setLong(2, expandoRowId);
                preparedStatement2.setLong(3, groupId);
                preparedStatement2.setLong(4, companyId);
                preparedStatement2.setLong(5, userId);
                preparedStatement2.setString(6, userName);
                preparedStatement2.setTimestamp(7, createDate);
                preparedStatement2.setTimestamp(8, createDate);
                preparedStatement2.setString(9, DDMStorageLink.class.getName());
                preparedStatement2.setString(10, null);
                preparedStatement2.setString(11, xml);
                preparedStatement2.addBatch();
                preparedStatement3.setLong(1, this._ddmContentClassNameId);
                preparedStatement3.setLong(2, this._expandoStorageAdapterClassNameId);
                preparedStatement3.setLong(3, expandoRowId);
                preparedStatement3.addBatch();
                expandoRowIds.add(expandoRowId);
            }
            if (expandoRowIds.isEmpty()) {
                return;
            }
            preparedStatement2.executeBatch();
            preparedStatement3.executeBatch();
            this._updateDDMStructureStorageType();
            this._deleteExpandoData(expandoRowIds);
        }
    }

    private void _upgradeFieldTypeReferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._upgradeDDLFieldTypeReferences();
            this._upgradeDLFieldTypeReferences();
        }
    }

    private void _upgradeStructurePermissions(long companyId, long structureId) throws Exception {
        List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(companyId, DDMStructure.class.getName(), 4, String.valueOf(structureId));
        for (ResourcePermission resourcePermission : resourcePermissions) {
            Long classNameId = this._structureClassNameIds.get(Long.valueOf(resourcePermission.getPrimKey()));
            if (classNameId == null) continue;
            String resourceName = this._getStructureModelResourceName(classNameId);
            ResourcePermission existingResourcePermission = this._resourcePermissionLocalService.fetchResourcePermission(companyId, resourceName, 4, String.valueOf(structureId), resourcePermission.getRoleId());
            if (existingResourcePermission != null) {
                this._resourcePermissionLocalService.deleteResourcePermission(resourcePermission.getResourcePermissionId());
                continue;
            }
            resourcePermission.setName(resourceName);
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        }
    }

    private void _upgradeStructuresAndAddStructureVersionsAndLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from DDMStructure");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMStructureVersion (structureVersionId, ", "groupId, companyId, userId, userName, createDate, ", "structureId, version, parentStructureId, name, ", "description, definition, storageType, type_, status, ", "statusByUserId, statusByUserName, statusDate) values ", "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?)"}));
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMStructureLayout (uuid_, ", "structureLayoutId, groupId, companyId, userId, ", "userName, createDate, modifiedDate, ", "structureVersionId, definition) values (?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?)"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long structureId = resultSet.getLong("structureId");
                long classNameId = resultSet.getLong("classNameId");
                String version = resultSet.getString("version");
                this._structureClassNameIds.put(structureId, classNameId);
                DDMForm ddmForm = this._getDDMForm(structureId);
                this.populateStructureInvalidDDMFormFieldNamesMap(structureId, ddmForm);
                String definition = DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
                preparedStatement2.setString(1, definition);
                preparedStatement2.setLong(2, structureId);
                preparedStatement2.addBatch();
                this._updateTemplateScriptDateFields(structureId, ddmForm);
                if (this._hasStructureVersion(structureId, version)) continue;
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp modifiedDate = resultSet.getTimestamp("modifiedDate");
                long parentStructureId = resultSet.getLong("parentStructureId");
                String name = resultSet.getString("name");
                String description = resultSet.getString("description");
                String storageType = resultSet.getString("storageType");
                int type = resultSet.getInt("type_");
                long structureVersionId = this.increment();
                preparedStatement3.setLong(1, structureVersionId);
                preparedStatement3.setLong(2, groupId);
                preparedStatement3.setLong(3, companyId);
                preparedStatement3.setLong(4, userId);
                preparedStatement3.setString(5, userName);
                preparedStatement3.setTimestamp(6, modifiedDate);
                preparedStatement3.setLong(7, structureId);
                preparedStatement3.setString(8, "1.0");
                preparedStatement3.setLong(9, parentStructureId);
                preparedStatement3.setString(10, name);
                preparedStatement3.setString(11, description);
                preparedStatement3.setString(12, definition);
                preparedStatement3.setString(13, storageType);
                preparedStatement3.setInt(14, type);
                preparedStatement3.setInt(15, 0);
                preparedStatement3.setLong(16, userId);
                preparedStatement3.setString(17, userName);
                preparedStatement3.setTimestamp(18, modifiedDate);
                preparedStatement3.addBatch();
                String ddmFormLayoutDefinition = this._getDefaultDDMFormLayoutDefinition(ddmForm);
                preparedStatement4.setString(1, PortalUUIDUtil.generate());
                preparedStatement4.setLong(2, this.increment());
                preparedStatement4.setLong(3, groupId);
                preparedStatement4.setLong(4, companyId);
                preparedStatement4.setLong(5, userId);
                preparedStatement4.setString(6, userName);
                preparedStatement4.setTimestamp(7, modifiedDate);
                preparedStatement4.setTimestamp(8, modifiedDate);
                preparedStatement4.setLong(9, structureVersionId);
                preparedStatement4.setString(10, ddmFormLayoutDefinition);
                preparedStatement4.addBatch();
            }
            preparedStatement2.executeBatch();
            preparedStatement3.executeBatch();
            preparedStatement4.executeBatch();
        }
    }

    private void _upgradeStructuresPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select * from DDMStructure");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                long structureId = resultSet.getLong("structureId");
                this._upgradeStructurePermissions(companyId, structureId);
            }
        }
    }

    private void _upgradeTemplatePermissions(long companyId, long templateId) throws Exception {
        List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(companyId, DDMTemplate.class.getName(), 4, String.valueOf(templateId));
        for (ResourcePermission resourcePermission : resourcePermissions) {
            Long classNameId = this._templateResourceClassNameIds.get(Long.valueOf(resourcePermission.getPrimKey()));
            if (classNameId == null) continue;
            String resourceName = this._getTemplateModelResourceName(classNameId);
            resourcePermission.setName(resourceName);
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        }
    }

    private void _upgradeTemplatesAndAddTemplateVersions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from DDMTemplate");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplate set resourceClassNameId = ? where templateId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplate set language = ?, script = ? where templateId = ?");
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMTemplateVersion (templateVersionId, ", "groupId, companyId, userId, userName, createDate, ", "classNameId, classPK, templateId, version, name, ", "description, language, script, status, ", "statusByUserId, statusByUserName, statusDate) values ", "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?)"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long classNameId = resultSet.getLong("classNameId");
                long classPK = resultSet.getLong("classPK");
                long templateId = resultSet.getLong("templateId");
                Long resourceClassNameId = this._getTemplateResourceClassNameId(classNameId, classPK);
                if (resourceClassNameId == null && _log.isWarnEnabled()) {
                    _log.warn((Object)("Orphaned DDM template " + templateId));
                    continue;
                }
                String version = resultSet.getString("version");
                String language = resultSet.getString("language");
                String script = resultSet.getString("script");
                preparedStatement2.setLong(1, resourceClassNameId);
                preparedStatement2.setLong(2, templateId);
                preparedStatement2.addBatch();
                this._templateResourceClassNameIds.put(templateId, resourceClassNameId);
                String updatedScript = this.renameInvalidDDMFormFieldNames(classPK, script);
                if (language.equals("xsd")) {
                    DDMForm ddmForm = this.deserialize(updatedScript, "xsd");
                    ddmForm = this._updateDDMFormFields(ddmForm);
                    updatedScript = DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer);
                    language = "json";
                }
                if (!script.equals(updatedScript)) {
                    preparedStatement3.setString(1, language);
                    preparedStatement3.setString(2, updatedScript);
                    preparedStatement3.setLong(3, templateId);
                    preparedStatement3.addBatch();
                }
                if (this._hasTemplateVersion(templateId, version)) continue;
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp modifiedDate = resultSet.getTimestamp("modifiedDate");
                preparedStatement4.setLong(1, this.increment());
                preparedStatement4.setLong(2, resultSet.getLong("groupId"));
                preparedStatement4.setLong(3, resultSet.getLong("companyId"));
                preparedStatement4.setLong(4, userId);
                preparedStatement4.setString(5, userName);
                preparedStatement4.setTimestamp(6, modifiedDate);
                preparedStatement4.setLong(7, classNameId);
                preparedStatement4.setLong(8, classPK);
                preparedStatement4.setLong(9, templateId);
                preparedStatement4.setString(10, "1.0");
                preparedStatement4.setString(11, resultSet.getString("name"));
                preparedStatement4.setString(12, resultSet.getString("description"));
                preparedStatement4.setString(13, language);
                preparedStatement4.setString(14, updatedScript);
                preparedStatement4.setInt(15, 0);
                preparedStatement4.setLong(16, userId);
                preparedStatement4.setString(17, userName);
                preparedStatement4.setTimestamp(18, modifiedDate);
                preparedStatement4.addBatch();
            }
            preparedStatement2.executeBatch();
            preparedStatement3.executeBatch();
            preparedStatement4.executeBatch();
        }
    }

    private void _upgradeTemplatesPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select * from DDMTemplate");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                long templateId = resultSet.getLong("templateId");
                this._upgradeTemplatePermissions(companyId, templateId);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _upgradeXMLStorageAdapter() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStorageLink.classPK, DDMStorageLink.", "structureId from DDMStorageLink inner join ", "DDMStructure on (DDMStorageLink.structureId = ", "DDMStructure.structureId) where DDMStorageLink.", "classNameId = ? and DDMStructure.storageType = ", "?"}));
                 PreparedStatement preparedStatement2 = this.connection.prepareStatement("select companyId, data_ from DDMContent where contentId = ? and data_ like '<%'");
                 PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_= ? where contentId = ?");){
                preparedStatement1.setLong(1, this._ddmContentClassNameId);
                preparedStatement1.setString(2, "xml");
                try (ResultSet resultSet = preparedStatement1.executeQuery();){
                    while (resultSet.next()) {
                        ResultSet resultSet2;
                        block71: {
                            long structureId = resultSet.getLong("structureId");
                            long classPK = resultSet.getLong("classPK");
                            DDMForm ddmForm = this._getFullHierarchyDDMForm(structureId);
                            preparedStatement2.setLong(1, classPK);
                            resultSet2 = preparedStatement2.executeQuery();
                            Throwable throwable = null;
                            try {
                                if (resultSet2.next()) {
                                    long companyId = resultSet2.getLong("companyId");
                                    String xml = this.renameInvalidDDMFormFieldNames(structureId, resultSet2.getString("data_"));
                                    String content = this.toJSON(this.getDDMFormValues(companyId, ddmForm, xml));
                                    preparedStatement3.setString(1, content);
                                    preparedStatement3.setLong(2, classPK);
                                    preparedStatement3.addBatch();
                                }
                                if (resultSet2 == null) continue;
                                if (throwable == null) break block71;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (resultSet2 == null) throw throwable3;
                                    if (throwable == null) {
                                        resultSet2.close();
                                        throw throwable3;
                                    }
                                    try {
                                        resultSet2.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                resultSet2.close();
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                continue;
                            }
                        }
                        resultSet2.close();
                    }
                    preparedStatement3.executeBatch();
                }
            }
            this._updateStructureStorageType();
            this._updateStructureVersionStorageType();
            return;
        }
    }

    private void _validateDDMFormFieldName(DDMFormField ddmFormField, Set<String> ddmFormFieldNames) throws DDMFormValidationException.MustNotDuplicateFieldName {
        if (ddmFormFieldNames.contains(StringUtil.toLowerCase((String)ddmFormField.getName()))) {
            throw new DDMFormValidationException.MustNotDuplicateFieldName(ddmFormField.getName());
        }
        ddmFormFieldNames.add(StringUtil.toLowerCase((String)ddmFormField.getName()));
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this._validateDDMFormFieldName(nestedDDMFormField, ddmFormFieldNames);
        }
    }

    private void _validateDDMFormFieldNames(DDMForm ddmForm) throws DDMFormValidationException.MustNotDuplicateFieldName {
        List ddmFormFields = ddmForm.getDDMFormFields();
        HashSet<String> ddmFormFieldNames = new HashSet<String>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            this._validateDDMFormFieldName(ddmFormField, ddmFormFieldNames);
        }
    }

    private class FileUploadDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final long _companyId;
        private final Timestamp _createDate;
        private final ModelPermissions _dlFileEntryModelPermissions;
        private final long _entryId;
        private final String _entryModelName;
        private final String _entryVersion;
        private final long _groupId;
        private final String[] _groupPermissions = new String[]{"ADD_DISCUSSION", "VIEW"};
        private final String[] _guestPermissions = new String[]{"ADD_DISCUSSION", "VIEW"};
        private final Timestamp _now = new Timestamp(System.currentTimeMillis());
        private final String[] _ownerPermissions = new String[]{"ADD_DISCUSSION", "DELETE", "DELETE_DISCUSSION", "OVERRIDE_CHECKOUT", "PERMISSIONS", "UPDATE", "UPDATE_DISCUSSION", "VIEW"};
        private final long _userId;
        private final String _userName;

        public FileUploadDDMFormFieldValueTransformer(long groupId, long companyId, long userId, String userName, Timestamp createDate, long entryId, String entryVersion, String entryModelName) {
            this._groupId = groupId;
            this._companyId = companyId;
            this._userId = userId;
            this._userName = userName;
            this._createDate = createDate;
            this._entryId = entryId;
            this._entryVersion = entryVersion;
            this._entryModelName = entryModelName;
            this._dlFileEntryModelPermissions = ModelPermissionsFactory.create((String[])this._groupPermissions, (String[])this._guestPermissions, (String)DLFileEntry.class.getName());
            this._dlFileEntryModelPermissions.addRolePermissions("Owner", this._ownerPermissions);
        }

        public String getFieldType() {
            return "ddm-fileupload";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                for (Locale locale : value.getAvailableLocales()) {
                    String valueString = value.getString(locale);
                    if (Validator.isNull((String)valueString)) continue;
                    String fileEntryUuid = PortalUUIDUtil.generate();
                    this.upgradeFileUploadReference(fileEntryUuid, ddmFormFieldValue.getName(), valueString);
                    value.addString(locale, this.toJSON(this._groupId, fileEntryUuid));
                }
            }
        }

        protected void addAssetEntry(long entryId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, String classUuid, long classTypeId, boolean visible, Timestamp startDate, Timestamp endDate, Timestamp publishDate, Timestamp expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, double priority, int viewCount) throws Exception {
            AssetEntry assetEntry = DynamicDataMappingUpgradeProcess.this._assetEntryLocalService.createAssetEntry(entryId);
            assetEntry.setGroupId(groupId);
            assetEntry.setCompanyId(companyId);
            assetEntry.setUserId(userId);
            assetEntry.setUserName(userName);
            assetEntry.setCreateDate((Date)createDate);
            assetEntry.setModifiedDate((Date)modifiedDate);
            assetEntry.setClassNameId(classNameId);
            assetEntry.setClassPK(classPK);
            assetEntry.setClassUuid(classUuid);
            assetEntry.setClassTypeId(classTypeId);
            assetEntry.setVisible(visible);
            assetEntry.setStartDate((Date)startDate);
            assetEntry.setEndDate((Date)endDate);
            assetEntry.setPublishDate((Date)publishDate);
            assetEntry.setExpirationDate((Date)expirationDate);
            assetEntry.setMimeType(mimeType);
            assetEntry.setTitle(title);
            assetEntry.setDescription(description);
            assetEntry.setSummary(summary);
            assetEntry.setUrl(url);
            assetEntry.setLayoutUuid(layoutUuid);
            assetEntry.setHeight(height);
            assetEntry.setWidth(width);
            assetEntry.setPriority(priority);
            DynamicDataMappingUpgradeProcess.this._assetEntryLocalService.updateAssetEntry(assetEntry);
            DynamicDataMappingUpgradeProcess.this._viewCountEntryLocalService.incrementViewCount(companyId, DynamicDataMappingUpgradeProcess.this._classNameLocalService.getClassNameId(AssetEntry.class), entryId, viewCount);
        }

        protected long addDDMDLFolder() throws Exception {
            long ddmFolderId = this.getDLFolderId(this._groupId, 0L, "DDM");
            if (ddmFolderId > 0L) {
                return ddmFolderId;
            }
            ddmFolderId = DynamicDataMappingUpgradeProcess.this.increment();
            this.addDLFolder(PortalUUIDUtil.generate(), ddmFolderId, this._groupId, this._companyId, this._userId, this._userName, this._now, this._now, this._groupId, 0L, "DDM", "", this._now);
            return ddmFolderId;
        }

        protected DLFileEntry addDLFileEntry(String uuid, long fileEntryId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, long repositoryId, long folderId, String treePath, String name, String fileName, String extension, String mimeType, String title, String description, String extraSettings, long fileEntryTypeId, String version, long size, int readCount, long smallImageId, long largeImageId, long custom1ImageId, long custom2ImageId, boolean manualCheckInRequired) throws Exception {
            DLFileEntry dlFileEntry = DynamicDataMappingUpgradeProcess.this._dlFileEntryLocalService.createDLFileEntry(fileEntryId);
            dlFileEntry.setUuid(uuid);
            dlFileEntry.setGroupId(groupId);
            dlFileEntry.setCompanyId(companyId);
            dlFileEntry.setUserId(userId);
            dlFileEntry.setUserName(userName);
            dlFileEntry.setCreateDate((Date)createDate);
            dlFileEntry.setModifiedDate((Date)modifiedDate);
            dlFileEntry.setClassNameId(classNameId);
            dlFileEntry.setClassPK(classPK);
            dlFileEntry.setRepositoryId(repositoryId);
            dlFileEntry.setFolderId(folderId);
            dlFileEntry.setTreePath(treePath);
            dlFileEntry.setName(name);
            dlFileEntry.setFileName(fileName);
            dlFileEntry.setExtension(extension);
            dlFileEntry.setMimeType(mimeType);
            dlFileEntry.setTitle(title);
            dlFileEntry.setDescription(description);
            dlFileEntry.setExtraSettings(extraSettings);
            dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
            dlFileEntry.setVersion(version);
            dlFileEntry.setSize(size);
            dlFileEntry.setSmallImageId(smallImageId);
            dlFileEntry.setLargeImageId(largeImageId);
            dlFileEntry.setCustom1ImageId(custom1ImageId);
            dlFileEntry.setCustom2ImageId(custom2ImageId);
            dlFileEntry.setManualCheckInRequired(manualCheckInRequired);
            DynamicDataMappingUpgradeProcess.this._viewCountEntryLocalService.incrementViewCount(dlFileEntry.getCompanyId(), DynamicDataMappingUpgradeProcess.this._classNameLocalService.getClassNameId(DLFileEntry.class), dlFileEntry.getFileEntryId(), readCount);
            return dlFileEntry;
        }

        protected void addDLFileVersion(String uuid, long fileVersionId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long repositoryId, long folderId, long fileEntryId, String treePath, String fileName, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, String version, long size, String checksum, int status, long statusByUserId, String statusByUserName, Timestamp statusDate) throws Exception {
            DLFileVersion dlFileVersion = DynamicDataMappingUpgradeProcess.this._dlFileVersionLocalService.createDLFileVersion(fileVersionId);
            dlFileVersion.setUuid(uuid);
            dlFileVersion.setGroupId(groupId);
            dlFileVersion.setCompanyId(companyId);
            dlFileVersion.setUserId(userId);
            dlFileVersion.setUserName(userName);
            dlFileVersion.setCreateDate((Date)createDate);
            dlFileVersion.setModifiedDate((Date)modifiedDate);
            dlFileVersion.setRepositoryId(repositoryId);
            dlFileVersion.setFolderId(folderId);
            dlFileVersion.setFileEntryId(fileEntryId);
            dlFileVersion.setTreePath(treePath);
            dlFileVersion.setFileName(fileName);
            dlFileVersion.setExtension(extension);
            dlFileVersion.setMimeType(mimeType);
            dlFileVersion.setTitle(title);
            dlFileVersion.setDescription(description);
            dlFileVersion.setChangeLog(changeLog);
            dlFileVersion.setExtraSettings(extraSettings);
            dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
            dlFileVersion.setVersion(version);
            dlFileVersion.setSize(size);
            dlFileVersion.setChecksum(checksum);
            dlFileVersion.setStatus(status);
            dlFileVersion.setStatusByUserId(statusByUserId);
            dlFileVersion.setStatusByUserName(statusByUserName);
            dlFileVersion.setStatusDate((Date)statusDate);
            DynamicDataMappingUpgradeProcess.this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
        }

        protected void addDLFolder(String uuid, long folderId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long repositoryId, long parentFolderId, String name, String description, Timestamp lastPostDate) throws Exception {
            DLFolder dlFolder = DynamicDataMappingUpgradeProcess.this._dlFolderLocalService.createDLFolder(folderId);
            dlFolder.setUuid(uuid);
            dlFolder.setGroupId(groupId);
            dlFolder.setCompanyId(companyId);
            dlFolder.setUserId(userId);
            dlFolder.setUserName(userName);
            dlFolder.setCreateDate((Date)createDate);
            dlFolder.setModifiedDate((Date)modifiedDate);
            dlFolder.setRepositoryId(repositoryId);
            dlFolder.setMountPoint(false);
            dlFolder.setParentFolderId(parentFolderId);
            dlFolder.setName(name);
            dlFolder.setDescription(description);
            dlFolder.setLastPostDate((Date)lastPostDate);
            dlFolder.setDefaultFileEntryTypeId(0L);
            dlFolder.setHidden(false);
            dlFolder.setRestrictionType(0);
            dlFolder.setStatus(0);
            dlFolder.setStatusByUserId(0L);
            dlFolder.setStatusByUserName("");
            dlFolder = DynamicDataMappingUpgradeProcess.this._dlFolderLocalService.updateDLFolder(dlFolder);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setModelPermissions(DynamicDataMappingUpgradeProcess.this._dlFolderModelPermissions);
            DynamicDataMappingUpgradeProcess.this._resourceLocalService.addModelResources((AuditedModel)dlFolder, serviceContext);
        }

        protected long addDLFolderTree(String ddmFormFieldName) throws Exception {
            long ddmFolderId = this.addDDMDLFolder();
            long entryIdFolderId = this.addEntryIdDLFolder(ddmFolderId);
            long entryVersionFolderId = this.addEntryVersionDLFolder(entryIdFolderId);
            long fieldNameFolderId = DynamicDataMappingUpgradeProcess.this.increment();
            this.addDLFolder(PortalUUIDUtil.generate(), fieldNameFolderId, this._groupId, this._companyId, this._userId, this._userName, this._now, this._now, this._groupId, entryVersionFolderId, ddmFormFieldName, "", this._now);
            return fieldNameFolderId;
        }

        protected long addEntryIdDLFolder(long ddmFolderId) throws Exception {
            long entryIdFolderId = this.getDLFolderId(this._groupId, ddmFolderId, String.valueOf(this._entryId));
            if (entryIdFolderId > 0L) {
                return entryIdFolderId;
            }
            entryIdFolderId = DynamicDataMappingUpgradeProcess.this.increment();
            this.addDLFolder(PortalUUIDUtil.generate(), entryIdFolderId, this._groupId, this._companyId, this._userId, this._userName, this._now, this._now, this._groupId, ddmFolderId, String.valueOf(this._entryId), "", this._now);
            return entryIdFolderId;
        }

        protected long addEntryVersionDLFolder(long entryIdFolderId) throws Exception {
            long entryVersionFolderId = this.getDLFolderId(this._groupId, entryIdFolderId, this._entryVersion);
            if (entryVersionFolderId > 0L) {
                return entryVersionFolderId;
            }
            entryVersionFolderId = DynamicDataMappingUpgradeProcess.this.increment();
            this.addDLFolder(PortalUUIDUtil.generate(), entryVersionFolderId, this._groupId, this._companyId, this._userId, this._userName, this._now, this._now, this._groupId, entryIdFolderId, this._entryVersion, "", this._now);
            return entryVersionFolderId;
        }

        protected File fetchFile(String filePath) throws Exception {
            try {
                return FileUtil.createTempFile((InputStream)DynamicDataMappingUpgradeProcess.this._store.getFileAsStream(this._companyId, 0L, filePath, ""));
            }
            catch (PortalException portalException) {
                _log.error((Object)String.format("Unable to find the binary file with path \"%s\" referenced by %s", filePath, this.getModelInfo()));
                throw portalException;
            }
        }

        protected long getDLFolderId(long groupId, long parentFolderId, String name) {
            DLFolder dlFolder = DynamicDataMappingUpgradeProcess.this._dlFolderLocalService.fetchFolder(groupId, parentFolderId, name);
            if (dlFolder == null) {
                return 0L;
            }
            return dlFolder.getFolderId();
        }

        protected String getExtension(String fileName) {
            String extension = "";
            int pos = fileName.lastIndexOf(46);
            if (pos > 0) {
                extension = fileName.substring(pos + 1);
            }
            return StringUtil.toLowerCase((String)extension);
        }

        protected String getModelInfo() {
            return String.format("%s {primaryKey: %d, version: %s}", this._entryModelName, this._entryId, this._entryVersion);
        }

        protected String toJSON(long groupId, String fileEntryUuid) {
            return JSONUtil.put((String)"groupId", (Object)groupId).put("uuid", fileEntryUuid).toString();
        }

        protected String upgradeFileUploadReference(String fileEntryUuid, String ddmFormFieldName, String valueString) throws PortalException {
            try {
                long dlFolderId = this.addDLFolderTree(ddmFormFieldName);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                String name = String.valueOf(DynamicDataMappingUpgradeProcess.this.increment(DLFileEntry.class.getName()));
                String fileName = jsonObject.getString("name");
                String filePath = jsonObject.getString("path");
                long fileEntryId = DynamicDataMappingUpgradeProcess.this.increment();
                String extension = this.getExtension(fileName);
                File file = this.fetchFile(filePath);
                DLFileEntry dlFileEntry = this.addDLFileEntry(fileEntryUuid, fileEntryId, this._groupId, this._companyId, this._userId, this._userName, this._createDate, this._createDate, 0L, 0L, this._groupId, dlFolderId, "", name, fileName, extension, MimeTypesUtil.getContentType((String)fileName), fileName, "", "", 0L, "1.0", file.length(), 0, 0L, 0L, 0L, 0L, false);
                this.addDLFileVersion(fileEntryUuid, DynamicDataMappingUpgradeProcess.this.increment(), this._groupId, this._companyId, this._userId, this._userName, this._createDate, this._createDate, this._groupId, dlFolderId, fileEntryId, "", fileName, extension, MimeTypesUtil.getContentType((String)fileName), fileName, "", "", "", 0L, "1.0", file.length(), "", 0, this._userId, this._userName, this._createDate);
                dlFileEntry = DynamicDataMappingUpgradeProcess.this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setModelPermissions(this._dlFileEntryModelPermissions);
                DynamicDataMappingUpgradeProcess.this._resourceLocalService.addModelResources((AuditedModel)dlFileEntry, serviceContext);
                this.addAssetEntry(DynamicDataMappingUpgradeProcess.this.increment(), this._groupId, this._companyId, this._userId, this._userName, this._createDate, this._createDate, PortalUtil.getClassNameId(DLFileEntry.class), fileEntryId, fileEntryUuid, 0L, false, null, null, null, null, MimeTypesUtil.getContentType((String)fileName), fileName, "", "", null, null, 0, 0, 0.0, 0);
                try (FileInputStream inputStream = new FileInputStream(file);){
                    DynamicDataMappingUpgradeProcess.this._store.addFile(this._companyId, dlFolderId, name, "1.0", (InputStream)inputStream);
                }
                file.delete();
                return fileEntryUuid;
            }
            catch (Exception exception) {
                throw new UpgradeException((Throwable)exception);
            }
        }
    }

    private static class DDMFormValuesXSDDeserializer {
        private long _companyId;

        public DDMFormValuesXSDDeserializer(long companyId) {
            this._companyId = companyId;
        }

        public DDMFormValues deserialize(DDMForm ddmForm, String xml) throws PortalException {
            try {
                DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
                Document document = SAXReaderUtil.read((String)xml);
                Element rootElement = document.getRootElement();
                this.setDDMFormValuesAvailableLocales(ddmFormValues, rootElement);
                this.setDDMFormValuesDefaultLocale(ddmFormValues, rootElement);
                DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
                for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
                    String fieldName = ddmFormField.getName();
                    int repetitions = this.countDDMFieldRepetitions(rootElement, fieldName, null, -1);
                    for (int i = 0; i < repetitions; ++i) {
                        DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(ddmFormField, ddmFieldsCounter, fieldName, rootElement);
                        if (ddmFormFieldValue == null) continue;
                        ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
                    }
                }
                return ddmFormValues;
            }
            catch (DocumentException documentException) {
                throw new UpgradeException((Throwable)documentException);
            }
        }

        protected int countDDMFieldRepetitions(Element rootElement, String fieldName, String parentFieldName, int parentOffset) {
            String[] ddmFieldsDisplayValues = this.getDDMFieldsDisplayValues(rootElement, true);
            if (ddmFieldsDisplayValues.length != 0) {
                return this.countDDMFieldRepetitions(ddmFieldsDisplayValues, fieldName, parentFieldName, parentOffset);
            }
            Element dynamicElementElement = this.getDynamicElementElementByName(rootElement, fieldName);
            if (dynamicElementElement != null) {
                return 1;
            }
            return 0;
        }

        protected int countDDMFieldRepetitions(String[] fieldsDisplayValues, String fieldName, String parentFieldName, int parentOffset) {
            int offset = -1;
            int repetitions = 0;
            for (String fieldDisplayName : fieldsDisplayValues) {
                if (offset > parentOffset) break;
                if (fieldDisplayName.equals(parentFieldName)) {
                    ++offset;
                }
                if (!fieldDisplayName.equals(fieldName) || offset != parentOffset) continue;
                ++repetitions;
            }
            return repetitions;
        }

        protected DDMFormFieldValue createDDMFormFieldValue(DDMFormField ddmFormField, DDMFieldsCounter ddmFieldsCounter, final String fieldName, Element rootElement) throws PortalException {
            final Value value = this.extractDDMFormFieldValue(ddmFormField, ddmFieldsCounter, fieldName, rootElement);
            if (value == null && !ddmFormField.isTransient()) {
                return null;
            }
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setName(fieldName);
                    this.setValue(value);
                }
            };
            this.setDDMFormFieldValueInstanceId(ddmFormFieldValue, rootElement, ddmFieldsCounter);
            this.setNestedDDMFormFieldValues(ddmFormFieldValue, ddmFormField, rootElement, ddmFieldsCounter);
            ddmFieldsCounter.incrementKey((Object)fieldName);
            return ddmFormFieldValue;
        }

        protected Value extractDDMFormFieldLocalizedValue(Element element, int index) {
            LocalizedValue value = new LocalizedValue(this.getDefaultLocale(element));
            HashMap<String, Integer> dynamicContentValues = new HashMap<String, Integer>();
            for (Element dynamicContentElement : element.elements("dynamic-content")) {
                String languageId = dynamicContentElement.attributeValue("language-id");
                int localizedContentIndex = dynamicContentValues.getOrDefault(languageId, 0);
                if (localizedContentIndex == index) {
                    value.addString(LocaleUtil.fromLanguageId((String)languageId), dynamicContentElement.getText());
                }
                dynamicContentValues.put(languageId, localizedContentIndex + 1);
            }
            return value;
        }

        protected Value extractDDMFormFieldValue(DDMFormField ddmFormField, DDMFieldsCounter ddmFieldsCounter, String fieldName, Element rootElement) {
            Object value = null;
            Element element = this.getDynamicElementElementByName(rootElement, fieldName);
            if (Validator.isNotNull((String)ddmFormField.getDataType()) && element != null) {
                value = ddmFormField.isLocalizable() ? this.extractDDMFormFieldLocalizedValue(element, ddmFieldsCounter.get((Object)fieldName)) : new UnlocalizedValue(this.getDDMFormFieldValueValueString(element, this.getDefaultLocale(element), ddmFieldsCounter.get((Object)fieldName)));
            }
            return value;
        }

        protected Set<Locale> getAvailableLocales(Element dynamicElementElement) {
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            LinkedHashSet<Locale> availableLocales = new LinkedHashSet<Locale>();
            for (Element dynamicContentElement : dynamicContentElements) {
                String languageId = dynamicContentElement.attributeValue("language-id");
                availableLocales.add(LocaleUtil.fromLanguageId((String)languageId));
            }
            return availableLocales;
        }

        protected Set<Locale> getAvailableLocales(List<Element> dynamicElementElements) {
            LinkedHashSet<Locale> availableLocales = new LinkedHashSet<Locale>();
            for (Element dynamicElementElement : dynamicElementElements) {
                availableLocales.addAll(this.getAvailableLocales(dynamicElementElement));
            }
            return availableLocales;
        }

        protected String getDDMFieldInstanceId(Element rootElement, String fieldName, int index) {
            String[] ddmFieldsDisplayValues = this.getDDMFieldsDisplayValues(rootElement, false);
            if (ddmFieldsDisplayValues.length == 0) {
                return StringUtil.randomString();
            }
            String prefix = fieldName.concat("_INSTANCE_");
            for (String ddmFieldsDisplayValue : ddmFieldsDisplayValues) {
                if (!ddmFieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
                return StringUtil.extractLast((String)ddmFieldsDisplayValue, (String)"_INSTANCE_");
            }
            return null;
        }

        protected String[] getDDMFieldsDisplayValues(Element rootElement, boolean extractFieldName) {
            Element fieldsDisplayDynamicContent;
            Element fieldsDisplayElement = this.getDynamicElementElementByName(rootElement, "_fieldsDisplay");
            ArrayList<String> ddmFieldsDisplayValues = new ArrayList<String>();
            if (fieldsDisplayElement != null && (fieldsDisplayDynamicContent = fieldsDisplayElement.element("dynamic-content")) != null) {
                String fieldsDisplayText = fieldsDisplayDynamicContent.getText();
                for (String fieldDisplayValue : StringUtil.split((String)fieldsDisplayText)) {
                    if (extractFieldName) {
                        fieldDisplayValue = StringUtil.extractFirst((String)fieldDisplayValue, (String)"_INSTANCE_");
                    }
                    ddmFieldsDisplayValues.add(fieldDisplayValue);
                }
            }
            return ddmFieldsDisplayValues.toArray(new String[0]);
        }

        protected DDMFormFieldValue getDDMFormFieldValue(Element dynamicElementElement) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(dynamicElementElement.attributeValue("name"));
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            ddmFormFieldValue.setValue(this.getValue(dynamicContentElements));
            ddmFormFieldValue.setNestedDDMFormFields(this.getDDMFormFieldValues(dynamicElementElement.elements("dynamic-element")));
            return ddmFormFieldValue;
        }

        protected List<DDMFormFieldValue> getDDMFormFieldValues(List<Element> dynamicElementElements) {
            if (dynamicElementElements == null) {
                return null;
            }
            ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
            for (Element dynamicElement : dynamicElementElements) {
                ddmFormFieldValues.add(this.getDDMFormFieldValue(dynamicElement));
            }
            return ddmFormFieldValues;
        }

        protected String getDDMFormFieldValueValueString(Element dynamicElementElement, Locale locale, int index) {
            Element dynamicContentElement = this.getDynamicContentElement(dynamicElementElement, locale, index);
            return dynamicContentElement.getTextTrim();
        }

        protected Locale getDefaultLocale(Element dynamicElementElement) {
            if (dynamicElementElement == null) {
                String locale = null;
                try {
                    locale = UpgradeProcessUtil.getDefaultLanguageId((long)this._companyId);
                }
                catch (SQLException sqlException) {
                    _log.error((Object)("Unable to get default locale for company " + this._companyId), (Throwable)sqlException);
                    throw new RuntimeException(sqlException);
                }
                return LocaleUtil.fromLanguageId((String)locale);
            }
            String defaultLanguageId = dynamicElementElement.attributeValue("default-language-id");
            return LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }

        protected Locale getDefaultLocale(List<Element> dynamicElementElements) {
            for (Element dynamicElement : dynamicElementElements) {
                String defaultLanguageId = dynamicElement.attributeValue("default-language-id");
                if (defaultLanguageId == null) continue;
                return LocaleUtil.fromLanguageId((String)defaultLanguageId);
            }
            return null;
        }

        protected Element getDynamicContentElement(Element dynamicElementElement, Locale locale, int index) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            XPath dynamicContentXPath = SAXReaderUtil.createXPath((String)("dynamic-content[(@language-id='" + languageId + "')]"));
            List nodes = dynamicContentXPath.selectNodes((Object)dynamicElementElement);
            if (nodes.isEmpty()) {
                dynamicContentXPath = SAXReaderUtil.createXPath((String)"dynamic-content");
                nodes = dynamicContentXPath.selectNodes((Object)dynamicElementElement);
                Element element = null;
                element = nodes.isEmpty() ? dynamicElementElement.addElement("dynamic-content") : (Element)nodes.get(index);
                element.addAttribute("language-id", languageId);
                return element;
            }
            return (Element)nodes.get(index);
        }

        protected Element getDynamicElementElementByName(Element rootElement, String fieldName) {
            XPath dynamicElementXPath = SAXReaderUtil.createXPath((String)("//dynamic-element[(@name=\"" + fieldName + "\")]"));
            if (dynamicElementXPath.booleanValueOf((Object)rootElement)) {
                return (Element)dynamicElementXPath.evaluate((Object)rootElement);
            }
            return null;
        }

        protected Value getValue(List<Element> dynamicContentElements) {
            LocalizedValue value = new LocalizedValue();
            for (Element dynamicContentElement : dynamicContentElements) {
                String fieldValue = dynamicContentElement.getText();
                String languageId = dynamicContentElement.attributeValue("language-id");
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                value.addString(locale, fieldValue);
            }
            return value;
        }

        protected void setDDMFormFieldValueInstanceId(DDMFormFieldValue ddmFormFieldValue, Element rootElement, DDMFieldsCounter ddmFieldsCounter) {
            String name = ddmFormFieldValue.getName();
            ddmFormFieldValue.setInstanceId(this.getDDMFieldInstanceId(rootElement, name, ddmFieldsCounter.get((Object)name)));
        }

        protected void setDDMFormValuesAvailableLocales(DDMFormValues ddmFormValues, Element rootElement) {
            ddmFormValues.setAvailableLocales(this.getAvailableLocales(rootElement.elements("dynamic-element")));
        }

        protected void setDDMFormValuesDefaultLocale(DDMFormValues ddmFormValues, Element rootElement) {
            ddmFormValues.setDefaultLocale(this.getDefaultLocale(rootElement.elements("dynamic-element")));
        }

        protected void setNestedDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue, DDMFormField ddmFormField, Element rootElement, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
            String fieldName = ddmFormFieldValue.getName();
            int parentOffset = ddmFieldsCounter.get((Object)fieldName);
            String[] ddmFieldsDisplayValues = this.getDDMFieldsDisplayValues(rootElement, true);
            List nestedDDMFormFields = ddmFormField.getNestedDDMFormFields();
            for (DDMFormField nestedDDMFormField : nestedDDMFormFields) {
                String nestedDDMFormFieldName = nestedDDMFormField.getName();
                int repetitions = this.countDDMFieldRepetitions(ddmFieldsDisplayValues, nestedDDMFormFieldName, fieldName, parentOffset);
                for (int i = 0; i < repetitions; ++i) {
                    DDMFormFieldValue nestedDDMFormFieldValue = this.createDDMFormFieldValue(nestedDDMFormField, ddmFieldsCounter, nestedDDMFormFieldName, rootElement);
                    if (nestedDDMFormFieldValue == null) continue;
                    ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
                }
            }
        }
    }

    private static class DateDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final DateFormat _dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd", (TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));

        private DateDDMFormFieldValueTransformer() {
        }

        public String getFieldType() {
            return "ddm-date";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                for (Locale locale : value.getAvailableLocales()) {
                    String valueString = value.getString(locale);
                    if (Validator.isNull((String)valueString) || !Validator.isNumber((String)valueString)) continue;
                    Date dateValue = new Date(GetterUtil.getLong((String)valueString));
                    value.addString(locale, this._dateFormat.format(dateValue));
                }
            }
        }
    }
}

