/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_1_0;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMField;
import com.liferay.dynamic.data.mapping.model.DDMFieldAttribute;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LRUMap;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMFieldUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(DDMFieldUpgradeProcess.class);
    private final Map<Long, DDMForm> _ddmForms = new LRUMap(1000);
    private final Map<Long, DDMForm> _fullHierarchyDDMForms = new LRUMap(1000);
    private final DDMFormDeserializer _jsonDDMFormJSONDeserializer;
    private final DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    private final JSONFactory _jsonFactory;

    public DDMFieldUpgradeProcess(JSONFactory jsonFactory, DDMFormDeserializer jsonDDMFormJSONDeserializer, DDMFormValuesDeserializer jsonDDMFormValuesDeserializer) {
        this._jsonFactory = jsonFactory;
        this._jsonDDMFormJSONDeserializer = jsonDDMFormJSONDeserializer;
        this._jsonDDMFormValuesDeserializer = jsonDDMFormValuesDeserializer;
    }

    protected void doUpgrade() throws Exception {
        Throwable throwable;
        Throwable throwable2;
        this.runSQL(StringBundler.concat((String[])new String[]{"create table DDMField (mvccVersion LONG default 0 not null, ", "ctCollectionId LONG default 0 not null, fieldId LONG not ", "null, companyId LONG, parentFieldId LONG, storageId LONG, ", "structureVersionId LONG, fieldName TEXT null, fieldType ", "VARCHAR(255) null, instanceId VARCHAR(75) null, localizable ", "BOOLEAN, priority INTEGER, primary key (fieldId, ", "ctCollectionId))"}));
        this.runSQL(StringBundler.concat((String[])new String[]{"create table DDMFieldAttribute (mvccVersion LONG default 0 ", "not null, ctCollectionId LONG default 0 not null, ", "fieldAttributeId LONG not null, companyId LONG, fieldId ", "LONG, storageId LONG, attributeName VARCHAR(255) null, ", "languageId VARCHAR(75) null, largeAttributeValue TEXT null, ", "smallAttributeValue VARCHAR(255) null, primary key ", "(fieldAttributeId, ctCollectionId))"}));
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMContent.contentId, DDMContent.companyId, ", "DDMContent.data_, DDMStorageLink.structureVersionId, ", "DDMStructure.structureId from DDMContent inner join ", "DDMStorageLink on DDMStorageLink.classPK = ", "DDMContent.contentId inner join DDMStructureVersion ", "on DDMStructureVersion.structureVersionId = ", "DDMStorageLink.structureVersionId inner join ", "DDMStructure on DDMStructureVersion.structureId = ", "DDMStructure.structureId where ", "DDMStructure.storageType = 'json' and ", "DDMContent.ctCollectionId = 0 and ", "DDMStorageLink.ctCollectionId = 0 and ", "DDMStructureVersion.ctCollectionId = 0 and ", "DDMStructure.ctCollectionId = 0"}));){
            throwable2 = null;
            try (PreparedStatement insertDDMFieldPreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into DDMField (mvccVersion, ", "ctCollectionId, fieldId, companyId, ", "parentFieldId, storageId, structureVersionId, ", "fieldName, fieldType, instanceId, localizable, ", "priority) values (0, 0, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?)"})));){
                throwable = null;
                try (PreparedStatement insertDDMFieldAttributePreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into DDMFieldAttribute (mvccVersion, ", "ctCollectionId, fieldAttributeId, companyId, ", "fieldId, storageId, attributeName, languageId, ", "largeAttributeValue, smallAttributeValue) values ", "(0, 0, ?, ?, ?, ?, ?, ?, ?, ?)"})));
                     PreparedStatement deleteDDMContentPreparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("delete from DDMContent where contentId = ? and ctCollectionId = 0"));
                     ResultSet resultSet = selectPreparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        this._upgradeDDMContent(resultSet.getLong("companyId"), resultSet.getLong("contentId"), insertDDMFieldPreparedStatement, insertDDMFieldAttributePreparedStatement, resultSet.getString("data_"), deleteDDMContentPreparedStatement2, resultSet.getLong("structureId"), resultSet.getLong("structureVersionId"));
                    }
                    insertDDMFieldPreparedStatement.executeBatch();
                    insertDDMFieldAttributePreparedStatement.executeBatch();
                    deleteDDMContentPreparedStatement2.executeBatch();
                }
                catch (Throwable deleteDDMContentPreparedStatement2) {
                    throwable = deleteDDMContentPreparedStatement2;
                    throw deleteDDMContentPreparedStatement2;
                }
            }
            catch (Throwable insertDDMFieldAttributePreparedStatement) {
                throwable2 = insertDDMFieldAttributePreparedStatement;
                throw insertDDMFieldAttributePreparedStatement;
            }
        }
        this._ddmForms.clear();
        this._fullHierarchyDDMForms.clear();
        this.runSQL("update DDMStructure set storageType = 'default' where storageType = 'json'");
        this.runSQL("update DDMStructureVersion set storageType = 'default' where storageType = 'json'");
        selectPreparedStatement = this.connection.prepareStatement("select formInstanceId, settings_ from DDMFormInstance where ctCollectionId = 0");
        var2_2 = null;
        try {
            throwable2 = null;
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
                throwable = null;
                try (PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update DDMFormInstance set settings_ = ? where formInstanceId = ? and ctCollectionId = 0"));){
                    while (resultSet.next()) {
                        String settings = resultSet.getString("settings_");
                        if (!Validator.isNotNull((String)settings)) continue;
                        JSONObject settingsJSONObject = this._jsonFactory.createJSONObject(settings);
                        JSONArray fieldValuesJSONArray = settingsJSONObject.getJSONArray("fieldValues");
                        for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
                            JSONObject jsonObject = fieldValuesJSONArray.getJSONObject(i);
                            if (!Objects.equals(jsonObject.getString("name"), "storageType")) continue;
                            JSONArray oldJSONArray = this._jsonFactory.createJSONArray(jsonObject.getString("value"));
                            JSONArray newJSONArray = this._jsonFactory.createJSONArray();
                            for (Object value : oldJSONArray) {
                                if (Objects.equals(value, "json")) {
                                    value = "default";
                                }
                                newJSONArray.put(value);
                            }
                            jsonObject.put("value", newJSONArray);
                            break;
                        }
                        updatePreparedStatement.setString(1, settingsJSONObject.toJSONString());
                        updatePreparedStatement.setLong(2, resultSet.getLong("formInstanceId"));
                        updatePreparedStatement.addBatch();
                    }
                    updatePreparedStatement.executeBatch();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
        }
        catch (Throwable throwable5) {
            var2_2 = throwable5;
            throw throwable5;
        }
        finally {
            if (selectPreparedStatement != null) {
                if (var2_2 != null) {
                    try {
                        selectPreparedStatement.close();
                    }
                    catch (Throwable throwable6) {
                        var2_2.addSuppressed(throwable6);
                    }
                } else {
                    selectPreparedStatement.close();
                }
            }
        }
    }

    private void _collectDDMFieldInfos(Map<String, DDMFieldInfo> ddmFieldInfoMap, List<DDMFormFieldValue> ddmFormValues, String parentInstanceId) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues) {
            DDMFieldInfo ddmFieldInfo = new DDMFieldInfo(ddmFormFieldValue.getName(), ddmFormFieldValue.getInstanceId(), parentInstanceId);
            ddmFieldInfoMap.put(ddmFieldInfo._instanceId, ddmFieldInfo);
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                Map values = value.getValues();
                for (Map.Entry entry : values.entrySet()) {
                    ddmFieldInfo._ddmFieldAttributeInfos.addAll(this._getDDMFieldAttributeInfos(LanguageUtil.getLanguageId((Locale)((Locale)entry.getKey())), (String)entry.getValue()));
                }
            }
            this._collectDDMFieldInfos(ddmFieldInfoMap, ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmFieldInfo._instanceId);
        }
    }

    private List<DDMFieldAttributeInfo> _getDDMFieldAttributeInfos(String languageId, String valueString) {
        block5: {
            int length = valueString.length();
            if (length > 1 && valueString.charAt(0) == '{' && valueString.charAt(length - 1) == '}') {
                try {
                    JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
                    Set keySet = jsonObject.keySet();
                    if (!keySet.isEmpty()) {
                        ArrayList<DDMFieldAttributeInfo> ddmFieldAttributeInfos = new ArrayList<DDMFieldAttributeInfo>(keySet.size());
                        for (String key : jsonObject.keySet()) {
                            ddmFieldAttributeInfos.add(new DDMFieldAttributeInfo(key, jsonSerializer.serialize(jsonObject.get(key)), languageId));
                        }
                        return ddmFieldAttributeInfos;
                    }
                }
                catch (JSONException jsonException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to parse: " + valueString), (Throwable)jsonException);
                }
            }
        }
        return Collections.singletonList(new DDMFieldAttributeInfo("", valueString, languageId));
    }

    private DDMForm _getDDMForm(long structureId) throws Exception {
        DDMForm ddmForm = this._ddmForms.get(structureId);
        if (ddmForm != null) {
            return ddmForm;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select definition from DDMStructure where structureId = ? and ctCollectionId = 0");){
            preparedStatement.setLong(1, structureId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._jsonDDMFormJSONDeserializer, (String)resultSet.getString("definition"));
                    this._ddmForms.put(structureId, ddmForm);
                    DDMForm dDMForm = ddmForm;
                    return dDMForm;
                }
            }
        }
        throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
    }

    private DDMForm _getFullHierarchyDDMForm(long structureId) throws Exception {
        DDMForm fullHierarchyDDMForm = this._fullHierarchyDDMForms.get(structureId);
        if (fullHierarchyDDMForm != null) {
            return fullHierarchyDDMForm;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select parentStructureId from DDMStructure where structureId = ? and ctCollectionId = 0");){
            preparedStatement.setLong(1, structureId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long parentStructureId = resultSet.getLong("parentStructureId");
                    fullHierarchyDDMForm = this._getDDMForm(structureId);
                    if (parentStructureId > 0L) {
                        DDMForm parentDDMForm = this._getFullHierarchyDDMForm(parentStructureId);
                        List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
                        ddmFormFields.addAll(parentDDMForm.getDDMFormFields());
                    }
                    this._fullHierarchyDDMForms.put(structureId, fullHierarchyDDMForm);
                    DDMForm dDMForm = fullHierarchyDDMForm;
                    return dDMForm;
                }
            }
        }
        throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
    }

    private void _upgradeDDMContent(long companyId, long contentId, PreparedStatement insertDDMFieldPreparedStatement, PreparedStatement insertDDMFieldAttributePreparedStatement, String data, PreparedStatement deleteDDMContentPreparedStatement, long structureId, long structureVersionId) throws Exception {
        DDMForm ddmForm = this._getFullHierarchyDDMForm(structureId);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)data, (DDMForm)ddmForm).build());
        if (ddmFormValuesDeserializerDeserializeResponse.getException() != null) {
            throw ddmFormValuesDeserializerDeserializeResponse.getException();
        }
        DDMFormValues ddmFormValues = ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
        ddmFormValues.setDDMFormFieldValues(this._upgradeDDMFormValuesHierarchy(ddmFormValues.getDDMFormFieldValues()));
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        DDMFieldInfo rootDDMFieldInfo = new DDMFieldInfo("", "", null);
        LinkedHashMap ddmFieldInfoMap = LinkedHashMapBuilder.put((Object)"", (Object)rootDDMFieldInfo).build();
        Collections.addAll(rootDDMFieldInfo._ddmFieldAttributeInfos, new DDMFieldAttributeInfo("availableLanguageIds", com.liferay.petra.string.StringUtil.merge((Collection)ddmFormValues.getAvailableLocales(), LocaleUtil::toLanguageId, (String)","), ""), new DDMFieldAttributeInfo("defaultLanguageId", LocaleUtil.toLanguageId((Locale)ddmFormValues.getDefaultLocale()), ""));
        this._collectDDMFieldInfos(ddmFieldInfoMap, ddmFormValues.getDDMFormFieldValues(), null);
        int priority = 0;
        HashMap<String, Long> instanceToFieldIdMap = new HashMap<String, Long>();
        for (DDMFieldInfo ddmFieldInfo : ddmFieldInfoMap.values()) {
            DDMFormField ddmFormField;
            long fieldId = this.increment(DDMField.class.getName());
            long parentFieldId = 0L;
            if (ddmFieldInfo._parentInstanceId != null) {
                parentFieldId = (Long)instanceToFieldIdMap.get(ddmFieldInfo._parentInstanceId);
            }
            String fieldType = "";
            boolean localizable = false;
            if (ddmFieldInfo != rootDDMFieldInfo && (ddmFormField = (DDMFormField)ddmFormFieldsMap.get(ddmFieldInfo._fieldName)) != null) {
                fieldType = ddmFormField.getType();
                localizable = ddmFormField.isLocalizable();
            }
            insertDDMFieldPreparedStatement.setLong(1, fieldId);
            insertDDMFieldPreparedStatement.setLong(2, companyId);
            insertDDMFieldPreparedStatement.setLong(3, parentFieldId);
            insertDDMFieldPreparedStatement.setLong(4, contentId);
            insertDDMFieldPreparedStatement.setLong(5, structureVersionId);
            insertDDMFieldPreparedStatement.setString(6, ddmFieldInfo._fieldName);
            insertDDMFieldPreparedStatement.setString(7, fieldType);
            insertDDMFieldPreparedStatement.setString(8, ddmFieldInfo._instanceId);
            insertDDMFieldPreparedStatement.setBoolean(9, localizable);
            insertDDMFieldPreparedStatement.setInt(10, priority);
            insertDDMFieldPreparedStatement.addBatch();
            ++priority;
            instanceToFieldIdMap.put(ddmFieldInfo._instanceId, fieldId);
            for (DDMFieldAttributeInfo ddmFieldAttributeInfo : ddmFieldInfo._ddmFieldAttributeInfos) {
                String smallAttributeValue = null;
                String largeAttributeValue = null;
                if (ddmFieldAttributeInfo._attributeValue != null) {
                    if (ddmFieldAttributeInfo._attributeValue.length() > 255) {
                        largeAttributeValue = ddmFieldAttributeInfo._attributeValue;
                    } else {
                        smallAttributeValue = ddmFieldAttributeInfo._attributeValue;
                    }
                }
                insertDDMFieldAttributePreparedStatement.setLong(1, this.increment(DDMFieldAttribute.class.getName()));
                insertDDMFieldAttributePreparedStatement.setLong(2, companyId);
                insertDDMFieldAttributePreparedStatement.setLong(3, fieldId);
                insertDDMFieldAttributePreparedStatement.setLong(4, contentId);
                insertDDMFieldAttributePreparedStatement.setString(5, ddmFieldAttributeInfo._attributeName);
                insertDDMFieldAttributePreparedStatement.setString(6, ddmFieldAttributeInfo._languageId);
                insertDDMFieldAttributePreparedStatement.setString(7, largeAttributeValue);
                insertDDMFieldAttributePreparedStatement.setString(8, smallAttributeValue);
                insertDDMFieldAttributePreparedStatement.addBatch();
            }
        }
        deleteDDMContentPreparedStatement.setLong(1, contentId);
        deleteDDMContentPreparedStatement.addBatch();
    }

    private List<DDMFormFieldValue> _upgradeDDMFormValuesHierarchy(List<DDMFormFieldValue> ddmFormFieldValues) {
        ArrayList<DDMFormFieldValue> newDDMFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (final DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (!ListUtil.isEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues()) && !StringUtil.equals((String)ddmFormFieldValue.getType(), (String)"fieldset")) {
                DDMFormFieldValue newDDMFormFieldValue = new DDMFormFieldValue(){
                    {
                        this.setName(ddmFormFieldValue.getName() + "FieldSet");
                        this.setInstanceId(StringUtil.randomString());
                    }
                };
                ArrayList<DDMFormFieldValue> nestedDDMFormFieldValues = new ArrayList<DDMFormFieldValue>(ddmFormFieldValue.getNestedDDMFormFieldValues());
                ddmFormFieldValue.setNestedDDMFormFields(new ArrayList());
                newDDMFormFieldValue.setNestedDDMFormFields(ListUtil.concat((List[])new List[]{Collections.singletonList(ddmFormFieldValue), this._upgradeDDMFormValuesHierarchy(nestedDDMFormFieldValues)}));
                newDDMFormFieldValues.add(newDDMFormFieldValue);
                continue;
            }
            newDDMFormFieldValues.add(ddmFormFieldValue);
        }
        return newDDMFormFieldValues;
    }

    private static class DDMFieldInfo {
        private final List<DDMFieldAttributeInfo> _ddmFieldAttributeInfos = new ArrayList<DDMFieldAttributeInfo>();
        private final String _fieldName;
        private final String _instanceId;
        private final String _parentInstanceId;

        private DDMFieldInfo(String fieldName, String instanceId, String parentInstanceId) {
            this._fieldName = fieldName;
            this._instanceId = instanceId;
            this._parentInstanceId = parentInstanceId;
        }
    }

    private static class DDMFieldAttributeInfo {
        private final String _attributeName;
        private final String _attributeValue;
        private final String _languageId;

        private DDMFieldAttributeInfo(String attributeName, String attributeValue, String languageId) {
            this._attributeName = attributeName;
            this._attributeValue = attributeValue;
            this._languageId = languageId;
        }
    }
}

