/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageAdapter;
import com.liferay.dynamic.data.mapping.storage.StorageAdapterRegistry;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StorageEngine.class})
public class StorageEngineImpl
implements StorageEngine {
    private static final Log _log = LogFactoryUtil.getLog(StorageEngineImpl.class);
    @Reference
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private StorageAdapterRegistry _storageAdapterRegistry;

    public long create(long companyId, long ddmStructureId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws StorageException {
        StorageAdapter storageAdapter = this._getStructureStorageAdapter(ddmStructureId);
        return storageAdapter.create(companyId, ddmStructureId, ddmFormValues, serviceContext);
    }

    public void deleteByClass(long classPK) throws StorageException {
        StorageAdapter storageAdapter = this._getClassStorageAdapter(classPK);
        if (storageAdapter != null) {
            storageAdapter.deleteByClass(classPK);
        }
    }

    public void deleteByDDMStructure(long ddmStructureId) throws StorageException {
        StorageAdapter storageAdapter = this._getStructureStorageAdapter(ddmStructureId);
        storageAdapter.deleteByDDMStructure(ddmStructureId);
    }

    public DDMFormValues getDDMFormValues(long classPK) throws StorageException {
        StorageAdapter storageAdapter = this._getClassStorageAdapter(classPK);
        if (storageAdapter == null) {
            return null;
        }
        return storageAdapter.getDDMFormValues(classPK);
    }

    public String getStorageType() {
        throw new UnsupportedOperationException();
    }

    public void update(long classPK, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws StorageException {
        StorageAdapter storageAdapter = this._getClassStorageAdapter(classPK);
        if (storageAdapter != null) {
            storageAdapter.update(classPK, ddmFormValues, serviceContext);
        }
    }

    protected StorageAdapter getStorageAdapter(String storageType) {
        StorageAdapter storageAdapter = this._storageAdapterRegistry.getStorageAdapter(storageType);
        if (storageAdapter != null) {
            return storageAdapter;
        }
        return this._storageAdapterRegistry.getDefaultStorageAdapter();
    }

    private StorageAdapter _getClassStorageAdapter(long classPK) throws StorageException {
        try {
            DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.fetchClassStorageLink(classPK);
            if (ddmStorageLink == null) {
                return null;
            }
            return this.getStorageAdapter(ddmStorageLink.getStorageType());
        }
        catch (NoSuchStructureException noSuchStructureException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchStructureException);
            }
            return this._storageAdapterRegistry.getDefaultStorageAdapter();
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException((Throwable)exception);
        }
    }

    private StorageAdapter _getStructureStorageAdapter(long ddmStructureId) throws StorageException {
        try {
            DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(ddmStructureId);
            return this.getStorageAdapter(ddmStructure.getStorageType());
        }
        catch (NoSuchStructureException noSuchStructureException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchStructureException);
            }
            return this._storageAdapterRegistry.getDefaultStorageAdapter();
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException((Throwable)exception);
        }
    }
}

