/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_0_0;

import com.liferay.dynamic.data.mapping.util.DDMDataDefinitionConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMStructureUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_DL_FILE_ENTRY_METADATA = "com.liferay.document.library.kernel.model.DLFileEntryMetadata";
    private static final String _CLASS_NAME_JOURNAL_ARTICLE = "com.liferay.journal.model.JournalArticle";
    private final DDMDataDefinitionConverter _ddmDataDefinitionConverter;

    public DDMStructureUpgradeProcess(DDMDataDefinitionConverter ddmDataDefinitionConverter) {
        this._ddmDataDefinitionConverter = ddmDataDefinitionConverter;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeStructureDefinition();
        this._upgradeStructureVersionDefinition();
        this._upgradeStructureLayoutDefinition();
    }

    private long _getParentStructureLayoutId(long parentStructureId) throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructureLayout.structureLayoutId  from ", "DDMStructureLayout inner join DDMStructureVersion on ", "DDMStructureVersion.structureVersionId = ", "DDMStructureLayout.structureVersionId inner join ", "DDMStructure on DDMStructure.structureId = ", "DDMStructureVersion.structureId and DDMStructure.version ", "= DDMStructureVersion.version where ", "DDMStructure.structureId = ?"}));){
            preparedStatement1.setLong(1, parentStructureId);
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong("structureLayoutId");
                    return l;
                }
            }
        }
        return 0L;
    }

    private void _upgradeStructureDefinition() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from DDMStructure where classNameId = ? or classNameId = ? order by createDate");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set parentStructureId = 0, definition = ? where structureId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DL_FILE_ENTRY_METADATA));
            preparedStatement1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long parentStructureId = resultSet.getLong("parentStructureId");
                    long parentStructureLayoutId = 0L;
                    if (parentStructureId > 0L) {
                        parentStructureLayoutId = this._getParentStructureLayoutId(parentStructureId);
                    }
                    preparedStatement2.setString(1, this._ddmDataDefinitionConverter.convertDDMFormDataDefinition(resultSet.getString("definition"), resultSet.getLong("groupId"), parentStructureId, parentStructureLayoutId, resultSet.getLong("structureId")));
                    preparedStatement2.setLong(2, resultSet.getLong("structureId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    private void _upgradeStructureLayoutDefinition() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructure.structureId, ", "DDMStructure.parentStructureId, DDMStructure.classNameId ", ", DDMStructure.structureKey, DDMStructure.version, ", "DDMStructureLayout.groupId, ", "DDMStructureLayout.structureLayoutId, ", "DDMStructureLayout.definition as ", "structureLayoutDefinition, ", "DDMStructureVersion.definition as ", "structureVersionDefinition from DDMStructureLayout inner ", "join DDMStructureVersion on ", "DDMStructureVersion.structureVersionId = ", "DDMStructureLayout.structureVersionId inner join ", "DDMStructure on DDMStructure.structureId = ", "DDMStructureVersion.structureId and DDMStructure.version ", "= DDMStructureVersion.version where ", "DDMStructure.classNameId = ? or DDMStructure.classNameId ", "= ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureLayout set definition = ?, classNameId = ?, structureLayoutKey = ? where structureLayoutId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DL_FILE_ENTRY_METADATA));
            preparedStatement1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    String structureLayoutDefinition = resultSet.getString("structureLayoutDefinition");
                    String structureVersionDefinition = resultSet.getString("structureVersionDefinition");
                    preparedStatement2.setString(1, this._ddmDataDefinitionConverter.convertDDMFormLayoutDataDefinition(resultSet.getLong("groupId"), resultSet.getLong("structureId"), structureLayoutDefinition, resultSet.getLong("structureLayoutId"), structureVersionDefinition));
                    preparedStatement2.setLong(2, resultSet.getLong("classNameId"));
                    String structureLayoutKey = resultSet.getString("structureKey");
                    if (!StringUtil.equals((String)resultSet.getString("version"), (String)"1.0")) {
                        structureLayoutKey = String.valueOf(this.increment());
                    }
                    preparedStatement2.setString(3, structureLayoutKey);
                    preparedStatement2.setLong(4, resultSet.getLong("structureLayoutId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    private void _upgradeStructureVersionDefinition() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructure.structureKey, DDMStructureVersion.* ", "from DDMStructureVersion inner join DDMStructure on ", "DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.classNameId = ? or DDMStructure.classNameId ", "= ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set parentStructureId = 0, definition = ? where structureVersionId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DL_FILE_ENTRY_METADATA));
            preparedStatement1.setLong(2, PortalUtil.getClassNameId((String)_CLASS_NAME_JOURNAL_ARTICLE));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long parentStructureId = resultSet.getLong("parentStructureId");
                    long parentStructureLayoutId = 0L;
                    if (parentStructureId > 0L) {
                        parentStructureLayoutId = this._getParentStructureLayoutId(parentStructureId);
                    }
                    preparedStatement2.setString(1, this._ddmDataDefinitionConverter.convertDDMFormDataDefinition(resultSet.getString("definition"), parentStructureId, parentStructureLayoutId));
                    preparedStatement2.setLong(2, resultSet.getLong("structureVersionId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

