/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.report;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.Validator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.field.type.name=color", "ddm.form.field.type.name=date", "ddm.form.field.type.name=date_time", "ddm.form.field.type.name=search_location", "ddm.form.field.type.name=text"}, service={DDMFormFieldTypeReportProcessor.class})
public class TextDDMFormFieldTypeReportProcessor
implements DDMFormFieldTypeReportProcessor {
    @Reference
    protected DDMFormInstanceRecordLocalService ddmFormInstanceRecordLocalService;
    private static final int _VALUES_MAX_LENGTH = 5;
    private static final Log _log = LogFactoryUtil.getLog(TextDDMFormFieldTypeReportProcessor.class);

    public JSONObject process(DDMFormFieldValue ddmFormFieldValue, JSONObject fieldJSONObject, long formInstanceRecordId, String ddmFormInstanceReportEvent) throws Exception {
        boolean nullValue = Validator.isNull((String)this.getValue(ddmFormFieldValue));
        int totalEntries = fieldJSONObject.getInt("totalEntries");
        JSONArray valuesJSONArray = JSONFactoryUtil.createJSONArray();
        if (ddmFormInstanceReportEvent.equals("add")) {
            if (nullValue) {
                return fieldJSONObject;
            }
            valuesJSONArray.put(JSONUtil.put((String)"formInstanceRecordId", (Object)formInstanceRecordId).put("value", this.getValue(ddmFormFieldValue)));
            JSONArray jsonArray = fieldJSONObject.getJSONArray("values");
            if (jsonArray != null) {
                Iterator iterator = jsonArray.iterator();
                while (iterator.hasNext() && valuesJSONArray.length() < 5) {
                    JSONObject jsonObject = (JSONObject)iterator.next();
                    valuesJSONArray.put(jsonObject);
                }
            }
            ++totalEntries;
        } else if (ddmFormInstanceReportEvent.equals("delete")) {
            DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordLocalService.getFormInstanceRecord(formInstanceRecordId);
            DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
            BaseModelSearchResult baseModelSearchResult = this.ddmFormInstanceRecordLocalService.searchFormInstanceRecords(ddmFormInstance.getFormInstanceId(), new String[]{ddmFormFieldValue.getName()}, 0, 0, 6, new Sort("modified", 6, true));
            List ddmFormInstanceRecords = baseModelSearchResult.getBaseModels();
            Stream stream = ddmFormInstanceRecords.stream();
            stream.filter(currentDDMFormInstanceRecord -> currentDDMFormInstanceRecord.getFormInstanceRecordId() != formInstanceRecordId).limit(5L).forEach(currentDDMFormInstanceRecord -> {
                block2: {
                    try {
                        DDMFormValues ddmFormValues = currentDDMFormInstanceRecord.getDDMFormValues();
                        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(true);
                        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get(ddmFormFieldValue.getName());
                        ddmFormFieldValues.forEach(currentDDMFormFieldValue -> valuesJSONArray.put(JSONUtil.put((String)"formInstanceRecordId", (Object)currentDDMFormInstanceRecord.getFormInstanceRecordId()).put("value", this.getValue((DDMFormFieldValue)currentDDMFormFieldValue))));
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Throwable)portalException);
                    }
                }
            });
            if (!nullValue) {
                --totalEntries;
            }
        }
        fieldJSONObject.put("totalEntries", totalEntries).put("values", valuesJSONArray);
        return fieldJSONObject;
    }

    protected String getValue(DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        return value.getString(value.getDefaultLocale());
    }
}

