/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.values.deserializer.type=json"}, service={DDMFormValuesDeserializer.class})
public class DDMFormValuesJSONDeserializer
implements DDMFormValuesDeserializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesJSONDeserializer.class);
    private JSONFactory _jsonFactory;
    private ServiceTrackerMap<String, DDMFormFieldValueJSONDeserializer> _serviceTrackerMap;

    public DDMFormValuesDeserializerDeserializeResponse deserialize(DDMFormValuesDeserializerDeserializeRequest ddmFormValuesDeserializerDeserializeRequest) {
        DDMForm ddmForm = ddmFormValuesDeserializerDeserializeRequest.getDDMForm();
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        DDMFormValuesDeserializerDeserializeResponse.Builder builder = DDMFormValuesDeserializerDeserializeResponse.Builder.newBuilder((DDMFormValues)ddmFormValues);
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(ddmFormValuesDeserializerDeserializeRequest.getContent());
            this._setDDMFormValuesAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmFormValues);
            this._setDDMFormValuesDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmFormValues);
            this.setDDMFormFieldValues(jsonObject.getJSONArray("fieldValues"), ddmForm, ddmFormValues);
            this.setDDMFormLocalizedValuesDefaultLocale(ddmFormValues);
            return builder.build();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            builder = builder.exception(exception);
            return builder.build();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDMFormFieldValueJSONDeserializer.class, (String)"ddm.form.field.type.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        if (jsonArray == null) {
            return availableLocales;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValues(JSONArray jsonArray, Map<String, DDMFormField> ddmFormFieldsMap) {
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue ddmFormFieldValue = this._getDDMFormFieldValue(jsonArray.getJSONObject(i), ddmFormFieldsMap);
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        return ddmFormFieldValues;
    }

    protected Value getValue(DDMFormField ddmFormField, JSONObject jsonObject) {
        DDMFormFieldValueJSONDeserializer ddmFormFieldValueJSONDeserializer = this._getDDMFormFieldValueJSONDeserializer(ddmFormField);
        if (ddmFormFieldValueJSONDeserializer != null) {
            return ddmFormFieldValueJSONDeserializer.deserialize(ddmFormField, String.valueOf(jsonObject.get("value")));
        }
        JSONObject valueJSONObject = jsonObject.getJSONObject("value");
        if (this.isLocalized(valueJSONObject)) {
            return this._getLocalizedValue(valueJSONObject);
        }
        return new UnlocalizedValue(jsonObject.getString("value"));
    }

    protected boolean isLocalized(JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        Set keys = jsonObject.keySet();
        Stream stream = keys.stream();
        return !stream.anyMatch(this::_isInvalidLocale);
    }

    protected void setDDMFormFieldValues(JSONArray jsonArray, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValues(jsonArray, ddmForm.getDDMFormFieldsMap(true));
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMFormValues ddmFormValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            this._setDDMFormFieldValueLocalizedValueDefaultLocale(ddmFormFieldValue, ddmFormValues.getDefaultLocale());
        }
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    private DDMFormFieldValue _getDDMFormFieldValue(JSONObject jsonObject, Map<String, DDMFormField> ddmFormFieldsMap) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setFieldReference(jsonObject.getString("fieldReference"));
        String instanceId = jsonObject.getString("instanceId");
        if (instanceId.matches("[a-zA-Z0-9]*")) {
            ddmFormFieldValue.setInstanceId(instanceId);
        }
        ddmFormFieldValue.setName(jsonObject.getString("name"));
        this._setDDMFormFieldValueValue(jsonObject, ddmFormFieldsMap.get(jsonObject.getString("name")), ddmFormFieldValue);
        this._setNestedDDMFormFieldValues(jsonObject.getJSONArray("nestedFieldValues"), ddmFormFieldsMap, ddmFormFieldValue);
        return ddmFormFieldValue;
    }

    private DDMFormFieldValueJSONDeserializer _getDDMFormFieldValueJSONDeserializer(DDMFormField ddmFormField) {
        if (ddmFormField == null) {
            return null;
        }
        return (DDMFormFieldValueJSONDeserializer)this._serviceTrackerMap.getService((Object)ddmFormField.getType());
    }

    private LocalizedValue _getLocalizedValue(JSONObject jsonObject) {
        LocalizedValue localizedValue = new LocalizedValue();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String languageId = (String)iterator.next();
            if (!LanguageUtil.isAvailableLocale((String)languageId)) continue;
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    private boolean _isInvalidLocale(String languageId) {
        return LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false) == null;
    }

    private void _setDDMFormFieldValueLocalizedValueDefaultLocale(DDMFormFieldValue ddmFormFieldValue, Locale defaultLocale) {
        Value value = ddmFormFieldValue.getValue();
        if (value != null && value.isLocalized()) {
            value.setDefaultLocale(defaultLocale);
        }
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._setDDMFormFieldValueLocalizedValueDefaultLocale(nestedDDMFormFieldValue, defaultLocale);
        }
    }

    private void _setDDMFormFieldValueValue(JSONObject jsonObject, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        String valueString = jsonObject.getString("value", null);
        if (valueString == null) {
            return;
        }
        ddmFormFieldValue.setValue(this.getValue(ddmFormField, jsonObject));
    }

    private void _setDDMFormValuesAvailableLocales(JSONArray jsonArray, DDMFormValues ddmFormValues) {
        ddmFormValues.setAvailableLocales(this.getAvailableLocales(jsonArray));
    }

    private void _setDDMFormValuesDefaultLocale(String defaultLanguageId, DDMFormValues ddmFormValues) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmFormValues.setDefaultLocale(defaultLocale);
        Set availableLocales = ddmFormValues.getAvailableLocales();
        if (availableLocales != null && !availableLocales.contains(defaultLocale)) {
            availableLocales.add(defaultLocale);
        }
    }

    private void _setNestedDDMFormFieldValues(JSONArray jsonArray, Map<String, DDMFormField> ddmFormFieldsMap, DDMFormFieldValue ddmFormFieldValue) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormFieldValue> nestedDDMFormFieldValues = this.getDDMFormFieldValues(jsonArray, ddmFormFieldsMap);
        ddmFormFieldValue.setNestedDDMFormFields(nestedDDMFormFieldValues);
    }
}

