/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_2_2;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DLFileEntryDDMFormInstanceRecordUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;

    public DLFileEntryDDMFormInstanceRecordUpgradeProcess(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMFieldAttribute.largeAttributeValue, ", "DDMFieldAttribute.smallAttributeValue, ", "DDMFormInstanceRecord.formInstanceRecordId, ", "DDMFormInstanceRecord.companyId from DDMFieldAttribute ", "join DDMField on DDMFieldAttribute.fieldId = ", "DDMField.fieldId join DDMFormInstanceRecord on ", "DDMFieldAttribute.storageId = ", "DDMFormInstanceRecord.storageId where DDMField.fieldType ", "like ? and DDMFieldAttribute.attributeName like ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"update DLFileEntry set classNameId = ?, classPK = ? ", "where fileEntryId = ? and userId = (select userId ", "from User_ where companyId = ? and screenName like ", "?)"}));){
            preparedStatement1.setString(1, "document_library");
            preparedStatement1.setString(2, "fileEntryId");
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long fileEntryId;
                    String attributeValue = StringUtil.unquote((String)resultSet.getString("largeAttributeValue"));
                    if (attributeValue.isEmpty()) {
                        attributeValue = StringUtil.unquote((String)resultSet.getString("smallAttributeValue"));
                    }
                    if ((fileEntryId = GetterUtil.getLong((String)attributeValue)) == 0L) continue;
                    preparedStatement2.setLong(1, this._classNameLocalService.getClassNameId(DDMFormInstanceRecord.class.getName()));
                    preparedStatement2.setLong(2, resultSet.getLong("formInstanceRecordId"));
                    preparedStatement2.setLong(3, fileEntryId);
                    preparedStatement2.setLong(4, resultSet.getLong("companyId"));
                    preparedStatement2.setString(5, "DDM_FORM_DEFAULT_USER_SCREEN_NAME");
                    preparedStatement2.addBatch();
                }
            }
            preparedStatement2.executeBatch();
        }
    }
}

