/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_0;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ConcurrentHashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DDMFormInstanceUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_FORM_INSTANCE = "com.liferay.dynamic.data.mapping.model.DDMFormInstance";
    private static final String _CLASS_NAME_RECORD_SET = "com.liferay.dynamic.data.lists.model.DDLRecordSet";
    private static final Map<String, String> _resourceActionIdsMap = ConcurrentHashMapBuilder.put((Object)"ADD_DATA_PROVIDER_INSTANCE", (Object)"ADD_DATA_PROVIDER_INSTANCE").put((Object)"ADD_RECORD", (Object)"ADD_FORM_INSTANCE_RECORD").put((Object)"ADD_RECORD_SET", (Object)"ADD_FORM_INSTANCE").put((Object)"ADD_STRUCTURE", (Object)"ADD_STRUCTURE").put((Object)"DELETE", (Object)"DELETE").put((Object)"PERMISSIONS", (Object)"PERMISSIONS").put((Object)"UPDATE", (Object)"UPDATE").put((Object)"VIEW", (Object)"VIEW").build();
    private final ClassNameLocalService _classNameLocalService;
    private final CounterLocalService _counterLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceActions _resourceActions;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;

    public DDMFormInstanceUpgradeProcess(ClassNameLocalService classNameLocalService, CounterLocalService counterLocalService, ResourceActions resourceActions, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._counterLocalService = counterLocalService;
        this._resourceActions = resourceActions;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._readAndCheckResourceActions();
        this._duplicateResourcePermission(_CLASS_NAME_RECORD_SET, _CLASS_NAME_FORM_INSTANCE);
        this._upgradeRootModelResourceResourcePermission("com.liferay.dynamic.data.lists", "com.liferay.dynamic.data.mapping");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDLRecordSet.*, TEMP_TABLE.structureVersionId ", "from DDLRecordSet inner join (select structureId, ", "max(structureVersionId) as structureVersionId from ", "DDMStructureVersion group by ", "DDMStructureVersion.structureId) TEMP_TABLE on ", "DDLRecordSet.DDMStructureId = TEMP_TABLE.structureId ", "where scope = 2"}));
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMFormInstance(uuid_, formInstanceId, ", "groupId, companyId, userId, userName, versionUserId, ", "versionUserName, createDate, modifiedDate, ", "structureId, version, name, description, settings_, ", "lastPublishDate) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?)"}));){
            while (resultSet.next()) {
                long recordSetId = resultSet.getLong("recordSetId");
                long structureId = resultSet.getLong("DDMStructureId");
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp createDate = resultSet.getTimestamp("createDate");
                String name = resultSet.getString("name");
                String description = resultSet.getString("description");
                String settings = resultSet.getString("settings_");
                Timestamp lastPublishDate = resultSet.getTimestamp("lastPublishDate");
                long structureVersionId = resultSet.getLong("structureVersionId");
                preparedStatement2.setString(1, PortalUUIDUtil.generate());
                preparedStatement2.setLong(2, recordSetId);
                preparedStatement2.setLong(3, groupId);
                preparedStatement2.setLong(4, companyId);
                preparedStatement2.setLong(5, userId);
                preparedStatement2.setString(6, userName);
                preparedStatement2.setLong(7, userId);
                preparedStatement2.setString(8, userName);
                preparedStatement2.setTimestamp(9, createDate);
                preparedStatement2.setTimestamp(10, resultSet.getTimestamp("modifiedDate"));
                preparedStatement2.setLong(11, structureId);
                preparedStatement2.setString(12, "1.0");
                preparedStatement2.setString(13, name);
                preparedStatement2.setString(14, description);
                preparedStatement2.setString(15, settings);
                preparedStatement2.setTimestamp(16, lastPublishDate);
                this._updateDDMStructure(structureId);
                this._updateDDMStructureLink(structureId);
                this._upgradeDDMFormInstanceVersion(groupId, companyId, userId, userName, createDate, recordSetId, structureVersionId, name, description, settings, lastPublishDate);
                this._upgradeResourcePermission(recordSetId, _CLASS_NAME_RECORD_SET, _CLASS_NAME_FORM_INSTANCE);
                this._updateWorkflowDefinitionLink(recordSetId);
                this._deleteDDLRecordSet(structureId, recordSetId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected long getNewActionIds(String oldName, String newName, long currentActionIds, long oldActionIds) {
        HashSet<String> actionsIdsList = new HashSet<String>();
        this._collectNewActionIds(actionsIdsList, this._resourceActionLocalService.getResourceActions(oldName), oldActionIds);
        List newResourceActions = this._resourceActionLocalService.getResourceActions(newName);
        this._collectNewActionIds(actionsIdsList, newResourceActions, currentActionIds);
        Stream resourceActionStream = newResourceActions.stream();
        Map<String, Long> map = resourceActionStream.collect(Collectors.toMap(resourceAction -> resourceAction.getActionId(), resourceAction -> resourceAction.getBitwiseValue()));
        Stream actionsIdsStream = actionsIdsList.stream();
        return actionsIdsStream.mapToLong(actionId -> MapUtil.getLong((Map)map, (String)actionId)).sum();
    }

    private void _collectNewActionIds(Set<String> actionsIdsSet, List<ResourceAction> resourceActionList, long oldActionIds) {
        for (ResourceAction resourceAction : resourceActionList) {
            long bitwiseValue = resourceAction.getBitwiseValue();
            if ((oldActionIds & bitwiseValue) != bitwiseValue) continue;
            actionsIdsSet.add(MapUtil.getString(_resourceActionIdsMap, (String)resourceAction.getActionId()));
        }
    }

    private void _deleteDDLRecordSet(long ddmStructureId, long recordSetId) throws SQLException {
        this._deleteStructureStructureLinks(ddmStructureId);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("delete from DDLRecordSet where recordSetId = ?");){
            preparedStatement.setLong(1, recordSetId);
            preparedStatement.executeUpdate();
        }
    }

    private void _deleteStructureStructureLinks(long ddmStructureId) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("delete from DDMStructureLink where structureId = ?");){
            preparedStatement.setLong(1, ddmStructureId);
            preparedStatement.executeUpdate();
        }
    }

    private void _duplicateResourcePermission(String oldName, String newName) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property nameProperty = PropertyFactoryUtil.forName((String)"name");
            dynamicQuery.add(nameProperty.eq((Object)oldName));
            Property primKeyProperty = PropertyFactoryUtil.forName((String)"scope");
            dynamicQuery.add(primKeyProperty.ne((Object)4));
        });
        actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
            resourcePermission.setName(newName);
            if (Objects.equals(resourcePermission.getPrimKey(), oldName)) {
                resourcePermission.setPrimKey(newName);
            }
            resourcePermission.setActionIds(this.getNewActionIds(oldName, newName, 0L, resourcePermission.getActionIds()));
            resourcePermission.setResourcePermissionId(this._counterLocalService.increment());
            this._resourcePermissionLocalService.addResourcePermission(resourcePermission);
        });
        actionableDynamicQuery.performActions();
    }

    private void _readAndCheckResourceActions() throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        this._resourceActions.populateModelResources(clazz.getClassLoader(), new String[]{"/resource-actions/default.xml"});
    }

    private void _updateDDMStructure(long ddmStructureId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DDMStructure set classNameId = ? where structureId = ?");){
            preparedStatement.setLong(1, this._classNameLocalService.getClassNameId(DDMFormInstance.class.getName()));
            preparedStatement.setLong(2, ddmStructureId);
            preparedStatement.executeUpdate();
        }
    }

    private void _updateDDMStructureLink(long ddmStructureId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DDMStructureLink set classNameId = ? where structureId = ?");){
            preparedStatement.setLong(1, this._classNameLocalService.getClassNameId(DDMFormInstance.class.getName()));
            preparedStatement.setLong(2, ddmStructureId);
            preparedStatement.executeUpdate();
        }
    }

    private void _updateWorkflowDefinitionLink(long recordSetId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update WorkflowDefinitionLink set classNameId = ? where classNameId = ? and classPK = ?");){
            preparedStatement.setLong(1, this._classNameLocalService.getClassNameId(_CLASS_NAME_FORM_INSTANCE));
            preparedStatement.setLong(2, this._classNameLocalService.getClassNameId(_CLASS_NAME_RECORD_SET));
            preparedStatement.setLong(3, recordSetId);
            preparedStatement.execute();
        }
    }

    private void _upgradeDDMFormInstanceVersion(long groupId, long companyId, long userId, String userName, Timestamp createDate, long formInstanceId, long structureVersionId, String name, String description, String settings, Timestamp statusDate) throws SQLException {
        try (PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into DDMFormInstanceVersion(", "formInstanceVersionId, groupId, companyId, userId, ", "userName, createDate, formInstanceId, ", "structureVersionId, name, description, settings_, ", "version, status, statusByUserId, statusByUserName, ", "statusDate) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?)"}));){
            preparedStatement2.setLong(1, this._counterLocalService.increment());
            preparedStatement2.setLong(2, groupId);
            preparedStatement2.setLong(3, companyId);
            preparedStatement2.setLong(4, userId);
            preparedStatement2.setString(5, userName);
            preparedStatement2.setTimestamp(6, createDate);
            preparedStatement2.setLong(7, formInstanceId);
            preparedStatement2.setLong(8, structureVersionId);
            preparedStatement2.setString(9, name);
            preparedStatement2.setString(10, description);
            preparedStatement2.setString(11, settings);
            preparedStatement2.setString(12, "1.0");
            preparedStatement2.setInt(13, 0);
            preparedStatement2.setLong(14, userId);
            preparedStatement2.setString(15, userName);
            preparedStatement2.setTimestamp(16, statusDate);
            preparedStatement2.execute();
        }
    }

    private void _upgradeResourcePermission(long primKeyId, String oldName, String newName) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property nameProperty = PropertyFactoryUtil.forName((String)"name");
            dynamicQuery.add(nameProperty.eq((Object)oldName));
            Property primKeyProperty = PropertyFactoryUtil.forName((String)"primKey");
            dynamicQuery.add(primKeyProperty.eq((Object)String.valueOf(primKeyId)));
        });
        actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
            resourcePermission.setName(newName);
            resourcePermission.setActionIds(this.getNewActionIds(oldName, newName, 0L, resourcePermission.getActionIds()));
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        });
        actionableDynamicQuery.performActions();
    }

    private void _upgradeRootModelResourceResourcePermission(String oldRootModelResourceName, String newRootModelResourceName) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property nameProperty = PropertyFactoryUtil.forName((String)"name");
            dynamicQuery.add(nameProperty.eq((Object)oldRootModelResourceName));
        });
        actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
            resourcePermission.setName(newRootModelResourceName);
            if (Objects.equals(resourcePermission.getPrimKey(), oldRootModelResourceName)) {
                resourcePermission.setPrimKey(newRootModelResourceName);
            }
            ResourcePermission existingResourcePermission = this._resourcePermissionLocalService.fetchResourcePermission(resourcePermission.getCompanyId(), resourcePermission.getName(), resourcePermission.getScope(), resourcePermission.getPrimKey(), resourcePermission.getRoleId());
            long currentActionIds = 0L;
            if (existingResourcePermission != null) {
                currentActionIds = existingResourcePermission.getActionIds();
                resourcePermission = existingResourcePermission;
            } else {
                resourcePermission.setResourcePermissionId(this._counterLocalService.increment());
            }
            resourcePermission.setActionIds(this.getNewActionIds(oldRootModelResourceName, newRootModelResourceName, currentActionIds, resourcePermission.getActionIds()));
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        });
        actionableDynamicQuery.performActions();
    }
}

